/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Project;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ProjectImpl
extends Project {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Project == null ? (class$com$sun$enterprise$deployment$Project = ProjectImpl.class$("com.sun.enterprise.deployment.Project")) : class$com$sun$enterprise$deployment$Project);
    private static final String APP_NAME_PROP = "appName";
    private static final String EAR_SIZE_PROP = "EAR_SIZE";
    private static final String JAR_NAME_PROP = "jarName";
    private static final String JAR_SIZE_PROP = "JAR_SIZE";
    private static final boolean debug = false;
    private Descriptor projDesc = null;
    private Hashtable projOrigins = null;
    private File originsFile = null;
    private String propKeyNAME = null;
    private String propKeySIZE = null;
    private File clientCodeFile = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Project;

    public ProjectImpl(Descriptor desc) {
        this.projDesc = desc;
        String filename = System.getProperty("user.home") + File.separator + ".j2eedeploymenttool" + File.separator + this.getName() + ".proj";
        this.originsFile = new File(filename);
        this.projOrigins = new Hashtable();
        if (this.projDesc instanceof Application) {
            this.propKeyNAME = APP_NAME_PROP;
            this.propKeySIZE = EAR_SIZE_PROP;
        } else {
            this.propKeyNAME = JAR_NAME_PROP;
            this.propKeySIZE = JAR_SIZE_PROP;
        }
    }

    public String getName() {
        return this.projDesc.getName();
    }

    public void setClientCodeFile(File cf2) {
        this.clientCodeFile = this.projDesc instanceof Application ? cf2 : null;
    }

    public File getClientCodeFile() {
        return this.clientCodeFile;
    }

    public Hashtable getArchiveContent(Archivist arch) {
        Hashtable h2 = (Hashtable)this.projOrigins.get(arch.getArchiveUri());
        return h2 != null ? (Hashtable)h2.clone() : null;
    }

    public void addFiles(Archivist arch, Hashtable files) {
        if (arch instanceof ApplicationArchivist) {
            this.projOrigins.putAll(files);
        } else {
            String bundleUri = arch.getArchiveUri();
            Hashtable bundleTable = (Hashtable)this.projOrigins.get(bundleUri);
            if (bundleTable == null) {
                bundleTable = new Hashtable();
                this.projOrigins.put(bundleUri, bundleTable);
            }
            bundleTable.putAll(files);
        }
    }

    public void removeEntries(Archivist arch, Vector entries) {
        ProjectImpl.debugPrintln("Removing files: " + entries);
        if (arch instanceof ApplicationArchivist) {
            int i2 = 0;
            while (i2 < entries.size()) {
                this.projOrigins.remove(entries.elementAt(i2));
                ++i2;
            }
        } else {
            String bundleUri = arch.getArchiveUri();
            Hashtable bundleTable = (Hashtable)this.projOrigins.get(bundleUri);
            if (bundleTable == null) {
                return;
            }
            int i3 = 0;
            while (i3 < entries.size()) {
                bundleTable.remove(entries.elementAt(i3));
                ++i3;
            }
        }
    }

    public void remove() {
        this.projOrigins = null;
    }

    public void save() {
        Archivist arch;
        ProjectImpl.debugPrintln("In save: " + this.getName());
        if (this.originsFile.exists()) {
            this.originsFile.delete();
        }
        Properties origins = new Properties();
        origins.setProperty(this.propKeyNAME, this.getName());
        if (this.projDesc instanceof Application) {
            arch = ((Application)this.projDesc).getApplicationArchivist();
            File earFile = ((ApplicationArchivist)arch).getApplicationFile();
            Long earFileLen = new Long(earFile.length());
            origins.setProperty(this.propKeySIZE, earFileLen.toString());
        } else if (this.projDesc instanceof ConnectorDescriptor) {
            arch = ((BundleDescriptor)this.projDesc).getArchivist();
            File jarFile = new File(arch.getArchiveUri());
            Long jarFileLen = new Long(jarFile.length());
            origins.setProperty(this.propKeySIZE, jarFileLen.toString());
        }
        Enumeration entries = this.projOrigins.keys();
        int nArchives = 0;
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            Object arOrigins = this.projOrigins.get(entry);
            if (arOrigins == null) continue;
            String arPrefix = "archive" + nArchives + ".";
            origins.setProperty(arPrefix + "name", entry);
            if (arOrigins instanceof File) {
                origins.setProperty(arPrefix + "origin", ((File)arOrigins).getAbsolutePath());
            } else if (arOrigins instanceof Hashtable) {
                Hashtable jarOrigins = (Hashtable)arOrigins;
                origins.setProperty(arPrefix + "numfiles", String.valueOf(jarOrigins.size()));
                Enumeration jarEntries = jarOrigins.keys();
                int entrycount = 0;
                while (jarEntries.hasMoreElements()) {
                    String entryPrefix = arPrefix + "entry" + entrycount + ".";
                    String jarEntry = (String)jarEntries.nextElement();
                    File originFile = (File)jarOrigins.get(jarEntry);
                    String origin = originFile.getAbsolutePath();
                    origins.setProperty(entryPrefix + "entry", jarEntry);
                    origins.setProperty(entryPrefix + "origin", origin);
                    ++entrycount;
                }
            }
            ++nArchives;
        }
        origins.setProperty("numArchives", String.valueOf(nArchives));
        ProjectImpl.debugPrintln("In saveFileOrigins, origins = " + origins);
        try {
            FileOutputStream fos = new FileOutputStream(this.originsFile);
            origins.store(fos, " File origins for '" + this.getName() + "'");
            fos.close();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void load() {
        ProjectImpl.debugPrintln("In loadFileOrigins: " + this.getName());
        if (!this.originsFile.exists()) {
            return;
        }
        Properties origins = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.originsFile);
            origins.load(fis);
            fis.close();
        }
        catch (Exception ex2) {
            return;
        }
        Long jarFileLen = null;
        if (this.projDesc instanceof Application) {
            Application app = (Application)this.projDesc;
            ApplicationArchivist appArch = app.getApplicationArchivist();
            jarFileLen = new Long(appArch.getApplicationFile().length());
        } else if (this.projDesc instanceof ConnectorDescriptor) {
            BundleDescriptor bd2 = (BundleDescriptor)this.projDesc;
            Archivist arch = bd2.getArchivist();
            jarFileLen = new Long(new File(arch.getArchiveUri()).length());
        }
        String oldJarFileLenStr = origins.getProperty(this.propKeySIZE);
        if (oldJarFileLenStr == null) {
            return;
        }
        Long oldJarFileLen = Long.decode(oldJarFileLenStr);
        if (!jarFileLen.equals(oldJarFileLen)) {
            this.originsFile.delete();
            ProjectImpl.debugPrintln("Project Impl: " + this.getName() + "size mismatch");
            return;
        }
        this.projOrigins = new Hashtable();
        String count = origins.getProperty("numArchives");
        if (count == null) {
            return;
        }
        int numArchives = Integer.parseInt(count);
        int i2 = 0;
        while (i2 < numArchives) {
            String arPrefix = "archive" + i2 + ".";
            String archive = origins.getProperty(arPrefix + "name");
            String numfiles = origins.getProperty(arPrefix + "numfiles");
            if (numfiles == null) {
                String arOrigin = origins.getProperty(arPrefix + "origin");
                if (arOrigin != null) {
                    File originFile = new File(arOrigin);
                    this.projOrigins.put(archive, originFile);
                }
            } else {
                int numEntries = Integer.parseInt(numfiles);
                Hashtable<String, File> arOrigins = new Hashtable<String, File>();
                this.projOrigins.put(archive, arOrigins);
                int j2 = 0;
                while (j2 < numEntries) {
                    String entryPrefix = arPrefix + "entry" + j2 + ".";
                    String jarEntry = origins.getProperty(entryPrefix + "entry");
                    String origin = origins.getProperty(entryPrefix + "origin");
                    File originFile = new File(origin);
                    arOrigins.put(jarEntry, originFile);
                    ++j2;
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector updateProjectFiles() throws Exception {
        if (this.projOrigins == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.main.noproject", "No project information for this application."));
        }
        String jarFileName = null;
        Archivist archivist = null;
        HashSet<Descriptor> archiveDescriptors = null;
        if (this.projDesc instanceof Application) {
            Application app = (Application)this.projDesc;
            archivist = app.getApplicationArchivist();
            jarFileName = ((ApplicationArchivist)archivist).getApplicationFile().getAbsolutePath();
            archiveDescriptors = app.getArchivableDescriptors();
        } else if (this.projDesc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)this.projDesc;
            archivist = cd2.getArchivist();
            jarFileName = new File(archivist.getArchiveUri()).getAbsolutePath();
            archiveDescriptors = new HashSet<Descriptor>();
            archiveDescriptors.add(this.projDesc);
        }
        ZipInputStream zipStream = new ZipInputStream(new FileInputStream(new File(jarFileName)));
        Vector<String> changedEntries = new Vector<String>();
        Hashtable<String, File> updateEarEntries = new Hashtable<String, File>();
        ZipEntry earEntry = null;
        block0: while ((earEntry = zipStream.getNextEntry()) != null) {
            ZipEntry jarEntry;
            Object arOrigin = this.projOrigins.get(earEntry.getName());
            if (arOrigin == null) continue;
            if (arOrigin instanceof File) {
                File originFile = (File)arOrigin;
                long zipTime = earEntry.getTime();
                if (zipTime <= 0L || originFile.lastModified() <= zipTime) continue;
                updateEarEntries.put(earEntry.getName(), originFile);
                changedEntries.add(earEntry.getName());
                continue;
            }
            if (!(arOrigin instanceof Hashtable)) continue;
            ZipInputStream zis = new ZipInputStream(zipStream);
            Hashtable origins = (Hashtable)arOrigin;
            Hashtable<String, File> updateJarEntries = new Hashtable<String, File>();
            while ((jarEntry = zis.getNextEntry()) != null) {
                void var12_13;
                Object origin = origins.get(var12_13.getName());
                if (origin == null) continue;
                File originFile = (File)origin;
                long zipTime = var12_13.getTime();
                if (zipTime <= 0L || originFile.lastModified() <= zipTime) continue;
                updateJarEntries.put(var12_13.getName(), originFile);
                changedEntries.add(earEntry.getName() + "!" + var12_13.getName());
            }
            if (updateJarEntries.size() <= 0) continue;
            Iterator it = archiveDescriptors.iterator();
            while (it.hasNext()) {
                Archivist arch = ((BundleDescriptor)it.next()).getArchivist();
                if (!arch.getArchiveUri().equals(earEntry.getName())) continue;
                arch.updateFiles(updateJarEntries);
                continue block0;
            }
        }
        if (updateEarEntries.size() > 0) {
            archivist.updateFiles(updateEarEntries);
        }
        if (zipStream != null) {
            zipStream.close();
        }
        return changedEntries;
    }

    private static void debugPrintln(String msg) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

