/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.sqlgen.DBInfoImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.BadServerDefinition;
import com.sun.enterprise.activation.Locator;
import com.sun.enterprise.activation.RepositoryImpl;
import com.sun.enterprise.activation.ServerAlreadyRegisteredException;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerManagerImpl;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogReaderImpl;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContextProviderImpl;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.ConfigurationImpl;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.security.AuthenticationServer;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.tools.deployment.backend.JarInstallerImpl;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.DebugController;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.UniqueValueGeneratorBackendImpl;
import com.sun.enterprise.util.Utility;
import com.sun.jms.spi.JMSManager;
import com.sun.web.server.WebServer;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class J2EEServer {
    public static final String LISTEN_PROP = "com.sun.CORBA.connection.ORBListenSocket";
    public static final String ADMIN_PORT = "ejb.http.port";
    public static final String DEFAULT_ADMIN_PORT = "9191";
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalHost() + ":";
    public static PrintStream ostream = System.out;
    public static PrintStream estream = System.err;
    public static final String QUEUE_CONNECTION_FACTORY_J2EE_PROPERTY = "queueconnectionfactory.j2ee";
    public static final String TOPIC_CONNECTION_FACTORY_J2EE_PROPERTY = "topicconnectionfactory.j2ee";
    private static final boolean debug = false;
    private static final int J2EE_SERVERID = 100;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$J2EEServer == null ? (class$com$sun$enterprise$server$J2EEServer = J2EEServer.class$("com.sun.enterprise.server.J2EEServer")) : class$com$sun$enterprise$server$J2EEServer);
    private static final String VERBOSE = "-verbose";
    private static final String HELP = "-help";
    private static final String VERSION = "-version";
    private static final String FULL_VERSION = "-fullversion";
    private static final String SINGLEVM = "-singleVM";
    private static final String MULTIVM = "-multiVM";
    private static final String DEBUG = "-debug";
    private static final String STOP = "-stop";
    private static final String NOJMS = "-noJMS";
    private static final String APPLICATIONS_DIRECTORY = "ejb.applications.directory";
    private static final String REPOSITORY_DIRECTORY = "ejb.repository.directory";
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    private static final String DefaultDbDir = "orb.db";
    private static final String CATALINA_HOME = "catalina.home";
    private static final String CATALINA_NAMING = "catalina.useNaming";
    private static final String J2EE_HOME = "com.sun.enterprise.home";
    private static final String DEFAULT_KEYSTORE_PROP = SSLUtils.getKeyStoreProp();
    private static final String DEFAULT_KEYSTORE_NAME = SSLUtils.getDefaultKeyStoreName();
    static String[][] orbServers;
    static String[][] ejbServers;
    private static final String QUEUE_CONNECTION_FACTORY_JMS_PROPERTY = "queueconnectionfactory.jms";
    private static final String TOPIC_CONNECTION_FACTORY_JMS_PROPERTY = "topicconnectionfactory.jms";
    private File dbDir;
    private String dbDirName;
    private ServerManagerImpl serverMgr;
    private Locator locator;
    private Activator activator;
    private RepositoryImpl repository;
    private Properties defaultProperties;
    private String codebasePort;
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    private JMSManager jmsManager = null;
    private boolean shutdownStarted = false;
    static /* synthetic */ Class class$com$sun$enterprise$server$J2EEServer;
    static /* synthetic */ Class class$com$sun$enterprise$activation$Activator;

    private void run(String[] args, boolean verbose, boolean singleVM, boolean startJMS) {
        EJBServer svr = null;
        try {
            new SecureRandom().nextLong();
            this.defaultProperties = new Properties();
            String propsFile = System.getProperty(J2EE_HOME) + File.separator + "config" + File.separator + "default.properties";
            FileInputStream fis = new FileInputStream(propsFile);
            this.defaultProperties.load(fis);
            Properties props = System.getProperties();
            String repname = "repository";
            try {
                ConfigurationImpl config = new ConfigurationImpl();
                repname = config.getProperty(REPOSITORY_DIRECTORY);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String activationDir = repname + File.separator + Utility.getLocalHost();
            ((Hashtable)props).put("com.sun.enterprise.activation.DbDir", FileUtil.getAbsolutePath(activationDir));
            if (singleVM) {
                String serverId = new Integer(100).toString();
                props.setProperty("com.sun.enterprise.activation.EJBServerId", serverId);
                props.setProperty("com.sun.enterprise.appname", "j2ee");
            }
            try {
                this.orb = this.createORB(args, singleVM);
                try {
                    Object obj = this.orb.resolve_initial_references("RootPOA");
                }
                catch (InvalidName in) {
                    in.printStackTrace();
                }
            }
            catch (Exception ex3) {
                Log.err.println(ex3);
                throw new RuntimeException("Unable to create ORB. Possible causes include TCP/IP ports in use by another process");
            }
            this.createRepositoryDir();
            if (!verbose) {
                this.redirectStreams();
            }
            Switch theSwitch = Switch.getSwitch();
            this.protocolMgr = new POAProtocolMgr(this.orb);
            theSwitch.setProtocolManager(this.protocolMgr);
            this.protocolMgr.setPersistentServerPort(ORBManager.getORBInitialPort());
            this.protocolMgr.setPersistentServerId(100);
            this.protocolMgr.initializeNaming(this.dbDir, this.orbInitialPort);
            ((POAProtocolMgr)this.protocolMgr).initializePOAs();
            System.out.println(localStrings.getLocalString("j2ee.naming", "Naming service started: ") + this.orbInitialPort);
            this.createActivationObjects();
            SerialContextProviderImpl.initSerialContextProvider();
            InvocationManagerImpl invMgr = new InvocationManagerImpl();
            theSwitch.setInvocationManager(invMgr);
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            this.protocolMgr.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            this.createConfiguration();
            File dir = LogUtil.getLogDirectory("j2ee", "j2ee");
            LogUtil.initDefaultLogFiles(dir);
            this.installOrbServers();
            this.startAuthenticationService();
            if (!singleVM) {
                this.installEJBServers();
            }
            this.startActivationObjects();
            J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
            theSwitch.setTransactionManager(tm);
            ResourceInstaller installer = theSwitch.getResourceInstaller();
            installer.installJdbcDataSources();
            installer.installConnectionFactories();
            if (startJMS) {
                this.jmsManager = JmsUtil.startJmsService();
            }
            if (singleVM) {
                svr = new EJBServer(this.orb);
                svr.setDefaultProperties(this.defaultProperties);
                svr.init(args);
            } else {
                System.setSecurityManager(new J2EESecurityManager());
            }
            ServerConfiguration sc = ServerConfiguration.getConfiguration();
            this.codebasePort = sc.getProperty(ADMIN_PORT, DEFAULT_ADMIN_PORT);
            System.setProperty(CATALINA_HOME, System.getProperty(J2EE_HOME));
            System.setProperty(CATALINA_NAMING, "false");
            WebServer webServer = null;
            webServer = this.startWebService(sc);
            this.startAdminService(sc);
            JarInstallerImpl jarinstaller = this.createInstaller(svr, webServer);
            nm.publishObject(USER_TX, (java.lang.Object)new UserTransactionImpl(), true);
            DBInfoImpl dbInfo = new DBInfoImpl();
            this.bindObject(this.orb, "DatabaseInformation", dbInfo);
            UniqueValueGeneratorBackendImpl uniqueValueGen = new UniqueValueGeneratorBackendImpl();
            this.bindObject(this.orb, "J2EE_UNIQUE_VALUE_GEN", uniqueValueGen);
            if (!singleVM) {
                this.registerDeployedApplications();
                this.startRegisteredServers();
            } else {
                this.loadDeployedApplications(svr);
            }
            this.restoreWebComponents(jarinstaller);
            LogReaderImpl.exportRemoteInterface();
            LogUtil.writevmModeDefaultLogFiles(dir, singleVM);
            System.out.println(localStrings.getLocalString("j2ee.started", "J2EE server startup complete."));
            if (!verbose) {
                ostream.println(localStrings.getLocalString("j2ee.started", "J2EE server startup complete."));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHelper()));
            this.orb.run();
        }
        catch (Exception ex4) {
            ex4.printStackTrace();
            Log.err.println(ex4);
            Log.err.flush();
            throw new RuntimeException(ex4.getMessage());
        }
    }

    private ORB createORB(String[] args, boolean singleVM) throws Exception {
        Properties props = new Properties();
        String recoverableStr = this.defaultProperties.getProperty("distributed.transaction.recovery");
        boolean recoverable = "true".equals(recoverableStr);
        if (singleVM) {
            EJBServer.initJTSProperties(recoverable, true, props);
        } else {
            EJBServer.initJTSProperties(recoverable, true, props);
        }
        ORBManager.init(args, props);
        this.orbInitialPort = ORBManager.getORBInitialPort();
        System.out.println(localStrings.getLocalString("j2ee.listenPort", "J2EE server listen port: ") + this.orbInitialPort);
        return ORBManager.getORB();
    }

    private void createActivationObjects() throws Exception {
        this.repository = new RepositoryImpl(this.dbDir, this);
        this.serverMgr = new ServerManagerImpl(this.repository, this.dbDirName, this);
        this.protocolMgr.setLocator(this.serverMgr);
        this.activator = (Activator)PortableRemoteObject.narrow((java.lang.Object)this.serverMgr, (Class)(class$com$sun$enterprise$activation$Activator == null ? (class$com$sun$enterprise$activation$Activator = J2EEServer.class$("com.sun.enterprise.activation.Activator")) : class$com$sun$enterprise$activation$Activator));
        this.repository.setActivator(this.activator);
    }

    private JarInstallerImpl createInstaller(EJBServer svr, WebServer httpd) {
        JarInstallerImpl impl = null;
        try {
            impl = new JarInstallerImpl(svr, httpd, this.getApplicationDirectory(), this.repository, this.activator);
            PortableRemoteObject.exportObject((Remote)impl);
            this.bindObject(this.orb, "JarInstaller", impl);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create JarInstaller remote object");
        }
        return impl;
    }

    private void startRegisteredServers() {
        int[] ids = null;
        try {
            ids = this.repository.listRegisteredServers();
        }
        catch (Exception e10) {
            Log.err.println(e10);
            return;
        }
        int i2 = 0;
        while (i2 < ids.length) {
            try {
                if (ids[i2] != 0) {
                    this.activator.activate(ids[i2], false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    private void loadDeployedApplications(EJBServer svr) throws MalformedURLException {
        try {
            JarManagerImpl jarimpl = svr.getEJBJarManager();
            Vector appList = JarRepository.getApplicationList();
            int i2 = 0;
            while (i2 < appList.size()) {
                String name = (String)appList.elementAt(i2);
                String url = JarRepository.getJarName(name);
                String jarfile = new URL(url).getFile();
                System.out.println(localStrings.getLocalString("j2ee.load", "Loading jar:{0}", new java.lang.Object[]{jarfile}));
                jarimpl.loadJar(jarfile);
                ++i2;
            }
        }
        catch (RemoteException re) {
            Log.err.println(re);
        }
    }

    private void registerDeployedApplications() throws MalformedURLException {
        try {
            Vector appList = JarRepository.getApplicationList();
            int i2 = 0;
            while (i2 < appList.size()) {
                String name = (String)appList.elementAt(i2);
                String url = JarRepository.getJarName(name);
                String jarfile = new URL(url).getFile();
                System.out.println(localStrings.getLocalString("j2ee.load", "Loading jar:{0}", new java.lang.Object[]{jarfile}));
                JarInstallerImpl.registerServer(name, new File(jarfile), this.repository);
                ++i2;
            }
        }
        catch (BadServerDefinition bsd) {
        }
        catch (Exception re) {
            Log.err.println(re);
        }
    }

    private File getApplicationDirectory() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String repname = config.getProperty(REPOSITORY_DIRECTORY, "repository");
        String dirname = config.getProperty(APPLICATIONS_DIRECTORY, "applications");
        String docRoot = repname + File.separator + Utility.getLocalHost() + File.separator + dirname;
        File applicationDirectory = new File(FileUtil.getAbsolutePath(docRoot));
        applicationDirectory.mkdirs();
        return applicationDirectory;
    }

    void redirectStreams() throws Exception {
        String appname = System.getProperty("com.sun.enterprise.appname", "j2ee");
        File logDir = LogUtil.getLogDirectory(appname, "j2ee");
        File ofile = new File(logDir, "system.out");
        FileOutputStream foutStream = new FileOutputStream(ofile.getAbsolutePath(), true);
        File efile = new File(logDir, "system.err");
        FileOutputStream ferrStream = new FileOutputStream(efile.getAbsolutePath(), true);
        PrintStream pSout = new PrintStream(foutStream, true);
        PrintStream pSerr = new PrintStream(ferrStream, true);
        LogUtil.printInfo(pSout);
        LogUtil.printInfo(pSerr);
        System.setOut(pSout);
        System.setErr(pSerr);
        ostream.println(localStrings.getLocalString("j2ee.redirect", "Redirecting the output and error streams to the following files:"));
        ostream.println(ofile.getAbsolutePath());
        ostream.println(efile.getAbsolutePath());
    }

    private void createConfiguration() throws RemoteException, NamingException {
        this.conf = new ConfigurationImpl();
        PortableRemoteObject.exportObject((Remote)this.conf);
        this.bindObject(this.orb, "ServerConfiguration", this.conf);
    }

    private void installEJBServers() {
        int serverId = 0;
        int i2 = 0;
        while (i2 < ejbServers.length) {
            try {
                String[] server = ejbServers[i2];
                ServerDef serverDef = new ServerDef(server[1], server[2], server[3], server[4], server[5] + " -Djava.compiler=NONE " + "-Djava.security.policy=" + System.getProperty("java.security.policy"));
                serverId = Integer.valueOf(ejbServers[i2][0]);
                this.repository.registerServerDef(serverDef, serverId);
                this.activator.activate(serverId, false);
            }
            catch (ServerAlreadyRegisteredException sar) {
                try {
                    this.activator.activate(serverId, false);
                }
                catch (Exception e10) {}
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private void createRepositoryDir() {
        Properties props = System.getProperties();
        this.dbDir = new File(props.getProperty("com.sun.enterprise.activation.DbDir", props.getProperty("user.dir") + File.separator + "repository"));
        this.dbDirName = this.dbDir.getAbsolutePath();
        ((Hashtable)props).put("com.sun.enterprise.activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
        }
    }

    private void startActivationObjects() throws Exception {
        String localHost = Utility.getLocalHost();
        PortableRemoteObject.exportObject((Remote)this.repository);
        this.bindObject(this.orb, "AppRepository", this.repository);
        PortableRemoteObject.exportObject((Remote)this.serverMgr);
        this.bindObject(this.orb, "ServerLocator", this.serverMgr);
        this.bindObject(this.orb, "ServerActivator", this.serverMgr);
    }

    private void bindObject(ORB orb, String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = Util.getTie((Remote)remote);
        servantsTie.orb(orb);
        NamingManager namingMgr = Switch.getSwitch().getNamingManager();
        namingMgr.publishObject(publishedName, (java.lang.Object)servantsTie, true);
    }

    private void installOrbServers() {
        int serverId = 0;
        int i2 = 1;
        while (i2 < orbServers.length) {
            try {
                String[] server = orbServers[i2];
                ServerDef serverDef = new ServerDef(server[1], server[2], server[3], server[4], server[5]);
                serverId = Integer.valueOf(orbServers[i2][0]);
                this.repository.registerServerDef(serverDef, serverId);
            }
            catch (ServerAlreadyRegisteredException sar) {
                try {
                    this.activator.activate(serverId, false);
                }
                catch (Exception e10) {}
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private WebService startAdminService(ServerConfiguration sc) throws Exception {
        String httpPort = null;
        java.lang.Object root = null;
        httpPort = sc.getProperty(ADMIN_PORT, DEFAULT_ADMIN_PORT);
        String rootDir = this.getApplicationDirectory().getAbsolutePath();
        WebService admin = new WebService(Utility.getLocalHost(), rootDir);
        admin.addConnector(Integer.valueOf(httpPort), null, false);
        admin.start();
        return admin;
    }

    private WebServer startWebService(ServerConfiguration sc) throws Exception {
        WebServer server = WebServer.getInstance();
        server.start();
        return server;
    }

    private void startAuthenticationService() {
        try {
            AuthenticationServer authSvr = new AuthenticationServer();
            authSvr.init();
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
    }

    /*
     * Loose catch block
     */
    private void restoreWebComponents(JarInstallerImpl jarinstaller) {
        int i2 = 0;
        while (i2 < 15) {
            jarinstaller.restoreWebComponents();
            java.lang.Object var5_3 = null;
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ie) {}
            break;
            {
                catch (Exception e10) {
                    var5_3 = null;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception ie) {}
                }
            }
            catch (Throwable throwable) {
                var5_3 = null;
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception ie) {
                    // empty catch block
                }
                throw throwable;
            }
            ++i2;
        }
    }

    public void shutdownJMSService() {
        try {
            System.out.println("Shutting down JMS Service...");
            if (this.jmsManager != null) {
                this.jmsManager.stopJMSService();
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private static void shutdown(boolean j2eestop) {
        try {
            Activator activator = (Activator)Utility.lookupObject("ServerActivator", class$com$sun$enterprise$activation$Activator == null ? (class$com$sun$enterprise$activation$Activator = J2EEServer.class$("com.sun.enterprise.activation.Activator")) : class$com$sun$enterprise$activation$Activator);
            int[] servers = activator.getActiveServers();
            int i2 = 0;
            while (i2 < servers.length) {
                if (servers[i2] != 0) {
                    activator.shutdown(servers[i2]);
                    System.out.println("server " + servers[i2] + " sucessfully shutdown.");
                }
                ++i2;
            }
            try {
                System.out.println(localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                if (j2eestop) {
                    activator.shutdown(0);
                }
            }
            catch (Exception cf2) {}
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            Log.err.println(t2);
            System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
        }
    }

    private static void printHelp(PrintStream out) {
        out.println(localStrings.getLocalString("j2ee.server", "Java 2 Enterprise Edition"));
        out.println(localStrings.getLocalString("j2ee.options", "Options:"));
        out.print("    ");
        out.println("-verbose\t\t" + localStrings.getLocalString("j2ee.verbose", "Redirect logging output to the current shell."));
        out.print("    ");
        out.println("-help\t\t" + localStrings.getLocalString("j2ee.help", "Print this help message."));
        out.print("    ");
        out.println("-version\t\t" + localStrings.getLocalString("j2ee.version", "Print the version."));
        out.print("    ");
        out.println("-stop\t\t" + localStrings.getLocalString("j2ee.stop", "Stop the J2EE server."));
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        boolean verbose = false;
        boolean singleVM = true;
        boolean startJMS = true;
        boolean dbg = false;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].trim().equals(HELP)) {
                J2EEServer.printHelp(System.out);
                return;
            }
            if (args[i2].trim().equals(STOP)) {
                System.setProperty(LISTEN_PROP, "");
                J2EEServer.shutdown(true);
                return;
            }
            if (args[i2].trim().equals(VERSION) || args[i2].trim().equals(FULL_VERSION)) {
                System.out.println(localStrings.getLocalString("j2ee.server_version", "Java 2 Enterprise Edition version ", new String[]{"1.3", "1.3-beta2-b35"}));
                return;
            }
            if (args[i2].trim().equals(VERBOSE)) {
                verbose = true;
            } else if (args[i2].trim().equals(DEBUG)) {
                dbg = true;
            } else if (args[i2].trim().equals(SINGLEVM)) {
                singleVM = true;
            } else if (args[i2].trim().equals(MULTIVM)) {
                System.out.println(localStrings.getLocalString("j2ee.msg001", "Warning: MultiVM mode is no longer supported."));
                singleVM = false;
            } else if (args[i2].trim().equals(NOJMS)) {
                startJMS = false;
            } else {
                J2EEServer.printHelp(System.out);
                return;
            }
            ++i2;
        }
        try {
            if (dbg && singleVM) {
                DebugController.init();
            }
            J2EEServer j2ee = new J2EEServer();
            j2ee.run(args, verbose, singleVM, startJMS);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            if (e10.getMessage() != null) {
                System.err.println("J2EE server reported the following error: " + e10.getMessage());
            }
            System.err.println("Error executing J2EE server ...");
            System.err.flush();
            System.exit(1);
        }
    }

    private static void initClasses() throws ClassNotFoundException {
        String[] classes = new String[]{"javax.servlet.ServletOutputStream"};
        int i2 = 0;
        while (i2 < classes.length) {
            Class.forName(classes[i2]);
            ++i2;
        }
    }

    public void internalShutdown() {
        this.shutdownStarted = true;
        this.shutdownJMSService();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.setProperty(DEFAULT_KEYSTORE_PROP, DEFAULT_KEYSTORE_NAME);
        orbServers = new String[][]{{"1", "NameServer", "com.sun.PCosNaming.NameServer", "", "", ""}, {"0", "J2EE Server", "com.sun.enterprise.server.J2EEServer", "", "", ""}};
        ejbServers = new String[0][];
    }

    class ShutdownHelper
    implements Runnable {
        ShutdownHelper() {
        }

        public void run() {
            try {
                if (!J2EEServer.this.shutdownStarted) {
                    J2EEServer.shutdown(false);
                    J2EEServer.this.shutdownJMSService();
                }
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
            }
        }
    }
}

