/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.ServerCallback;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;

public final class EJBServer {
    public static boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$EJBServer == null ? (class$com$sun$enterprise$server$EJBServer = EJBServer.class$("com.sun.enterprise.server.EJBServer")) : class$com$sun$enterprise$server$EJBServer);
    private static final String EJB_SERVER_PORT = "com.sun.enterprise.activation.EJBServerPort";
    public static final String EJB_SERVER_ID = "com.sun.enterprise.activation.EJBServerId";
    public static final String EJB_ACTIVATIONDB_DIR = "com.sun.enterprise.activation.DbDir";
    public static final String EJB_APPNAME = "com.sun.enterprise.appname";
    public static final String EJB_HOME = "com.sun.enterprise.home";
    public static final String EJB_SERVER_CLASS = "com.sun.enterprise.server.EJBServer";
    public static final String EJB_RECOVERABLE = "distributed.transaction.recovery";
    public static final String JTS_SERVERID = "com.sun.jts.persistentServerId";
    public static POA transientPOA = null;
    public static POA persistentPOA = null;
    private boolean serverIsDaemonActivated = false;
    private ServerCallback serverCallback = null;
    private ORB orb = null;
    private JarManagerImpl jarManager = null;
    private InitialContext initialContext;
    private Properties defaultProperties;
    private ProtocolManager protocolMgr = null;
    private static String DEFAULT_KEYSTORE_PROP = SSLUtils.getKeyStoreProp();
    private static String DEFAULT_KEYSTORE_NAME = SSLUtils.getDefaultKeyStoreName();
    static /* synthetic */ Class class$com$sun$enterprise$server$EJBServer;
    static /* synthetic */ Class class$com$sun$enterprise$activation$Activator;

    public EJBServer(ORB orb) {
        System.setSecurityManager(new J2EESecurityManager());
        this.orb = orb;
    }

    void setDefaultProperties(Properties props) {
        this.defaultProperties = props;
    }

    private void run(String[] args) throws Exception {
        java.lang.Object sync;
        Switch sw = Switch.getSwitch();
        this.protocolMgr = new POAProtocolMgr(this.orb);
        sw.setProtocolManager(this.protocolMgr);
        InvocationManagerImpl invMgr = new InvocationManagerImpl();
        sw.setInvocationManager(invMgr);
        this.initialContext = new InitialContext();
        NamingManagerImpl nm = new NamingManagerImpl(this.initialContext);
        sw.setNamingManager(nm);
        int persServerId = this.initPersistentServerInfo();
        ((POAProtocolMgr)this.protocolMgr).initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
        J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
        sw.setTransactionManager(tm);
        this.init(args);
        this.createServerCallback();
        int i2 = 0;
        while (i2 < args.length) {
            this.jarManager.loadJar(args[i2]);
            ++i2;
        }
        this.replyToActivator(persServerId);
        System.out.println(localStrings.getLocalString("ejbserver.wait", "waiting for invocations ... "));
        java.lang.Object object = sync = new java.lang.Object();
        synchronized (object) {
            sync.wait();
        }
    }

    public void init(String[] args) throws Exception {
        Switch sw = Switch.getSwitch();
        if (this.initialContext == null) {
            this.initialContext = (InitialContext)sw.getNamingManager().getInitialContext();
        }
        if (this.protocolMgr == null) {
            this.protocolMgr = sw.getProtocolManager();
        }
        this.protocolMgr.setEJBServer(this);
        this.jarManager = new JarManagerImpl();
        sw.setEJBJarManager(this.jarManager);
        String recoverableStr = this.defaultProperties.getProperty(EJB_RECOVERABLE);
        boolean recoverable = "true".equals(recoverableStr);
        if (recoverable) {
            System.err.println(localStrings.getLocalString("ejbserver.recovery", "Perform recovery of XAResources..."));
            J2EETransactionManager tm = sw.getTransactionManager();
            ResourceInstaller installer = sw.getResourceInstaller();
            installer.recoverXAResources();
        }
        ContainerFactoryImpl cf2 = new ContainerFactoryImpl();
        sw.setContainerFactory(cf2);
    }

    private static void initializeLogs() throws Exception {
        String serverId = System.getProperty(EJB_SERVER_ID, "0");
        String appname = System.getProperty(EJB_APPNAME);
        if (appname == null || appname.equals("")) {
            appname = serverId;
        }
        File dir = LogUtil.getLogDirectory(appname, "j2ee");
        LogUtil.initDefaultLogFiles(dir);
    }

    public static void main(String[] args) {
        try {
            Utility.checkJVMVersion();
            EJBServer.initializeLogs();
            Properties defaultProperties = new Properties();
            String propsFile = System.getProperty(EJB_HOME) + File.separator + "config" + File.separator + "default.properties";
            FileInputStream fis = new FileInputStream(propsFile);
            defaultProperties.load(fis);
            Properties props = new Properties();
            String recoverableStr = defaultProperties.getProperty(EJB_RECOVERABLE);
            boolean recoverable = "true".equals(recoverableStr);
            EJBServer.initJTSProperties(recoverable, true, props);
            ORBManager.init(args, props);
            ORB orb = ORBManager.getORB();
            try {
                Object obj = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName in) {
                in.printStackTrace();
            }
            EJBServer server = new EJBServer(orb);
            server.setDefaultProperties(defaultProperties);
            server.run(args);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            if (debug) {
                ex2.printStackTrace();
            }
            System.exit(1);
        }
    }

    public static void initJTSProperties(boolean recoverable, boolean lateRegistration, Properties props) {
        if (!lateRegistration) {
            ((Hashtable)props).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        if (recoverable) {
            String serverId;
            if (debug) {
                System.err.println("Recoverable J2EE Server");
            }
            if ((serverId = System.getProperty(EJB_SERVER_ID)) == null) {
                serverId = "0";
            }
            ((Hashtable)props).put(JTS_SERVERID, serverId);
            ((Hashtable)props).put("com.sun.jts.ManualRecovery", "true");
            String hostname = "";
            try {
                InetAddress ia = InetAddress.getLocalHost();
                hostname = ia.getHostName();
            }
            catch (UnknownHostException ex2) {
                hostname = "localhost";
            }
            String logdir = FileUtil.getAbsolutePath("logs/" + hostname + "/jts");
            if (debug) {
                System.err.println("JTS log directory: " + logdir);
                System.err.println("Server id " + serverId);
            }
            new File(logdir).mkdirs();
            ((Hashtable)props).put("com.sun.jts.logDirectory", logdir);
        }
    }

    public JarManagerImpl getEJBJarManager() {
        return this.jarManager;
    }

    private void createServerCallback() {
        if (this.serverIsDaemonActivated) {
            this.serverCallback = new ServerCallback(this);
            try {
                PortableRemoteObject.exportObject((Remote)this.serverCallback);
                Tie servantsTie = Util.getTie((Remote)this.serverCallback);
                servantsTie.orb(this.orb);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                if (debug) {
                    ex2.printStackTrace();
                }
                throw new RuntimeException("Unable to create a callback object.");
            }
        }
    }

    private void replyToActivator(int persServerId) {
        if (this.serverIsDaemonActivated) {
            try {
                java.lang.Object objRef = this.initialContext.lookup("ServerActivator");
                Activator activator = (Activator)PortableRemoteObject.narrow((java.lang.Object)objRef, (Class)(class$com$sun$enterprise$activation$Activator == null ? (class$com$sun$enterprise$activation$Activator = EJBServer.class$("com.sun.enterprise.activation.Activator")) : class$com$sun$enterprise$activation$Activator));
                activator.active(this.serverCallback, persServerId);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                if (debug) {
                    ex2.printStackTrace();
                }
                throw new RuntimeException("Unable to register with Activator");
            }
        }
    }

    private int initPersistentServerInfo() {
        String serverPortStr = System.getProperty(EJB_SERVER_PORT);
        if (serverPortStr != null) {
            this.protocolMgr.setPersistentServerPort(Integer.parseInt(serverPortStr));
        } else {
            int daemonPort = ORBManager.getORBInitialPort();
            System.out.println("The EJBServer's daemon port is configured to: " + daemonPort);
            this.protocolMgr.setDaemonPort(daemonPort);
            this.serverIsDaemonActivated = true;
        }
        int persServerId = -1;
        String persServerIdStr = System.getProperty(EJB_SERVER_ID);
        if (persServerIdStr != null) {
            persServerId = Integer.parseInt(persServerIdStr);
            this.protocolMgr.setPersistentServerId(persServerId);
        }
        return persServerId;
    }

    void shutdown() {
        Log.flushAll();
        try {
            this.orb.shutdown(false);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    int getListenerPort(String type) {
        return this.protocolMgr.getListenerPort(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.setProperty(DEFAULT_KEYSTORE_PROP, DEFAULT_KEYSTORE_NAME);
    }
}

