/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateUser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

final class CertificateStore {
    private CertificateRealm realm;
    private File file;
    private char[] password = "changeit".toCharArray();
    private KeyStore kstore;
    private CertificateFactory cfactory;

    public CertificateStore(CertificateRealm realm, String fileName) throws BadRealmException {
        try {
            this.realm = realm;
            this.file = new File(fileName);
            this.kstore = KeyStore.getInstance("JKS");
            this.cfactory = CertificateFactory.getInstance("X509");
            this.read();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    void read() throws IOException {
        block13: {
            FileInputStream fis = null;
            fis = new FileInputStream(this.file);
            Object var4_2 = null;
            try {
                this.kstore.load(fis, this.password);
            }
            catch (Exception ce2) {
                ce2.printStackTrace();
            }
            if (fis != null) {
                fis.close();
            }
            break block13;
            {
                catch (Exception e10) {
                    Object var4_3 = null;
                    try {
                        this.kstore.load(fis, this.password);
                    }
                    catch (Exception ce2) {
                        ce2.printStackTrace();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.kstore.load(fis, this.password);
                }
                catch (Exception ce2) {
                    ce2.printStackTrace();
                }
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void rewrite() throws IOException {
        block13: {
            FileOutputStream fos = null;
            fos = new FileOutputStream(this.file);
            Object var4_2 = null;
            try {
                this.kstore.store(fos, this.password);
            }
            catch (Exception e10) {
                // empty catch block
            }
            if (fos != null) {
                fos.close();
            }
            break block13;
            {
                catch (Exception e11) {
                    e11.printStackTrace();
                    Object var4_3 = null;
                    try {
                        this.kstore.store(fos, this.password);
                    }
                    catch (Exception e10) {
                        // empty catch block
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.kstore.store(fos, this.password);
                }
                catch (Exception e10) {
                    // empty catch block
                }
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
        }
    }

    synchronized Enumeration getUsers() {
        Vector<String> users = new Vector<String>();
        try {
            try {
                Enumeration<String> e10 = this.kstore.aliases();
                while (e10.hasMoreElements()) {
                    users.addElement(e10.nextElement());
                }
            }
            catch (Exception kse) {
                Object var4_5 = null;
                return users.elements();
            }
            Object var4_4 = null;
            return users.elements();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            return users.elements();
        }
    }

    private String getPrincipalName(X509Certificate cert) {
        String subject = cert.getSubjectDN().getName();
        int start = subject.indexOf("CN=") + 3;
        int end = subject.indexOf(",", start);
        return subject.substring(start, end);
    }

    synchronized User getUser(String alias) throws NoSuchUserException {
        try {
            if (!this.kstore.containsAlias(alias)) {
                throw new NoSuchUserException(alias);
            }
            Certificate cert = this.kstore.getCertificate(alias);
            String subject = ((X509Certificate)cert).getSubjectDN().getName();
            return new CertificateUser(this.realm, alias, cert);
        }
        catch (KeyStoreException kse) {
            throw new NoSuchUserException(kse.getMessage());
        }
    }

    synchronized void addUser(String user, byte[] cert) throws BadRealmException {
        ByteArrayInputStream istream = new ByteArrayInputStream(cert);
        try {
            Certificate certificate = this.cfactory.generateCertificate(istream);
            this.kstore.setCertificateEntry(user, certificate);
            this.rewrite();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new BadRealmException(e10.getMessage());
        }
    }

    synchronized void removeUser(String user) throws BadRealmException {
        try {
            this.kstore.deleteEntry(user);
            this.rewrite();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    synchronized Certificate[] getCertificates() throws NoSuchUserException {
        Certificate[] certs = null;
        try {
            certs = new Certificate[this.kstore.size()];
            int i2 = 0;
            Enumeration<String> e10 = this.kstore.aliases();
            while (e10.hasMoreElements()) {
                certs[i2++] = this.kstore.getCertificate(e10.nextElement());
            }
        }
        catch (KeyStoreException ex2) {
            throw new NoSuchUserException(ex2.getMessage());
        }
        return certs;
    }
}

