/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.security.auth.AuthenticationInfo;
import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Authenticator;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.CredentialsImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.PrivilegeImpl;
import com.sun.enterprise.security.auth.RealmInfo;
import com.sun.enterprise.security.auth.RealmInfoImpl;
import com.sun.enterprise.security.auth.RemoteObject;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AuthenticatorImpl
extends RemoteObject
implements Authenticator {
    private static final boolean debug = false;
    private Hashtable credentialStore = new Hashtable();

    public Credentials initAuthentication() throws RemoteException {
        CredentialsImpl obj = new CredentialsImpl();
        this.exportObject(obj);
        Credentials c10 = (Credentials)this.getStub(obj);
        this.credentialStore.put(c10, obj);
        return c10;
    }

    private boolean isValid(Credentials cred) throws RemoteException {
        Credentials obj = (Credentials)this.credentialStore.get(cred);
        if (obj == null) {
            return false;
        }
        return obj.isValid();
    }

    private boolean isValid(String realmName, String authMethod) throws BadRealmException, NoSuchRealmException {
        return Realm.getInstance(realmName) != null && Realm.getInstance(realmName).getAuthType().equals(authMethod);
    }

    public AuthenticationStatus authenticate(String principalName, String realmName, String authMethod, byte[] authData, Credentials creds) throws RemoteException {
        AuthenticationStatus as2 = null;
        try {
            block7: {
                try {
                    if (this.isValid(creds)) {
                        if (this.isValid(realmName, authMethod)) {
                            Realm realm = Realm.getInstance(realmName);
                            AuthenticationHandler handler = realm.getAuthenticationHandler();
                            as2 = handler.doAuthentication((Credentials)this.credentialStore.get(creds), principalName, authData);
                        } else {
                            as2 = new AuthenticationStatusImpl(principalName, realmName, authMethod, 1);
                        }
                        break block7;
                    }
                    as2 = new AuthenticationStatusImpl(principalName, realmName, authMethod, 3);
                }
                catch (Exception e10) {
                    e10.printStackTrace(System.out);
                    throw new RemoteException(e10.getMessage());
                }
            }
            Object var10_10 = null;
            return as2;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            return as2;
        }
    }

    public AuthenticationStatus authenticateWithNoPassword(String principalName, String realmName, String authMethod, Credentials creds) throws RemoteException {
        AuthenticationStatusImpl as2 = null;
        try {
            block8: {
                try {
                    if (this.isValid(creds)) {
                        if (this.isValid(realmName, authMethod)) {
                            Realm realm = Realm.getInstance(realmName);
                            int status = 0;
                            AuthenticationInfoImpl ainfo = new AuthenticationInfoImpl(principalName, realmName, true);
                            ainfo.setAttribute("Groups", new Privilege[0]);
                            as2 = new AuthenticationStatusImpl(principalName, realmName, authMethod, status);
                            Credentials credsTemp = (Credentials)this.credentialStore.get(creds);
                            if (credsTemp instanceof CredentialsImpl) {
                                CredentialsImpl cimpl = (CredentialsImpl)credsTemp;
                                cimpl.setAuthenticationStatus(as2);
                                cimpl.addAuthenticationInfo(ainfo);
                            }
                        } else {
                            as2 = new AuthenticationStatusImpl(principalName, realmName, authMethod, 1);
                        }
                        break block8;
                    }
                    as2 = new AuthenticationStatusImpl(principalName, realmName, authMethod, 3);
                }
                catch (Exception e10) {
                    e10.printStackTrace(System.out);
                    throw new RemoteException(e10.getMessage());
                }
            }
            Object var12_12 = null;
            return as2;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            return as2;
        }
    }

    public AuthenticationStatus continueAuthentication(byte[] respData, Credentials creds) throws RemoteException {
        return new AuthenticationStatusImpl(null, null, null, 1);
    }

    public void destroyCredentials(Credentials creds) throws RemoteException {
        CredentialsImpl obj = (CredentialsImpl)this.credentialStore.get(creds);
        if (obj != null) {
            obj.invalidate();
        }
    }

    void invalidateCredentials(long age) {
        Enumeration e10 = this.credentialStore.keys();
        while (e10.hasMoreElements()) {
            CredentialsImpl cimpl = (CredentialsImpl)this.credentialStore.get(e10.nextElement());
            if (cimpl == null || System.currentTimeMillis() - cimpl.getCreationTime() <= age) continue;
            cimpl.invalidate();
        }
    }

    void removeInvalidCredentials() {
        Enumeration e10 = this.credentialStore.keys();
        while (e10.hasMoreElements()) {
            Credentials creds = (Credentials)e10.nextElement();
            try {
                if (this.isValid(creds)) continue;
                this.credentialStore.remove(creds);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Enumeration getRealmNames(Credentials cred) {
        Hashtable<String, String> t2 = new Hashtable<String, String>();
        try {
            try {
                AuthenticationInfo[] ainfo = cred.getAuthenticationInfo();
                int i2 = 0;
                while (ainfo != null && i2 < ainfo.length) {
                    t2.put(ainfo[i2].getRealmName(), "");
                    ++i2;
                }
            }
            catch (Exception e10) {
                return t2.keys();
            }
            Object var6_6 = null;
            return t2.keys();
        }
        catch (Throwable throwable) {
            return t2.keys();
        }
    }

    private RealmInfo getRealmInfo(Realm realm) throws BadRealmException {
        RealmInfoImpl rinfo = new RealmInfoImpl(realm.getName());
        Enumeration e10 = realm.getUserNames();
        while (e10.hasMoreElements()) {
            rinfo.addUser((String)e10.nextElement());
        }
        Enumeration e11 = realm.getGroupNames();
        while (e11.hasMoreElements()) {
            String grp = (String)e11.nextElement();
            rinfo.addPrivilege("Groups", new PrivilegeImpl(grp));
        }
        return rinfo;
    }

    public RealmInfo[] getRealmInfo(Credentials cred) throws RemoteException {
        Vector<RealmInfo> v2 = new Vector<RealmInfo>();
        try {
            if (cred.isValid()) {
                Enumeration e10 = this.getRealmNames(cred);
                while (e10.hasMoreElements()) {
                    String realmName = (String)e10.nextElement();
                    Realm realm = Realm.getInstance(realmName);
                    RealmInfo rinfo = this.getRealmInfo(realm);
                    v2.add(rinfo);
                }
            }
        }
        catch (Exception e11) {
            throw new RemoteException(e11.getMessage());
        }
        Object[] rarray = new RealmInfo[v2.size()];
        v2.copyInto(rarray);
        return rarray;
    }

    public void refresh(String realmName) throws RemoteException {
        try {
            Realm realm = Realm.getInstance(realmName);
            if (realm != null) {
                realm.refresh();
            }
        }
        catch (Exception e10) {
            throw new RemoteException(e10.getMessage());
        }
    }
}

