/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.GUILoginDialog;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.LoginDialog;
import com.sun.enterprise.security.TextLoginDialog;

public final class LoginManager {
    private LoginDialog loginDialog;
    public static final boolean debug = false;

    public LoginManager(LoginDialog loginDialog) {
        this.loginDialog = loginDialog;
    }

    public void login() throws SecurityException {
        String userName = this.loginDialog.getUserName();
        String password = this.loginDialog.getPassword();
        LoginContext lc = new LoginContext();
        lc.login(userName, password);
    }

    public static LoginManager newInstance() {
        LoginDialog ld = null;
        boolean isGUI = Boolean.valueOf(System.getProperty("auth.gui", "true"));
        final String username = System.getProperty("login.username");
        final String password = System.getProperty("login.password");
        ld = username == null || password == null ? (isGUI ? new GUILoginDialog() : new TextLoginDialog()) : new LoginDialog(){

            public String getUserName() {
                return username;
            }

            public String getPassword() {
                return password;
            }
        };
        return new LoginManager(ld);
    }

    public static void main(String[] args) {
        LoginManager lm = LoginManager.newInstance();
        try {
            lm.login();
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }
}

