/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.AbstractSystemJdbcAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import javax.naming.Context;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SystemJdbc20XaAllocator
extends AbstractSystemJdbcAllocator {
    private String jndiName;

    public SystemJdbc20XaAllocator(PoolManager poolMgr, String jndiName, ResourceSpec spec, ClientSecurityInfo info) {
        super(poolMgr, spec, info);
        this.jndiName = jndiName;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
            XADataSource ds2 = (XADataSource)ic.lookup(this.jndiName);
            ResourcePrincipal prin = this.info.getPrincipal();
            String user = prin.getName();
            String password = prin.getPassword();
            XAConnection con = ds2.getXAConnection(user, password);
            ResourceHandle resource = new ResourceHandle(con, this.spec, this, this.info);
            AbstractSystemJdbcAllocator.ConnectionListenerImpl l2 = new AbstractSystemJdbcAllocator.ConnectionListenerImpl(resource);
            con.addConnectionEventListener(l2);
            return resource;
        }
        catch (Exception ex2) {
            if (ex2 instanceof PoolingException) {
                throw (PoolingException)ex2;
            }
            throw new PoolingException(ex2);
        }
    }
}

