/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class NoTxConnectorAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ConnectionRequestInfo reqInfo;
    private Subject subject;
    private ManagedConnectionFactory mcf;
    private ConnectorDescriptor desc;
    private ClientSecurityInfo info;

    public NoTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        this.poolMgr = poolMgr;
        this.mcf = mcf;
        this.spec = spec;
        this.subject = subject;
        this.reqInfo = reqInfo;
        this.info = info;
        this.desc = desc;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = new ResourceHandle(mc, this.spec, this, this.info);
            ConnectionListenerImpl l2 = new ConnectionListenerImpl(resource);
            mc.addConnectionEventListener(l2);
            return resource;
        }
        catch (ResourceException ex2) {
            ex2.printStackTrace(Log.err);
            if (ex2.getLinkedException() != null) {
                ex2.getLinkedException().printStackTrace(Log.err);
            }
            Log.err.flush();
            throw new PoolingException(ex2);
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            resource.fillInResourceObjects(con, null);
        }
        catch (ResourceException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.cleanup();
        }
        catch (ResourceException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.destroy();
        }
        catch (ResourceException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public boolean matchConnection(ResourceHandle h2) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(h2.getResource());
        try {
            ManagedConnection mc = this.mcf.matchManagedConnections(set, this.subject, this.reqInfo);
            return mc != null;
        }
        catch (ResourceException ex2) {
            return false;
        }
    }

    public boolean supportsReauthentication() {
        return this.desc.supportsReauthentication();
    }

    public void cleanup(ResourceHandle h2) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)h2.getResource();
            mc.cleanup();
        }
        catch (ResourceException ex2) {
            throw new PoolingException(ex2.toString(), ex2);
        }
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener(this);
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                mc.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }

        public void localTransactionStarted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }
    }
}

