/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import javax.naming.Context;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class Jdbc20XaAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private Context ic;
    private ResourceSpec spec;
    private boolean shareable;
    private ClientSecurityInfo info;
    private String jndiName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$Jdbc20XaAllocator == null ? (class$com$sun$enterprise$resource$Jdbc20XaAllocator = Jdbc20XaAllocator.class$("com.sun.enterprise.resource.Jdbc20XaAllocator")) : class$com$sun$enterprise$resource$Jdbc20XaAllocator);
    static /* synthetic */ Class class$com$sun$enterprise$resource$Jdbc20XaAllocator;

    public Jdbc20XaAllocator(PoolManager poolMgr, String jndiName, ResourceSpec spec, ClientSecurityInfo info, boolean shareable) {
        this.poolMgr = poolMgr;
        this.spec = spec;
        this.jndiName = jndiName;
        this.shareable = shareable;
        this.info = info;
        this.ic = Switch.getSwitch().getNamingManager().getInitialContext();
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            XADataSource ds2 = (XADataSource)this.ic.lookup(this.jndiName);
            ResourcePrincipal prin = this.info.getPrincipal();
            XAConnection con = ds2.getXAConnection(prin.getName(), prin.getPassword());
            ResourceHandle resource = new ResourceHandle(con, this.spec, this, this.info);
            ConnectionListenerImpl l2 = new ConnectionListenerImpl(resource);
            con.addConnectionEventListener(l2);
            return resource;
        }
        catch (Exception ex2) {
            if (ex2 instanceof PoolingException) {
                throw (PoolingException)ex2;
            }
            throw new PoolingException(ex2);
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            Connection con = xacon.getConnection();
            XAResource xares = xacon.getXAResource();
            ConnectionWrapper conWrapper = new ConnectionWrapper(resource, con);
            resource.fillInResourceObjects(conWrapper, xares);
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            Connection con = (Connection)resource.getUserConnection();
            con.close();
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            xacon.close();
        }
        catch (SQLException ex3) {
            throw new PoolingException(ex3);
        }
    }

    public boolean matchConnection(ResourceHandle h2) {
        return h2.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle h2) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        h2.incrementCount();
        ConnectionWrapper con = new ConnectionWrapper(h2);
        return con;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConnectionWrapper
    implements Connection {
        private Connection dbCon;
        private ResourceHandle handle;
        private boolean closed;

        ConnectionWrapper(ResourceHandle handle, Connection dbCon) {
            this.dbCon = dbCon;
            this.handle = handle;
        }

        ConnectionWrapper(ResourceHandle handle) {
            this.handle = handle;
            this.dbCon = ((ConnectionWrapper)handle.getUserConnection()).dbCon;
        }

        public Statement createStatement() throws SQLException {
            this.errorIfClosed();
            Statement dbStatement = this.dbCon.createStatement();
            return dbStatement;
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.errorIfClosed();
            PreparedStatement pStmt = this.dbCon.prepareStatement(sql);
            return pStmt;
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.errorIfClosed();
            CallableStatement cStmt = this.dbCon.prepareCall(sql);
            return cStmt;
        }

        public String nativeSQL(String sql) throws SQLException {
            this.errorIfClosed();
            return this.dbCon.nativeSQL(sql);
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setAutoCommit(autoCommit);
        }

        public boolean getAutoCommit() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getAutoCommit();
        }

        public void commit() throws SQLException {
            this.errorIfClosed();
            this.dbCon.commit();
        }

        public void rollback() throws SQLException {
            this.errorIfClosed();
            this.dbCon.rollback();
        }

        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.handle.getShareCount() == 0) {
                this.dbCon.close();
                Jdbc20XaAllocator.this.poolMgr.resourceClosed(this.handle);
            } else {
                this.handle.decrementCount();
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getMetaData();
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setReadOnly(readOnly);
        }

        public boolean isReadOnly() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.isReadOnly();
        }

        public void setCatalog(String catalog) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setCatalog(catalog);
        }

        public String getCatalog() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getCatalog();
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setTransactionIsolation(level);
        }

        public int getTransactionIsolation() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.errorIfClosed();
            this.dbCon.clearWarnings();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.errorIfClosed();
            this.dbCon.setTypeMap(map);
        }

        public Map getTypeMap() throws SQLException {
            this.errorIfClosed();
            return this.dbCon.getTypeMap();
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            PreparedStatement pStmt = this.dbCon.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return pStmt;
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            Statement dbStatement = this.dbCon.createStatement(resultSetType, resultSetConcurrency);
            return dbStatement;
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            CallableStatement cStmt = this.dbCon.prepareCall(sql, resultSetType, resultSetConcurrency);
            return cStmt;
        }

        private void errorIfClosed() throws SQLException {
            if (this.closed) {
                throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
            }
        }
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            XAConnection con = (XAConnection)evt.getSource();
            con.removeConnectionEventListener(this);
            Jdbc20XaAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

