/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.java;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.naming.SerialNameParser;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ResolveResult;

public class javaURLContext
implements Context {
    public static final String JAVA_URL = "java:";
    public static final String COMP_STRING = "comp";
    public static final String PM_STRING = "pm";
    public static final boolean debug = false;
    static NameParser myParser = new SerialNameParser();
    Hashtable myEnv;
    private Context ctx;

    public javaURLContext(Hashtable environment) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new javaURLContext(this.myEnv);
        }
        ResolveResult r2 = this.getComponentContext(name);
        this.ctx = (Context)r2.getResolvedObj();
        name = r2.getRemainingName().toString();
        return this.ctx.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        this.callBindOrRebind(name, obj, false);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.callBindOrRebind(name, obj, true);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    private void callBindOrRebind(String name, Object obj, boolean rebind) throws NamingException {
        ResolveResult r2 = this.getComponentContext(name);
        this.ctx = (Context)r2.getResolvedObj();
        name = r2.getRemainingName().toString();
        if (rebind) {
            this.ctx.rebind(name, obj);
        } else {
            this.ctx.bind(name, obj);
        }
    }

    public void unbind(String name) throws NamingException {
        ResolveResult r2 = this.getComponentContext(name);
        this.ctx = (Context)r2.getResolvedObj();
        name = r2.getRemainingName().toString();
        this.ctx.unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException("Cannot rename in the java:comp namespace");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            SerialContext c10 = new SerialContext("", this.myEnv);
            return c10.list("");
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            SerialContext c10 = new SerialContext("", this.myEnv);
            return c10.listBindings("");
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("javaURLContext does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("javaURLContext does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }

    private ResolveResult getComponentContext(String name) throws NamingException {
        String compId = "";
        name = this.getRelativeName(name);
        Context context = null;
        if (name.equals("")) {
            context = new javaURLContext(this.myEnv);
        } else if (name.startsWith("env")) {
            NamingManager namingManager = Switch.getSwitch().getNamingManager();
            if (namingManager == null) {
                throw new NamingException("java:comp/env namespace is only available from within a J2EE component");
            }
            compId = namingManager.getComponentId();
            context = new SerialContext(compId, this.myEnv);
        } else {
            context = new SerialContext("", this.myEnv);
        }
        ResolveResult r2 = new ResolveResult((Object)context, name);
        return r2;
    }

    private String getRelativeName(String name) throws NamingException {
        if (!name.startsWith(JAVA_URL)) {
            name = "java:comp/" + name;
        }
        int start = 0;
        start = name.indexOf(":");
        name = name.substring(++start, name.length());
        CompositeName n2 = new CompositeName(name);
        if (name.startsWith(COMP_STRING)) {
            if (name.equals(COMP_STRING)) {
                return "";
            }
            name = name.substring(COMP_STRING.length() + 1, name.length());
        } else if (name.startsWith(PM_STRING)) {
            name = name.substring(PM_STRING.length() + 1, name.length());
        } else {
            throw new NameNotFoundException("Invalid name:" + name);
        }
        return name;
    }
}

