/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.enterprise.iiop.security.Logger;
import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUtils {
    public static final ObjectIdentifier GSSUP_MECH_OID;
    public static final ObjectIdentifier GSS_NT_EXPORT_NAME_OID;
    public static final ObjectIdentifier GSS_NT_SCOPED_USERNAME_OID;

    public static String dumpHex(byte[] octets) {
        StringBuffer result = new StringBuffer("");
        int i2 = 0;
        while (i2 < octets.length) {
            String hex;
            int b10;
            if (i2 != 0 && i2 % 16 == 0) {
                result.append("\n    ");
            }
            if ((b10 = octets[i2]) < 0) {
                b10 = 256 + b10;
            }
            if ((hex = Integer.toHexString(b10)).length() == 1) {
                hex = "0" + hex;
            }
            result.append(hex + " ");
            ++i2;
        }
        return result.toString();
    }

    public static byte[] importName(ObjectIdentifier oid, byte[] externalName) throws IOException {
        Logger.fine("Attempting to import mechanism independent name");
        Logger.fine(GSSUtils.dumpHex(externalName));
        IOException e10 = new IOException("Invalid Name");
        if (externalName[0] != 4) {
            throw e10;
        }
        if (externalName[1] != 1) {
            throw e10;
        }
        int mechoidlen = (externalName[2] << 8) + externalName[3];
        Logger.fine("Mech OID length = " + mechoidlen);
        if (externalName.length < 4 + mechoidlen + 4) {
            throw e10;
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(externalName, 4, deroid, 0, mechoidlen);
        ObjectIdentifier oid1 = GSSUtils.getOID(deroid);
        if (!oid1.equals(oid)) {
            throw e10;
        }
        int pos = 4 + mechoidlen;
        int namelen = (externalName[pos] << 24) + (externalName[pos + 1] << 16) + (externalName[pos + 2] << 8) + externalName[pos + 3];
        pos += 4;
        if (externalName.length != 4 + mechoidlen + 4 + namelen) {
            throw e10;
        }
        byte[] name = new byte[externalName.length - pos];
        System.arraycopy(externalName, pos, name, 0, externalName.length - pos);
        Logger.fine("Mechanism specific name:");
        Logger.fine(GSSUtils.dumpHex(name));
        Logger.fine("Successfully imported mechanism independent name");
        return name;
    }

    public static byte[] createExportedName(ObjectIdentifier oid, byte[] extName) throws IOException {
        byte[] oidDER = GSSUtils.getDER(oid);
        int tokensize = 4 + oidDER.length + 4 + extName.length;
        byte[] token = new byte[tokensize];
        int pos = 0;
        token[0] = 4;
        token[1] = 1;
        token[2] = (byte)(oidDER.length & 0xFF00);
        token[3] = (byte)(oidDER.length & 0xFF);
        pos = 4;
        System.arraycopy(oidDER, 0, token, pos, oidDER.length);
        pos += oidDER.length;
        int namelen = extName.length;
        token[pos++] = (byte)(namelen & 0xFF0000);
        token[pos++] = (byte)(namelen & 0xFF00);
        token[pos++] = (byte)(namelen & 0xFF00);
        token[pos++] = (byte)(namelen & 0xFF);
        System.arraycopy(extName, 0, token, pos, namelen);
        return token;
    }

    public static byte[] getDER(ObjectIdentifier id) throws IOException {
        Logger.fine("Returning OID in DER format");
        Logger.fine("    OID = " + id.toString());
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(id);
        byte[] oid = dos.toByteArray();
        Logger.fine("    DER OID: " + GSSUtils.dumpHex(oid));
        return oid;
    }

    public static ObjectIdentifier getOID(byte[] derOID) throws IOException {
        DerInputStream dis = new DerInputStream(derOID);
        ObjectIdentifier oid = dis.getOID();
        return oid;
    }

    public static byte[] createMechIndToken(ObjectIdentifier mechoid, byte[] mechtok) throws IOException {
        byte[] deroid = GSSUtils.getDER(mechoid);
        byte[] token = new byte[1 + GSSUtils.getDERLengthSize(deroid.length + mechtok.length) + deroid.length + mechtok.length];
        Logger.fine("Going to create a mechanism independent token");
        int index = 0;
        token[index++] = 96;
        index = GSSUtils.writeDERLength(token, index, deroid.length + mechtok.length);
        System.arraycopy(deroid, 0, token, index, deroid.length);
        System.arraycopy(mechtok, 0, token, index += deroid.length, mechtok.length);
        Logger.fine("Mechanism independent token created: ");
        Logger.fine(GSSUtils.dumpHex(token));
        return token;
    }

    public static byte[] getMechToken(ObjectIdentifier oid, byte[] token) {
        byte[] mechtoken = null;
        Logger.fine("Received mechanism independent token: ");
        Logger.fine(GSSUtils.dumpHex(token));
        try {
            int index = GSSUtils.verifyTokenHeader(oid, token);
            int mechtoklen = token.length - index;
            mechtoken = new byte[mechtoklen];
            System.arraycopy(token, index, mechtoken, 0, mechtoklen);
            Logger.fine("Mechanism specific token : ");
            Logger.fine(GSSUtils.dumpHex(mechtoken));
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
        return mechtoken;
    }

    private static int verifyTokenHeader(ObjectIdentifier oid, byte[] token) throws IOException {
        int index = 0;
        Logger.fine("Attempting to verify tokenheader in the mechanism independent token.");
        if (token[index++] != 96) {
            throw new IOException("Defective Token");
        }
        int toklen = GSSUtils.readDERLength(token, index);
        Logger.fine("Mech OID length + Mech specific length = " + toklen);
        Logger.fine("Mechanism OID index : " + (index += GSSUtils.getDERLengthSize(toklen)));
        if (token[index] != 6) {
            throw new IOException("Defective Token");
        }
        byte[] buf = new byte[token.length - index];
        System.arraycopy(token, index, buf, 0, token.length - index);
        ObjectIdentifier mechoid = GSSUtils.getOID(buf);
        Logger.fine("Comparing mech OID in token with the expected mech OID");
        Logger.fine("mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(mechoid)));
        Logger.fine("expected mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(oid)));
        if (!mechoid.equals(oid)) {
            Logger.fine("mech OID in token does not match expected mech OID");
            throw new IOException("Defective token");
        }
        int mechoidlen = GSSUtils.getDER(oid).length;
        Logger.fine("Mechanism specific token index : " + index + mechoidlen);
        Logger.fine("Successfully verified header in the mechanism independent token.");
        return index + mechoidlen;
    }

    static int getDERLengthSize(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    static int writeDERLength(byte[] token, int index, int length) {
        if (length < 128) {
            token[index++] = (byte)length;
        } else {
            token[index++] = (byte)(GSSUtils.getDERLengthSize(length) + 127);
            if (length >= 0x1000000) {
                token[index++] = (byte)(length >> 24);
            }
            if (length >= 65536) {
                token[index++] = (byte)(length >> 16 & 0xFF);
            }
            if (length >= 256) {
                token[index++] = (byte)(length >> 8 & 0xFF);
            }
            token[index++] = (byte)(length & 0xFF);
        }
        return index;
    }

    static int readDERLength(byte[] token, int index) {
        int sf;
        int ret = 0;
        if (((sf = token[index++]) & 0x80) == 128) {
            int nooctets = sf & 0x7F;
            while (nooctets != 0) {
                ret = (ret << 8) + (token[index++] & 0xFF);
                --nooctets;
            }
        } else {
            ret = sf;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            byte[] len = new byte[]{-126, 1, -45};
            Logger.fine("Length byte array : " + GSSUtils.dumpHex(len));
            Logger.fine(" Der length = " + GSSUtils.readDERLength(len, 0));
            String name = "default";
            byte[] externalName = GSSUtils.createExportedName(GSSUP_MECH_OID, name.getBytes());
            byte[] m2 = GSSUtils.importName(GSSUP_MECH_OID, externalName);
            System.out.println("BAR:" + new String(m2));
            String msg = "dummy_gss_export_sec_context";
            byte[] foo = GSSUtils.createMechIndToken(GSSUP_MECH_OID, msg.getBytes());
            System.out.println("FOO:" + GSSUtils.dumpHex(foo));
            byte[] msg1 = GSSUtils.getMechToken(GSSUP_MECH_OID, foo);
            System.out.println("BAR:" + GSSUtils.dumpHex(msg1));
            System.out.println("BAR string: " + new String(msg1));
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    static {
        int i2 = "oid:2.23.130.1.1.1".indexOf(58);
        GSSUP_MECH_OID = new ObjectIdentifier("oid:2.23.130.1.1.1".substring(i2 + 1));
        i2 = "oid:1.3.6.1.5.6.4".indexOf(58);
        GSS_NT_EXPORT_NAME_OID = new ObjectIdentifier("oid:1.3.6.1.5.6.4".substring(i2 + 1));
        i2 = "oid:2.23.130.1.2.1".indexOf(58);
        GSS_NT_SCOPED_USERNAME_OID = new ObjectIdentifier("oid:2.23.130.1.2.1".substring(i2 + 1));
        try {
            Logger.fine("GSSUP_MECH_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSSUP_MECH_OID)));
            Logger.fine("GSS_NT_EXPORT_NAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_EXPORT_NAME_OID)));
            Logger.fine("GSS_NT_SCOPED_USERNAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_SCOPED_USERNAME_OID)));
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
    }
}

