/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.XMLTree;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.parser.Resolver;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLParser {
    private XmlDocument doc = null;
    private static final boolean DefaultCheckType = false;
    private static final String DefaultContentType = "text/html;charset=utf-8";
    private static final String DefaultScheme = "file";
    private static final boolean DefaultXMLValidate = true;
    private static final int PCDataType = 3;

    public void clear() {
        this.doc = null;
    }

    public XMLTree process(InputStream is) throws IOException, SAXParseException, SAXException {
        return this.process(is, false, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType) throws IOException, SAXParseException, SAXException {
        return this.process(is, checkType, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType) throws IOException, SAXParseException, SAXException {
        return this.process(is, checkType, contentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, String scheme) throws IOException, SAXParseException, SAXException {
        return this.parse(Resolver.createInputSource(contentType, is, checkType, scheme), checkType);
    }

    public XMLTree process(URL uri) throws IOException, SAXParseException, SAXException {
        return this.process(uri, false);
    }

    public XMLTree process(URL uri, boolean checkType) throws IOException, SAXParseException, SAXException {
        return this.parse(new InputSource(uri.toString()), checkType);
    }

    public XmlDocument getXmlDocument() {
        return this.doc;
    }

    public void write() throws IOException {
        this.write(null);
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            os = System.out;
        }
        this.doc.getDocumentElement().normalize();
        this.doc.write(os);
    }

    private XMLTree parse(InputSource is) throws IOException, SAXParseException, SAXException {
        return this.parse(is, true);
    }

    private XMLTree parse(InputSource is, boolean validate) throws IOException, SAXParseException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        if (validate) {
            spf.setValidating(true);
        } else {
            spf.setValidating(false);
        }
        try {
            XMLReader parser = spf.newSAXParser().getXMLReader();
            Resolver resolver = new Resolver();
            XmlDocumentBuilder builder = new XmlDocumentBuilder();
            String serverURL = XMLUtils.getAbsoluteFilenameURLForDTD(XMLUtils.WEB_DTD);
            String webApplicationURL = XMLUtils.getAbsoluteFilenameURLForDTD(XMLUtils.WEB_DTD);
            resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD Servlet Server 1.0//EN", serverURL);
            resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", webApplicationURL);
            resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", webApplicationURL);
            resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", XMLUtils.getAbsoluteFilenameURLForDTD(XMLUtils.TAGLIB_DTD_11));
            resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", XMLUtils.getAbsoluteFilenameURLForDTD(XMLUtils.TAGLIB_DTD_12));
            parser.setEntityResolver(resolver);
            builder.setDisableNamespaces(true);
            builder.setIgnoringLexicalInfo(true);
            parser.setContentHandler(builder);
            parser.parse(is);
            this.doc = builder.getDocument();
        }
        catch (Exception e10) {
            String systemId = "";
            int lineNumber = -1;
            String message = "";
            String publicId = "";
            int columnNumber = -1;
            if (e10 instanceof SAXParseException) {
                systemId = ((SAXParseException)e10).getSystemId();
                lineNumber = ((SAXParseException)e10).getLineNumber();
                message = ((SAXParseException)e10).getMessage();
                publicId = ((SAXParseException)e10).getPublicId();
                columnNumber = ((SAXParseException)e10).getColumnNumber();
            }
            String msg = "Parse Error: " + systemId + " : " + lineNumber + "\n  msg : " + message;
            throw new SAXParseException(msg, publicId, systemId, lineNumber, columnNumber);
        }
        XMLTree xmlElement = new XMLTree();
        Element element = this.doc.getDocumentElement();
        xmlElement.setName(element.getTagName());
        this.addAttributes(xmlElement, element);
        this.addElements(xmlElement, element);
        return xmlElement;
    }

    private void addAttributes(XMLTree xmlElement, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                Node attribute = attributes.item(i2);
                xmlElement.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
                ++i2;
            }
        }
    }

    private void addElements(XMLTree xmlElement, Node node) {
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            XMLTree childXMLTree = new XMLTree();
            Node childNode = childNodes.item(i2);
            childXMLTree.setName(childNode.getNodeName());
            this.addAttributes(childXMLTree, childNode);
            if (childNode.getNodeType() != 3) {
                this.addElements(childXMLTree, childNode);
                xmlElement.addElement(childXMLTree);
            } else {
                xmlElement.setValue(childNode.getNodeValue());
            }
            ++i2;
        }
    }
}

