/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.w3c.dom.Node;

public class DescriptorNodeUtils {
    static String EJB_STYLE = "EJB_STYLE";
    static String WEB_STYLE = "WEB_STYLE";
    static String SERVLET_STYLE = "SERVLET_STYLE";
    static String APP_STYLE = "APP_STYLE";
    static String APP_CLIENT_STYLE = "APP_CLIENT_STYLE";
    static String TAGLIB_STYLE = "TAGLIB_STYLE";
    static String CONNECTOR_STYLE = "CONNECTOR_STYLE";

    public static void appendDescriptorAttributes(XMLUtils factory, Descriptor descriptor, ElementNode elementNode, String style) {
        DescriptorNodeUtils.appendDescriptorAttributes(factory, descriptor, elementNode, style, null);
    }

    public static void appendDescriptorAttributes(XMLUtils factory, Descriptor descriptor, ElementNode elementNode, String style, ElementNode extraNodeForWeb) {
        ElementNode descriptionNode = null;
        ElementNode displayNameNode = null;
        ElementNode iconNode = null;
        ElementNode smallIconNode = null;
        ElementNode largeIconNode = null;
        Vector<ElementNode> iconNodes = new Vector<ElementNode>();
        if (!"".equals(descriptor.getDescription()) && descriptor.getDescription() != null) {
            descriptionNode = factory.getTextNode("description", descriptor.getDescription());
        }
        if (!"".equals(descriptor.getName()) && descriptor.getName() != null) {
            displayNameNode = factory.getTextNode("display-name", descriptor.getName());
        }
        if ((iconNode = factory.getNode("icon")) != null) {
            if (!"".equals(descriptor.getLargeIconUri()) && descriptor.getLargeIconUri() != null) {
                largeIconNode = factory.getTextNode("large-icon", descriptor.getLargeIconUri());
            }
            if (!"".equals(descriptor.getSmallIconUri()) && descriptor.getSmallIconUri() != null) {
                smallIconNode = factory.getTextNode("small-icon", descriptor.getSmallIconUri());
            }
            if (EJB_STYLE.equals(style)) {
                if (smallIconNode != null) {
                    iconNodes.addElement(smallIconNode);
                }
                if (largeIconNode != null) {
                    iconNodes.addElement(largeIconNode);
                }
            } else if (smallIconNode != null || largeIconNode != null) {
                iconNodes.addElement(iconNode);
                if (smallIconNode != null) {
                    iconNode.appendChild(smallIconNode);
                }
                if (largeIconNode != null) {
                    iconNode.appendChild(largeIconNode);
                }
            }
        }
        if (EJB_STYLE.equals(style)) {
            if (descriptionNode != null) {
                elementNode.appendChild(descriptionNode);
            }
            if (displayNameNode != null) {
                elementNode.appendChild(displayNameNode);
            }
            Enumeration e10 = iconNodes.elements();
            while (e10.hasMoreElements()) {
                elementNode.appendChild((ElementNode)e10.nextElement());
            }
        } else {
            if (SERVLET_STYLE.equals(style)) {
                elementNode.appendChild(extraNodeForWeb);
            }
            if (displayNameNode != null) {
                elementNode.appendChild(displayNameNode);
            }
            if (descriptionNode != null) {
                elementNode.appendChild(descriptionNode);
            }
            Enumeration e11 = iconNodes.elements();
            while (e11.hasMoreElements()) {
                elementNode.appendChild((ElementNode)e11.nextElement());
            }
        }
    }

    public static void appendEnvironmentProperties(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty nextEnvironmentProperty = (EnvironmentProperty)itr.next();
            ElementNode environmentPropertyNode = factory.getNode("env-entry");
            elementNode.appendChild(environmentPropertyNode);
            DescriptorNodeUtils.appendXmlChild(factory, environmentPropertyNode, nextEnvironmentProperty.getDescription(), "description");
            environmentPropertyNode.appendChild(factory.getTextNode("env-entry-name", nextEnvironmentProperty.getName()));
            environmentPropertyNode.appendChild(factory.getTextNode("env-entry-type", nextEnvironmentProperty.getValueType().getName()));
            DescriptorNodeUtils.appendXmlChild(factory, environmentPropertyNode, nextEnvironmentProperty.getValue(), "env-entry-value");
        }
    }

    public static void appendOtherDescriptorAttribs(XMLUtils factory, ConnectorDescriptor descriptor, ElementNode elementNode) {
        Object eisNode = null;
        Object vendorNode = null;
        Object versionNode = null;
        ElementNode license = null;
        ElementNode licenseDescription = null;
        ElementNode licenseRequired = null;
        DescriptorNodeUtils.appendXmlChild2(factory, elementNode, descriptor.getVendorName(), "vendor-name");
        DescriptorNodeUtils.appendXmlChild2(factory, elementNode, descriptor.getVersion(), "spec-version");
        DescriptorNodeUtils.appendXmlChild2(factory, elementNode, descriptor.getEisType(), "eis-type");
        DescriptorNodeUtils.appendXmlChild2(factory, elementNode, descriptor.getVersion(), "version");
        license = factory.getNode("license");
        if (!"".equals(descriptor.getLicenseDescription()) && descriptor.getLicenseDescription() != null) {
            licenseDescription = factory.getTextNode("description", descriptor.getLicenseDescription());
        }
        if (descriptor.getLicenseRequired() != null) {
            licenseRequired = factory.getTextNode("license-required", descriptor.getLicenseRequired().toString());
        }
        if (license != null && licenseRequired != null) {
            if (licenseDescription != null) {
                license.appendChild(licenseDescription);
            }
            license.appendChild(licenseRequired);
            elementNode.appendChild(license);
        }
    }

    public static void appendResourceAdapter(XMLUtils factory, ConnectorDescriptor descriptor, ElementNode elementNode) {
        ElementNode resourceAdapter = null;
        resourceAdapter = factory.getNode("resourceadapter");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getManagedConnectionFactoryImpl(), "managedconnectionfactory-class");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getConnectionFactoryInterface(), "connectionfactory-interface");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getConnectionFactoryImpl(), "connectionfactory-impl-class");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getConnectionInterface(), "connection-interface");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getConnectionImpl(), "connection-impl-class");
        DescriptorNodeUtils.appendXmlChild2(factory, resourceAdapter, descriptor.getTransSupport(), "transaction-support");
        Iterator itr = descriptor.getConfigProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty nextEnvironmentProperty = (EnvironmentProperty)itr.next();
            ElementNode configPropertyNode = factory.getNode("config-property");
            resourceAdapter.appendChild(configPropertyNode);
            DescriptorNodeUtils.appendXmlChild(factory, configPropertyNode, nextEnvironmentProperty.getDescription(), "description");
            DescriptorNodeUtils.appendXmlChild(factory, configPropertyNode, nextEnvironmentProperty.getName(), "config-property-name");
            DescriptorNodeUtils.appendXmlChild(factory, configPropertyNode, nextEnvironmentProperty.getValueType().getName(), "config-property-type");
            DescriptorNodeUtils.appendXmlChild(factory, configPropertyNode, nextEnvironmentProperty.getValue(), "config-property-value");
        }
        Iterator itr2 = descriptor.getAuthMechanisms().iterator();
        while (itr2.hasNext()) {
            AuthMechanism nextAuth = (AuthMechanism)itr2.next();
            ElementNode authNode = factory.getNode("authentication-mechanism");
            resourceAdapter.appendChild(authNode);
            DescriptorNodeUtils.appendXmlChild(factory, authNode, nextAuth.getDescription(), "description");
            DescriptorNodeUtils.appendXmlChild(factory, authNode, nextAuth.getAuthMechType(), "authentication-mechanism-type");
            DescriptorNodeUtils.appendXmlChild2(factory, authNode, nextAuth.getCredentialInterface(), "credential-interface");
        }
        resourceAdapter.appendChild(factory.getTextNode("reauthentication-support", new Boolean(descriptor.supportsReauthentication()).toString()));
        Iterator itr3 = descriptor.getSecurityPermissions().iterator();
        while (itr3.hasNext()) {
            SecurityPermission nextSecPermission = (SecurityPermission)itr3.next();
            ElementNode secNode = factory.getNode("security-permission");
            resourceAdapter.appendChild(secNode);
            DescriptorNodeUtils.appendXmlChild(factory, secNode, nextSecPermission.getDescription(), "description");
            DescriptorNodeUtils.appendXmlChild(factory, secNode, nextSecPermission.getPermission(), "security-permission-spec");
        }
        elementNode.appendChild(resourceAdapter);
    }

    public static void appendEjbReferences(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
            ElementNode ejbReferenceNode = nextEjbReference.isLocal() ? factory.getNode("ejb-local-ref") : factory.getNode("ejb-ref");
            elementNode.appendChild(ejbReferenceNode);
            if (!"".equals(nextEjbReference.getDescription())) {
                ejbReferenceNode.appendChild(factory.getTextNode("description", nextEjbReference.getDescription()));
            }
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-name", nextEjbReference.getName()));
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-type", nextEjbReference.getEjbDescriptor().getType()));
            if (nextEjbReference.isLocal()) {
                ejbReferenceNode.appendChild(factory.getTextNode("local-home", nextEjbReference.getHomeClassName()));
                ejbReferenceNode.appendChild(factory.getTextNode("local", nextEjbReference.getBeanClassName()));
            } else {
                ejbReferenceNode.appendChild(factory.getTextNode("home", nextEjbReference.getHomeClassName()));
                ejbReferenceNode.appendChild(factory.getTextNode("remote", nextEjbReference.getBeanClassName()));
            }
            if (!nextEjbReference.isLinked()) continue;
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-link", nextEjbReference.getLinkName()));
        }
    }

    public static void checkEjbReference(EjbAbstractDescriptor refereeBean, String referenceType, String homeClassName, String remoteClassName, String ejbRefereeName) {
        if (Descriptor.isBoundsChecking()) {
            if (!refereeBean.getType().equals(referenceType)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of type " + referenceType + " but no bean of this name and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getHomeClassName().equals(homeClassName)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of home class " + homeClassName + " but no bean with this home classname and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getRemoteClassName().equals(remoteClassName)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of remote class " + remoteClassName + " but no bean with this remote classname and type can be found in this ejb-jar.");
            }
        }
    }

    public static void checkEjbLocalReference(EjbAbstractDescriptor refereeBean, String referenceType, String localHomeClassName, String localInterfaceClassName, String ejbRefereeName) {
        if (Descriptor.isBoundsChecking()) {
            if (!refereeBean.getType().equals(referenceType)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of type " + referenceType + " but no bean of this name and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getLocalHomeClassName().equals(localHomeClassName)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of local home class " + localHomeClassName + " but no bean with this local home classname and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getLocalClassName().equals(localInterfaceClassName)) {
                throw new IllegalArgumentException(refereeBean.getName() + " says it links to an ejb called " + ejbRefereeName + " of local interface class " + localInterfaceClassName + " but no bean with this local interface classname and type can be found in this ejb-jar.");
            }
        }
    }

    public static void appendResourceReferences(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor nextResourceReference = (ResourceReferenceDescriptor)itr.next();
            ElementNode resourceReferenceNode = factory.getNode("resource-ref");
            elementNode.appendChild(resourceReferenceNode);
            if (!nextResourceReference.getDescription().equals("")) {
                resourceReferenceNode.appendChild(factory.getTextNode("description", nextResourceReference.getDescription()));
            }
            resourceReferenceNode.appendChild(factory.getTextNode("res-ref-name", nextResourceReference.getName()));
            resourceReferenceNode.appendChild(factory.getTextNode("res-type", nextResourceReference.getType()));
            resourceReferenceNode.appendChild(factory.getTextNode("res-auth", nextResourceReference.getAuthorization()));
            if (nextResourceReference.getSharingScope().equals("")) continue;
            resourceReferenceNode.appendChild(factory.getTextNode("res-sharing-scope", nextResourceReference.getSharingScope()));
        }
    }

    public static void appendJmsDestinationReferences(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            JmsDestinationReferenceDescriptor nextJmsDestRef = (JmsDestinationReferenceDescriptor)itr.next();
            ElementNode jmsDestRefNode = factory.getNode("resource-env-ref");
            elementNode.appendChild(jmsDestRefNode);
            if (!nextJmsDestRef.getDescription().equals("")) {
                jmsDestRefNode.appendChild(factory.getTextNode("description", nextJmsDestRef.getDescription()));
            }
            jmsDestRefNode.appendChild(factory.getTextNode("resource-env-ref-name", nextJmsDestRef.getName()));
            jmsDestRefNode.appendChild(factory.getTextNode("resource-env-ref-type", nextJmsDestRef.getRefType()));
        }
    }

    public static void setEnvironmentProperties(ElementNode elementNode, WritableJndiNameEnvironment descriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)elementNode, "env-entry");
        while (e10.hasMoreElements()) {
            ElementNode nextEnvironmentPropertyNode = (ElementNode)e10.nextElement();
            String optionalDescription = "";
            if (XMLUtils.hasNodesUnder(nextEnvironmentPropertyNode, "description")) {
                optionalDescription = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "description");
            }
            String type = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-type");
            String value = "";
            if (XMLUtils.hasNodesUnder(nextEnvironmentPropertyNode, "env-entry-value")) {
                value = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-value");
            }
            EnvironmentProperty environmentProperty = new EnvironmentProperty(XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-name"), value, optionalDescription, type);
            descriptor.addEnvironmentProperty(environmentProperty);
        }
    }

    public static void setResourceReferences(ElementNode elementNode, WritableJndiNameEnvironment descriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)elementNode, "resource-ref");
        while (e10.hasMoreElements()) {
            ElementNode nextResourceNode = (ElementNode)e10.nextElement();
            String optionalDescription = "";
            if (XMLUtils.hasNodesUnder(nextResourceNode, "description")) {
                optionalDescription = XMLUtils.getTextFor(nextResourceNode, "description");
            }
            String resourceReferenceName = XMLUtils.getTextFor(nextResourceNode, "res-ref-name");
            ResourceReferenceDescriptor resourceReference = new ResourceReferenceDescriptor(resourceReferenceName, optionalDescription, XMLUtils.getTextFor(nextResourceNode, "res-type"));
            resourceReference.setAuthorization(XMLUtils.getTextFor(nextResourceNode, "res-auth"));
            if (XMLUtils.hasNodesUnder(nextResourceNode, "res-sharing-scope")) {
                String resourceSharing = XMLUtils.getTextFor(nextResourceNode, "res-sharing-scope");
                resourceReference.setSharingScope(resourceSharing);
            }
            descriptor.addResourceReferenceDescriptor(resourceReference);
        }
    }

    public static void setJmsDestinationReferences(ElementNode elementNode, WritableJndiNameEnvironment descriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)elementNode, "resource-env-ref");
        while (e10.hasMoreElements()) {
            ElementNode nextJmsDestRefNode = (ElementNode)e10.nextElement();
            String optionalDescription = "";
            if (XMLUtils.hasNodesUnder(nextJmsDestRefNode, "description")) {
                optionalDescription = XMLUtils.getTextFor(nextJmsDestRefNode, "description");
            }
            String jmsDestRefName = XMLUtils.getTextFor(nextJmsDestRefNode, "resource-env-ref-name");
            JmsDestinationReferenceDescriptor jmsDestReference = new JmsDestinationReferenceDescriptor(jmsDestRefName, optionalDescription, XMLUtils.getTextFor(nextJmsDestRefNode, "resource-env-ref-type"));
            descriptor.addJmsDestinationReferenceDescriptor(jmsDestReference);
        }
    }

    public static void setDescriptorAttributes(ElementNode elementNode, Descriptor descriptor, String style) {
        if (XMLUtils.hasImmediateElementChildFor(elementNode, "description")) {
            descriptor.setDescription(XMLUtils.getTextFor(elementNode, "description"));
        }
        if (XMLUtils.hasImmediateElementChildFor(elementNode, "display-name")) {
            descriptor.setName(XMLUtils.getTextFor(elementNode, "display-name"));
        }
        ElementNode iconHolderNode = null;
        iconHolderNode = EJB_STYLE.equals(style) ? elementNode : XMLUtils.getFirstNodeUnder(elementNode, "icon");
        if (iconHolderNode != null) {
            if (XMLUtils.hasImmediateElementChildFor(iconHolderNode, "large-icon")) {
                descriptor.setLargeIconUri(XMLUtils.getTextFor(elementNode, "large-icon"));
            }
            if (XMLUtils.hasImmediateElementChildFor(iconHolderNode, "small-icon")) {
                descriptor.setSmallIconUri(XMLUtils.getTextFor(elementNode, "small-icon"));
            }
        }
    }

    public static void appendXmlChild(XMLUtils factory, ElementNode node, String s2, String tag) {
        if (!"".equals(s2) && s2 != null) {
            node.appendChild(factory.getTextNode(tag, s2));
        }
    }

    public static void appendXmlChild2(XMLUtils factory, ElementNode node, String s2, String tag) {
        if (s2 == null) {
            throw new NullPointerException("Cannot have null value for mandatory element");
        }
        node.appendChild(factory.getTextNode(tag, s2));
    }
}

