/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class HttpAuthenticator
extends Authenticator {
    public static final boolean debug = true;
    private AppContainer container = null;

    public HttpAuthenticator(AppContainer container) {
        this.container = container;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        String user = null;
        String password = null;
        Subject subject = null;
        String scheme = this.getRequestingScheme();
        System.out.println("scheme=" + scheme);
        System.out.println("requesting prompt=" + this.getRequestingPrompt());
        System.out.println("requesting protocol=" + this.getRequestingProtocol());
        LoginContext[] ctx = this.container.getLoginContexts();
        subject = ctx[0].getSubject();
        user = this.getUserName(subject);
        password = this.getPassword(subject);
        if (user == null || password == null) {
            try {
                System.out.println("Initiating login again...");
                ctx[0].login();
                subject = ctx[0].getSubject();
                user = this.getUserName(subject);
                password = this.getPassword(subject);
            }
            catch (Exception e10) {
                e10.printStackTrace();
                return null;
            }
        }
        System.out.println("Username:" + user + " Password:" + password);
        return new PasswordAuthentication(user, password.toCharArray());
    }

    private String getUserName(Subject s2) {
        String user = null;
        if (s2 == null) {
            return null;
        }
        Set principalSet = s2.getPrincipals();
        Iterator itr = principalSet.iterator();
        if (itr.hasNext()) {
            Principal p2 = (Principal)itr.next();
            user = p2.getName();
        }
        return user;
    }

    private String getPassword(Subject s2) {
        Object o2;
        String password = null;
        if (s2 == null) {
            return null;
        }
        Set credentials = s2.getPrivateCredentials();
        Iterator credIter = credentials.iterator();
        if (credIter.hasNext() && (o2 = credIter.next()) instanceof PasswordCredential) {
            PasswordCredential pc = (PasswordCredential)o2;
            password = pc.getPassword();
        }
        return password;
    }
}

