/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.enterprise.log.Log;
import java.util.Vector;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

final class ContainerSynchronization
implements Synchronization {
    private Vector beans = new Vector();
    private Vector pmSyncs = new Vector();
    private Transaction tx;
    private ContainerFactoryImpl containerFactory;

    ContainerSynchronization(Transaction tx, ContainerFactoryImpl containerFactory) {
        this.tx = tx;
        this.containerFactory = containerFactory;
    }

    void addBean(EJBContextImpl bean) {
        this.beans.add(bean);
    }

    void addPMSynchronization(Synchronization sync) {
        this.pmSyncs.add(sync);
    }

    public void beforeCompletion() {
        int i2 = 0;
        while (i2 < this.beans.size()) {
            EJBContextImpl context = (EJBContextImpl)this.beans.elementAt(i2);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                container.beforeCompletion(context);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException e10) {
                    // empty catch block
                }
                return;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.pmSyncs.size()) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i3);
            try {
                sync.beforeCompletion();
            }
            catch (Exception ex3) {
                Log.err.println(ex3);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException e11) {
                    // empty catch block
                }
                return;
            }
            ++i3;
        }
    }

    public void afterCompletion(int status) {
        int i2 = 0;
        while (i2 < this.beans.size()) {
            EJBContextImpl context = (EJBContextImpl)this.beans.elementAt(i2);
            BaseContainer container = (BaseContainer)context.getContainer();
            try {
                container.afterCompletion(context, status);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.pmSyncs.size()) {
            Synchronization sync = (Synchronization)this.pmSyncs.elementAt(i3);
            try {
                sync.afterCompletion(status);
            }
            catch (Exception ex3) {
                // empty catch block
            }
            ++i3;
        }
        this.containerFactory.removeContainerSync(this.tx);
    }
}

