/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Interceptors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;

public class InterceptorList {
    static final int INTERCEPTOR_TYPE_CLIENT = 0;
    static final int INTERCEPTOR_TYPE_SERVER = 1;
    static final int INTERCEPTOR_TYPE_IOR = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{class$org$omg$PortableInterceptor$ClientRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ClientRequestInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.ClientRequestInterceptor")) : class$org$omg$PortableInterceptor$ClientRequestInterceptor, class$org$omg$PortableInterceptor$ServerRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ServerRequestInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.ServerRequestInterceptor")) : class$org$omg$PortableInterceptor$ServerRequestInterceptor, class$org$omg$PortableInterceptor$IORInterceptor == null ? (class$org$omg$PortableInterceptor$IORInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.IORInterceptor")) : class$org$omg$PortableInterceptor$IORInterceptor};
    private boolean locked = false;
    private Interceptor[][] interceptors = new Interceptor[3][];
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ClientRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ServerRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$IORInterceptor;

    InterceptorList() {
        this.initInterceptorArrays();
    }

    void register_interceptor(Interceptor interceptor, int n2) throws DuplicateName {
        if (this.locked) {
            throw new INTERNAL("InterceptorList is locked.");
        }
        String string = interceptor.name();
        boolean bl2 = string.equals("");
        boolean bl3 = false;
        Interceptor[] interceptorArray = this.interceptors[n2];
        if (!bl2) {
            int n3 = interceptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Interceptor interceptor2 = interceptorArray[n4];
                if (interceptor2.name().equals(string)) {
                    bl3 = true;
                    break;
                }
                ++n4;
            }
        }
        if (bl3) {
            throw new DuplicateName(string);
        }
        this.growInterceptorArray(n2);
        this.interceptors[n2][this.interceptors[n2].length - 1] = interceptor;
    }

    void lock() {
        this.locked = true;
    }

    Interceptor[] getInterceptors(int n2) {
        return this.interceptors[n2];
    }

    boolean hasInterceptorsOfType(int n2) {
        return this.interceptors[n2].length > 0;
    }

    private void initInterceptorArrays() {
        int n2 = 0;
        while (n2 < 3) {
            Class clazz = classTypes[n2];
            this.interceptors[n2] = (Interceptor[])Array.newInstance(clazz, 0);
            ++n2;
        }
    }

    private void growInterceptorArray(int n2) {
        Class clazz = classTypes[n2];
        int n3 = this.interceptors[n2].length;
        Interceptor[] interceptorArray = (Interceptor[])Array.newInstance(clazz, n3 + 1);
        System.arraycopy(this.interceptors[n2], 0, interceptorArray, 0, n3);
        this.interceptors[n2] = interceptorArray;
    }

    void destroyAll() {
        int n2 = this.interceptors.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.interceptors[n3].length;
            int n5 = 0;
            while (n5 < n4) {
                this.interceptors[n3][n5].destroy();
                ++n5;
            }
            ++n3;
        }
    }

    void sortInterceptors() {
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        int n2 = this.interceptors.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            int n4 = this.interceptors[n3].length;
            if (n4 > 0) {
                arrayList = new ArrayList<Object>();
                arrayList2 = new ArrayList<Object>();
            }
            int n5 = 0;
            while (n5 < n4) {
                object = this.interceptors[n3][n5];
                if (object instanceof Comparable) {
                    arrayList.add(object);
                } else {
                    arrayList2.add(object);
                }
                ++n5;
            }
            if (n4 > 0 && arrayList.size() > 0) {
                Collections.sort(arrayList);
                object = arrayList.iterator();
                Iterator iterator = arrayList2.iterator();
                int n6 = 0;
                while (n6 < n4) {
                    if (object.hasNext()) {
                        this.interceptors[n3][n6] = (Interceptor)object.next();
                    } else if (iterator.hasNext()) {
                        this.interceptors[n3][n6] = (Interceptor)iterator.next();
                    } else {
                        throw new INTERNAL("InterceptorList.sortInterceptors");
                    }
                    ++n6;
                }
            }
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

