/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlclass;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class SqlCppTest
extends TestCase {
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final int DBERR_SPACE_EXHAUSTED = -904;
    private static final int DBERR_DB_FULL = -900;
    private static final int DBERR_NO_MORE_MEMORY = -915;
    private static final int DBERR_TRIGGER_FAILED = -9406;
    private static final String sUser = "SQLCPP";
    private static final String sPassword = "SQLCPP";
    private static final boolean m_consoleMsg = true;
    private static int LC_VERSION = 0;
    private DBM mDBMan = null;

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = SqlCppTest.getDatabase().getHost();
            mName = SqlCppTest.getDatabase().getName();
            int mPort = SqlCppTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON " + SqlCppTest.getDatabase().getDBMUser() + "," + SqlCppTest.getDatabase().getDBMPassword();
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void Trace(boolean consoleMsg, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        SqlCppTest.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private static void callTestWithoutParms(TestStatement Statement2, String ProcedureName) throws TestCaseException {
        String CallString = "";
        boolean retryCall = true;
        while (retryCall) {
            try {
                CallString = "CALL " + ProcedureName;
                Statement2.execute(CallString);
                retryCall = false;
            }
            catch (SQLException e) {
                if (-915 == e.getErrorCode() || -9406 == e.getErrorCode()) {
                    retryCall = true;
                    continue;
                }
                retryCall = false;
                if (-904 == e.getErrorCode() || -900 == e.getErrorCode()) continue;
                throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
            }
        }
    }

    private static void deleteTable(TestStatement Statement2, String TableName) throws TestCaseException {
        block2: {
            String CallString = "";
            try {
                CallString = "delete " + TableName;
                Statement2.execute(CallString);
            }
            catch (SQLException e) {
                if (-904 == e.getErrorCode()) break block2;
                throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
            }
        }
    }

    public static void createPackageWithFile(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " FILE '" + PackageIdentifier + "' " + CreationMode;
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getLocalizedMessage());
        }
    }

    private static void createPackage(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " AS '" + PackageIdentifier + "' " + " INPROC";
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    private static void createProc(TestStatement Statement2, String ProcedureName, String PackageName) throws TestCaseException {
        String CallString = "";
        try {
            CallString = "CREATE DBPROC " + ProcedureName + " IN " + PackageName + " EXECUTE INPROC";
            Statement2.execute(CallString);
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        String pkg = "SQLCPP_PACKAGE";
        try {
            try {
                con = SqlCppTest.getDatabase().connect("SQLCPP", "SQLCPP");
                stmt = new TestStatement(null, con);
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    SqlCppTest.createPackageWithFile(stmt, pkg, "lcsqlcpp");
                } else {
                    SqlCppTest.createPackage(stmt, pkg, "liveCache.lcsqlcpp.v1.0");
                }
                SqlCppTest.createProc(stmt, "LCSQLCPP_TEST1", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_TEST2", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_TEST3", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_TEST4", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_FILL_DB", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_PARSEAGAIN_PREP", pkg);
                SqlCppTest.createProc(stmt, "LCSQLCPP_PARSEAGAIN_EXEC", pkg);
                con.commit();
            }
            catch (Exception e) {
                SqlCppTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
                throw new TestCaseException("SqlCppTest.createDBProcedures() failed");
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    public static void cleanUp() throws TestCaseException {
    }

    public static String getTestClassId() {
        return null;
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            try {
                block10: {
                    lDefConnection = SqlCppTest.getDatabase().connect(SqlCppTest.getUser(), SqlCppTest.getPassword());
                    LC_VERSION = SqlCppTest.xgetVersionString();
                    lDefTstmt = new TestStatement(null, lDefConnection);
                    lDefTstmt.enableExceptions(false);
                    lDefTstmt.executeUpdate("drop user SQLCPP");
                    lDefTstmt.enableExceptions(true);
                    try {
                        lDefTstmt.executeUpdate("Create user SQLCPP password SQLCPP dba not exclusive");
                    }
                    catch (DatabaseException e) {
                        if (e.getErrorCode() == -6006) break block10;
                        SqlCppTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : SQLCPP not possible");
                        throw e;
                    }
                }
                SqlCppTest.createDBProcedures();
            }
            catch (Exception e) {
                SqlCppTest.handleGlobalExceptions((Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                lDefTstmt.close();
                lDefConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        lDefTstmt.close();
        lDefConnection.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection lConnection = null;
        Connection lConnection2 = null;
        TestStatement lTstmt = null;
        TestStatement lTstmt2 = null;
        Object lTPstmt = null;
        try {
            try {
                if (LC_VERSION > 743) {
                    SqlCppTest.Trace(true, "Stop DB and start TEST-DB (testing exceptions provoked by thrown BAD_ALLOCs)");
                    this.executeDBMCmd("db_offline");
                    this.executeDBMCmd("db_online -t");
                }
                lConnection = SqlCppTest.getDatabase().connect("SQLCPP", "SQLCPP");
                lTstmt = new TestStatement((TestCase)this, lConnection);
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_TEST1");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_TEST2");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_TEST3");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_TEST4");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_FILL_DB");
                lTstmt.execute("ROLLBACK");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_PARSEAGAIN_PREP");
                lTstmt.execute("COMMIT");
                lConnection2 = SqlCppTest.getDatabase().connect("SQLCPP", "SQLCPP");
                lTstmt2 = new TestStatement((TestCase)this, lConnection2);
                SqlCppTest.deleteTable(lTstmt2, "LCSQLCPP_PARSEAGAIN");
                lTstmt2.execute("COMMIT");
                SqlCppTest.callTestWithoutParms(lTstmt, "LCSQLCPP_PARSEAGAIN_EXEC");
                SqlCppTest.Trace(true, "restart DB in normal mode");
                this.executeDBMCmd("db_restart");
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                lTstmt.close();
                lTPstmt.close();
                lConnection.close();
                SqlCppTest.Trace(true, "restart DB kernel");
                this.executeDBMCmd("db_restart");
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        lTstmt.close();
        lTPstmt.close();
        lConnection.close();
        SqlCppTest.Trace(true, "restart DB kernel");
        this.executeDBMCmd("db_restart");
    }

    private static int xgetVersionString() {
        String KernelVersion = "";
        try {
            KernelVersion = ((TestDatabaseSap)SqlCppTest.getDatabase()).getKernelVersion();
            SqlCppTest.Trace(true, "Running livecache kernel version: " + KernelVersion);
        }
        catch (TestDatabaseException testDatabaseException) {
            // empty catch block
        }
        if (KernelVersion.equals("7.2.4")) {
            return 724;
        }
        if (KernelVersion.equals("7.2.5")) {
            return 725;
        }
        if (KernelVersion.equals("7.4.1")) {
            return 741;
        }
        if (KernelVersion.equals("7.4.2")) {
            return 742;
        }
        if (KernelVersion.equals("7.4.3")) {
            return 743;
        }
        if (KernelVersion.equals("7.4.4")) {
            return 744;
        }
        if (KernelVersion.equals("7.4.5")) {
            return 745;
        }
        if (KernelVersion.equals("7.4.6")) {
            return 746;
        }
        if (KernelVersion.equals("7.4.7")) {
            return 747;
        }
        if (KernelVersion.equals("7.4.8")) {
            return 748;
        }
        if (KernelVersion.equals("7.4.9")) {
            return 749;
        }
        if (KernelVersion.equals("8.0")) {
            return 800;
        }
        return 0;
    }
}

