/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.simple.SQLMaster;
import com.sap.sapdb.oltptest.simple.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import com.sap.sapdb.testframe.utilities.Table;
import java.sql.SQLException;

class StressTestActor
extends TestActor {
    private int mMaxRownumber = 0;
    private int mRowLength = 0;
    private int mInitialRownumber = 0;
    private boolean mDropAfterExecution = false;
    private int mInsertPercentage = 0;
    private int mUpdatePercentage = 0;
    private int mDeletePercentage = 0;
    private int mSelectPercentage = 0;
    private int mCommitPercentage = 0;
    private int mMaxStatementsPerTransaction;
    private int mStatementCount;
    private int mStatementsPerTransaction;
    private int mAction;
    private static final int W_INSERT = 0;
    private static final int W_UPDATE = 1;
    private static final int W_DELETE = 2;
    private static final int W_SELECT = 3;
    private static final int W_COMMIT = 4;
    private static final int W_ROLLBACK = 5;

    public StressTestActor() {
        this.mTitle = "Writer";
    }

    protected int nextAction() {
        if (this.mStatementCount < this.mStatementsPerTransaction) {
            int NextDDLAction = RandomGenerator.randomInteger((int)0, (int)100);
            this.mAction = NextDDLAction < this.mInsertPercentage ? 0 : (NextDDLAction < this.mInsertPercentage + this.mUpdatePercentage ? 1 : (NextDDLAction < this.mInsertPercentage + this.mUpdatePercentage + this.mDeletePercentage ? 2 : 3));
            ++this.mStatementCount;
        } else {
            this.mAction = RandomGenerator.randomInteger((int)0, (int)100) <= this.mCommitPercentage ? 4 : 5;
            this.mStatementCount = 0;
            this.mStatementsPerTransaction = RandomGenerator.randomInteger((int)1, (int)this.mMaxStatementsPerTransaction);
        }
        return this.mAction;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block29: {
            SelectStatement = null;
            UpdateStatement = null;
            DeleteStatement = null;
            KeepRunning = true;
            lTable = null;
            this.mRunning = true;
            try {
                try {
                    lTable = new Table(String.valueOf(this.mTitle) + "_Table");
                    lTable.setConnection(this.mConnection);
                    lTable.addInteger("KEYCOL", true, true, false, 0, 0, 0);
                    lTable.addCharacter("FILLCOL", this.mRowLength, false, false, true, null);
                    lTable.create(true);
                    i = 0;
                    while (true) {
                        if (i >= this.mInitialRownumber) {
                            this.mConnection.commit();
                            break;
                        }
                        lTable.randomInsert();
                        ++i;
                    }
                    while (KeepRunning) {
                        this.mAction = this.nextAction();
                        switch (this.mAction) {
                            case 0: {
                                lTable.randomInsert();
                                break;
                            }
                            case 1: {
                                if (UpdateStatement == null) {
                                    UpdateStatement = this.mConnection.prepareStatement("UPDATE " + lTable.getName() + " SET FILLCOL=? WHERE KEYCOL = ?");
                                }
                                Key1 = Integer.parseInt(lTable.getField(0).getLastValue()) * RandomGenerator.randomInteger((int)1, (int)100) / 100;
                                UpdateStatement.setInt(2, Key1);
                                UpdateStatement.setString(1, RandomGenerator.randomString((int)this.mRowLength));
                                try {
                                    UpdateStatement.execute();
                                }
                                catch (Exception e) {
                                    System.out.println("Error while executing Update: " + e.getMessage());
                                }
                                break;
                            }
                            case 2: {
                                if (DeleteStatement == null) {
                                    DeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + lTable.getName() + " WHERE KEYCOL = ?");
                                }
                                Key1 = Integer.parseInt(lTable.getField(0).getLastValue()) * RandomGenerator.randomInteger((int)1, (int)100) / 100;
                                DeleteStatement.setInt(1, Key1);
                                try {
                                    DeleteStatement.execute();
                                }
                                catch (Exception e) {
                                    System.out.println("Error while executing Delete: " + e.getMessage());
                                }
                                break;
                            }
                            case 3: {
                                if (SelectStatement == null) {
                                    SelectStatement = this.mConnection.prepareStatement("SELECT * FROM " + lTable.getName() + " WHERE KEYCOL >= ? AND KEYCOL <= ? ");
                                }
                                Key1 = Integer.parseInt(lTable.getField(0).getLastValue()) * RandomGenerator.randomInteger((int)1, (int)33) / 100;
                                Key2 = Key1 + Integer.parseInt(lTable.getField(0).getLastValue()) * RandomGenerator.randomInteger((int)1, (int)66) / 100;
                                SelectStatement.setInt(1, Key1);
                                SelectStatement.setInt(2, Key2);
                                SelectStatement.executeQuery();
                                break;
                            }
                            case 4: {
                                this.mConnection.commit();
                                break;
                            }
                            case 5: {
                                this.mConnection.rollback();
                                break;
                            }
                        }
                        StressTestActor.sleep(25L);
                        if (!this.mShouldStop) continue;
                        SQLMaster.printTrace(String.valueOf(this.mTitle) + ": Soft interrupted");
                        KeepRunning = false;
                        this.setStatus(2);
                    }
                }
                catch (SQLException e) {
                    SQLMaster.printTrace(String.valueOf(this.mTitle) + ": ** ERROR ** Raising exception " + e.getMessage());
                    this.setStatus(-2, "SQLException: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    SQLMaster.printTrace(String.valueOf(this.mTitle) + ": Hard interrupted");
                    this.setStatus(2);
                }
                catch (Exception e) {
                    SQLMaster.printTrace(String.valueOf(this.mTitle) + ": ** ERROR **  General exception: " + e.getMessage());
                    this.setStatus(-3, "Exception: " + e.getMessage());
                }
            }
            catch (Throwable var10_14) {
                var9_15 = null;
                super.cleanup();
                try {
                    if (this.mDropAfterExecution == false) throw var10_14;
                    lTable.drop();
                    throw var10_14;
                }
                catch (Exception var11_17) {
                    // empty catch block
                }
                throw var10_14;
            }
            {
                var9_16 = null;
                super.cleanup();
            }
            ** try [egrp 4[TRYBLOCK] [7 : 796->811)] { 
lbl102:
            // 1 sources

            if (this.mDropAfterExecution) {
                lTable.drop();
            }
            break block29;
lbl105:
            // 1 sources

            catch (Exception var11_18) {
                // empty catch block
            }
        }
        this.mRunning = false;
        SQLMaster.printTrace(String.valueOf(this.mTitle) + ": Terminating");
    }

    public void setMaster(SQLMaster newMaster) throws TestDatabaseException, SQLException {
        super.setMaster(newMaster);
        this.mRowLength = TestCase.getParameterInt((String)"RowLength", (int)1024);
        this.mMaxRownumber = TestCase.getParameterInt((String)"MaxRownumber", (int)1000);
        this.mInitialRownumber = TestCase.getParameterInt((String)"InitialRownumber", (int)10);
        this.mDropAfterExecution = TestCase.getParameterBoolean((String)"DropAfterExecution", (boolean)true);
        this.mInsertPercentage = TestCase.getParameterInt((String)"InsertPercentage", (int)25);
        this.mDeletePercentage = TestCase.getParameterInt((String)"DeletePercentage", (int)25);
        this.mUpdatePercentage = TestCase.getParameterInt((String)"UpdatePercentage", (int)25);
        this.mSelectPercentage = TestCase.getParameterInt((String)"SelectPercentage", (int)25);
        this.mCommitPercentage = TestCase.getParameterInt((String)"CommitPercentage", (int)67);
        this.mMaxStatementsPerTransaction = TestCase.getParameterInt((String)"MaxStatementsPerTransaction", (int)5);
        if (this.mRowLength == 0) {
            throw new TestDatabaseException("The row length has to be greater then 0");
        }
        if (this.mInitialRownumber > this.mMaxRownumber) {
            throw new TestDatabaseException("The InitialRownumber has to be smaller then the MaxRownumber");
        }
        if (this.mMaxStatementsPerTransaction <= 0) {
            throw new TestDatabaseException("MaxStatementsPerTransaction has to be greater then 0");
        }
        if (this.mMaxRownumber <= 0) {
            throw new TestDatabaseException("MaxRownumber has to be greater then 0");
        }
        float OverallPercentage = (float)(this.mInsertPercentage + this.mUpdatePercentage + this.mDeletePercentage + this.mSelectPercentage) / 100.0f;
        this.mInsertPercentage = (int)((float)this.mInsertPercentage * OverallPercentage);
        this.mUpdatePercentage = (int)((float)this.mUpdatePercentage * OverallPercentage);
        this.mDeletePercentage = (int)((float)this.mDeletePercentage * OverallPercentage);
        this.mSelectPercentage = (int)((float)this.mSelectPercentage * OverallPercentage);
    }
}

