/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.migration;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class CatalogToUnicode
extends TestCase {
    private DBM mDBMan = null;
    protected Connection myConnection = null;
    protected TestStatement myStatement = null;
    static final String VERSION = "1.14";
    static final String sysdba = "DBA";
    static final String sysdbaPassword = "DBA";
    static final String domainuser = "DOMAIN";
    static final String domainPassword = "DOMAIN";
    static final String mExUser = "MIGRATIONTESTER";
    static final String mExPassword = "MIGRATION";
    static String m_kernelVersion;
    static final String c_extraSchema = "MIGSCHEMA";
    static final String migrationPacketSizeStr;
    String kernelMode = "SLOW";
    static final String logIdent = "writer";
    static final String[] domainlist;
    static boolean m_hasSchema;
    static boolean m_hasPostupgradeChecklist;
    ArrayList dbprocs = new ArrayList();

    static {
        migrationPacketSizeStr = String.valueOf(131072);
        domainlist = new String[]{"SYSID", "SYSQPNAME", "SYSCOMMENT", "SYSMSGTEXT", "SYSLONG", "SYSJOB", "SYSSTATEMENT", "SYSDATATYPE", "SYSDATA"};
        m_hasSchema = false;
        m_hasPostupgradeChecklist = true;
    }

    public static String getMinimumRelease() {
        return "7.4.3";
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        System.out.println("Start of " + CatalogToUnicode.getTestClassId() + " " + VERSION);
        try {
            m_kernelVersion = ((TestDatabaseSap)CatalogToUnicode.getDatabase()).getKernelVersion();
            if (TestDriver.compareRelease((String)m_kernelVersion, (String)">=", (String)"7.6.00")) {
                m_hasSchema = true;
            }
            myConnection = CatalogToUnicode.getDatabase().connect(CatalogToUnicode.getUser(), CatalogToUnicode.getPassword());
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user MIGRATIONTESTER");
            myConnection.commit();
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user MIGRATIONTESTER password MIGRATION dba not exclusive");
            myStatement.close();
            myConnection.close();
        }
        catch (Exception e) {
            CatalogToUnicode.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public void run() {
        if (!this.initTestData()) {
            return;
        }
        this.addMessage("run", 'I', "Catalog migration to unicode test V1.14.");
        this.setStatus("preparing");
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)CatalogToUnicode.getDatabase();
            this.kernelMode = sapdb.getKernelMode();
        }
        catch (Exception e) {
            System.err.println("Could not determine kernel mode, using " + this.kernelMode);
        }
        this.addMessage("run", 'I', "Shutting down DB.");
        this.executeDBMCmd("db_offline");
        if (this.doMigration()) {
            this.addMessage("run", 'I', "Bringing DB to online state (" + this.kernelMode + ").");
            this.executeDBMCmd("db_online -" + this.kernelMode);
            this.reloadSystables();
            this.executeDBMCmd("db_admin -" + this.kernelMode);
            this.addMessage("run", 'I', "Switching on redo log.");
            this.executeDBMCmd("util_execute set log writer on");
            this.addMessage("run", 'I', "Bringing DB to online state (" + this.kernelMode + ").");
            this.executeDBMCmd("db_online -" + this.kernelMode);
            try {
                this.addMessage("run", 'I', "Verifying some catalog entries");
                this.verifyDatabase();
            }
            catch (TestCaseException e) {
                this.addMessage("run", 'E', "Error during verification: " + ((Object)((Object)e)).getClass() + e.getMessage());
            }
        }
        this.setStatus("cleanup");
        this.addMessage("run", 'I', "Resetting _UNICODE to NO before exiting.");
        this.executeDBMCmd("param_directput _UNICODE NO");
        this.addMessage("run", 'I', "Test finished.");
        System.out.println("End of " + CatalogToUnicode.getTestClassId());
    }

    public boolean doMigration() {
        String packetSizeStr = this.executeDBMCmd("param_directget _PACKET_SIZE");
        if (packetSizeStr.equals("error")) {
            this.addMessage(CatalogToUnicode.getTestClassId(), 'E', "Could not determine parameter _PACKET_SIZE. Aborting migration.");
            return false;
        }
        boolean retVal = true;
        this.executeDBMCmd("param_directput _PACKET_SIZE " + migrationPacketSizeStr);
        this.addMessage("doMigration", 'I', "Setting _UNICODE to YES.");
        this.executeDBMCmd("param_directput _UNICODE YES");
        this.addMessage("doMigration", 'I', "Bringing DB to admin state (" + this.kernelMode + ").");
        this.executeDBMCmd("db_admin -" + this.kernelMode);
        this.addMessage("doMigration", 'I', "Switching off redo log.");
        this.executeDBMCmd("util_execute set log writer off");
        this.addMessage("doMigration", 'I', "Starting migration.");
        this.setStatus("migrating");
        if (this.executeDBMCmd("util_execute migrate to unicode").equals("error")) {
            this.addMessage("doMigration", 'E', "Migration failed!");
            retVal = false;
        }
        this.addMessage("doMigration", 'I', "Shutting down DB.");
        this.executeDBMCmd("db_offline");
        this.addMessage("doMigration", 'I', "Restore _PACKET_SIZE.");
        this.executeDBMCmd("param_directput " + packetSizeStr);
        return retVal;
    }

    public boolean reloadSystables() {
        this.setStatus("reloading systables");
        this.addMessage("reloadSystables", 'I', "Loading system tables.");
        this.executeDBMCmd("load_systab -m");
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyDatabase() throws TestCaseException {
        block35: {
            this.setStatus("verifiying");
            try {
                try {
                    block33: {
                        block32: {
                            this.myConnection = CatalogToUnicode.getDatabase().connect("MIGRATIONTESTER", "MIGRATION");
                            this.myStatement = new TestStatement(null, this.myConnection, 1005, 1007);
                            this.addMessage("verify", 'I', "starting verify");
                            this.addMessage("verify", 'I', "verify existence of constraint");
                            try {
                                this.myStatement.execute("insert into migrationtesttable(k1) values (15)");
                            }
                            catch (SQLException e) {
                                if (e.getErrorCode() == 300) break block32;
                                throw new TestCaseException("Error during verify: " + e.getClass() + e.getMessage());
                            }
                        }
                        this.myStatement.execute("insert into migrationtesttable(k1) values (14)");
                        try {
                            this.addMessage("verify", 'I', "verify existence of substitute trigger");
                            this.myStatement.execute("insert into \"t 1\" (i1) values (15)");
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == -8052) break block33;
                            throw new TestCaseException("Error during verify: " + e.getClass() + e.getMessage());
                        }
                    }
                    this.addMessage("verify", 'I', "verify contents of 'dbprocedures'");
                    result = this.myStatement.executeQuery("Select dbprocname,comment from dbprocedures");
                    expected = new VerificationDataComplete();
                    expected.add("'this is a db_proc with a_name', 'This db_proc has a comment.'");
                    it = this.dbprocs.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            if (expected.equals(result)) break;
                            throw new TestCaseException(" in table 'dbprocedures': " + expected.getErrorMessage());
                        }
                        dbprocInfo = (DbprocInfo)it.next();
                        name = dbprocInfo.getName();
                        comment = dbprocInfo.getComment();
                        procInfo = comment != null ? "'" + name + "', '" + comment + "'" : "'" + name + "', null";
                        expected.add(procInfo);
                    }
                    this.addMessage("verify", 'I', "verify contents of 'triggers'");
                    result = this.myStatement.executeQuery("Select triggername,comment from triggers");
                    expected = new VerificationDataComplete();
                    expected.add("'MIGRATIONTESTTRIGGER','And there shall be a comment for this trigger!'");
                    expected.add("'TESTTABLETESTTRIGGER', null");
                    expected.add("'LEFTOVER_I_TRIGGER', null");
                    expected.add("'LEFTOVER_U_TRIGGER', null");
                    expected.add("'LEFTOVER_D_TRIGGER', null");
                    if (!expected.equals(result)) {
                        result.beforeFirst();
                        contentStr = new StringBuffer("\nDumping contents of 'TRIGGERS':\n\n");
                        while (true) {
                            if (!result.next()) {
                                this.addMessage("content of 'triggers'", 'E', contentStr.toString());
                                throw new TestCaseException(" in table 'triggers': " + expected.getErrorMessage());
                            }
                            contentStr.append(String.valueOf(result.getString(1)) + ", " + result.getString(2) + "\n");
                        }
                    }
                    this.addMessage("verify", 'I', "verify contents of 'tables'");
                    result = this.myStatement.executeQuery("Select tablename from tables where owner='MIGRATIONTESTER' and tabletype <> 'RESULT'");
                    expected = new VerificationDataComplete();
                    expected.add("'FOREIGNREFTABLE'");
                    expected.add("'FOREIGNREFTABLE1'");
                    expected.add("'FOREIGNREFTABLE2'");
                    expected.add("'MIGRATIONLONGVIEW'");
                    expected.add("'MIGRATIONTESTTABLE'");
                    expected.add("'TABLESYNONYM'");
                    expected.add("'t 1'");
                    expected.add("'V'");
                    expected.add("'SERIALTAB'");
                    expected.add("'FOREIGNDEFAULTTABLE'");
                    expected.add("'TRIGGERTESTTABLE'");
                    if (!expected.equals(result)) {
                        result.beforeFirst();
                        contentStr = new StringBuffer("\nDumping contents of 'TABLES':\n\n");
                        while (true) {
                            if (!result.next()) {
                                this.addMessage("content of 'TABLES'", 'E', contentStr.toString());
                                throw new TestCaseException(" in table 'tables': " + expected.getErrorMessage());
                            }
                            contentStr.append(String.valueOf(result.getString(1)) + "\n");
                        }
                    }
                    this.addMessage("verify", 'I', "verify contents of 'views'");
                    result = this.myStatement.executeQuery("Select viewname,privileges from views where owner='MIGRATIONTESTER'");
                    expected = new VerificationDataComplete();
                    expected.add("'MIGRATIONLONGVIEW','SEL+    DEL+'");
                    expected.add("'V','SEL+UPD+DEL+INS+'");
                    if (!expected.equals(result)) {
                        result.beforeFirst();
                        contentStr = new StringBuffer("\nDumping contents of 'VIEWS':\n\n");
                        while (true) {
                            if (!result.next()) {
                                this.addMessage("content of 'VIEWS'", 'E', contentStr.toString());
                                throw new TestCaseException(" in table 'views': " + expected.getErrorMessage());
                            }
                            contentStr.append(String.valueOf(result.getString(1)) + ", " + result.getString(2) + "\n");
                        }
                    }
                    this.addMessage("verify", 'I', "verify contents of 'indexes'");
                    result = this.myStatement.executeQuery("Select tablename,indexname,type from indexes");
                    expected = new VerificationDataComplete();
                    expected.add("'FOREIGNREFTABLE','an index with a long name',''");
                    expected.add("'FOREIGNREFTABLE','many columns index','UNIQUE'");
                    expected.add("'MIGRATIONTESTTABLE','INDEX001','UNIQUE'");
                    expected.add("'MIGRATIONTESTTABLE','testindex','UNIQUE'");
                    if (!expected.equals(result)) {
                        result.beforeFirst();
                        contentStr = new StringBuffer("\nDumping contents of 'VIEWS':\n\n");
                        while (true) {
                            if (!result.next()) {
                                this.addMessage("content of 'indexes'", 'E', contentStr.toString());
                                throw new TestCaseException(" in table 'indexes': " + expected.getErrorMessage());
                            }
                            contentStr.append(String.valueOf(result.getString(1)) + ", " + result.getString(2) + ", " + result.getString(3) + "\n");
                        }
                    }
                    result.close();
                    this.addMessage("verify", 'I', "verify contents of 'foreigndefaulttable'");
                    this.myStatement.execute("delete from migrationtesttable where k1 = 3");
                    result = this.myStatement.executeQuery("Select c1 from foreigndefaulttable");
                    expected = new VerificationDataComplete();
                    expected.add("1");
                    expected.add("2");
                    expected.add("12345");
                    if (!expected.equals(result)) {
                        result.beforeFirst();
                        contentStr = new StringBuffer("\nDumping contents of 'FOREIGNDEFAULTTABLE':\n\n");
                        while (true) {
                            if (!result.next()) {
                                this.addMessage("content of 'FOREIGNDEFAULTTABLE'", 'E', contentStr.toString());
                                throw new TestCaseException(" in table 'FOREIGNDEFAULTTABLE': " + expected.getErrorMessage());
                            }
                            contentStr.append(String.valueOf(result.getString(1)) + "\n");
                        }
                    }
                    this.myConnection.close();
                    this.verifyAsDba();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TestCaseException("Error during verification: " + e.getClass() + ", " + e.getMessage());
                }
            }
            catch (Throwable var9_11) {
                var8_12 = null;
                try {
                    this.myStatement.close();
                }
                catch (Exception var10_14) {
                    // empty catch block
                }
                try {
                    this.myConnection.commit();
                    this.myConnection.close();
                    throw var9_11;
                }
                catch (Exception var10_14) {
                    // empty catch block
                }
                throw var9_11;
            }
            {
                var8_13 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 1449->1459)] { 
lbl159:
            // 1 sources

            this.myStatement.close();
            break block35;
lbl161:
            // 1 sources

            catch (Exception var10_15) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var10_15) {
            return;
        }
        this.myConnection.commit();
        this.myConnection.close();
    }

    private void verifyAsDba() throws TestDatabaseException, SQLException, TestCaseException {
        this.myConnection = CatalogToUnicode.getDatabase().connect("DBA", "DBA");
        this.myStatement = new TestStatement(null, this.myConnection, 1005, 1007);
        this.addMessage("verify", 'I', "verifying as user 'DBA'");
        if (TestDriver.compareRelease((String)m_kernelVersion, (String)">", (String)"7.4.03")) {
            this.addMessage("verify", 'I', "verify exec privileges on dbprocs");
            ResultSet result = this.myStatement.executeQuery("Select dbprocname from dbprocedures where dbprocname = 'this is a db_proc with a_name'");
            if (!result.first()) {
                this.addMessage("missing exec rights", 'E', "missing exec rights for 'this is a db_proc with a_name'");
                throw new TestCaseException("missing exec rights for 'this is a db_proc with a_name'");
            }
        }
        if (m_hasPostupgradeChecklist) {
            this.verifyPostUpgradeCheckList();
        }
        this.checkColumnTypes(this.myStatement);
        if (TestDriver.compareRelease((String)m_kernelVersion, (String)">", (String)"7.4.03")) {
            this.addMessage("verify", 'I', "check catalog");
            this.myStatement.execute("check catalog");
        }
        this.addMessage("verify", 'I', "verify finished successfully");
    }

    private void verifyPostUpgradeCheckList() throws SQLException, TestCaseException {
        String[] droppedObjectsForCompare;
        this.addMessage("verify", 'I', "verify contents of 'postupgradechecklistunicode'");
        ResultSet result = this.myStatement.executeQuery("Select statement, upgradedate from postupgradechecklistunicode");
        String[] droppedObjects = null;
        if (TestDriver.compareRelease((String)m_kernelVersion, (String)">=", (String)"7.6.00")) {
            droppedObjectsForCompare = new String[]{"LEFTOVER", "LEFTOVERLONGTEXT", "LEFTOVER_I_TRIGGER", "LEFTOVER_U_TRIGGER", "LEFTOVER_D_TRIGGER", "This DB-Proc wont survive", "Doomed Oracle DB-Proc", "TESTTABLETESTTRIGGER", "TQUERYREWRITERULES"};
            droppedObjects = droppedObjectsForCompare;
        } else {
            droppedObjectsForCompare = new String[]{"LEFTOVER", "LEFTOVERLONGTEXT", "LEFTOVER_I_TRIGGER", "LEFTOVER_U_TRIGGER", "LEFTOVER_D_TRIGGER", "This DB-Proc wont survive", "Doomed Oracle DB-Proc", "TESTTABLETESTTRIGGER"};
            droppedObjects = droppedObjectsForCompare;
        }
        int verifiedResultCount = 0;
        int resultCount = 0;
        while (result.next()) {
            ++resultCount;
            if (result.getTime(2) == null) {
                throw new TestCaseException(" in table 'POSTUPGRADECHECKLISTUNICODE': UPGRADEDATE is null");
            }
            int i = 0;
            while (i < droppedObjects.length) {
                if (droppedObjects[i] != null && result.getString(1) != null && result.getString(1).indexOf(droppedObjects[i]) != -1) {
                    ++verifiedResultCount;
                    droppedObjects[i] = null;
                }
                ++i;
            }
        }
        if (resultCount != droppedObjects.length || verifiedResultCount != droppedObjects.length) {
            result.beforeFirst();
            StringBuffer contentStr = new StringBuffer("\nDumping contents of 'POSTUPGRADECHECKLISTUNICODE':\n\n");
            while (result.next()) {
                contentStr.append(String.valueOf(result.getString(1)) + "\n------------------------------------------\n");
            }
            this.addMessage("content of 'POSTUPGRADECHECKLISTUNICODE'", 'E', contentStr.toString());
            throw new TestCaseException(" in table 'POSTUPGRADECHECKLISTUNICODE': mismatch in number of dropped objects: is " + resultCount + " should be " + droppedObjects.length);
        }
        result.beforeFirst();
        while (result.next()) {
            if (result.getString(1).indexOf("LEFTOVERLONGTEXT") == -1 || result.getString(1).indexOf(CatalogToUnicode.getViewDefinitionString()) != -1) continue;
            this.addMessage("statementtext of 'LEFTOVERLONGTEXT'", 'E', result.getString(1));
            throw new TestCaseException(" in table 'postupgradechecklistunicode': error in verify of statement text for 'POSTUPGRADECHECKLISTUNICODE'");
        }
    }

    private void checkColumnTypes(TestStatement statement) throws SQLException {
        this.addMessage("verify", 'I', "- checking for suspicious column definitions that maybe should have been\n  converted to unicode");
        VerificationDataComplete knownExceptions = new VerificationDataComplete();
        if (TestDriver.compareRelease((String)m_kernelVersion, (String)">=", (String)"7.6.00")) {
            knownExceptions.add("'ACTIVECONFIGURATION', 'PARAMETERNAME', 'CHAR'");
        } else if (TestDriver.compareRelease((String)m_kernelVersion, (String)"==", (String)"7.5.00")) {
            knownExceptions.add("'ACTIVECONFIGURATION', 'PARAMETERNAME', 'CHAR'");
            knownExceptions.add("'WA_INODE', 'OWNER', 'CHAR'");
            knownExceptions.add("'WA_MY_INODE', 'OWNER', 'CHAR'");
        } else if (TestDriver.compareRelease((String)m_kernelVersion, (String)"==", (String)"7.4.03")) {
            knownExceptions.add("'SHOW_SYSDBA', 'USERNAME', 'CHAR'");
            knownExceptions.add("'WA_INODE', 'OWNER', 'CHAR'");
            knownExceptions.add("'WA_MY_INODE', 'OWNER', 'CHAR'");
        }
        ResultSet result = statement.executeQuery("Select Tablename, Columnname, Datatype from Columns where(    columnname = 'CONSTRAINTNAME' or columnname = 'DBPROCNAME' or columnname = 'DOMAINNAME' or columnname = 'FUNCTIONNAME' or columnname = 'GROUPNAME' or columnname = 'INDEXNAME' or columnname = 'OWNER' or columnname = 'PARAMETERNAME' or columnname = 'REFCOLUMNNAME' or columnname = 'REFSCHEMANAME' or columnname = 'SCHEMANAME' or columnname = 'SYNONYMNAME' or columnname = 'TABLENAME' or columnname = 'TABLESCHEMANAME' or columnname = 'TRIGGERNAME' or columnname = 'USERNAME' or columnname = 'VIEWCOLUMNNAME' or columnname = 'VIEWNAME' or columnname = 'VIEWOWNER' or columnname = 'VOLUMENAME') and Codetype = 'ASCII'");
        if (!knownExceptions.equals(result)) {
            result.beforeFirst();
            StringBuffer contentStr = new StringBuffer("\nDumping all suspicious column definitions:\n\n");
            while (result.next()) {
                contentStr.append(String.valueOf(result.getString(1)) + ", " + result.getString(2) + ", " + result.getString(3) + "\n");
            }
            this.addMessage("Suspicious column definitions", 'W', contentStr.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean initTestData() {
        try {
            try {
                String schema;
                this.myConnection = CatalogToUnicode.getDatabase().connect(mExUser, mExPassword);
                this.myStatement = new TestStatement(null, this.myConnection, 1005, 1007);
                try {
                    ResultSet result = this.myStatement.executeQuery("Select dbprocname,comment from dbprocedures");
                    while (result.next()) {
                        this.dbprocs.add(new DbprocInfo(result.getString(1), result.getString(2)));
                    }
                }
                catch (SQLException e) {
                    throw new TestCaseException("Error during prepare: " + e.getClass() + e.getMessage());
                }
                this.myStatement.execute("create table migrationtesttable (k1 int, columnwithlongname char(15), col2 char(30), col3 fixed(5), col4 int unique, primary key (k1), constraint \"migrationtableconstraint\" check k1 < 15 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15  and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1  + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 and k1 < 15 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and  k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 and k1 < 15 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 and k1 < 15 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 and k1 < 15 and k1 < 15)");
                this.myStatement.execute("insert into migrationtesttable (k1) values(1)");
                this.myStatement.execute("insert into migrationtesttable (k1) values(2)");
                this.myStatement.execute("insert into migrationtesttable (k1) values(3)");
                this.myStatement.execute("insert into migrationtesttable (k1) values(4)");
                this.myStatement.execute("insert into migrationtesttable (k1) values(5)");
                this.myStatement.execute("create unique index \"testindex\" on  migrationtesttable (k1,col4)");
                this.myStatement.execute("create table foreignreftable (c1 int, c2 int, c3 int, c4 int, c5 int, c6 int, c7 int, c8 int, c9 int, c10 int, c11 int, c12 int, c13 int, c14 int, c15 int, c16 int, c17 int, c18 int, c19 int, c20 int, c21 int, c22 int, c23 int, c24 int, c25 int, c26 int, c27 int, c28 int, c29 int, c30 int, c31 int, c32 int, c33 int, foreign key (c1) references migrationtesttable (k1), foreign key (c2) references migrationtesttable (k1), foreign key (c3) references migrationtesttable (k1), foreign key (c4) references migrationtesttable (k1), foreign key (c5) references migrationtesttable (k1), foreign key (c6) references migrationtesttable (k1), foreign key (c7) references migrationtesttable (k1), foreign key (c8) references migrationtesttable (k1), foreign key (c9) references migrationtesttable (k1), foreign key (c10) references migrationtesttable (k1), foreign key (c11) references migrationtesttable (k1), foreign key (c12) references migrationtesttable (k1), foreign key (c13) references migrationtesttable (k1), foreign key (c14) references migrationtesttable (k1), foreign key (c15) references migrationtesttable (k1), foreign key (c16) references migrationtesttable (k1), foreign key (c17) references migrationtesttable (k1), foreign key (c18) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c20) references migrationtesttable (k1), foreign key (c21) references migrationtesttable (k1), foreign key (c22) references migrationtesttable (k1), foreign key (c23) references migrationtesttable (k1), foreign key (c24) references migrationtesttable (k1), foreign key (c25) references migrationtesttable (k1), foreign key (c26) references migrationtesttable (k1), foreign key (c27) references migrationtesttable (k1), foreign key (c28) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c30) references migrationtesttable (k1), foreign key (c31) references migrationtesttable (k1))");
                this.myStatement.execute("create sequence migrationtestsequence");
                this.myStatement.execute("comment on sequence migrationtestsequence is 'comments seem to be a cause of trouble'");
                this.myStatement.execute("create index \"an index with a long name\" on foreignreftable (c1,c2,c3,c4,c5,c6,c7,c8)");
                this.myStatement.execute("create unique index \"many columns index\" on foreignreftable (c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,c16)");
                this.myStatement.execute("create table foreignreftable1 (c1 int, c2 int, c3 int, c4 int, c5 int, c6 int, c7 int, c8 int, c9 int, c10 int, c11 int, c12 int, c13 int, c14 int, c15 int, c16 int, c17 int, c18 int, c19 int, c20 int, c21 int, c22 int, c23 int, c24 int, c25 int, c26 int, c27 int, c28 int, c29 int, c30 int, c31 int, c32 int, c33 int, foreign key (c1) references migrationtesttable (k1), foreign key (c2) references migrationtesttable (k1), foreign key (c3) references migrationtesttable (k1), foreign key (c4) references migrationtesttable (k1), foreign key (c5) references migrationtesttable (k1), foreign key (c6) references migrationtesttable (k1), foreign key (c7) references migrationtesttable (k1), foreign key (c8) references migrationtesttable (k1), foreign key (c9) references migrationtesttable (k1), foreign key (c10) references migrationtesttable (k1), foreign key (c11) references migrationtesttable (k1), foreign key (c12) references migrationtesttable (k1), foreign key (c13) references migrationtesttable (k1), foreign key (c14) references migrationtesttable (k1), foreign key (c15) references migrationtesttable (k1), foreign key (c16) references migrationtesttable (k1), foreign key (c17) references migrationtesttable (k1), foreign key (c18) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c20) references migrationtesttable (k1), foreign key (c21) references migrationtesttable (k1), foreign key (c22) references migrationtesttable (k1), foreign key (c23) references migrationtesttable (k1), foreign key (c24) references migrationtesttable (k1), foreign key (c25) references migrationtesttable (k1), foreign key (c26) references migrationtesttable (k1), foreign key (c27) references migrationtesttable (k1), foreign key (c28) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c30) references migrationtesttable (k1), foreign key (c31) references migrationtesttable (k1))");
                this.myStatement.execute("create table foreignreftable2 (c1 int, c2 int, c3 int, c4 int, c5 int, c6 int, c7 int, c8 int, c9 int, c10 int, c11 int, c12 int, c13 int, c14 int, c15 int, c16 int, c17 int, c18 int, c19 int, c20 int, c21 int, c22 int, c23 int, c24 int, c25 int, c26 int, c27 int, c28 int, c29 int, c30 int, c31 int, c32 int, c33 int, foreign key (c1) references migrationtesttable (k1), foreign key (c2) references migrationtesttable (k1), foreign key (c3) references migrationtesttable (k1), foreign key (c4) references migrationtesttable (k1), foreign key (c5) references migrationtesttable (k1), foreign key (c6) references migrationtesttable (k1), foreign key (c7) references migrationtesttable (k1), foreign key (c8) references migrationtesttable (k1), foreign key (c9) references migrationtesttable (k1), foreign key (c10) references migrationtesttable (k1), foreign key (c11) references migrationtesttable (k1), foreign key (c12) references migrationtesttable (k1), foreign key (c13) references migrationtesttable (k1), foreign key (c14) references migrationtesttable (k1), foreign key (c15) references migrationtesttable (k1), foreign key (c16) references migrationtesttable (k1), foreign key (c17) references migrationtesttable (k1), foreign key (c18) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c20) references migrationtesttable (k1), foreign key (c21) references migrationtesttable (k1), foreign key (c22) references migrationtesttable (k1), foreign key (c23) references migrationtesttable (k1), foreign key (c24,c25) references migrationtesttable (k1, col4), foreign key (c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,c16) references foreignreftable (c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,c16), foreign key (c25) references migrationtesttable (k1), foreign key (c26) references migrationtesttable (k1), foreign key (c27) references migrationtesttable (k1), foreign key (c28) references migrationtesttable (k1), foreign key (c29) references migrationtesttable (k1), foreign key (c30) references migrationtesttable (k1), foreign key (c31) references migrationtesttable (k1))");
                this.myStatement.execute("create table foreigndefaulttable (c1 int default 12345,  c2 int, foreign key (c1) references migrationtesttable (k1) on delete set default)");
                this.myStatement.execute("insert into foreigndefaulttable (c1) values(1)");
                this.myStatement.execute("insert into foreigndefaulttable (c1) values(2)");
                this.myStatement.execute("insert into foreigndefaulttable (c1) values(3)");
                this.myStatement.execute("create trigger migrationtesttrigger for\n user.migrationtesttable\n after update execute (\n TRY\n if NEW.col3 = OLD.col3\n THEN INSERT INTO migrationtester.migrationtesttable(k1)\n values\n (migrationtester.migrationtestsequence.nextval);\n CATCH\n if $rc <> 100\n THEN STOP ($rc, 'unexpected error');\n )");
                this.myStatement.execute("create dbproc \"this is a db_proc with a_name\" (\n in db_proc_parameter0 int,\n in db_proc_parameter1 int,\n in another_db_proc_parameter int,\n in the_last_db_proc_parameter int) as\n insert into migrationtester.migrationtesttable (k1, col3)\n values (:db_proc_parameter0, :db_proc_parameter1);\n insert into migrationtester.migrationtesttable (k1, col3) values\n (:another_db_proc_parameter, :the_last_db_proc_parameter);\n");
                this.myStatement.execute("grant execute on \"this is a db_proc with a_name\" to DBA");
                this.myStatement.execute("create trigger \"trigger to be dropped\" for\n migrationtester.migrationtesttable\n after delete execute (\n TRY\n if 3 = 6\n THEN INSERT INTO migrationtester.migrationtesttable(k1)\n values\n (migrationtester.migrationtestsequence.nextval);\n CATCH\n if $rc <> 100\n THEN STOP ($rc, 'unexpected error');\n )");
                this.myStatement.execute("create dbproc \"db_proc to be dropped\" (\n in db_proc_parameter0 int,\n in db_proc_parameter1 int,\n in another_db_proc_parameter int,\n in the_last_db_proc_parameter int) as\n insert into migrationtester.migrationtesttable (k1, col3)\n values (:db_proc_parameter0, :db_proc_parameter1);\n insert into migrationtester.migrationtesttable (k1, col3) values\n (:another_db_proc_parameter, :the_last_db_proc_parameter);\n");
                this.myStatement.execute("comment on column migrationtesttable.col3 is'This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case.This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case.This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case. This is quite a long text which will allow me to detect errors in my routine easily and will help me remove them as quickly as possible. Maybe I should think of using an even longer text, as frequent repetitions might become a problem. However, I do not think this will really be the case.'");
                this.myStatement.execute("comment on trigger migrationtesttable.migrationtesttrigger is 'And there shall be a comment for this trigger!'");
                this.myStatement.execute("comment on dbproc migrationtester.\"this is a db_proc with a_name\" is 'This db_proc has a comment.'");
                this.myStatement.execute("comment on trigger migrationtesttable.\"trigger to be dropped\" is'This comment will not be dropped and rot on the harddisk'");
                this.myStatement.execute("comment on dbproc migrationtester.\"db_proc to be dropped\" is  'This comment will not be dropped and rot on the harddisk'");
                this.myStatement.execute("drop dbproc \"db_proc to be dropped\"");
                this.myStatement.execute("drop trigger \"trigger to be dropped\" of migrationtesttable");
                this.myStatement.execute("create view migrationlongview as select k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, k1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890 from migrationtesttable");
                this.myStatement.execute("create synonym tablesynonym for migrationtesttable");
                this.myStatement.execute("create table \"t 1\" (i1 int, i2 int, i3 int)");
                this.myStatement.execute("create view v as select i1, i2, i3 from \"t 1\"");
                this.myStatement.execute("comment on column v.i1 is 'this is a comment for i1'");
                this.myStatement.execute("comment on column v.i2 is 'this is a comment for i2'");
                this.myStatement.execute("comment on column v.i3 is 'this is a comment for i3'");
                this.myStatement.execute("create or replace view v as select i3 from \"t 1\"");
                if (m_hasSchema) {
                    schema = c_extraSchema;
                    this.myStatement.execute("create schema " + schema);
                    this.myStatement.execute("set current_schema = " + schema);
                } else {
                    schema = mExUser;
                }
                this.myStatement.execute("create table shortlived (c char(15), c1 int, k1 int)");
                this.myStatement.execute("create view leftover as select * from shortlived no references");
                this.myStatement.execute("comment on table leftover is 'this comment should be dropped during the migration'");
                this.myStatement.execute("create dbproc \"This DB-Proc wont survive\" (\n in db_proc_parameter0 int,\n in db_proc_parameter1 int,\n in another_db_proc_parameter int,\n in the_last_db_proc_parameter int) as\n insert into " + schema + ".shortlived (c1, k1)\n" + " values (:db_proc_parameter0, :db_proc_parameter1);\n" + " insert into migrationtester.migrationtesttable (k1, col3) values\n" + " (:another_db_proc_parameter, :the_last_db_proc_parameter);\n");
                if (m_hasSchema) {
                    this.myStatement.execute("set current_schema = MIGRATIONTESTER");
                }
                this.myStatement.execute("create trigger leftover_i_trigger for \"t 1\" after insert execute ( try insert " + schema + ".shortlived (c1) values(:new.i1); " + " catch if $rc <> 100 then stop ($rc, 'error'); )");
                this.myStatement.execute("create trigger leftover_u_trigger for \"t 1\" after update execute ( try insert " + schema + ".shortlived (c1) values(:new.i1); " + " catch if $rc <> 100 then stop ($rc, 'error'); )");
                this.myStatement.execute("create trigger leftover_d_trigger for \"t 1\" after delete execute ( try insert " + schema + ".shortlived (c1) values(:old.i1); " + " catch if $rc <> 100 then stop ($rc, 'error'); )");
                this.myStatement.execute("create view leftoverlongtext as select " + CatalogToUnicode.getViewDefinitionString() + " from " + schema + ".shortlived no references");
                this.myStatement.execute("create table serialtab (c1 char(15), s1 serial)");
                this.myConnection.commit();
                this.myConnection.close();
                Properties oracleProps = new Properties();
                oracleProps.setProperty("user", mExUser);
                oracleProps.setProperty("password", mExPassword);
                oracleProps.setProperty("sqlmode", "ORACLE");
                this.myConnection = CatalogToUnicode.getDatabase().connect(oracleProps);
                this.myStatement = new TestStatement(null, this.myConnection, 1005, 1007);
                this.myStatement.execute("create dbproc \"Doomed Oracle DB-Proc\" (\n in db_proc_parameter0 int,\n in db_proc_parameter1 int,\n in another_db_proc_parameter int,\n in the_last_db_proc_parameter int) as\n insert into " + schema + ".shortlived (c1, k1)\n" + " values (:db_proc_parameter0, :db_proc_parameter1);\n" + " insert into migrationtester.migrationtesttable (k1, col3) values\n" + " (:another_db_proc_parameter, :the_last_db_proc_parameter);\n");
                this.myStatement.execute("drop table " + schema + ".shortlived");
                this.myStatement.execute("create table triggertesttable (c char(15))");
                this.myStatement.execute("create trigger testtabletesttrigger for\n migrationtester.triggertesttable\n after insert, update execute (\n TRY\n if 3 = 5 \n THEN INSERT INTO user.triggertesttable(c)\n values\n (1);\n CATCH\n if $rc <> 100\n THEN STOP ($rc, 'unexpected error');\n )");
            }
            catch (Exception e) {
                CatalogToUnicode.addGlobalMessage((String)"Method run", (char)'E', (String)"preparation failed");
                this.addMessage("run", 'E', "Error during test data creation: " + e.getClass() + e.getMessage());
                Object var3_5 = null;
                try {
                    this.myStatement.close();
                }
                catch (Exception e2) {
                    return false;
                }
                try {
                    this.myConnection.commit();
                    this.myConnection.close();
                    return false;
                }
                catch (Exception e3) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {}
            catch (Exception e2) {
                return false;
            }
            this.myStatement.close();
            try {}
            catch (Exception e3) {
                return false;
            }
            this.myConnection.commit();
            this.myConnection.close();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        try {}
        catch (Exception e2) {
            return false;
        }
        this.myStatement.close();
        try {}
        catch (Exception e3) {
            return false;
        }
        this.myConnection.commit();
        this.myConnection.close();
        return true;
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = CatalogToUnicode.getDatabase().getHost();
            mName = CatalogToUnicode.getDatabase().getName();
            int mPort = CatalogToUnicode.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            this.addMessage("executeDBMCmd()", 'E', "Command failed: " + pCmd + "\nException: " + e.getMessage());
            return "error";
        }
    }

    private static String getViewDefinitionString() {
        String viewDef = "K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890";
        return "K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890, K1 + 1.1234567890123456789012345678901234567890123456789012345678901234567890";
    }

    class DbprocInfo {
        String procName;
        String procComment;

        DbprocInfo(String name, String comment) {
            this.procName = name;
            this.procComment = comment;
        }

        String getName() {
            return this.procName;
        }

        String getComment() {
            return this.procComment;
        }
    }
}

