/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransferSax
extends DefaultHandler
implements ErrorHandler {
    private XMLReader parser = null;
    private String uri;
    private Vector schemas;
    private ArrayList tables;
    private ArrayList columns;
    private String table = null;
    private String schema = null;
    private String column = null;
    private String sortableTypes = "BOOLEAN, CHAR, DECIMAL, FIXED, INTEGER, SMALLINT, FLOAT, REAL, DOUBLE PRECISION, DATE, TIME, TIMESTAMP, VARCHAR";

    public void parse(String uri) throws Exception {
        try {
            this.uri = uri;
            this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
            this.parser.parse(uri);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public Iterator iterator() {
        if (this.schemas != null) {
            return this.schemas.iterator();
        }
        return null;
    }

    public void startDocument() throws SAXException {
        this.schemas = new Vector();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("DeployedSchema")) {
            this.schema = attributes.getValue("oim:name");
            if (this.schema != null) {
                this.tables = new ArrayList();
                this.tables.add(this.schema);
            }
        } else if (localName.equals("DeployedTable")) {
            this.table = attributes.getValue("oim:name");
            if (this.table != null) {
                this.columns = new ArrayList();
                this.columns.add(this.table);
            }
        } else if (localName.equals("DeployedColumn")) {
            this.column = attributes.getValue("dbm:name");
        } else if (this.sortableTypes.indexOf(localName) > -1 && this.column != null) {
            this.columns.add(this.column);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("DeployedSchema")) {
            this.schemas.add(this.tables);
        } else if (localName.equals("ColumnSetColumns")) {
            this.tables.add(this.columns);
            this.columns = new ArrayList();
        }
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXParseException {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }
}

