/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.Loader;
import com.sap.sapdb.oltptest.loader.TransferSax;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LoaderTestStarterPython
extends TestCase {
    private static ArrayList sPythonCalls = null;
    private static String jtestRoot;
    private static String fileSep;
    private static String dbName;
    private Properties conProps;
    private static String dbHost;
    private static String instRoot;
    private static String secondInstRoot;
    private static String sourceDbName;
    private static String targetDbName;
    private static String sourceDbHost;
    private static String targetDbHost;
    private static int sourceDbPort;
    private static int targetDbPort;
    private static TestDatabaseSap sourceDb;
    private static TestDatabaseSap targetDb;
    private TestDriverConfiguration sourceDbCfg;
    private TestDriverConfiguration targetDbCfg;
    private HashMap sourceDbParams;
    private HashMap targetDbParams;
    private Connection sourceConnection;
    private Connection targetConnection;
    private TestStatement sourceStatement;
    private TestStatement targetStatement;
    private ResultSet sourceResult;
    private ResultSet targetResult;
    private VerificationDataSorted sourceVeriS;
    private VerificationDataComplete sourceVeriC;
    private static String indepProgPath;
    private static String indepDataPath;
    private ZipOutputStream zos;
    private int stmtCtr = 0;
    private String failedCommands = "";
    private ArrayList userNames;
    private String[] cmdArr;
    private static int mMaxRuntime;
    private static String zipFileName;
    private File zipFile;
    private int bufLength;
    private static boolean diffErr;
    private TransferSax TransformationPackage;
    private String[] callStrings = new String[]{"SELECT OWNER, TABLENAME, COLUMNNAME, MODE, DATATYPE, DEC, NULLABLE, COLUMNPRIVILEGES, \"DEFAULT\" FROM \"DOMAIN\".\"COLUMNS\"", "SELECT OWNER, TABLENAME, CONSTRAINTNAME FROM \"DOMAIN\".\"CONSTRAINTS\"", "SELECT OWNER, TABLENAME, COLUMNNAME, FKEYNAME, REFOWNER, REFTABLENAME, REFCOLUMNNAME, RULE FROM \"DOMAIN\".\"FOREIGNKEYCOLUMNS\"", "SELECT OWNER, TABLENAME, FKEYNAME, RULE FROM \"DOMAIN\".\"FOREIGNKEYS\"", "SELECT OWNER, TABLENAME, INDEXNAME, TYPE, COLUMNNAME, SORT, COLUMNNO, DATATYPE FROM \"DOMAIN\".\"INDEXCOLUMNS\"", "SELECT OWNER, TABLENAME, INDEXNAME, TYPE, DISABLED FROM \"DOMAIN\".\"INDEXES\"", "SELECT OWNER, TABLENAME, ROLE, GRANTEE, PRIVILEGES, GRANTOR FROM \"DOMAIN\".\"ROLEPRIVILEGES\"", "SELECT OWNER, ROLE, PASSWORD_REQUIRED, GRANTED FROM \"DOMAIN\".\"ROLES\"", "SELECT OWNER, SEQUENCE_NAME, MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE FROM \"DOMAIN\".\"SEQUENCES\"", "SELECT OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME FROM \"DOMAIN\".\"SYNONYMS\"", "SELECT OWNER, TABLENAME, PRIVILEGES, TYPE, TABLETYPE FROM \"DOMAIN\".\"TABLES\" WHERE TABLETYPE != 'RESULT' ", "SELECT OWNER, TABLENAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM \"DOMAIN\".\"TABLEPRIVILEGES\"  WHERE TABLENAME <> 'TRANSFORMATIONMODEL'  ", "SELECT OWNER, TABLENAME, TRIGGERNAME, \"INSERT\", \"UPDATE\", \"DELETE\" FROM \"DOMAIN\".\"TRIGGERS\"", "SELECT OWNER, GROUPNAME, USERNAME, USERMODE, CONNECTMODE FROM \"DOMAIN\".\"USERS\"", "SELECT OWNER, VIEWNAME, VIEWCOLUMNNAME, TABLEOWNER, TABLENAME, COLUMNNAME FROM \"DOMAIN\".\"VIEWCOLUMNS\"", "SELECT OWNER, VIEWNAME FROM \"DOMAIN\".\"VIEWDEFS\"", "SELECT OWNER, VIEWNAME, PRIVILEGES, TYPE FROM \"DOMAIN\".\"VIEWS\""};
    private String[] callStringsRedWhsp = new String[]{"SELECT DEFINITION FROM \"DOMAIN\".\"CONSTRAINTS\"", "SELECT DEFINITION FROM \"DOMAIN\".\"TRIGGERS\"", "SELECT DEFINITION FROM \"DOMAIN\".\"VIEWDEFS\""};
    private String defaultPassword = "initial";

    static {
        indepProgPath = "";
        indepDataPath = "";
        mMaxRuntime = 60;
    }

    public static long getTimeout() {
        return mMaxRuntime * 1000 * 60;
    }

    public static void prepare() throws TestCaseException {
        sPythonCalls = LoaderTestStarterPython.getUnnamedParameterList();
        mMaxRuntime = LoaderTestStarterPython.getParameterInt((String)"timeout", (int)60);
        jtestRoot = System.getProperty("jtest.root");
        if (jtestRoot == null) {
            LoaderTestStarterPython.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). Property jtest.root not set.");
            throw new TestCaseException("Property jtest.root not set.");
        }
        fileSep = System.getProperty("file.separator");
        dbName = LoaderTestStarterPython.getDatabase().getName();
        sourceDbName = String.valueOf(dbName) + "S";
        targetDbName = String.valueOf(dbName) + "T";
        sourceDbPort = LoaderTestStarterPython.getDatabase().getPort();
        targetDbPort = LoaderTestStarterPython.getDatabase().getPort();
        File wrkDir = null;
        instRoot = mTestDriverOptions.getProperty("DBRoot");
        if (instRoot == null) {
            instRoot = "";
            LoaderTestStarterPython.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare(). INSTROOT (DBROOT) not set.");
        }
        if ((secondInstRoot = mTestDriverOptions.getProperty("DBSecondRoot")) == null) {
            secondInstRoot = instRoot;
            LoaderTestStarterPython.addGlobalMessage((String)"", (char)'I', (String)"prepare(): second INSTROOT (DBROOT) not set, using first INSTROOT for both databases.");
        } else {
            System.out.println("Source INSTROOT (DBROOT): " + secondInstRoot);
            LoaderTestStarterPython.addGlobalMessage((String)"", (char)'I', (String)("prepare(): Source INSTROOT (DBROOT): " + secondInstRoot));
        }
        sourceDbHost = dbHost = LoaderTestStarterPython.getDatabase().getHost();
        targetDbHost = dbHost;
        try {
            sourceDb = new TestDatabaseSap(sourceDbHost, sourceDbName);
            sourceDb.setPort(sourceDbPort);
            targetDb = new TestDatabaseSap(targetDbHost, targetDbName);
            targetDb.setPort(targetDbPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            indepDataPath = ((TestDatabaseSap)LoaderTestStarterPython.getDatabase()).getIndepDataPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            boolean deleted;
            String fileName;
            wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk");
            File[] dirContent = wrkDir.listFiles();
            int i = 0;
            while (i < dirContent.length) {
                fileName = dirContent[i].getName();
                if ((fileName.indexOf("loader") != -1 || fileName.indexOf("install") != -1) && fileName.endsWith(".prt")) {
                    deleted = false;
                    deleted = dirContent[i].delete();
                    if (!deleted) {
                        LoaderTestStarterPython.addGlobalMessage((String)"prepare()", (char)'W', (String)("Could not delete old protocol file " + indepDataPath + fileSep + "wrk" + fileSep + fileName));
                    }
                }
                ++i;
            }
            wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + sourceDbName);
            dirContent = wrkDir.listFiles();
            if (dirContent != null) {
                i = 0;
                while (i < dirContent.length) {
                    fileName = dirContent[i].getName();
                    if (fileName.endsWith("_knldiag.err")) {
                        deleted = false;
                        deleted = dirContent[i].delete();
                        if (!deleted) {
                            LoaderTestStarterPython.addGlobalMessage((String)"prepare()", (char)'W', (String)("Could not delete old file " + indepDataPath + fileSep + "wrk" + fileSep + fileName));
                        }
                    }
                    ++i;
                }
            }
            if ((dirContent = (wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + targetDbName)).listFiles()) != null) {
                i = 0;
                while (i < dirContent.length) {
                    fileName = dirContent[i].getName();
                    if (fileName.endsWith(".PACKAGE") || fileName.endsWith("_knldiag.err")) {
                        deleted = false;
                        deleted = dirContent[i].delete();
                        if (!deleted) {
                            LoaderTestStarterPython.addGlobalMessage((String)"prepare()", (char)'W', (String)("Could not delete old file " + indepDataPath + fileSep + "wrk" + fileSep + fileName));
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("  Exception caught: " + e.getClass());
            e.printStackTrace();
        }
    }

    public void run() {
        String cmd = "";
        boolean sourceDbStop = true;
        boolean targetDbStop = true;
        this.userNames = new ArrayList();
        String sourceUnicodeOld = "";
        String sourceDefaultCodeOld = "";
        String targetUnicodeOld = "";
        String targetDefaultCodeOld = "";
        String realDbHostname = "";
        int numCommands = 0;
        File wrkDir = null;
        String protocolPath = null;
        String packagePath = null;
        Properties loaderProperties = null;
        loaderProperties = new Properties();
        try {
            String host = "";
            String db = "";
            Loader mLoader = Loader.dbLoader((String)host, (String)db);
            String reply = mLoader.cmd("SET");
            StringTokenizer stz = new StringTokenizer(reply, "\n");
            mLoader.release();
            String dummy = null;
            while (stz.hasMoreTokens()) {
                dummy = stz.nextToken().trim();
                if (dummy.startsWith("Loader protocol")) {
                    protocolPath = dummy.substring(dummy.indexOf(":") + 1).trim();
                    protocolPath = protocolPath.replace('\'', ' ').trim();
                }
                if (!dummy.startsWith("Loader packages")) continue;
                packagePath = dummy.substring(dummy.indexOf(":") + 1).trim();
                packagePath = packagePath.replace('\'', ' ').trim();
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        String version = DriverSapDB.getStaticVersion();
        System.out.println("Jdbc   version (sapdbc.jar   ): " + version);
        System.out.println("Loader protocol(sapdbcbin.dll): " + protocolPath);
        System.out.println("Loader packages(sapdbcbin.dll): " + packagePath);
        String tapeHostList = LoaderTestStarterPython.getParameterString((String)"tapeHostList", (String)"");
        String webDavHostList = LoaderTestStarterPython.getParameterString((String)"webDavHostList", (String)"");
        zipFileName = "loadertest.zip";
        this.zipFile = this.createZipFile(String.valueOf(jtestRoot) + fileSep + "protocols" + fileSep + zipFileName);
        if (this.zipFile == null) {
            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)"Creating of empty zip file failed.");
        }
        try {
            this.zos = new ZipOutputStream(new FileOutputStream(this.zipFile));
        }
        catch (FileNotFoundException e) {
            this.addMessage("run()", 'W', "Cannot open zip file.\nException: " + e.getMessage());
        }
        if (sPythonCalls != null && !sPythonCalls.isEmpty()) {
            String fileName;
            File protocolFile;
            String protocolFileParent;
            File protocol;
            File[] dirContent;
            numCommands = sPythonCalls.size();
            boolean winFlag = false;
            String osName = System.getProperty("os.name");
            if (osName != null && osName.indexOf("Windows") != -1) {
                winFlag = true;
            }
            try {
                this.executeDBMCmd(sourceDbName, dbHost, sourceDbPort, "db_online");
                this.executeDBMCmd(targetDbName, dbHost, targetDbPort, "db_online");
            }
            catch (Exception dummy) {
                // empty catch block
            }
            ListIterator it = sPythonCalls.listIterator();
            String strCmdCtr = "";
            int realCmdCtr = 0;
            while (it.hasNext()) {
                String options = ((String)it.next()).trim();
                ++realCmdCtr;
                int cmdCtr = 0;
                StringTokenizer st = new StringTokenizer(options);
                String tOld = "";
                String tNew = "";
                while (st.hasMoreTokens()) {
                    tOld = tNew;
                    tNew = st.nextToken();
                    if (!tOld.equals("-T")) continue;
                    cmdCtr = new Integer(tNew);
                }
                System.out.println("-----------------------\nLoader test case #" + cmdCtr);
                this.addMessage("run()", 'I', "Loader test case #" + cmdCtr);
                try {
                    realDbHostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                if (!(options.indexOf("-p WEBDAV") != -1 && webDavHostList.toLowerCase().indexOf(realDbHostname.toLowerCase()) == -1 || options.indexOf("-m TAPE") != -1 && tapeHostList.toLowerCase().indexOf(realDbHostname.toLowerCase()) == -1)) {
                    boolean renamed;
                    String fileName2;
                    int i;
                    String targetDefaultCode;
                    String targetUnicode;
                    String sourceDefaultCode;
                    String sourceUnicode;
                    int sourceDbIndex;
                    try {
                        int i2 = 0;
                        while (i2 < 2) {
                            sourceDbIndex = options.indexOf("LOCALHOST");
                            if (sourceDbIndex != -1) {
                                options = String.valueOf(options.substring(0, sourceDbIndex)) + InetAddress.getLocalHost().getHostName() + options.substring(sourceDbIndex + 9);
                            }
                            ++i2;
                        }
                    }
                    catch (UnknownHostException i2) {
                        // empty catch block
                    }
                    sourceDbIndex = options.indexOf("SOURCEDB");
                    int targetDbIndex = options.indexOf("TARGETDB");
                    if (sourceDbIndex != -1 || targetDbIndex != -1) {
                        options = String.valueOf(options.substring(0, sourceDbIndex)) + sourceDbName + options.substring(sourceDbIndex + 8, targetDbIndex) + targetDbName + options.substring(targetDbIndex + 8);
                    }
                    sourceDbIndex = options.indexOf("sourceinstroot");
                    targetDbIndex = options.indexOf("targetinstroot");
                    if (sourceDbIndex != -1 || targetDbIndex != -1) {
                        options = String.valueOf(options.substring(0, sourceDbIndex)) + secondInstRoot + options.substring(sourceDbIndex + 14, targetDbIndex) + instRoot + options.substring(targetDbIndex + 14);
                    }
                    String validateWhat = "all";
                    String validateHow = "sorted";
                    int validateIndex = options.indexOf("-v catalog");
                    if (validateIndex != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 10);
                        validateWhat = "catalog";
                    }
                    if ((validateIndex = options.indexOf("-v data")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 7);
                        validateWhat = "data";
                    }
                    if ((validateIndex = options.indexOf("-v all")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 6);
                        validateWhat = "all";
                    }
                    if ((validateIndex = options.indexOf("-v none")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 7);
                        validateWhat = "none";
                    }
                    if ((validateIndex = options.indexOf("-V sorted")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 9);
                        validateHow = "sorted";
                    }
                    if ((validateIndex = options.indexOf("-V complete")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 11);
                        validateHow = "complete";
                    }
                    if ((validateIndex = options.indexOf("-V none")) != -1) {
                        options = String.valueOf(options.substring(0, validateIndex)) + options.substring(validateIndex + 7);
                        validateHow = "none";
                    }
                    boolean sortedVeri = !validateHow.equals("complete") && options.indexOf("-p WEBDAV") == -1;
                    if (System.getProperty("os.name").indexOf("Windows") != -1) {
                        this.cmdArr = new String[1];
                    } else {
                        this.cmdArr = new String[3];
                        this.cmdArr[0] = "sh";
                        this.cmdArr[1] = "-c";
                    }
                    String scriptDir = String.valueOf(jtestRoot.substring(0, jtestRoot.length() - "/jtest".length())) + fileSep + "sdb" + fileSep + "loader" + fileSep + "test";
                    String script = String.valueOf(scriptDir) + fileSep + "test_loader.py";
                    this.cmdArr[this.cmdArr.length - 1] = String.valueOf(instRoot) + fileSep + "bin" + fileSep + "x_python " + script + " " + options;
                    if (!new File(script).exists()) {
                        System.out.println("Script_not_found: " + script);
                        this.addMessage("run()", 'E', "Script_not_found: " + script);
                        this.addMessage("run()", 'E', "Script_not_found: " + script);
                    }
                    this.sourceDbCfg = new TestDriverConfiguration();
                    this.sourceDbCfg.setConfiguration(mTestDriverOptions);
                    this.sourceDbCfg.setConfigValue("DBName", (Object)sourceDbName);
                    this.sourceDbCfg.setConfigValue("DBHost", (Object)sourceDbHost);
                    this.sourceDbCfg.setConfigValue("DBRoot", (Object)secondInstRoot);
                    this.sourceDbCfg.setConfigValue("DBForce", (Object)Boolean.TRUE);
                    this.sourceDbCfg.setConfigValue("DBKeep", (Object)Boolean.TRUE);
                    this.sourceDbCfg.setConfigValue("DBDrop", (Object)Boolean.FALSE);
                    this.sourceDbCfg.setConfigValue("DBKeepState", (Object)"OFFLINE");
                    this.targetDbCfg = new TestDriverConfiguration();
                    this.targetDbCfg.setConfiguration(mTestDriverOptions);
                    this.targetDbCfg.setConfigValue("DBName", (Object)targetDbName);
                    this.targetDbCfg.setConfigValue("DBHost", (Object)targetDbHost);
                    this.targetDbCfg.setConfigValue("DBRoot", (Object)instRoot);
                    this.targetDbCfg.setConfigValue("DBForce", (Object)Boolean.TRUE);
                    this.targetDbCfg.setConfigValue("DBKeep", (Object)Boolean.TRUE);
                    this.targetDbCfg.setConfigValue("DBDrop", (Object)Boolean.FALSE);
                    this.targetDbCfg.setConfigValue("DBKeepState", (Object)"OFFLINE");
                    this.sourceDbParams = mTestDriverConfiguration.getDBParameterMap();
                    if (this.sourceDbParams == null) {
                        this.sourceDbParams = new HashMap();
                    }
                    this.targetDbParams = mTestDriverConfiguration.getDBParameterMap();
                    if (this.targetDbParams == null) {
                        this.targetDbParams = new HashMap();
                    }
                    if (options.indexOf("-eSRC unicode,ascii") > -1) {
                        sourceUnicode = "YES";
                        sourceDefaultCode = "ASCII";
                    } else if (options.indexOf("-eSRC ascii") > -1) {
                        sourceUnicode = "NO";
                        sourceDefaultCode = "ASCII";
                    } else {
                        sourceUnicode = "YES";
                        sourceDefaultCode = "UNICODE";
                    }
                    if (options.indexOf("-eSRC ascii") > -1) {
                        this.sourceDbParams.put("_UNICODE", "NO");
                        this.sourceDbParams.put("DEFAULT_CODE", "ASCII");
                    } else {
                        this.sourceDbParams.put("_UNICODE", "YES");
                        this.sourceDbParams.put("DEFAULT_CODE", "UNICODE");
                    }
                    if (options.indexOf("-eTRG unicode,ascii") > -1) {
                        targetUnicode = "YES";
                        targetDefaultCode = "ASCII";
                    } else if (options.indexOf("-eTRG ascii") > -1) {
                        targetUnicode = "NO";
                        targetDefaultCode = "ASCII";
                    } else {
                        targetUnicode = "YES";
                        targetDefaultCode = "UNICODE";
                    }
                    if (options.indexOf("-eTRG ascii") > -1) {
                        this.targetDbParams.put("_UNICODE", "NO");
                        this.targetDbParams.put("DEFAULT_CODE", "ASCII");
                    } else {
                        this.targetDbParams.put("_UNICODE", "YES");
                        this.targetDbParams.put("DEFAULT_CODE", "UNICODE");
                    }
                    this.sourceDbCfg.setDBParameterMap(this.sourceDbParams);
                    this.sourceDbCfg.setDBDeviceList(mTestDriverConfiguration.getDBDeviceList());
                    this.targetDbCfg.setDBParameterMap(this.targetDbParams);
                    this.targetDbCfg.setDBDeviceList(mTestDriverConfiguration.getDBDeviceList());
                    try {
                        if (sourceUnicode.equals(sourceUnicodeOld) && sourceDefaultCode.equals(sourceDefaultCodeOld) || options.indexOf("-iSRC delete") > -1) {
                            if (options.indexOf("-iSRC delete") > -1) {
                                try {
                                    sourceDbStop = false;
                                    this.deleteLoaderTables(sourceDb);
                                    System.out.println("Deleting Loader tables from " + sourceDbName);
                                    this.addMessage("run()", 'I', "Deleting Loader tables from " + sourceDbName);
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Exception during deleting of source DB loader tables: " + e.getMessage());
                                    e.printStackTrace();
                                    System.out.println("Dropping/creating " + sourceDbName);
                                    this.addMessage("run()", 'I', "Dropping/creating " + sourceDbName);
                                    sourceDb = this.additionalDatabase(this.sourceDbCfg, 0);
                                }
                            } else {
                                try {
                                    sourceDbStop = true;
                                    System.out.println("Restoring " + sourceDbName + " from initial backup.");
                                    this.addMessage("run()", 'I', "Restoring " + sourceDbName + " from initial backup.");
                                    sourceDb.restoreInstance();
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Exception during restoring of source DB instance: " + e.getMessage());
                                    e.printStackTrace();
                                    System.out.println("Dropping/creating " + sourceDbName);
                                    this.addMessage("run()", 'I', "Dropping/creating " + sourceDbName);
                                    sourceDb = this.additionalDatabase(this.sourceDbCfg, 0);
                                }
                            }
                        } else {
                            System.out.println("Dropping/creating " + sourceDbName);
                            this.addMessage("run()", 'I', "Dropping/creating " + sourceDbName);
                            sourceDb = this.additionalDatabase(this.sourceDbCfg, 0);
                        }
                        if (targetUnicode.equals(targetUnicodeOld) && targetDefaultCode.equals(targetDefaultCodeOld) || options.indexOf("-iTRG delete") > -1) {
                            if (options.indexOf("-iTRG delete") > -1) {
                                try {
                                    targetDbStop = false;
                                    System.out.println("Deleting Loader tables from " + targetDbName);
                                    this.addMessage("run()", 'I', "Deleting Loader tables from " + targetDbName);
                                    this.deleteLoaderTables(targetDb);
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Exception during deleting of target DB loader tables: " + e.getMessage());
                                    e.printStackTrace();
                                    System.out.println("Dropping/creating " + targetDbName);
                                    this.addMessage("run()", 'I', "Dropping/creating " + targetDbName);
                                    targetDb = this.additionalDatabase(this.targetDbCfg, 0);
                                }
                            } else {
                                try {
                                    targetDbStop = true;
                                    System.out.println("Restoring " + targetDbName + " from initial backup.");
                                    this.addMessage("run()", 'I', "Restoring " + targetDbName + " from initial backup.");
                                    targetDb.restoreInstance();
                                }
                                catch (Exception e) {
                                    this.addMessage("run()", 'E', "Exception during restoring of target DB instance: " + e.getMessage());
                                    e.printStackTrace();
                                    System.out.println("Dropping/creating " + targetDbName);
                                    this.addMessage("run()", 'I', "Dropping/creating " + targetDbName);
                                    targetDb = this.additionalDatabase(this.targetDbCfg, 0);
                                }
                            }
                        } else {
                            System.out.println("Dropping/creating " + targetDbName);
                            this.addMessage("run()", 'I', "Dropping/creating " + targetDbName);
                            targetDb = this.additionalDatabase(this.targetDbCfg, 0);
                        }
                    }
                    catch (Exception e) {
                        this.addMessage("run()", 'E', "Exception during creation of database: " + e.getMessage());
                        e.printStackTrace();
                    }
                    this.userNames = new ArrayList();
                    sourceUnicodeOld = sourceUnicode;
                    sourceDefaultCodeOld = sourceDefaultCode;
                    targetUnicodeOld = targetUnicode;
                    targetDefaultCodeOld = targetDefaultCode;
                    cmd = "";
                    int i3 = 0;
                    while (i3 < this.cmdArr.length) {
                        cmd = String.valueOf(cmd) + this.cmdArr[i3] + " ";
                        ++i3;
                    }
                    System.out.println("Executing command #" + cmdCtr + ":\n" + cmd);
                    this.addMessage("run()", 'I', "Executing command #" + cmdCtr + ":\n" + cmd);
                    this.setStatus("Test #" + cmdCtr + " (" + realCmdCtr + " of " + numCommands + ")");
                    StringBuffer sb = new StringBuffer();
                    Execute exc = System.getProperty("os.name").indexOf("Windows") != -1 ? new Execute(cmd, null, sb) : new Execute(this.cmdArr, null, sb);
                    exc.exec(new File(scriptDir));
                    System.out.println("Result of command #" + cmdCtr + ":\n" + sb.toString());
                    this.addMessage("run()", 'I', "Result of command #" + cmdCtr + ":\n" + sb.toString());
                    strCmdCtr = cmdCtr < 10 ? "" + cmdCtr : "" + cmdCtr;
                    String xmlDir = "";
                    xmlDir = String.valueOf(packagePath) + fileSep + "export" + fileSep + realDbHostname + fileSep + sourceDbName + fileSep + cmdCtr;
                    wrkDir = new File(xmlDir);
                    boolean zipped = false;
                    File[] dirContent2 = wrkDir.listFiles();
                    if (dirContent2 != null) {
                        i = 0;
                        while (i < dirContent2.length) {
                            fileName2 = dirContent2[i].getName();
                            if (fileName2.endsWith(".PACKAGE")) {
                                if (!fileName2.startsWith(strCmdCtr)) {
                                    renamed = false;
                                    fileName2 = String.valueOf(fileName2.substring(0, fileName2.indexOf(".") + 1)) + "EXPORT";
                                    fileName2 = String.valueOf(strCmdCtr) + "_" + fileName2;
                                    renamed = dirContent2[i].renameTo(new File(String.valueOf(xmlDir) + fileSep + fileName2));
                                    if (!renamed) {
                                        LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not rename PACKAGE file " + xmlDir + fileSep + fileName2));
                                    }
                                }
                                zipped = false;
                                zipped = this.addToZipFile(this.zipFile, new String[]{String.valueOf(xmlDir) + fileSep + fileName2});
                                if (!zipped) {
                                    LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append export PACKAGE file " + xmlDir + fileSep + fileName2 + " to zip archive."));
                                }
                            }
                            ++i;
                        }
                    }
                    if ((dirContent2 = (wrkDir = new File(xmlDir = String.valueOf(packagePath) + fileSep + "import" + fileSep + realDbHostname + fileSep + targetDbName + fileSep + cmdCtr)).listFiles()) != null) {
                        i = 0;
                        while (i < dirContent2.length) {
                            fileName2 = dirContent2[i].getName();
                            if (fileName2.endsWith(".PACKAGE")) {
                                if (!fileName2.startsWith(strCmdCtr)) {
                                    renamed = false;
                                    fileName2 = String.valueOf(fileName2.substring(0, fileName2.indexOf(".") + 1)) + "IMPORT";
                                    fileName2 = String.valueOf(strCmdCtr) + "_" + fileName2;
                                    renamed = dirContent2[i].renameTo(new File(String.valueOf(xmlDir) + fileSep + fileName2));
                                    if (!renamed) {
                                        LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not rename PACKAGE file " + xmlDir + fileSep + fileName2));
                                    }
                                }
                                zipped = false;
                                zipped = this.addToZipFile(this.zipFile, new String[]{String.valueOf(xmlDir) + fileSep + fileName2});
                                if (!zipped) {
                                    LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append import PACKAGE file " + xmlDir + fileSep + fileName2 + " to zip archive."));
                                }
                            }
                            ++i;
                        }
                    }
                    if ((dirContent2 = (wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk")).listFiles()) != null) {
                        i = 0;
                        while (i < dirContent2.length) {
                            fileName2 = dirContent2[i].getName();
                            if ((fileName2.startsWith("loader") || fileName2.startsWith("install")) && fileName2.indexOf(".prt") != -1) {
                                renamed = false;
                                renamed = dirContent2[i].renameTo(new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + strCmdCtr + fileName2));
                                if (!renamed) {
                                    LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not rename protocol file " + indepDataPath + fileSep + "wrk" + fileSep + fileName2 + " to " + strCmdCtr + fileName2));
                                }
                            }
                            ++i;
                        }
                    }
                    if (this.failedCommands.indexOf("" + cmdCtr) > -1) {
                        try {
                            this.copyFile(new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + sourceDbName + fileSep + "knldiag.err"), new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + sourceDbName + fileSep + strCmdCtr + sourceDbName + "_knldiag.err"));
                        }
                        catch (Exception e) {
                            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not copy knldiag.err file " + indepDataPath + fileSep + "wrk" + fileSep + sourceDbName + fileSep + "knldiag.err" + " to " + indepDataPath + fileSep + "wrk" + fileSep + sourceDbName + fileSep + strCmdCtr + sourceDbName + "_knldiag.err"));
                        }
                        try {
                            this.copyFile(new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + targetDbName + fileSep + "knldiag.err"), new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + targetDbName + fileSep + strCmdCtr + targetDbName + "_knldiag.err"));
                        }
                        catch (Exception e) {
                            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not copy knldiag.err file " + indepDataPath + fileSep + "wrk" + fileSep + targetDbName + fileSep + "knldiag.err" + " to " + indepDataPath + fileSep + "wrk" + fileSep + targetDbName + fileSep + strCmdCtr + targetDbName + "_knldiag.err"));
                        }
                    }
                    String xmlFile = "";
                    xmlDir = String.valueOf(packagePath) + fileSep + "export" + fileSep + realDbHostname + fileSep + sourceDbName + fileSep + cmdCtr + fileSep;
                    xmlFile = String.valueOf(cmdCtr) + ".xml";
                    if (!new File(String.valueOf(xmlDir) + xmlFile).exists()) continue;
                    System.out.println("Verify    transformation package : " + cmdCtr + " " + validateWhat + " " + validateHow);
                    this.addMessage("run()", 'I', "Verify    transformation package " + cmdCtr + ": " + validateWhat + validateHow);
                    try {
                        this.TransformationPackage = new TransferSax();
                        this.TransformationPackage.parse("file:///" + xmlDir + xmlFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Iterator itSchemas = this.TransformationPackage.iterator();
                    if (itSchemas == null) {
                        LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)"Parsing of XML file failed: list of schemas is empty.");
                    }
                    while (itSchemas != null && itSchemas.hasNext()) {
                        String userName;
                        Iterator itTable;
                        block133: {
                            ArrayList schema = (ArrayList)itSchemas.next();
                            itTable = schema.iterator();
                            userName = itTable.next().toString();
                            this.userNames.add(userName);
                            try {
                                this.conProps = new Properties();
                                this.conProps.put("user", userName);
                                if (userName.equalsIgnoreCase("DBA")) {
                                    this.conProps.put("password", "dba");
                                } else {
                                    this.conProps.put("password", this.defaultPassword);
                                }
                                this.sourceConnection = sourceDb.connect(this.conProps);
                                this.targetConnection = targetDb.connect(this.conProps);
                            }
                            catch (TestDatabaseException e) {
                                this.addMessage("run()", 'E', "Exception during connect:  " + e.getMessage());
                                e.printStackTrace();
                                if (this.failedCommands.indexOf("" + cmdCtr) != -1) break block133;
                                this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                            }
                        }
                        if ((validateWhat.equals("catalog") || validateWhat.equals("all")) && !validateHow.equals("none")) {
                            int i4 = 0;
                            while (i4 < this.callStrings.length) {
                                block134: {
                                    try {
                                        this.sourceStatement = new TestStatement((TestCase)this, this.sourceConnection);
                                        this.sourceStatement.executeQuery(this.callStrings[i4]);
                                        ++this.stmtCtr;
                                        this.sourceResult = this.sourceStatement.getResultSet();
                                        this.sourceVeriC = new VerificationDataComplete(this.sourceResult);
                                        this.targetStatement = new TestStatement((TestCase)this, this.targetConnection);
                                        this.targetStatement.executeQuery(this.callStrings[i4]);
                                        this.targetResult = this.targetStatement.getResultSet();
                                        if (!this.sourceVeriC.equals(this.targetResult)) {
                                            this.addMessage("run()", 'E', "Difference between source and target DB, user: " + userName + ", statement:\n" + this.callStrings[i4] + "\n  executed python command  #" + cmdCtr + " was: " + cmd + "\n  Details from VerificationData: " + this.sourceVeriC.getErrorMessage());
                                            if (this.failedCommands.indexOf("" + cmdCtr) == -1) {
                                                this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        this.addMessage("run()", 'E', "Exception during statement, user: " + userName + ", statement:\n" + this.callStrings[i4] + "\n  " + e.getMessage());
                                        e.printStackTrace();
                                        if (this.failedCommands.indexOf("" + cmdCtr) != -1) break block134;
                                        this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                    }
                                }
                                ++i4;
                            }
                            i4 = 0;
                            while (i4 < this.callStringsRedWhsp.length) {
                                block135: {
                                    try {
                                        this.sourceStatement = new TestStatement((TestCase)this, this.sourceConnection);
                                        this.sourceStatement.executeQuery(this.callStringsRedWhsp[i4]);
                                        ++this.stmtCtr;
                                        this.sourceResult = this.sourceStatement.getResultSet();
                                        this.sourceVeriC = new VerificationDataComplete(this.sourceResult);
                                        this.targetStatement = new TestStatement((TestCase)this, this.targetConnection);
                                        this.targetStatement.executeQuery(this.callStringsRedWhsp[i4]);
                                        this.targetResult = this.targetStatement.getResultSet();
                                        if (!this.sourceVeriC.equalsSubstString(this.targetResult, "s/\\s+//g")) {
                                            this.addMessage("run()", 'E', "Difference between source and target DB, user: " + userName + ", statement:\n" + this.callStringsRedWhsp[i4] + "\n  executed python command  #" + cmdCtr + " was: " + cmd + "\n  Details from VerificationData: " + this.sourceVeriC.getErrorMessage());
                                            if (this.failedCommands.indexOf("" + cmdCtr) == -1) {
                                                this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        this.addMessage("run()", 'E', "Exception during statement, user: " + userName + ", statement:\n" + this.callStringsRedWhsp[i4] + "\n  " + e.getMessage());
                                        e.printStackTrace();
                                        if (this.failedCommands.indexOf("" + cmdCtr) != -1) break block135;
                                        this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                    }
                                }
                                ++i4;
                            }
                        }
                        if ((validateWhat.equals("data") || validateWhat.equals("all")) && !validateHow.equals("none")) {
                            String tableName = "";
                            String columnName = "";
                            String select = "SELECT * FROM ";
                            String statementText = "";
                            while (itTable.hasNext()) {
                                String orderClause = " ORDER BY ";
                                Iterator itColumn = ((ArrayList)itTable.next()).iterator();
                                tableName = itColumn.next().toString();
                                while (itColumn.hasNext()) {
                                    columnName = itColumn.next().toString();
                                    orderClause = orderClause.equals(" ORDER BY ") ? String.valueOf(orderClause) + columnName : String.valueOf(orderClause) + ", " + columnName;
                                }
                                statementText = sortedVeri ? String.valueOf(select) + tableName + orderClause : String.valueOf(select) + tableName;
                                try {
                                    this.sourceStatement = new TestStatement((TestCase)this, this.sourceConnection);
                                    this.sourceStatement.executeQuery(statementText);
                                    ++this.stmtCtr;
                                    this.sourceResult = this.sourceStatement.getResultSet();
                                    if (sortedVeri) {
                                        this.sourceVeriS = new VerificationDataSorted(this.sourceResult);
                                    } else {
                                        this.sourceVeriC = new VerificationDataComplete(this.sourceResult);
                                    }
                                    this.targetStatement = new TestStatement((TestCase)this, this.targetConnection);
                                    this.targetStatement.executeQuery(statementText);
                                    this.targetResult = this.targetStatement.getResultSet();
                                    if (sortedVeri) {
                                        if (this.sourceVeriS.equals(this.targetResult)) continue;
                                        this.addMessage("run()", 'E', "Difference between source and target DB, user: " + userName + ", statement:\n" + statementText + "\n  executed python command  #" + cmdCtr + " was: " + cmd + "\n  Details from VerificationData: " + this.sourceVeriS.getErrorMessage());
                                        if (this.failedCommands.indexOf("" + cmdCtr) != -1) continue;
                                        this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                        continue;
                                    }
                                    if (this.sourceVeriC.equals(this.targetResult)) continue;
                                    this.addMessage("run()", 'E', "Difference between source and target DB, user: " + userName + ", statement:\n" + statementText + "\n  executed python command  #" + cmdCtr + " was: " + cmd + "\n  Details from VerificationData: " + this.sourceVeriC.getErrorMessage());
                                    if (this.failedCommands.indexOf("" + cmdCtr) != -1) continue;
                                    this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                }
                                catch (SQLException e) {
                                    this.addMessage("run()", 'E', "Exception during statement, user: " + userName + ", statement:\n" + statementText + "\n  " + e.getMessage());
                                    e.printStackTrace();
                                    if (this.failedCommands.indexOf("" + cmdCtr) != -1) continue;
                                    this.failedCommands = String.valueOf(this.failedCommands) + " " + cmdCtr;
                                }
                            }
                        }
                        try {
                            this.sourceConnection.close();
                            this.targetConnection.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                System.out.println("\nCommand  #" + cmdCtr + " is excluded.");
                this.addMessage("run()", 'I', "Command  #" + cmdCtr + " is excluded.\n");
            }
            if (sourceDbStop) {
                this.executeDBMCmd(sourceDbName, dbHost, sourceDbPort, "db_stop");
            }
            if (targetDbStop) {
                this.executeDBMCmd(targetDbName, dbHost, targetDbPort, "db_stop");
            }
            if ((dirContent = (protocol = new File(protocolFileParent = (protocolFile = new File(protocolPath)).getParent())).listFiles()) != null) {
                int i = 0;
                while (i < dirContent.length) {
                    String fileName3 = dirContent[i].getName();
                    if ((fileName3.indexOf("loader") != -1 || fileName3.indexOf("install") != -1) && fileName3.endsWith(".prt")) {
                        boolean zipped = false;
                        zipped = this.addToZipFile(this.zipFile, new String[]{String.valueOf(protocolFileParent) + fileSep + fileName3});
                        if (!zipped) {
                            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append protocol file " + protocolFileParent + fileSep + fileName3 + " to zip archive."));
                        }
                    }
                    ++i;
                }
            }
            wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + sourceDbName);
            File[] srcDirContent = wrkDir.listFiles();
            wrkDir = new File(String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + targetDbName);
            File[] tgtDirContent = wrkDir.listFiles();
            if (srcDirContent != null) {
                int i = 0;
                while (i < srcDirContent.length) {
                    fileName = srcDirContent[i].getName();
                    if (fileName.endsWith(".PACKAGE") || fileName.endsWith("_knldiag.err")) {
                        boolean zipped = false;
                        zipped = this.addToZipFile(this.zipFile, new String[]{String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + sourceDbName + fileSep + fileName});
                        if (!zipped) {
                            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append file " + indepDataPath + fileSep + "wrk" + fileSep + sourceDbName + fileSep + fileName + " to zip archive."));
                        }
                    }
                    ++i;
                }
            }
            if (tgtDirContent != null) {
                int i = 0;
                while (i < tgtDirContent.length) {
                    fileName = tgtDirContent[i].getName();
                    if (fileName.endsWith(".PACKAGE") || fileName.endsWith("_knldiag.err")) {
                        boolean zipped = false;
                        zipped = this.addToZipFile(this.zipFile, new String[]{String.valueOf(indepDataPath) + fileSep + "wrk" + fileSep + targetDbName + fileSep + fileName});
                        if (!zipped) {
                            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append file " + indepDataPath + fileSep + "wrk" + fileSep + targetDbName + fileSep + fileName + " to zip archive."));
                        }
                    }
                    ++i;
                }
            }
            boolean zipped = false;
            String parFile = this.getParameterFileLocation();
            if (parFile != null) {
                zipped = this.addToZipFile(this.zipFile, new String[]{parFile});
            }
            if (parFile == null || !zipped) {
                LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'W', (String)("Could not append parameter file " + parFile + " to zip archive."));
            }
            try {
                this.zos.close();
            }
            catch (IOException e) {
                this.addMessage("run()", 'W', "Cannot close zip file.\nException: " + e.getMessage());
            }
            this.failedCommands = this.failedCommands.equals("") ? "No errors occured." : "Errors occured at execution of commands: " + this.failedCommands;
            System.out.println("\nNumber of validation statements executed: " + this.stmtCtr + "\n" + this.failedCommands + "\n");
            LoaderTestStarterPython.addGlobalMessage((String)"run()", (char)'I', (String)("\nNumber of validation statements executed: " + this.stmtCtr + "\n" + this.failedCommands));
        }
    }

    public String executeDBMCmd(String name, String host, int port, String cmd) {
        String logon = "";
        try {
            DBM dBMan = DBM.dbDBM((String)(String.valueOf(host) + ":" + port), (String)name);
            logon = "USER_LOGON DBM,DBM";
            dBMan.cmd(logon);
            return dBMan.cmd(cmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + cmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            this.addMessage("executeDBMCmd()", 'I', "Exception: " + e.getMessage());
            return "info";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteLoaderTables(TestDatabaseSap db) {
        Connection connection = null;
        TestStatement statement = null;
        Iterator itUserNames = this.userNames.iterator();
        boolean success = true;
        try {
            try {
                Properties cPs = new Properties();
                cPs.put("user", "DBA");
                cPs.put("password", "dba");
                connection = db.connect(cPs);
                statement = new TestStatement((TestCase)this, connection);
                statement.executeUpdate("DELETE SYSLOADER.TRANSFORMATIONMODEL");
            }
            catch (Exception e) {
                this.addMessage("deleteLoaderTables()", 'E', "Exception occured:  " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (connection == null) throw throwable;
                if (statement == null) throw throwable;
                statement.close();
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (connection == null) return;
        if (statement == null) return;
        statement.close();
        connection.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dropUsers(TestDatabaseSap db) {
        Connection connection = null;
        TestStatement statement = null;
        Iterator itUserNames = this.userNames.iterator();
        boolean success = true;
        try {
            try {
                Properties cPs = new Properties();
                cPs.put("user", "DBA");
                cPs.put("password", "dba");
                connection = db.connect(cPs);
                statement = new TestStatement((TestCase)this, connection);
                while (itUserNames != null && itUserNames.hasNext()) {
                    statement.executeQuery("drop user " + itUserNames.next().toString());
                }
            }
            catch (Exception e) {
                success = false;
                this.addMessage("dropUser()", 'E', "Exception occured:  " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (connection == null) throw throwable;
                if (statement == null) throw throwable;
                statement.close();
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (Exception exception) {
            return success;
        }
        if (connection == null) return success;
        if (statement == null) return success;
        statement.close();
        connection.close();
        return success;
    }

    private File createZipFile(String pathName) {
        File outFile = new File(pathName);
        if (outFile.exists()) {
            if (outFile.isDirectory()) {
                this.addMessage("createZipFile()", 'W', String.valueOf(pathName) + " exists but is a directory - cannot create zip file.");
                return null;
            }
            if (!outFile.delete()) {
                this.addMessage("createZipFile()", 'W', "Cannot delete file " + pathName);
                return null;
            }
        }
        try {
            if (!outFile.createNewFile()) {
                this.addMessage("createZipFile()", 'W', "Cannot create file " + pathName);
                return null;
            }
        }
        catch (IOException e) {
            this.addMessage("createZipFile()", 'W', "Cannot create file " + pathName + " due to I/O error.");
            return null;
        }
        return outFile;
    }

    private boolean addToZipFile(File zipFile, String[] pathName) {
        try {
            int h = 0;
            while (h < pathName.length) {
                String subDir;
                File[] content;
                File file = new File(pathName[h]);
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    content = file.listFiles();
                    subDir = file.getName();
                } else if (file.isFile()) {
                    content = new File[]{file};
                    subDir = file.getParentFile().getName();
                } else {
                    return false;
                }
                if (content.length == 0) {
                    this.addMessage("addToZipFile()", 'I', "Cannot add " + pathName[h] + " to zip file, directory is empty.");
                } else {
                    int i = 0;
                    while (i < content.length) {
                        String fileName = content[i].getName();
                        ZipEntry entry = new ZipEntry(String.valueOf(subDir) + fileSep + fileName);
                        entry.setTime(content[i].lastModified());
                        this.zos.putNextEntry(entry);
                        FileInputStream fis = new FileInputStream(content[i]);
                        byte[] buf = new byte[1024];
                        int j = 0;
                        while ((j = fis.read(buf, 0, 1024)) != -1) {
                            if (System.getProperty("os.name").indexOf("Windows") == -1) {
                                byte[] bufLb = this.addWindowsLineBreaks(buf, j);
                                this.zos.write(bufLb, 0, this.bufLength);
                                continue;
                            }
                            this.zos.write(buf, 0, j);
                        }
                        fis.close();
                        ++i;
                    }
                }
                ++h;
            }
        }
        catch (Exception e) {
            this.addMessage("addToZipFile()", 'W', "Cannot add files to zip file.\nException: " + e.getMessage());
            return false;
        }
        return true;
    }

    private byte[] addWindowsLineBreaks(byte[] inBuf, int inBufLength) {
        byte[] outBuf = new byte[2048];
        int j = 0;
        this.bufLength = 0;
        int i = 0;
        while (i < inBufLength) {
            if (inBuf[i] == 10) {
                outBuf[j++] = 13;
                outBuf[j++] = 10;
                this.bufLength += 2;
            } else {
                outBuf[j++] = inBuf[i];
                ++this.bufLength;
            }
            ++i;
        }
        return outBuf;
    }

    private void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public String getLogFile() {
        File logFile = new File(String.valueOf(jtestRoot) + fileSep + "protocols" + fileSep + zipFileName);
        if (logFile.exists()) {
            return String.valueOf(jtestRoot) + fileSep + "protocols" + fileSep + zipFileName;
        }
        return null;
    }
}

