/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.ptest.PExec;
import com.sap.sdb.msgServer.util.ServerException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;

public class SyncManTest
extends TestCase {
    public static final String LSEP = System.getProperty("line.separator", "\r\n");
    public static final String SECURITY_PROVIDER_KEY = "security_provider";
    public static final String SECURITY_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String MSGSERVERKEY = "MSGSERVER";
    public static final String SYNC_SCHEMA = "SYNCHRONIZATIONSERVICE";
    public static final String MSGSERVER_SCHEMA = "MESSAGESERVICE";
    public static final String m_DBService_User = "DBSERVICE";
    public static final String m_DBService_Password = "SECRET";
    public static final String m_MsgSvr_TESTUSER = "";
    public static final String m_MsgSvr_TESTPW = "hallo";
    protected ThreadGroup m_Threads;
    protected Server m_MessageServer;
    protected int m_DeliveryMode;
    protected String m_sAdminPort;
    protected String m_sMsgPort;
    protected String m_sJndiPort;
    protected String m_sSyncMasterAdminPort;
    protected String m_sSyncClientAdminPort;
    protected String m_sSyncInitialAdminPort;

    public SyncManTest() throws Exception {
        String qalevel = mTestDriverOptions.getProperty("QALevel");
        long time = System.currentTimeMillis();
        long time2 = time / 1000L;
        int offSet = Math.max(5, (int)(time - (time2 *= 1000L)));
        int newPort = -1;
        if (qalevel.equalsIgnoreCase("D") || qalevel.equalsIgnoreCase("N")) {
            newPort = 7220 + offSet;
        } else if (qalevel.equalsIgnoreCase("C")) {
            newPort = 8220 + offSet;
        } else if (qalevel.equalsIgnoreCase("R")) {
            newPort = 9220 + offSet;
        } else if (qalevel.equalsIgnoreCase("H")) {
            newPort = 6220 + offSet;
        } else {
            throw new Exception("QA Level " + qalevel + " not supported");
        }
        this.m_sAdminPort = Integer.toString(newPort);
        this.m_sJndiPort = Integer.toString(newPort + 1);
        this.m_sMsgPort = Integer.toString(newPort + 2);
        this.m_sSyncMasterAdminPort = Integer.toString(newPort + 10);
        this.m_sSyncClientAdminPort = Integer.toString(newPort + 11);
        this.m_sSyncInitialAdminPort = Integer.toString(newPort + 12);
        SyncManTest.addGlobalMessage((String)"PExec", (char)'I', (String)("AdminPort:" + this.m_sAdminPort + ",JndiPort:" + this.m_sJndiPort + ",MsgPort:" + this.m_sMsgPort));
        TestDatabase master = SyncManTest.getDatabase();
        String cmd = "java -classpath " + System.getProperty("java.class.path") + " com.sap.sdb.syncMan.acc.SyncManACC" + " -A" + " " + MSGSERVERKEY + " -" + SECURITY_PROVIDER_KEY + " " + SECURITY_PROVIDER + " -d" + " " + master.getName() + " -n" + " localhost:" + master.getPort() + " -user" + " " + m_DBService_User + " -password" + " " + m_DBService_Password + " -msgserver_password" + " SECRET123" + " -msgserver_admin_port" + " " + this.m_sAdminPort + " -msgserver_port" + " " + this.m_sMsgPort + " -jndiserver_port" + " " + this.m_sJndiPort + " -c" + " set" + " -no_exit";
        SyncManTest.addGlobalMessage((String)"PExec", (char)'I', (String)cmd);
        PExec exec = new PExec(cmd, null, new PrintWriter(System.out));
        exec.exec();
        try {
            this.m_Threads = new ThreadGroup("MsgSvr_Test_Threads");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        Exception ex = new Exception("run shoud not be called");
        this.addMessage(String.valueOf(((Object)((Object)this)).toString()) + ".run", 'E', ex.toString());
        ex.printStackTrace();
    }

    private static void executeSQL(TestStatement aStatement, String cmd) throws SQLException {
        block2: {
            try {
                aStatement.executeUpdate(cmd);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4004) break block2;
                throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
            }
        }
    }

    public static void cleanMsgServerSchema() throws TestDatabaseException, SQLException {
        Connection aConnection = null;
        TestStatement aStatement = null;
        aConnection = SyncManTest.getDatabase().connect(m_DBService_User, m_DBService_Password);
        aStatement = new TestStatement(null, aConnection);
        aStatement.enableExceptions(true);
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_CONSUMER");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_DESTINATION");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_DEST_AUTH");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_MESSAGE");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_MSGPROPERTIES");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_SENDORDER");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_TABLES_VERSION");
        SyncManTest.executeSQL(aStatement, "delete MESSAGESERVICE.MSGSERVER_TRANSACTIONS");
        aStatement.close();
        aConnection.close();
        SyncManTest.addGlobalMessage((String)"cleanMsgServerSchema", (char)'I', (String)"Cleaned msg server schema.");
    }

    public void startMessageServer() throws Exception {
        try {
            Hashtable<String, String> commandline_options = new Hashtable<String, String>();
            commandline_options.put("A", MSGSERVERKEY);
            commandline_options.put(SECURITY_PROVIDER_KEY, SECURITY_PROVIDER);
            this.m_MessageServer = new Server(String.valueOf(this.getDataInputPath()) + "/../../syncman/MSGSERVER.xml", null, commandline_options);
            this.addMessage("startMessageServer", 'I', "Server started");
        }
        catch (ServerException ex) {
            this.addMessage("startMessageServer", 'E', SyncManTest.getStackTraceAsString((Exception)((Object)ex)));
        }
    }

    public void stopMessageServer() {
        if (this.m_MessageServer != null) {
            this.m_MessageServer.shutdown();
            this.addMessage("stopMessageServer", 'I', "Server stopped");
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0.Wait 120 sec for Message Server .........");
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0....................................");
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException ex) {
                this.addMessage("stopMessageServer", 'E', SyncManTest.getStackTraceAsString(ex));
            }
        }
    }

    protected void threadWait() {
        try {
            while (this.m_Threads.activeCount() > 0) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            this.addMessage(String.valueOf(((Object)((Object)this)).toString()) + ".run", 'E', ex.toString());
        }
    }

    public static String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }

    private int getMsgSendOrderCount() throws TestDatabaseException, SQLException {
        Connection aConnection = null;
        TestStatement aStatement = null;
        aConnection = SyncManTest.getDatabase().connect(m_DBService_User, m_DBService_Password);
        aStatement = new TestStatement((TestCase)this, aConnection);
        aStatement.executeQuery("select * from MESSAGESERVICE.MSGSERVER_SENDORDER");
        int count = aStatement.getResultCounter();
        if (count > 0) {
            this.addMessage("run", 'E', "MSGSERVER_SENDORDER has " + Integer.toString(count) + "rows left.");
        } else {
            this.addMessage("run", 'I', "MSGSERVER_SENDORDER OK!");
        }
        aStatement.close();
        aConnection.close();
        return count;
    }

    protected int shutDownMsgServerAndCheckSendOrders() throws InterruptedException, TestDatabaseException, SQLException {
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0.Wait 60 sec for before shutdown ...-");
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0....................................");
        Thread.sleep(60000L);
        this.stopMessageServer();
        return this.getMsgSendOrderCount();
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + SyncManTest.getTestClassId());
        try {
            SyncManTest.cleanMsgServerSchema();
        }
        catch (Exception e) {
            SyncManTest.addGlobalMessage((String)"Method CleanUp", (char)'E', (String)e.getMessage());
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public static String getTestClassId() {
        return "MessageServerTests";
    }

    public String getMsgServerPort() {
        return this.m_sMsgPort;
    }

    public String getJndiPort() {
        return this.m_sJndiPort;
    }
}

