/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.SyncManExample;

import com.sap.sapdb.SyncMan.SyncManTest;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sdb.msgServer.ptest.PExec;
import com.sap.sdb.syncMan.test.CompareTables;
import com.sap.sdb.syncMan.test.CreateExampleTables;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SyncManExamplePExec
extends SyncManTest {
    public static String getTestClassId() {
        return "SyncManExamplePExec-SyncManTests";
    }

    public static void prepare() throws TestCaseException {
    }

    public void run() {
        try {
            SyncManExamplePExec.cleanMsgServerSchema();
            SyncManExamplePExec.cleanSyncSchema();
            TestDatabase master = SyncManExamplePExec.getDatabase();
            String clientDBName = "X" + master.getName().substring(1);
            TestDriverConfiguration configOfClientDB = new TestDriverConfiguration();
            configOfClientDB.setConfiguration(mTestDriverOptions);
            configOfClientDB.setConfigValue("DBName", (Object)clientDBName);
            configOfClientDB.setConfigValue("DBKind", (Object)"OLTP");
            configOfClientDB.setConfigValue("DBForce", (Object)Boolean.TRUE);
            configOfClientDB.setConfigValue("DBKeep", (Object)Boolean.TRUE);
            configOfClientDB.setConfigValue("DBKeepState", (Object)"online");
            TestDatabaseSap client = this.additionalDatabase(configOfClientDB, 3);
            String newLine = "";
            String s = "";
            BufferedReader stdin = new BufferedReader(new FileReader(String.valueOf(this.getDataInputPath()) + "/../../syncman/DefineExampleSchema.txt"));
            PrintWriter stdout = new PrintWriter(new FileWriter(String.valueOf(this.getDataInputPath()) + "/../../syncman/DefEx" + client.getName() + ".txt"));
            int index = 0;
            while (true) {
                if ((s = stdin.readLine()) == null) break;
                index = s.trim().indexOf("@database@");
                newLine = index > 0 ? s.replaceAll("@database@", client.getName()) : s;
                index = newLine.trim().indexOf("localhost");
                if (index > 0) {
                    newLine = newLine.replaceAll("localhost", "localhost:" + client.getPort());
                }
                stdout.println(newLine);
            }
            stdin.close();
            stdin.close();
            if (stdout.checkError()) {
                this.addMessage(String.valueOf(((Object)((Object)this)).toString()) + ".run", 'E', "Error writing syncman cli input file");
                System.exit(1);
            }
            stdout.close();
            String[] argv = new String[]{"-masterURL", "jdbc:sapdb://localhost:" + master.getPort() + "/" + master.getName(), "-clientURL", "jdbc:sapdb://localhost:" + client.getPort() + "/" + client.getName()};
            CreateExampleTables.main((String[])argv);
            Connection aConnection = null;
            TestStatement aStatement = null;
            aConnection = SyncManExamplePExec.getDatabase().connect("USER_MASTER", "MASTER");
            aStatement = new TestStatement(null, aConnection);
            aStatement.enableExceptions(true);
            SyncManExamplePExec.executeSQL(aStatement, "delete USER_MASTER.CUSTOMER where cno = 3000");
            String cmd = "INSERT INTO USER_MASTER.CUSTOMER VALUES (8888, 'Mr', '\u00f6\u00e4\u00fc', 'Aha', '4321', 'Nobulu', 'C', 'Da',?)";
            String blobString = "1234567";
            byte[] blobBytes = blobString.getBytes();
            TestPreparedStatement stmtPrep = new TestPreparedStatement(null, aConnection, cmd);
            stmtPrep.setBytes(1, blobBytes);
            stmtPrep.execute();
            stmtPrep.close();
            SyncManExamplePExec.executeSQL(aStatement, "UPDATE USER_MASTER.RESERVATION SET ARRIVAL = '2004-11-14' WHERE RNO = 100");
            aStatement.close();
            aConnection.close();
            Thread.sleep(20000L);
            this.startMessageServer();
            Thread.sleep(20000L);
            cmd = "java -classpath " + System.getProperty("java.class.path") + " com.sap.sdb.syncMan.cli.SyncManCLI" + " -" + "security_provider" + " " + "org.bouncycastle.jce.provider.BouncyCastleProvider" + " -database_host" + " localhost:" + master.getPort() + " -database_name" + " " + master.getName() + " -user" + " DBSERVICE" + " -password" + " SECRET" + " -msgserver_host" + " localhost" + " -msgserver_password" + " SECRET123" + " -msgserver_admin_port" + " " + this.m_sAdminPort + " -msgserver_port" + " " + this.m_sMsgPort + " -jndiserver_port" + " " + this.m_sJndiPort + " -file" + " " + this.getDataInputPath() + "/../../syncman/DefEx" + client.getName() + ".txt";
            SyncManExamplePExec.addGlobalMessage((String)"PExec", (char)'I', (String)cmd);
            StringBuffer buf = new StringBuffer();
            PExec exec = new PExec(cmd, null, buf);
            exec.exec();
            System.out.println(buf.toString());
            System.out.println("-----> Finished SyncManCLI");
            SyncManExamplePExec.addGlobalMessage((String)"SyncManCLI", (char)'I', (String)"Finished SyncManCLI.");
            Thread.sleep(20000L);
            cmd = "java -classpath " + System.getProperty("java.class.path") + " com.sap.sdb.syncMan.SyncService" + " -database_url" + " jdbc:sapdb://localhost:" + master.getPort() + "/" + master.getName() + "?timeout=0" + " -" + "security_provider" + " " + "org.bouncycastle.jce.provider.BouncyCastleProvider" + " -user" + " DBSERVICE" + " -password" + " SECRET" + " -admin_port" + " " + this.m_sSyncInitialAdminPort + " -jndiserver_port" + " " + this.m_sJndiPort + " -msgserver_port" + " " + this.m_sMsgPort + " -initial" + " allunits" + " -verbose_exception_stacktrace";
            SyncManExamplePExec.addGlobalMessage((String)"PExec", (char)'I', (String)cmd);
            StringBuffer bufClient = new StringBuffer();
            exec = new PExec(cmd, null, bufClient);
            exec.exec();
            System.out.println("-----> Finished initial copy");
            SyncManExamplePExec.addGlobalMessage((String)"SyncService", (char)'I', (String)"Finished initial copy.");
            Thread.sleep(20000L);
            cmd = "java -classpath " + System.getProperty("java.class.path") + " com.sap.sdb.syncMan.SyncService" + " -database_url" + " jdbc:sapdb://localhost:" + client.getPort() + "/" + client.getName() + "?timeout=0" + " -user" + " DBSERVICE" + " -password" + " SECRET" + " -admin_port" + " " + this.m_sSyncClientAdminPort + " -jndiserver_port" + " " + this.m_sJndiPort + " -msgserver_port" + " " + this.m_sMsgPort + " -verbose_exception_stacktrace" + " -verbose_consumption_messages" + " -verbose_capture_messages" + " -exit_timeout" + " 360";
            SyncManExamplePExec.addGlobalMessage((String)"PExec", (char)'I', (String)cmd);
            StringBuffer bufMaster = new StringBuffer();
            exec = new PExec(cmd, null, bufMaster);
            exec.execNoWait();
            System.out.println("-----> Startet client");
            SyncManExamplePExec.addGlobalMessage((String)"SyncService", (char)'I', (String)"Startet client.");
            Thread.sleep(10000L);
            cmd = "java -classpath " + System.getProperty("java.class.path") + " com.sap.sdb.syncMan.SyncService" + " -database_url" + " jdbc:sapdb://localhost:" + master.getPort() + "/" + master.getName() + "?timeout=0" + " -" + "security_provider" + " " + "org.bouncycastle.jce.provider.BouncyCastleProvider" + " -user" + " DBSERVICE" + " -password" + " SECRET" + " -admin_port" + " " + this.m_sSyncMasterAdminPort + " -jndiserver_port" + " " + this.m_sJndiPort + " -msgserver_port" + " " + this.m_sMsgPort + " -verbose_exception_stacktrace" + " -verbose_consumption_messages" + " -verbose_capture_messages" + " -exit_timeout" + " 360";
            SyncManExamplePExec.addGlobalMessage((String)"PExec", (char)'I', (String)cmd);
            exec = new PExec(cmd, null, new PrintWriter(System.out));
            exec.execNoWait();
            System.out.println("-----> Startet master");
            SyncManExamplePExec.addGlobalMessage((String)"SyncService", (char)'I', (String)"Startet master.");
            Thread.sleep(10000L);
            aConnection = SyncManExamplePExec.getDatabase().connect("USER_MASTER", "MASTER");
            aStatement = new TestStatement(null, aConnection);
            aStatement.enableExceptions(true);
            SyncManExamplePExec.executeSQL(aStatement, "delete USER_MASTER.CUSTOMER where cno = 3000");
            cmd = "UPDATE USER_MASTER.CUSTOMER SET PORTRAIT = ?";
            String massBlobString = "a1c2e3g4";
            byte[] massBlobBytes = massBlobString.getBytes();
            stmtPrep = new TestPreparedStatement(null, aConnection, cmd);
            stmtPrep.enableExceptions(true);
            stmtPrep.setBytes(1, massBlobBytes);
            stmtPrep.executeUpdate();
            stmtPrep.close();
            cmd = "INSERT INTO USER_MASTER.CUSTOMER VALUES (9999, 'Mr', 'J\u00fcrgen', 'Aurisch', '1234', 'Berlin', 'B', 'Hier',?)";
            blobString = "abcdefgh";
            blobBytes = blobString.getBytes();
            stmtPrep = new TestPreparedStatement(null, aConnection, cmd);
            stmtPrep.setBytes(1, blobBytes);
            stmtPrep.execute();
            stmtPrep.close();
            SyncManExamplePExec.executeSQL(aStatement, "UPDATE USER_MASTER.RESERVATION SET ARRIVAL = '2004-11-14' WHERE RNO = 100");
            aStatement.executeQuery("select PORTRAIT from USER_MASTER.CUSTOMER where CNO != 9999");
            ResultSet result = aStatement.getResultSet();
            while (result.next()) {
                String tmp = new String(result.getBytes(1));
                if (tmp.equals(massBlobString)) continue;
                this.addMessage("run", 'E', "Blob Column PORTRAIT on master does not contain expected data <" + massBlobString + "> found <" + tmp + ">");
            }
            result.close();
            aStatement.close();
            aConnection.close();
            aConnection = client.connect("USER2_CLIENT", "CLIENT");
            aStatement = new TestStatement(null, aConnection);
            aStatement.enableExceptions(true);
            SyncManExamplePExec.executeSQL(aStatement, "UPDATE USER2_CLIENT.GUEST SET SURNAME = 'Black' WHERE GUEST = 3100");
            SyncManExamplePExec.executeSQL(aStatement, "delete USER2_CLIENT.BOOKING where id = 120");
            aStatement.close();
            aConnection.close();
            System.out.println("-----> Did some db action");
            SyncManExamplePExec.addGlobalMessage((String)"Application", (char)'I', (String)"Did some DB action.");
            System.out.println("-----> Wait 420 sec");
            SyncManExamplePExec.addGlobalMessage((String)"Application", (char)'I', (String)"Wait 360 sec.");
            Thread.sleep(420000L);
            this.stopMessageServer();
            System.out.println("------------ Buffer Client SyncMan ------------------------------------");
            System.out.println(bufClient.toString());
            System.out.println("------------ Buffer Master SyncMan ------------------------------------");
            System.out.println(bufMaster.toString());
            String[] argv7 = new String[]{"-f", String.valueOf(this.getDataInputPath()) + "/../../syncman/test_compare.xml", "-sourceURL", "jdbc:sapdb://localhost:" + master.getPort() + "/" + master.getName(), "-targetURL", "jdbc:sapdb://localhost:" + client.getPort() + "/" + client.getName()};
            CompareTables.mainWithException((String[])argv7);
            SyncManExamplePExec.addGlobalMessage((String)"CompareTables", (char)'I', (String)"Comparing tables is ok.");
        }
        catch (Exception ex) {
            this.addMessage("run", 'E', SyncManExamplePExec.getStackTraceAsString(ex));
        }
    }

    public static void cleanUp() throws TestCaseException {
        SyncManTest.cleanUp();
    }

    private static void executeSQL(TestStatement aStatement, String cmd) throws SQLException {
        block2: {
            try {
                aStatement.executeUpdate(cmd);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4004) break block2;
                throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
            }
        }
    }

    private static void cleanSyncSchema() throws TestDatabaseException, SQLException {
        Connection aConnection = null;
        TestStatement aStatement = null;
        aConnection = SyncManExamplePExec.getDatabase().connect("DBSERVICE", "SECRET");
        aStatement = new TestStatement(null, aConnection);
        aStatement.enableExceptions(true);
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_PARTICIPANT");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_PARTICIPANT_AUTH");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_PARTICIPANT_CONFIG");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_PARTICIPANT_TABLE");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_REP_TABLE");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_TABLE_COLUMN");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_TABLE_COLUMN_GROUP");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.RD_TABLE_VERSIONS");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_CLIENT_CONSTRAINT");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_DROPPED_TRIGGERS");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_IGNORE_LIST");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_TABLES");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_TABLE_COLUMNS");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_TABLE_VERSIONS");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_TRANSACTION_LIST");
        SyncManExamplePExec.executeSQL(aStatement, "delete SYNCHRONIZATIONSERVICE.REPLICATION_UNITS");
        aStatement.close();
        aConnection.close();
        SyncManExamplePExec.addGlobalMessage((String)"cleanMsgServerSchema", (char)'I', (String)"Cleaned msg server schema.");
    }
}

