/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService.DurableSub;

import com.sap.sapdb.SyncMan.MsgService.MsgTopicClient;
import com.sap.sapdb.SyncMan.SyncManTest;
import com.sap.sapdb.testframe.testcase.TestCase;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;

public class SubPubD_010
extends MsgTopicClient {
    private boolean m_AlreadyStop = false;
    private int m_MessagesReceivedOk = 0;
    private int m_MessagesReceivedUntilNow = 0;

    public SubPubD_010(TestCase aTestCase, ThreadGroup aThreadGroup, String topicName, String user, String password, String id, int deliveryMode) throws Exception {
        super(aTestCase, deliveryMode, topicName, user, password, "", true, 1, false, 1, false, aThreadGroup, "SubPubD_010" + id);
        this.m_Subscriber.setMessageListener((MessageListener)this);
        this.m_Connection.start();
    }

    protected void writeMessage() throws JMSException {
        MapMessage message = this.m_PubSession.createMapMessage();
        message.setJMSDeliveryMode(this.m_DeliveryMode);
        message.setString("StringValue", "Hello");
        this.m_Publisher.publish((Message)message);
        ++this.m_MessagesSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block6: {
            try {
                MapMessage mapMessage = (MapMessage)message;
                String text = mapMessage.getString("StringValue");
                ++this.m_MessagesReceived;
                if (text.equalsIgnoreCase("Hello")) {
                    ++this.m_MessagesReceivedOk;
                }
                if (this.m_MessagesReceived != this.m_NumberOfMessages * this.m_NumberOfPublishers) break block6;
                SubPubD_010 subPubD_010 = this;
                synchronized (subPubD_010) {
                    this.notify();
                }
            }
            catch (JMSException ex) {
                this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".onMessage", 'E', ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "Start writing Messages.");
            while (this.m_MessagesSend < this.m_NumberOfMessages) {
                this.writeMessage();
            }
            System.out.println("-----------------------------------------------------------------------------------------------------------");
            System.out.println(String.valueOf(this.toString()) + " --> " + this.m_MessagesSend + " Message(s) send ... DeliveryMode: " + this.m_DeliveryModeAsString);
            System.out.println("-----------------------------------------------------------------------------------------------------------");
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "Sent: " + Integer.toString(this.m_MessagesSend) + " Messages (map),stopped sending Messages. ... DeliveryMode: " + this.m_DeliveryModeAsString);
            SubPubD_010 subPubD_010 = this;
            synchronized (subPubD_010) {
                while (true) {
                    if (this.m_MessagesReceived >= this.m_NumberOfMessages * this.m_NumberOfPublishers / 8 && !this.m_AlreadyStop) {
                        this.closeSub();
                        System.out.println("-----------------------------------------------------------------------------------------------------------");
                        System.out.println("Block 1 " + this.toString() + " --> " + this.m_MessagesReceived + " Message(s) received ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        System.out.println("-----------------------------------------------------------------------------------------------------------");
                        this.m_MessagesReceivedUntilNow = this.m_MessagesReceived;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', String.valueOf(ex.toString()) + " ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        }
                        this.startSub();
                        this.m_AlreadyStop = true;
                    }
                    if (this.m_MessagesReceived >= this.m_NumberOfMessages * this.m_NumberOfPublishers / 3 * 2 && this.m_AlreadyStop) {
                        System.out.println("-----------------------------------------------------------------------------------------------------------");
                        System.out.println("Block 2 " + this.toString() + " --> " + this.m_MessagesReceived + " Message(s) received ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        System.out.println("-----------------------------------------------------------------------------------------------------------");
                        this.unSubscribeSub();
                        this.m_MessagesReceivedUntilNow = this.m_MessagesReceived;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', String.valueOf(ex.toString()) + " ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        }
                        this.startSub();
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', String.valueOf(ex.toString()) + " ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        }
                        if (this.m_MessagesReceivedUntilNow == this.m_MessagesReceived) {
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "No more messages suscribed ... DeliveryMode: " + this.m_DeliveryModeAsString);
                            break;
                        }
                        this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', "More messages suscribed ... DeliveryMode: " + this.m_DeliveryModeAsString);
                        break;
                    }
                    this.wait(100L);
                }
            }
            System.out.println("-----------------------------------------------------------------------------------------------------------");
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + this.m_MessagesReceived + " Message(s) received ... DeliveryMode: " + this.m_DeliveryModeAsString);
            System.out.println("-----------------------------------------------------------------------------------------------------------");
            char messageType = this.m_MessagesReceived > 0 && this.m_MessagesReceivedUntilNow > 0 && this.m_MessagesReceived >= this.m_MessagesReceivedUntilNow ? (char)'I' : 'E';
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", messageType, "Received until Subscriber.close(): " + Integer.toString(this.m_MessagesReceivedUntilNow) + SyncManTest.LSEP + "   Received until m_SubSession.unsubscribe(Subscriber): " + Integer.toString(this.m_MessagesReceived) + SyncManTest.LSEP + "   Messages (text) of " + Integer.toString(this.m_NumberOfMessages * this.m_NumberOfPublishers) + " ... DeliveryMode: " + this.m_DeliveryModeAsString);
            this.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
        }
    }
}

