/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.cli;

import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.ColumnGroup;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.InstalledRepTable;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.design.ReplicationTable;
import com.sap.sdb.syncMan.design.UnitTable;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.ColumnDesc;
import com.sap.sdb.syncMan.util.GenUID;
import com.sap.sdb.syncMan.util.SQLBuilder;
import com.sap.sdb.syncMan.util.SyncManTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyncManCLI {
    private static final String DB_HOST = "-database_host";
    private static final String DB_NAME = "-database_name";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String ACCESS_KEY = "-access_key";
    private static final String DB_ENCRYPTION = "-database_encryption";
    private static final String MSG_ENCRYPTION = "-msgserver_encryption";
    private static final String MSG_SERVER = "-msgserver_host";
    private static final String JNDI_SERVER = "-jndiserver_host";
    private static final String MSG_SERVER_PORT = "-msgserver_port";
    private static final String JNDI_SERVER_PORT = "-jndiserver_port";
    private static final String MSG_SERVER_ADMIN_PORT = "-msgserver_admin_port";
    private static final String MSG_SERVER_PASSWORD = "-msgserver_password";
    private static final String COMMAND = "-command";
    private static final String SECURITY_PROVIDER = "-security_provider";
    private static final String HELP1 = "-help";
    private static final String HELP2 = "-h";
    private static final String HELP3 = "-?";
    private static final String CMD_HELP1 = "help";
    private static final String CMD_HELP2 = "h";
    private static final String CMD_HELP3 = "?";
    private static final String CMD_QUIT1 = "quit";
    private static final String CMD_QUIT2 = "bye";
    private static final String CMD_QUIT3 = "exit";
    static String cmd_host = null;
    static String cmd_database = null;
    static String cmd_user = null;
    static String cmd_password = null;
    static String cmd_db_ssl = null;
    static String cmd_ms_password = null;
    static String cmd_msg_server = null;
    static String cmd_jndi_server = null;
    static String cmd_ms_admin_port = null;
    static String cmd_ms_msg_port = null;
    static String cmd_ms_jndi_port = null;
    static String cmd_ms_ssl = null;
    static String cmd_jdbcdriver = null;
    static String cmd_cmd = null;
    static String cmd_file = null;
    static String cmd_access_key = null;
    static String cmd_security_provider = null;
    private ConDataBase m_conMetaData = null;
    private ConMessageServer m_conMessageServer = null;
    private static String m_SyncSchema;

    public SyncManCLI() {
        Resources.createInstance();
        m_SyncSchema = "SYNCHRONIZATIONSERVICE";
        try {
            SQLBuilder.createInstance(null);
        }
        catch (Exception ex) {
            System.out.println(SyncManCLI.getStackTraceAsString(ex));
            System.exit(1);
        }
        this.m_conMetaData = new ConDataBase(cmd_security_provider, m_SyncSchema, true, true);
        if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
            this.m_conMetaData.setJDBCDriver(cmd_jdbcdriver);
        } else {
            this.m_conMetaData.setJDBCDriver("com.sap.dbtech.jdbc.DriverSapDB");
        }
        this.m_conMessageServer = new ConMessageServer();
    }

    public static void main(String[] args) {
        boolean no_exit = false;
        try {
            int i = 0;
            while (i < args.length) {
                String tmp;
                if (args[i].equals("-A") || args[i].equals(ACCESS_KEY)) {
                    cmd_access_key = args[i + 1];
                    i += 2;
                    AccParams param = new AccParams(cmd_access_key, cmd_security_provider);
                    param.loadParameters();
                    if (cmd_host != null && cmd_host.length() > 0) {
                        System.out.println("Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_host = param.getDBHost();
                    if (cmd_database != null && cmd_database.length() > 0) {
                        System.out.println("Database " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_database = param.getDBName();
                    if (cmd_user != null && cmd_user.length() > 1) {
                        System.out.println("User " + Resources.getString("CMDLine.Error"));
                        throw new Exception("User " + Resources.getString("CMDLine.Error"));
                    }
                    cmd_user = param.getDBUser();
                    if (cmd_password != null && cmd_password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_password = param.getDBPassword();
                    if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
                        System.out.println("JDBC Driver " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    if (cmd_msg_server != null && cmd_msg_server.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_msg_server = param.getMsgServer();
                    if (cmd_jndi_server != null && cmd_jndi_server.length() > 0) {
                        System.out.println("Jndi Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jndi_server = param.getJndiServer();
                    if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_admin_port = param.getMsgSvrAdminPort();
                    if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                        System.out.println("Jndi Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_jndi_port = param.getJndiPort();
                    if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                        System.out.println("Message Server Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_msg_port = param.getMsgPort();
                    if (cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        System.out.println("Message Server Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_password = param.getMsgAdminPassword();
                    if (cmd_ms_ssl != null && cmd_ms_ssl.length() > 0) {
                        System.out.println("Message Server Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_ssl = param.getMsg_SSL();
                    continue;
                }
                if (args[i].equals("-n") || args[i].equals(DB_HOST)) {
                    if (cmd_host != null && cmd_host.length() > 0) {
                        System.out.println("Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_host = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals(DB_NAME)) {
                    if (cmd_database != null && cmd_database.length() > 0) {
                        System.out.println("Database " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_database = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-u")) {
                    StringTokenizer st = new StringTokenizer(args[i + 1], ",");
                    if (st.hasMoreTokens()) {
                        if (cmd_user != null && cmd_user.length() > 1) {
                            System.out.println("User " + Resources.getString("CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_user = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        if (cmd_password != null && cmd_password.length() > 0) {
                            System.out.println("Password " + Resources.getString("CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_password = st.nextToken();
                        i += 2;
                        continue;
                    }
                    if (cmd_password == null || cmd_password.length() < 1) {
                        cmd_password = PasswordPrompt.getPassword("Database Password:\n");
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals(USER)) {
                    if (cmd_user != null && cmd_user.length() > 1) {
                        System.out.println("User " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_user = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(PASSWORD)) {
                    if (cmd_password != null && cmd_password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cmd_password == null || cmd_password.length() < 1) {
                        ++i;
                        cmd_password = PasswordPrompt.getPassword("Database Password:\n");
                        continue;
                    }
                    i += 2;
                    continue;
                }
                if (args[i].equals(DB_ENCRYPTION)) {
                    if (cmd_db_ssl != null && cmd_db_ssl.length() > 0) {
                        System.out.println("Database Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_db_ssl = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER)) {
                    if (cmd_msg_server != null && cmd_msg_server.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_msg_server = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER)) {
                    if (cmd_jndi_server != null && cmd_jndi_server.length() > 0) {
                        System.out.println("Jndi Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jndi_server = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PORT)) {
                    if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                        System.out.println("Message Server Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_msg_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER_PORT)) {
                    if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                        System.out.println("Jndi Server Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_jndi_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_ADMIN_PORT)) {
                    if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_admin_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_ENCRYPTION)) {
                    if (cmd_ms_ssl != null && cmd_ms_ssl.length() > 0) {
                        System.out.println("Message Server Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_ssl = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(SECURITY_PROVIDER)) {
                    cmd_security_provider = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PASSWORD)) {
                    if (cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        System.out.println("Message Server Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_ms_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (cmd_ms_password == null || cmd_ms_password.length() < 1) {
                        ++i;
                        cmd_ms_password = PasswordPrompt.getPassword("Message Server Password:\n");
                        continue;
                    }
                    i += 2;
                    continue;
                }
                if (args[i].equals("-j") || args[i].equals("-driver")) {
                    if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
                        System.out.println("JDBC Driver " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jdbcdriver = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(HELP1) || args[i].equals(HELP2) || args[i].equals(HELP3)) {
                    SyncManCLI.displayCmdHelp();
                    return;
                }
                if (args[i].equals(COMMAND) || args[i].equals("-c")) {
                    if (cmd_cmd != null && cmd_cmd.length() > 0) {
                        System.out.println("Command " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_cmd = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-file") || args[i].equals("-f")) {
                    if (cmd_file != null && cmd_file.length() > 0) {
                        System.out.println("Command " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_file = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-no_exit")) {
                    no_exit = true;
                    ++i;
                    continue;
                }
                System.out.println("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                SyncManCLI.displayCmdHelp();
                return;
            }
        }
        catch (Exception ex) {
            System.out.println("An exception occurred while parsing the commandline: " + SyncManCLI.getStackTraceAsString(ex));
        }
        SyncManCLI.doWork(no_exit);
        SQLBuilder.destroyInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void doWork(boolean noExit) {
        int retCode;
        block23: {
            retCode = 0;
            SyncManCLI cli = new SyncManCLI();
            if (cmd_database != null && cmd_database.length() > 0 && cmd_user != null && cmd_user.length() > 0 && cmd_password != null && cmd_password.length() > 0) {
                boolean db_ssl = cmd_db_ssl != null && cmd_db_ssl.equalsIgnoreCase("ssl");
                cli.getConMetaData().connect(cmd_host, cmd_database, cmd_user, cmd_password, db_ssl);
                if (cli.getConMetaData().isConnected()) {
                    if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0 && cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        boolean msssl = cmd_ms_ssl != null && cmd_ms_ssl.equalsIgnoreCase("ssl");
                        int msgPort = -1;
                        if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                            msgPort = Integer.parseInt(cmd_ms_msg_port);
                        }
                        int jndiPort = -1;
                        if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                            jndiPort = Integer.parseInt(cmd_ms_jndi_port);
                        }
                        cli.getConMessageServer().connect(cmd_msg_server, msgPort, cmd_jndi_server, jndiPort, cmd_ms_admin_port != null ? Integer.parseInt(cmd_ms_admin_port) : -1, cmd_ms_password, msssl);
                    }
                    if (cmd_cmd != null) {
                        SyncManCLI.processCMD(cli, cmd_cmd);
                    } else {
                        SyncManCLI.readCMDInput(cli);
                    }
                }
            } else {
                throw new Exception("Insufficient logon parameters.");
            }
            Object var8_8 = null;
            try {
                if (cli.getConMetaData().isConnected()) {
                    cli.getConMetaData().disconnect();
                }
                if (cli.getConMessageServer().isConnected()) {
                    cli.getConMessageServer().disconnect();
                }
                break block23;
            }
            catch (Exception ex2) {}
            break block23;
            {
                catch (Exception ex) {
                    System.out.println("An exception occurred: " + SyncManCLI.getStackTraceAsString(ex));
                    retCode = 1;
                    Object var8_9 = null;
                    try {
                        if (cli.getConMetaData().isConnected()) {
                            cli.getConMetaData().disconnect();
                        }
                        if (cli.getConMessageServer().isConnected()) {
                            cli.getConMessageServer().disconnect();
                        }
                        break block23;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (cli.getConMetaData().isConnected()) {
                        cli.getConMetaData().disconnect();
                    }
                    if (cli.getConMessageServer().isConnected()) {
                        cli.getConMessageServer().disconnect();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!noExit) {
            System.exit(retCode);
        }
    }

    private static void readCMDInput(SyncManCLI cli) {
        try {
            boolean end = false;
            String s = "";
            BufferedReader stdin = null;
            stdin = cmd_file != null ? new BufferedReader(new FileReader(cmd_file)) : new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                if (cmd_file == null) {
                    System.out.print(">");
                    System.out.flush();
                }
                if ((s = stdin.readLine()) == null && cmd_file != null) {
                    stdin.close();
                    return;
                }
                if (s == null) continue;
                if (s.trim().equalsIgnoreCase(CMD_QUIT1) || s.trim().equalsIgnoreCase(CMD_QUIT2) || s.trim().equalsIgnoreCase(CMD_QUIT3)) {
                    stdin.close();
                    end = true;
                    continue;
                }
                if (s.trim().length() <= 0) continue;
                SyncManCLI.processCMD(cli, s);
            }
        }
        catch (IOException ex) {
            System.out.println("An exception occurred while reading the command input: " + SyncManCLI.getStackTraceAsString(ex));
        }
    }

    private static void displayCmdHelp() {
        System.out.println("-database_host  | -n        // host");
        System.out.println("-database_name  | -d        // database");
        System.out.println("-user                       // user");
        System.out.println("-password                   // password");
        System.out.println("-database_encryption ssl    // use a ssl socket");
        System.out.println("-msgserver_host             // message server");
        System.out.println("-msgserver_port             // message server port");
        System.out.println("-jndiserver_host            // jndi server");
        System.out.println("-jndiserver_port            // jndi server port");
        System.out.println("-msgserver_admin_port       // message server admin port");
        System.out.println("-msgserver_password         // message server password");
        System.out.println("-msgserver_encryption ssl   // use ssl sockets");
        System.out.println("-security_provider          //class name of a security provider.");
        System.out.println("-help                       // help");
        System.out.println("-h                          // help");
        System.out.println("-?                          // help");
        System.exit(0);
    }

    private static void displayCmds() {
        System.out.println("help                                                                                                help");
        System.out.println("h                                                                                                   help");
        System.out.println("?                                                                                                   help");
        System.out.println("quit                                                                                                quit");
        System.out.println("bye                                                                                                 quit");
        System.out.println("exit                                                                                                quit");
        System.out.println("add       replication table  <schema> <table>                                                       add a table for replication");
        System.out.println("remove    replication table  <schema> <table>                                                       remove a table from replication");
        System.out.println("add       column group <column_group_name> for <schema> <table>                                     add a column group to a replication table");
        System.out.println("remove    column group <column_group_name> for <schema> <table>                                     remove a column group from a replication table");
        System.out.println("list      column groups for <schema> <table>                                                        list all column groups for a replication table");
        System.out.println("add       column <column_name> to <column_group_name> for <schema> <table>                          add a column to a column group of a replication table");
        System.out.println("remove    column <column_name> from <column_group_name> for <schema> <table>                        remove a column to a column group of a replication table");
        System.out.println("version   column group <column_group_name> for <schema> <table>                                     make the column group versioned");
        System.out.println("unversion column group <column_group_name> for <schema> <table                                      make the column group unversioned");
        System.out.println("list      columns     of    <column_group_name> for <schema> <table>>                               list all columns of a column group");
        System.out.println("add       master      unit  <unit name>  <inout|in|out>                                             add a master unit");
        System.out.println("remove    master      unit  <unit name>                                                             remove a master unit");
        System.out.println("add       client      unit  <unit name>  <inout|in|out> <server> <database> <user> <password> for <unit name>  add a a client unit");
        System.out.println("remove    client      unit  <unit name> from master unit <unit name>                                remove a a client unit");
        System.out.println("add       unit table  <schema> <table>  to   master unit <unit name>                                add a unit table");
        System.out.println("remove    unit table  <schema> <table>  from master unit <unit name>                                remove a unit table");
        System.out.println("");
        System.out.println("exclude   column group <column_group_name> from <unit name> for <schema> <table>                    exclude a column group from a unit table");
        System.out.println("include   column group <column_group_name> to <unit name> for <schema> <table>                      include a column group from a unit table");
        System.out.println("");
        System.out.println("set       master unit name <unit name> to <new unit name>                                              change name of master unit");
        System.out.println("set       client unit name <unit name> of master unit <unit name> to <new unit name>                   change name of client unit");
        System.out.println("set       client unit type of unit <unit name> of master unit <unit name> to <new unit type>           change the type of a client unit");
        System.out.println("set       client unit host of unit <unit name> of master unit <unit name> to <new unit host>           change the host of a client unit");
        System.out.println("set       client unit database of unit <unit name> of master unit <unit name> to <new unit database>   change the databse of a client unit");
        System.out.println("set       client unit user of unit <unit name> of master unit <unit name> to <new unit user>           change the user of a client unit");
        System.out.println("set       client unit password of unit <unit name> of master unit <unit name> to <new unit password>   change the password of a client unit");
        System.out.println("");
        System.out.println("set       column name       <new column name> for <schema> <table> <column> in <unit name> of <master unit>     change the column name of a client unit table");
        System.out.println("set       table  name       <new table  name> for <schema> <table> in <unit name> of <master unit>              change the table name of a client unit table");
        System.out.println("set       table  schema     <new schema name> for <schema> <table> in <unit name> of <master unit>              change the schema name of a client unit table");
        System.out.println("set       column constraint <none|=|<|<=|>|>=|in|not in|between> for <schema> <table> <column name> in <unit name> of <master unit>  <value1> [<value2>]>   set the constraint value for a client column");
        System.out.println("");
        System.out.println("set       syncservice jdbcdriver <jdbc driver name>          for <server> <database>                       set the jdbc driver for a synchronization service");
        System.out.println("set       syncservice param      <param name> <param value>  for <server> <database>                       set a parameter for a synchronization service");
        System.out.println(" ");
        System.out.println("activate  master      unit  <unit name>                                                          activate a master unit");
        System.out.println("dectivate master      unit  <unit name>                                                          deactivate a master unit");
        System.out.println("activate  client       unit  <unit name> of master unit <unit name>                              activate a client unit");
        System.out.println("dectivate client       unit  <unit name> of master unit <unit name>                              deactivate a client unit");
        System.out.println("activate  all units                                                                              activate all units");
        System.out.println("dectivate all units                                                                              deactivate all units");
        System.out.println("");
        System.out.println("");
        System.out.println("update message server                                                                            update the destination on the message server");
        System.out.println("");
        System.out.println("bye,quit,exit                                                                                    quit SyncManCLI");
        System.out.println("help,?,h                                                                                         display help");
        System.out.println("");
        System.out.println("- debug cmds --------------------------------------------------------------------------------");
        System.out.println("lifecycle for <schema> <table> <key> <key value>");
    }

    public ConMessageServer getConMessageServer() {
        return this.m_conMessageServer;
    }

    public ConDataBase getConMetaData() {
        return this.m_conMetaData;
    }

    private static void processCMD(SyncManCLI cli, String completeCMD) {
        SyncManTokenizer st = new SyncManTokenizer(completeCMD.toCharArray());
        try {
            String cmd = st.nextWordToken();
            if (cmd == null) {
                throw new Exception("No valid command :" + completeCMD);
            }
            if (!(cmd.equalsIgnoreCase(CMD_QUIT1) || cmd.equalsIgnoreCase(CMD_QUIT2) || cmd.equalsIgnoreCase(CMD_QUIT3))) {
                if (cmd.equalsIgnoreCase(CMD_HELP1) || cmd.equalsIgnoreCase(CMD_HELP2) || cmd.equalsIgnoreCase(CMD_HELP3)) {
                    SyncManCLI.displayCmds();
                } else if (cmd.equalsIgnoreCase("add")) {
                    SyncManCLI.processAddCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("remove")) {
                    SyncManCLI.processRemoveCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("version")) {
                    SyncManCLI.processVersionCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("unversion")) {
                    SyncManCLI.processUnversionCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("set")) {
                    SyncManCLI.processSetCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("activate")) {
                    SyncManCLI.processActivateCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("deactivate")) {
                    SyncManCLI.processDeactivateCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("update")) {
                    SyncManCLI.processUpdateCMD(cli.getConMetaData(), cli.getConMessageServer(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("exclude")) {
                    SyncManCLI.processExcludeCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("include")) {
                    SyncManCLI.processIncludeCMD(cli.getConMetaData(), completeCMD, st);
                } else if (cmd.equalsIgnoreCase("lifecycle")) {
                    SyncManCLI.processLifeCycle(cli.getConMetaData(), completeCMD, st);
                } else {
                    throw new Exception("'" + completeCMD + "'" + " not yet supported.");
                }
            }
            SyncManCLI.commitConnection(cli.getConMetaData());
            System.out.println("OK");
            if (cmd_file != null) {
                System.out.println("'" + completeCMD + "'");
            }
            System.out.println("---");
        }
        catch (NoSuchElementException ex) {
            System.out.println("ERR");
            System.out.println("'" + completeCMD + "'" + " incomplete.");
            System.out.println("---");
        }
        catch (Exception ex) {
            System.out.println("ERR");
            System.out.println("'" + completeCMD + "'");
            System.out.println(ex);
            System.out.println("---");
            SyncManCLI.rollBackConnection(cli.getConMetaData());
        }
    }

    private static void processActivateCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("all")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("units")) {
                throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            }
        } else {
            throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        }
        SyncManCLI.internalActivateAllParticipants(dbCon, true);
    }

    private static void processDeactivateCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("all")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("units")) {
                throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            }
        } else {
            throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        }
        SyncManCLI.internalActivateAllParticipants(dbCon, false);
    }

    private static void processUpdateCMD(ConDataBase dbCon, ConMessageServer msCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("message")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("server")) {
                throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            }
        } else {
            throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        }
        SyncManCLI.updateMsgServerDestinations(dbCon, msCon);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processSetCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("table")) {
            cmd = st.nextWordToken();
            if (cmd.equalsIgnoreCase("schema")) {
                String newSchema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("for")) return;
                String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("in")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String clientUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("of")) return;
                String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                UnitTable unitTable = SyncManCLI.getUnitTable(dbCon, masterUnitName, clientUnitName, schema, table);
                unitTable.setSchema(newSchema);
                DesignSQLLayer.alterUnitTable(dbCon, unitTable);
                return;
            } else {
                if (!cmd.equalsIgnoreCase("name")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String newTable = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("for")) return;
                String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("in")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String clientUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("of")) return;
                String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                UnitTable unitTable = SyncManCLI.getUnitTable(dbCon, masterUnitName, clientUnitName, schema, table);
                unitTable.setName(newTable);
                DesignSQLLayer.alterUnitTable(dbCon, unitTable);
            }
            return;
        } else if (cmd.equalsIgnoreCase("column")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("name") && !cmd.equalsIgnoreCase("constraint")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String colAtr = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            boolean colNameChange = cmd.equalsIgnoreCase("name");
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("for")) return;
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String column = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("in")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String clientUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("of")) return;
            String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String value1 = null;
            String value2 = null;
            if (!colNameChange) {
                value1 = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                if (cmd.equalsIgnoreCase("between")) {
                    value2 = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                }
            }
            UnitTable unitTable = SyncManCLI.getUnitTable(dbCon, masterUnitName, clientUnitName, schema, table);
            unitTable.loadColumns(dbCon);
            Column col = null;
            for (int i = 0; i < unitTable.getColumns().size() && !(col = (Column)unitTable.getColumns().get(i)).columnName().equals(column); ++i) {
                col = null;
            }
            if (col == null) {
                throw new Exception("Unit column " + column + " not available for " + schema + "." + table);
            }
            if (colNameChange) {
                col.setColumnName(colAtr);
            } else {
                int constrType = 0;
                for (constrType = 0; constrType < ColumnDesc.constraints.length && !colAtr.equalsIgnoreCase(ColumnDesc.constraints[constrType]); ++constrType) {
                }
                col.setConstraintType(constrType);
                col.setConstraintValue1(value1);
                if (value2 != null) {
                    col.setConstraintValue1(value2);
                }
            }
            DesignSQLLayer.alterColumn(dbCon, unitTable.getParticipantID(), unitTable.getTableID(), col);
            return;
        } else {
            String database;
            if (!cmd.equalsIgnoreCase("syncservice")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("jdbcdriver")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String jdbcdriver = st.nextWordToken();
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String server = st.nextWordToken();
            ParticipantConfig config = DesignSQLLayer.selectParticipantConfig(dbCon, server, database = st.nextWordToken());
            if (config == null) {
                throw new Exception("No valid participant config for " + server + " " + database);
            }
            config.setJDBCDriver(jdbcdriver);
            DesignSQLLayer.alterParticipantConfig(dbCon, config);
        }
    }

    private static UnitTable getUnitTable(ConDataBase dbCon, String masterUnitName, String clientUnitName, String schema, String table) throws Exception {
        Participant masterParticipant = DesignSQLLayer.selectMasterParticipantByName(dbCon, masterUnitName);
        if (masterParticipant == null) {
            throw new Exception("Master participant " + masterUnitName + " not available");
        }
        Participant clientParticipant = DesignSQLLayer.selectClientParticipantByName(dbCon, clientUnitName, masterParticipant.getDesignID());
        if (clientParticipant == null) {
            throw new Exception("Client participant " + clientUnitName + " not available");
        }
        UnitTable unitTable = DesignSQLLayer.selectUnitTable(dbCon, clientParticipant.getDesignID(), clientParticipant.getParticipantID(), schema, table);
        if (unitTable == null) {
            throw new Exception("Unit table " + schema + "." + table + " not available");
        }
        return unitTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processAddCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        int typeCmd = -1;
        int typeCmdNext = -1;
        String cmd = st.nextWordToken();
        typeCmd = st.ttype;
        if (cmd.equalsIgnoreCase("replication")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("table")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            DesignSQLLayer.insertRepTable(dbCon, schema, table);
            return;
        } else if (cmd.equalsIgnoreCase("column")) {
            cmd = st.nextWordToken();
            typeCmd = st.ttype;
            String cmdNext = st.nextWordToken();
            typeCmdNext = st.ttype;
            if (cmd.equalsIgnoreCase("group")) {
                String colGroupName = SyncManCLI.buildQualifier(cmdNext, typeCmdNext);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
                SyncManCLI.checkTableUsageCount(dbCon, repTable);
                long columnGroupID = GenUID.getNext();
                ColumnGroup cg = new ColumnGroup(colGroupName, columnGroupID);
                cg.setForReplication(true);
                repTable.addColumnGroup(cg);
                DesignSQLLayer.alterRepTable(dbCon, repTable);
                return;
            } else {
                if (!cmdNext.equalsIgnoreCase("to")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String colName = SyncManCLI.buildQualifier(cmd, typeCmd);
                String colGroupName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                cmd = st.nextWordToken();
                if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
                String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
                ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
                SyncManCLI.checkTableUsageCount(dbCon, repTable);
                ColumnGroup cg = repTable.singleColumnGroup();
                if (cg == null) {
                    throw new Exception("Single ColumnGroup not available");
                }
                ColumnGroup target = repTable.getColumnGroupByName(colGroupName);
                if (target == null) {
                    throw new Exception("ColumnGroup " + colGroupName + " not available");
                }
                if (cg == null) return;
                Column col = cg.getColumnByName(colName);
                if (col == null) {
                    throw new Exception("Column '" + colName + "'" + " not available");
                }
                repTable.assignColumnToColumnGroup(target, col);
                DesignSQLLayer.alterRepTable(dbCon, repTable);
            }
            return;
        } else if (cmd.equalsIgnoreCase("master")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("unit")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String unitname = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String type = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            int unitType = -1;
            if (type.equalsIgnoreCase("out")) {
                unitType = 0;
            } else if (type.equalsIgnoreCase("in")) {
                unitType = 1;
            } else {
                if (!type.equalsIgnoreCase("inout")) throw new Exception("'" + completeCMD + "'" + " invalid unittype.");
                unitType = 2;
            }
            long unitID = GenUID.getNext();
            Participant participant = new Participant(unitID, unitID, unitname, unitType, dbCon.getHost(), dbCon.getDataBase(), "\"" + dbCon.getUser() + "\"", "", true, false);
            DesignSQLLayer.insertParticipant(dbCon, participant, !participant.isMaster());
            return;
        } else if (cmd.equalsIgnoreCase("client")) {
            Participant participant;
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("unit")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String unitname = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String type = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            int unitType = -1;
            if (type.equalsIgnoreCase("out")) {
                unitType = 0;
            } else if (type.equalsIgnoreCase("in")) {
                unitType = 1;
            } else {
                if (!type.equalsIgnoreCase("inout")) throw new Exception("'" + completeCMD + "'" + " invalid unittype.");
                unitType = 2;
            }
            String server = st.nextWordToken();
            String database = st.nextWordToken();
            String user = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String password = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            Participant masterParticipant = DesignSQLLayer.selectMasterParticipantByName(dbCon, masterUnitName);
            if (masterParticipant == null) {
                throw new Exception("Master participant " + masterUnitName + " not available");
            }
            long unitID = GenUID.getNext();
            DesignSQLLayer.insertParticipant(dbCon, participant, !(participant = new Participant(masterParticipant.getDesignID(), unitID, unitname, unitType, server, database, "\"" + user + "\"", "\"" + password + "\"", false, false)).isMaster());
            return;
        } else {
            if (!cmd.equalsIgnoreCase("unit")) throw new Exception("'" + completeCMD + "'" + " not yet supported.");
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("table")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            Participant masterParticipant = DesignSQLLayer.selectMasterParticipantByName(dbCon, masterUnitName);
            if (masterParticipant == null) {
                throw new Exception("Master participant " + masterUnitName + " not available");
            }
            ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
            DesignSQLLayer.tableForReplication(dbCon, masterParticipant.getDesignID(), repTable);
        }
    }

    private static void checkTableUsageCount(ConDataBase dbCon, ReplicationTable repTable) throws Exception {
        long count = DesignSQLLayer.selectTableUsageCount(dbCon, repTable.getTableID());
        if (count > 0L) {
            throw new Exception(Resources.getString("ReplicationTable.Changes_not_possible.Base_Table") + repTable.getName() + Resources.getString("ReplicationTable.is_used_by") + String.valueOf(count) + Resources.getString("ReplicationTable.Replication_Participants"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processVersionCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("column")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("group")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        String colGroupName = st.nextWordToken();
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("for")) return;
        String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
        SyncManCLI.checkTableUsageCount(dbCon, repTable);
        ColumnGroup cg = repTable.getColumnGroupByName(colGroupName);
        cg.setVersioned(true);
        DesignSQLLayer.alterRepTable(dbCon, repTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processUnversionCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("column")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("group")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        String colGroupName = st.nextWordToken();
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("for")) return;
        String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
        ColumnGroup cg = repTable.getColumnGroupByName(colGroupName);
        cg.setVersioned(false);
        DesignSQLLayer.alterRepTable(dbCon, repTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processRemoveCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("replication")) {
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("table")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
            SyncManCLI.checkTableUsageCount(dbCon, repTable);
            DesignSQLLayer.deleteRepTable(dbCon, repTable.getTableID());
            return;
        } else {
            if (!cmd.equalsIgnoreCase("column")) throw new Exception("'" + completeCMD + "'" + " not yet supported.");
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("group")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String colGroupName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            cmd = st.nextWordToken();
            if (!cmd.equalsIgnoreCase("for")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            ReplicationTable repTable = SyncManCLI.getRepTable(dbCon, schema, table);
            SyncManCLI.checkTableUsageCount(dbCon, repTable);
            ColumnGroup cg = repTable.getColumnGroupByName(colGroupName);
            if (cg == null) {
                throw new Exception("ColumnGroup " + colGroupName + " not available");
            }
            repTable.removeColumnGroup(cg);
            DesignSQLLayer.alterRepTable(dbCon, repTable);
        }
    }

    public static void commitConnection(ConDataBase dbCon) {
        try {
            dbCon.getConnection().commit();
        }
        catch (SQLException ex) {
            System.out.println(ex);
        }
    }

    public static void rollBackConnection(ConDataBase dbCon) {
        if (dbCon == null) {
            return;
        }
        try {
            dbCon.getConnection().rollback();
        }
        catch (SQLException ex) {
            System.out.println(ex);
        }
    }

    private static String buildQualifier(String name, int tokenType) {
        if (tokenType == -5) {
            return name.toUpperCase();
        }
        return name;
    }

    private static ReplicationTable getRepTable(ConDataBase dbCon, String schema, String table) throws Exception {
        ReplicationTable repTable = DesignSQLLayer.selectRepTable(dbCon, dbCon.getHost(), dbCon.getDataBase(), schema, table);
        if (repTable == null) {
            throw new Exception(schema + "." + table + " not available");
        }
        repTable.loadColumnGroups(dbCon);
        return repTable;
    }

    private static void internalActivateAllParticipants(ConDataBase dbCon, boolean activate) throws Exception {
        ConDataBase dbTarget = new ConDataBase(cmd_security_provider, m_SyncSchema, false, true);
        Vector masterParticipantNodes = DesignSQLLayer.selectParticipants(dbCon, -1L, true, false);
        for (int j = 0; j < masterParticipantNodes.size(); ++j) {
            Participant masterParticipantNode = (Participant)masterParticipantNodes.get(j);
            Vector clientParticpantsToWork = DesignSQLLayer.selectParticipants(dbCon, masterParticipantNode.getDesignID(), true, true);
            for (int i = 0; i < clientParticpantsToWork.size(); ++i) {
                Participant part = (Participant)clientParticpantsToWork.get(i);
                SyncManCLI.internalActivateParticipant(dbCon, dbTarget, part, activate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void internalActivateParticipant(ConDataBase dbSource, ConDataBase dbTarget, Participant part, boolean activate) {
        block30: {
            block28: {
                try {
                    try {
                        config = null;
                        config = part.getConfig();
                        if (config == null) {
                            config = DesignSQLLayer.selectParticipantConfig(dbSource, part.getHost(), part.getDataBase());
                            if (config == null) {
                                throw new Exception("No valid participant config for " + part.getParticipantName());
                            }
                            part.setConfig(config);
                        }
                        if (!part.isMaster()) {
                            dbTarget.setJDBCDriver(part.getConfig().jdbcDriver());
                            dbTarget.connect(part.getHost(), part.getDataBase(), part.getUser(), part.getPassWord(), part.getConfig().getUseSSL());
                        } else {
                            dbTarget = dbSource;
                        }
                        if (!dbTarget.isConnected()) {
                            var7_6 = null;
                            break block28;
                        }
                        if (!dbTarget.isMaxDB() && !dbTarget.isMinDB() && part.getParticipantType() != 1) {
                            throw new Exception(Resources.getString("Units.Unit_Type_Not_Allowed_For_Database"));
                        }
                        if (!activate) {
                            block29: {
                                try {
                                    DesignSQLLayer.unInstallReplicationUnit(dbSource, dbTarget, part, true);
                                }
                                catch (SQLException ex) {
                                    if (dbTarget.isMinDB()) break block29;
                                    throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
                                }
                            }
                            System.out.println(Resources.getString("Units.Unit") + part.getParticipantName() + Resources.getString("Units.On") + dbTarget.getUrl() + Resources.getString("Units.Deactivated"));
                        } else {
                            DesignSQLLayer.installReplicationUnit(dbSource, dbTarget, part);
                            System.out.println(Resources.getString("Units.Unit") + part.getParticipantName() + " (" + part.getParticipantID() + ") on " + dbTarget.getUrl() + Resources.getString("Units.Activated"));
                            if (part.getConfig() == null) {
                                throw new Exception(Resources.getString("Units.No_Valid_Participant"));
                            }
                        }
                        part.setIsInstalled(activate);
                        DesignSQLLayer.alterInstalledFlagForParticipant(dbSource, part);
                        if (!part.isMaster()) {
                            dbTarget.getConnection().commit();
                        }
                        dbSource.getConnection().commit();
                        break block30;
                    }
                    catch (Exception ex) {
                        System.out.println("An exception occurred while (de)activating a participant: " + SyncManCLI.getStackTraceAsString(ex));
                        if (dbSource.isConnected()) {
                            try {
                                dbSource.getConnection().rollback();
                            }
                            catch (SQLException e1) {
                                // empty catch block
                            }
                        }
                        if (!part.isMaster() && dbTarget.isConnected()) {
                            try {
                                dbTarget.getConnection().rollback();
                            }
                            catch (SQLException e2) {
                            }
                        }
                        var7_8 = null;
                        try {
                            if (part.isMaster() != false) return;
                            dbTarget.disconnect();
                            return;
                        }
                        catch (SQLException ex) {
                            return;
                        }
                    }
                }
                catch (Throwable var6_17) {
                    var7_9 = null;
                    ** try [egrp 5[TRYBLOCK] [9 : 506->520)] { 
lbl67:
                    // 1 sources

                    if (part.isMaster() != false) throw var6_17;
                    dbTarget.disconnect();
                    throw var6_17;
lbl70:
                    // 1 sources

                    catch (SQLException ex) {
                        // empty catch block
                    }
                    throw var6_17;
                }
            }
            ** try [egrp 5[TRYBLOCK] [9 : 506->520)] { 
lbl75:
            // 1 sources

            if (part.isMaster() != false) return;
            dbTarget.disconnect();
            return;
lbl78:
            // 1 sources

            catch (SQLException ex) {
                // empty catch block
            }
            return;
        }
        var7_7 = null;
        try {}
        catch (SQLException ex) {}
        if (part.isMaster() != false) return;
        dbTarget.disconnect();
        return;
    }

    private static void updateMsgServerDestinations(ConDataBase dbCon, ConMessageServer msCon) throws Exception {
        if (!msCon.isConnected()) {
            throw new Exception(Resources.getString("MsgServer.Error.Destination") + ":" + Resources.getString("Message_Server_No_Connection"));
        }
        DesignSQLLayer.createDestinations(dbCon, msCon, false);
        System.out.println(Resources.getString("MessageServer.Created_destinations_on_message_server"));
        System.out.println(Resources.getString("MessageServer.Dest_Sync_Success"));
        dbCon.getConnection().commit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processExcludeCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("column")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("group")) return;
        String colGroupName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("from")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("for")) return;
        String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        SyncManCLI.setColumnGroupUse(dbCon, colGroupName, masterUnitName, schema, table, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processIncludeCMD(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        String cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("column")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("group")) return;
        String colGroupName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("from")) throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        String masterUnitName = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        cmd = st.nextWordToken();
        if (!cmd.equalsIgnoreCase("for")) return;
        String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
        SyncManCLI.setColumnGroupUse(dbCon, colGroupName, masterUnitName, schema, table, true);
    }

    private static void setColumnGroupUse(ConDataBase dbCon, String cgName, String masterUnitName, String schema, String table, boolean useIt) throws Exception {
        Participant masterParticipant = DesignSQLLayer.selectMasterParticipantByName(dbCon, masterUnitName);
        if (masterParticipant == null) {
            throw new Exception("Master participant " + masterUnitName + " not available");
        }
        UnitTable unitTable = DesignSQLLayer.selectUnitTable(dbCon, masterParticipant.getDesignID(), masterParticipant.getParticipantID(), schema, table);
        if (unitTable == null) {
            throw new Exception("Unit table " + schema + "." + table + " not available");
        }
        long count = DesignSQLLayer.selectNumberOfInstalledParticipants(dbCon, unitTable.getDesignID());
        if (count > 0L) {
            throw new Exception(Resources.getString("Units.Unit_Has") + count + Resources.getString("Units.Active_Participants"));
        }
        unitTable.loadColumnGroups(dbCon);
        for (int i = 0; i < unitTable.getColumnGroups().size(); ++i) {
            ColumnGroup cg = (ColumnGroup)unitTable.getColumnGroups().get(i);
            if (!cg.columnGroupName().equals(cgName)) continue;
            cg.setForReplication(useIt);
            DesignSQLLayer.alterColumnGroup(dbCon, -1L, unitTable.getTableID(), cg);
            break;
        }
    }

    private static void processLifeCycle(ConDataBase dbCon, String completeCMD, SyncManTokenizer st) throws Exception {
        PrintWriter out;
        String cmd = st.nextWordToken();
        if (cmd.equalsIgnoreCase("for")) {
            String schema = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String table = SyncManCLI.buildQualifier(st.nextWordToken(), st.ttype);
            String key = st.nextWordToken();
            String keyValue = st.nextWordToken();
            out = new PrintWriter(new BufferedWriter(new FileWriter("livecyle.csv")));
            out.println("HOST_DB;LAST_UPDATER;AUDIT_TIME;CONFLICT_TYPE;ROW_CREATOR;ROW_VERSION;REP_TYPE");
            Vector temp = DesignSQLLayer.selectParticipantsOfTable(dbCon, schema, table);
            for (int i = 0; i < temp.size(); ++i) {
                SyncManCLI.protAuditTableValuesForKey(out, dbCon, (Participant)temp.get(i), schema, table, "\"" + key + "\"=" + keyValue);
            }
        } else {
            throw new Exception("'" + completeCMD + "'" + " incomplete or wrong.");
        }
        out.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void protAuditTableValuesForKey(PrintWriter out, ConDataBase dbCon, Participant part, String schema, String table, String keyClause) throws Exception {
        block28: {
            block27: {
                block26: {
                    block24: {
                        block25: {
                            resultSet = null;
                            tables = null;
                            dbTarget = null;
                            try {
                                try {
                                    if (part == null) {
                                        var18_9 = null;
                                        if (resultSet == null) break block24;
                                        break block25;
                                    }
                                    DesignSQLLayer.checkParticipantParameters(dbCon, part);
                                    dbTarget = new ConDataBase(SyncManCLI.cmd_security_provider, SyncManCLI.m_SyncSchema, false, false);
                                    dbTarget.setJDBCDriver(part.getConfig().jdbcDriver());
                                    dbTarget.setConnectParam(part.getHost(), part.getDataBase(), part.getUser(), part.getPassWord(), part.getConfig().getUseSSL(), true);
                                    if (!dbTarget.isMaxDB()) {
                                        break block26;
                                    }
                                    dbTarget.connect();
                                    if (!dbTarget.isConnected()) {
                                        break block27;
                                    }
                                    part.setPassWord(dbTarget.getPassWord());
                                    tables = DesignSQLLayer.selectRepSystemTables(dbTarget);
                                    row = "";
                                    for (i = 0; i < tables.size(); ++i) {
                                        inst_table = (InstalledRepTable)tables.get(i);
                                        if (!inst_table.getSchemaTableName().equals(schema) || !inst_table.getTableName().equals(table)) continue;
                                        stmt = dbTarget.getConnection().createStatement();
                                        query = "SELECT LAST_UPDATER,AUDIT_TIME,CONFLICT_TYPE,ROW_CREATOR,ROW_VERSION,REP_TYPE FROM " + dbTarget.buildTableQualifier(inst_table.getAuditTableName()) + " where " + keyClause;
                                        resultSet = stmt.executeQuery(query);
                                        while (resultSet.next()) {
                                            row = part.getDataBase() + "_at_" + part.getHost() + ";";
                                            id = resultSet.getLong(1);
                                            if (id > 0L) {
                                                lastUpdater = DesignSQLLayer.selectParticipant(dbCon, id);
                                                row = row + lastUpdater.getDataBase() + "_at_" + lastUpdater.getHost() + ";";
                                            } else {
                                                row = row + "master;";
                                            }
                                            row = row + resultSet.getString(2) + ";";
                                            row = row + SQLBuilder.getConflictTypeAsString((int)resultSet.getInt(3)) + ";";
                                            id = resultSet.getLong(4);
                                            if (id > 0L) {
                                                creator = DesignSQLLayer.selectParticipant(dbCon, id);
                                                row = row + creator.getDataBase() + "_at_" + creator.getHost() + ";";
                                            } else {
                                                row = row + "master;";
                                            }
                                            row = row + resultSet.getString(5) + ";";
                                            row = row + SQLBuilder.getReplicationTypeAsString((int)resultSet.getInt(6)) + ";";
                                            out.println(row);
                                            out.flush();
                                        }
                                    }
                                    break block28;
                                }
                                catch (SQLException ex) {
                                    throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
                                }
                            }
                            catch (Throwable var17_27) {
                                var18_13 = null;
                                if (resultSet != null) {
                                    resultSet.close();
                                    resultSet = null;
                                }
                                if (dbTarget.isConnected() == false) throw var17_27;
                                try {
                                    dbTarget.disconnect();
                                    throw var17_27;
                                }
                                catch (SQLException ex2) {
                                    // empty catch block
                                }
                                throw var17_27;
                            }
                        }
                        resultSet.close();
                        resultSet = null;
                    }
                    if (dbTarget.isConnected() == false) return;
                    ** try [egrp 2[TRYBLOCK] [9 : 712->720)] { 
lbl77:
                    // 1 sources

                    dbTarget.disconnect();
                    return;
lbl79:
                    // 1 sources

                    catch (SQLException ex2) {
                        // empty catch block
                    }
                    return;
                }
                var18_10 = null;
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (dbTarget.isConnected() == false) return;
                ** try [egrp 2[TRYBLOCK] [9 : 712->720)] { 
lbl89:
                // 1 sources

                dbTarget.disconnect();
                return;
lbl91:
                // 1 sources

                catch (SQLException ex2) {
                    // empty catch block
                }
                return;
            }
            var18_11 = null;
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (dbTarget.isConnected() == false) return;
            ** try [egrp 2[TRYBLOCK] [9 : 712->720)] { 
lbl101:
            // 1 sources

            dbTarget.disconnect();
            return;
lbl103:
            // 1 sources

            catch (SQLException ex2) {
                // empty catch block
            }
            return;
        }
        var18_12 = null;
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
        if (dbTarget.isConnected() == false) return;
        try {}
        catch (SQLException ex2) {}
        dbTarget.disconnect();
        return;
    }

    private static String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }
}

