/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.ApplicationParam;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateTestTables {
    private static final String CREATE_TAB1 = "CREATE TABLE tab1 (keyColB CHAR(10),  keyColA CHAR(10),  col1    CHAR(10),  col2    CHAR(50), PRIMARY KEY (keyColA, keyColB))";
    private static final String CREATE_TAB2 = "CREATE TABLE tab2 (keyField INTEGER,  field1   INTEGER,  field2   INTEGER,  field3   FIXED(5),  field4   FIXED(10,2),  field5   FIXED(30),  field6   FLOAT(10),  field7   FLOAT(20),  field8   FLOAT(35), PRIMARY KEY (keyField))";
    private static final String CREATE_TAB3 = "CREATE TABLE tab3 (keyField INTEGER,  charCol  CHAR(10),  blobCol  Long BYTE, PRIMARY KEY (keyField))";
    private static final String CREATE_TAB4 = "CREATE TABLE tab4 (keyField INTEGER,  charCol  CHAR(10),  clobCol  Long ASCII, PRIMARY KEY (keyField))";
    private static final String DROP_TAB = "DROP TABLE tab";
    private static final int RC_UNKNOWN_TABLE_NAME = -4004;

    public static void main(String[] argv) {
        DebugOutput.setVerboseTraceback();
        ApplicationParam param = new ApplicationParam(argv);
        param.enableParamUser(null, null);
        if (param.createProperties()) {
            new CreateTestTables().doWork(param);
        }
    }

    private CreateTestTables() {
    }

    private void doWork(ApplicationParam param) {
        try {
            Connection con = DriverManager.getConnection(param.getURL(), param.getUser(), param.getPassword());
            con.setAutoCommit(false);
            CreateTestTables.printDatabaseConnection(con, param);
            Statement stmt = con.createStatement();
            for (int k = 1; k <= 4; ++k) {
                this.executeIgnoreUnknownTable(stmt, DROP_TAB + k);
            }
            stmt.execute(CREATE_TAB1);
            stmt.execute(CREATE_TAB2);
            stmt.execute(CREATE_TAB3);
            stmt.execute(CREATE_TAB4);
            con.commit();
            DebugOutput.println((String)"4 tables created");
        }
        catch (SQLException ex) {
            DebugOutput.printException((Exception)ex);
        }
    }

    private void executeIgnoreUnknownTable(Statement stmt, String cmd) throws SQLException {
        block2: {
            try {
                stmt.execute(cmd);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4004) break block2;
                throw ex;
            }
        }
    }

    static void printDatabaseConnection(Connection con, ApplicationParam param) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        DebugOutput.println();
        DebugOutput.println((String)("Database URL : " + param.getURL()));
        DebugOutput.println((String)("Database user: " + param.getUser()));
        DebugOutput.println((String)("Product name : " + metaData.getDatabaseProductName()));
        DebugOutput.println((String)("Product vers : " + metaData.getDatabaseProductVersion()));
        DebugOutput.println((String)("JDBC driver  : " + metaData.getDriverVersion()));
        DebugOutput.println();
    }
}

