/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class SyncQueueReceiver
implements ExceptionListener,
MessageListener {
    private QueueSession mySyncSession;
    private QueueSession myAsyncSession;
    private QueueConnection myConnection;
    private QueueReceiver mySyncReceiver;
    private QueueReceiver myAsyncReceiver;
    private int myMessagesReceived;
    private int myMessagesToReceive;
    private int myTimeToWait;
    private static boolean bEnd;

    public SyncQueueReceiver(String QueueName, String timeToWait, String messagesToReceive) throws Exception {
        bEnd = false;
        this.myMessagesReceived = 0;
        this.myTimeToWait = new Integer(timeToWait);
        this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        QueueConnectionFactory conFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
        this.myConnection = conFactory.createQueueConnection("", "");
        this.mySyncSession = this.myConnection.createQueueSession(false, 1);
        this.myAsyncSession = this.myConnection.createQueueSession(false, 1);
        Queue aQueue = (Queue)jndi.lookup("jms.queue." + QueueName);
        this.mySyncReceiver = this.mySyncSession.createReceiver(aQueue);
        this.myAsyncReceiver = this.myAsyncSession.createReceiver(aQueue);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
            ConnectionMetaData meta = this.myConnection.getMetaData();
            System.out.println("Started connection: Provider: " + meta.getJMSProviderName() + ", Version: " + meta.getProviderVersion());
            System.out.println("Waiting for " + this.myMessagesToReceive + " messages to receive.");
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    private void receiveMessages() {
        if (this.myMessagesReceived > this.myMessagesToReceive) {
            return;
        }
        TextMessage textMessage = null;
        boolean bToggle = true;
        try {
            this.myAsyncReceiver.setMessageListener((MessageListener)this);
            while (this.myMessagesReceived < this.myMessagesToReceive) {
                textMessage = bToggle ? (TextMessage)this.mySyncReceiver.receive((long)this.myTimeToWait) : (TextMessage)this.mySyncReceiver.receive();
                boolean bl = bToggle = !bToggle;
                if (textMessage != null) {
                    String text = textMessage.getText();
                    ++this.myMessagesReceived;
                    System.out.println(this.toString() + ":Syncronous Receiving: Count:" + this.myMessagesReceived + ",Text:" + text + ",msgID:" + textMessage.getJMSMessageID());
                    continue;
                }
                System.out.println("No message received ..." + new Date().toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error ex) {
            ex.printStackTrace();
        }
        System.out.println("Messages received: " + this.myMessagesReceived);
        this.exit();
    }

    public void onException(JMSException ex) {
        System.out.println(ex.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        if (this.myMessagesReceived > this.myMessagesToReceive) {
            return;
        }
        try {
            TextMessage textMessage = (TextMessage)message;
            if (textMessage != null) {
                String text = textMessage.getText();
                ++this.myMessagesReceived;
                System.out.println(this.toString() + ":Asyncronous Receiving: Count:" + this.myMessagesReceived + ",Text:" + text + ",msgID:" + textMessage.getJMSMessageID());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.myMessagesReceived == this.myMessagesToReceive) {
            this.exit();
        }
    }

    private void exit() {
        bEnd = true;
    }

    public void close() throws JMSException {
        this.myAsyncReceiver.close();
        this.mySyncReceiver.close();
        this.myConnection.close();
        System.out.println(new Date().toString() + ":Connection closed");
    }

    public static void main(String[] args) {
        SyncQueueReceiver aSQR = null;
        try {
            if (args.length != 3) {
                System.out.println("Queue,TimeToWait or MessageToReceive missing");
            }
            aSQR = new SyncQueueReceiver(args[0], args[1], args[2]);
            System.out.println("Type 'start' to start connection ...");
            while (!bEnd) {
                try {
                    BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                    String s = stdin.readLine();
                    if (!s.equalsIgnoreCase("start")) continue;
                    stdin.close();
                    aSQR.receiveMessages();
                }
                catch (IOException ioe) {}
            }
        }
        catch (Exception ex) {
        }
        catch (Error e) {
            System.out.println("Unhandled Error!");
            e.printStackTrace();
        }
        try {
            while (!bEnd) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            aSQR.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

