/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PriorityMessagesQS
extends Thread
implements ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private QueueSender qSender = null;
    private Queue aQueue = null;
    private int sentMessages = 0;

    public PriorityMessagesQS(String queueName) {
        try {
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(false, 1);
            this.aQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.qSender = this.qSession.createSender(this.aQueue);
            this.qConnect.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    private void sendAMessage(Date aDate, int iMessageNumber, int priority) {
        try {
            TextMessage textMsg = this.qSession.createTextMessage();
            textMsg.setText("TextMessage " + aDate.toString() + " Priority:" + new Integer(priority).toString() + " Nr:" + new Integer(iMessageNumber).toString());
            System.out.println(textMsg.getText());
            this.qSender.send((Message)textMsg, 0, priority, 0L);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        int messagesToSend = 1000;
        int priority = 0;
        while (this.sentMessages < messagesToSend) {
            try {
                Date newT = new Date();
                this.sendAMessage(newT, this.sentMessages, priority);
                ++this.sentMessages;
                if (this.sentMessages % 10 == 0) {
                    ++priority;
                }
                if (priority <= 9) continue;
                priority = 0;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
        this.interrupt();
        this.exit();
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    private void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("QueueName missing");
        }
        PriorityMessagesQS t1qs = new PriorityMessagesQS(argv[0]);
        System.out.println("QueueSender application started");
        t1qs.start();
    }
}

