/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Enumeration;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneQueueBrowser
implements ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private Queue receiveQueue = null;
    private int myMessagesReceived = 0;
    private int myMessagesToReceive = 0;

    public OneQueueBrowser(String queueName, String messagesToReceive) {
        try {
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(false, 1);
            this.receiveQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.qConnect.setExceptionListener((ExceptionListener)this);
            this.qConnect.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    private void handleMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            System.out.println("Timestamp Diff in ms:" + (System.currentTimeMillis() - textMessage.getLongProperty("TIMESTAMP")));
            ++this.myMessagesReceived;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void doWork() {
        try {
            System.out.print("Creating QueueBrowser...");
            QueueBrowser browser = this.qSession.createBrowser(this.receiveQueue);
            System.out.println("[done]");
            Enumeration e = browser.getEnumeration();
            while (this.myMessagesReceived < this.myMessagesToReceive) {
                while (e.hasMoreElements()) {
                    TextMessage message = (TextMessage)e.nextElement();
                    this.handleMessage((Message)message);
                }
                System.out.println("No Messages in Queue ... sleep 1 sec");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }

    public void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("QueueName or Messagenumber missing");
        }
        OneQueueBrowser qb = new OneQueueBrowser(argv[0], argv[1]);
        System.out.println("OneQueueBrowser application started. Stop with 'exit'");
        qb.doWork();
        System.out.println("OneQueueBrowser application stopped");
    }
}

