/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import com.sap.sdb.msgServer.client.AdminConnection;
import com.sap.sdb.syncMan.message.SyncManMessage;
import java.io.IOException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AdminMessageServer {
    public static final String MS_SERVICE = "SERVICE com.sap.sdb.msgServer.service.JmsService ON PORT ";
    private static final String MS_VECTOR = "Vector:";
    private String m_passWord;
    private AdminConnection m_adminConnect = null;

    public void disconnect() throws IOException {
        if (this.m_adminConnect != null) {
            this.m_adminConnect.close();
            this.m_adminConnect = null;
        }
    }

    public void connect(String host, int port, String password, boolean useSSL) throws IOException {
        if (host == null || host.length() < 1) {
            host = "127.0.0.1";
        }
        this.m_passWord = password;
        this.m_adminConnect = new AdminConnection();
        this.m_adminConnect.connectToAdminService(useSSL, host, port);
        this.send("password " + password, true);
        this.send("status", true);
    }

    public void createDurableTopicSubscriber(String topicName, String subscriptionName, long clientUnitId) throws JMSException, NamingException {
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        String selector = SyncManMessage.createMessageSelectorString((long)clientUnitId);
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        TopicConnection connection = conFactory.createTopicConnection("", "");
        TopicSession subSession = connection.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        TopicSubscriber subscriber = subSession.createDurableSubscriber(aTopic, subscriptionName, selector, false);
        subscriber.close();
        connection.close();
    }

    public void dropDurableTopicSubscriber(String topicName, String subscriptionName) throws JMSException, NamingException {
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        TopicConnection connection = conFactory.createTopicConnection("", "");
        TopicSession subSession = connection.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        subSession.createDurableSubscriber(aTopic, subscriptionName);
        subSession.unsubscribe(subscriptionName);
        connection.close();
    }

    public String inetAddress() {
        return this.m_adminConnect != null ? this.m_adminConnect.getInetAddress().toString() : "";
    }

    public String port() {
        return this.m_adminConnect != null ? String.valueOf(this.m_adminConnect.getPort()) : "";
    }

    public String password() {
        return this.m_passWord;
    }

    public boolean isConnected() {
        return this.m_adminConnect != null;
    }

    private boolean parseMessageServerRespond(String respond) {
        if (respond.length() < 1) {
            return true;
        }
        int servicePort1 = respond.indexOf(MS_SERVICE);
        if (servicePort1 <= 0) {
            if (respond.startsWith("OK")) {
                return true;
            }
            return respond.indexOf("com.sap.sdb.msgServer.agents.DestinationAlreadyExistsException") > 0;
        }
        return true;
    }

    public Vector parseVectorResponse(String respond) {
        Vector<String> ret = new Vector<String>();
        if (!respond.startsWith(MS_VECTOR)) {
            return ret;
        }
        respond = respond.substring(MS_VECTOR.length(), respond.length() - 1);
        String item = "";
        int index = respond.indexOf("\r\n", 0);
        int lastIndex = 0;
        while (index > 0) {
            if (lastIndex != 0) {
                lastIndex += 2;
            }
            item = respond.substring(lastIndex, index);
            ret.add(item);
            lastIndex = index;
            index = respond.indexOf("\r\n", lastIndex + 1);
        }
        return ret;
    }

    public String send(String command, boolean parseRespond) throws IOException {
        if (this.m_adminConnect == null) {
            throw new IOException("Message Server: No valid server!");
        }
        this.m_adminConnect.sendMessage(command);
        String ret = this.m_adminConnect.receivedMessage();
        if (ret == null) {
            return "";
        }
        if (parseRespond && !this.parseMessageServerRespond(ret)) {
            throw new IOException("Message Server:" + ret);
        }
        return ret;
    }
}

