/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.jsp;

import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import com.sap.sapdb.benchmark.common.where.FilteredView;
import com.sap.sapdb.benchmark.common.where.WhereException;
import com.sap.sapdb.benchmark.tp2.jsp.SearchFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SessionList
extends FilteredView {
    private SortedMap sessions = null;
    private int globalTestCount = 0;
    private String benchmarkType = null;

    public SessionList() {
    }

    public SessionList(SearchFilter searchFilter) throws SQLException, WhereException {
        Iterator it = searchFilter.getAFKeys();
        while (it.hasNext()) {
            Class clss = (Class)it.next();
            this.addAtomicFilter(searchFilter.getAF(clss));
        }
        this.benchmarkType = searchFilter.getBenchmarkType();
    }

    public String getPreparedQuery() throws WhereException {
        StringBuffer res = new StringBuffer("");
        if (this.benchmarkType.equals("Wisconsin")) {
            res.append("SELECT \nsess.id AS sess_id,\nsess.description AS sess_desc,\nsess.benchmark_type,\nsess.begin_date,\nsess.end_date,\nusers.id AS user_id,\nusers.name AS user_name,\nusers.description AS user_desc,\nusers.mail AS user_mail,\nCOUNT(lnk.def_id) AS tests_count\n FROM \nsessions sess,\nusers,\nservernodes nodes,\ndbdescriptions dbdesc,\nwisc_definitions def,\nwisc_sessions_results lnk\n WHERE \n lnk.session_id = sess.id\n AND lnk.def_id = def.id\n AND sess.user_id = users.id\n AND dbdesc.id = def.dbdescription_id\n AND nodes.id = def.servernode_id\n");
        } else {
            res.append("SELECT \nsess.id AS sess_id,\nsess.description AS sess_desc,\nsess.benchmark_type,\nsess.begin_date,\nsess.end_date,\nusers.id AS user_id,\nusers.name AS user_name,\nusers.description AS user_desc,\nusers.mail AS user_mail,\nCOUNT(lnk.def_id) AS tests_count\n FROM \nsessions sess,\nusers,\nservernodes nodes,\ndbdescriptions dbdesc,\ntp2_definitions def,\ntp2_sessions_results lnk\n WHERE \n lnk.session_id = sess.id\n AND lnk.def_id = def.id\n AND sess.user_id = users.id\n AND dbdesc.id = def.dbdescription_id\n AND nodes.id = def.servernode_id\n");
        }
        if (this.getFilterCount() > 0) {
            res.append(" AND " + this.getPreparedWherePart() + "\n");
        }
        res.append(" GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,users.id,users.name,users.description,users.mail");
        return res.toString();
    }

    public void retrieve() throws SQLException, WhereException {
        this.prepare(StorableObject.getConnection());
        this.sessions = new TreeMap();
        this.globalTestCount = 0;
        while (this.next()) {
            ResultSet RS = this.executeQuery();
            while (RS.next()) {
                Session sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
                sess.setRelatedTestsCount(RS.getInt("tests_count"));
                this.globalTestCount += sess.getRelatedTestsCount();
                CompInt sessId = new CompInt(sess.getId());
                if (!this.sessions.containsKey(sessId)) {
                    this.sessions.put(sessId, sess);
                    continue;
                }
                Session sortedSess = (Session)this.sessions.get(sessId);
                sortedSess.setRelatedTestsCount(sortedSess.getRelatedTestsCount() + RS.getInt("tests_count"));
            }
            RS.close();
        }
    }

    public SortedSet getSessions() {
        return new TreeSet(this.sessions.values());
    }

    public int getGlobalTestCount() {
        return this.globalTestCount;
    }
}

