/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.benchmark.tp2.cases.InteractiveException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class InteractiveCmd {
    private String cmdName = null;
    private Properties namedOptions = new Properties();
    private Vector unnamedOptions = new Vector();

    public InteractiveCmd(String cmdStr) throws InteractiveException {
        StringTokenizer ST = new StringTokenizer(cmdStr, " ");
        this.cmdName = ST.nextToken();
        while (ST.hasMoreTokens()) {
            String currOpt = ST.nextToken();
            if (currOpt.charAt(0) == '-') {
                if (ST.hasMoreTokens()) {
                    this.namedOptions.setProperty(currOpt, ST.nextToken());
                    continue;
                }
                throw new InteractiveException("Option " + currOpt + " is not followed by a value");
            }
            this.unnamedOptions.add(currOpt);
        }
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getOption(String optionName) {
        return this.namedOptions.getProperty(optionName);
    }

    public String getOption(int i) {
        return (String)this.unnamedOptions.get(i);
    }

    public boolean hasOption(String optionName) {
        return this.namedOptions.containsKey(optionName) || this.unnamedOptions.contains(optionName);
    }

    public boolean hasOption(int i) {
        return this.unnamedOptions.size() > i;
    }

    public String toString() {
        return this.getCmdName() + " " + this.unnamedOptions + " " + this.namedOptions;
    }
}

