/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.lcbenchmarks;

import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.SQLException;

public class LcBenchmarkWrapper
extends PrimaryTest {
    public static final String VERSION = "1.0";
    public static int mTraceLevel;
    public static String mMakeKey;
    public static String mBenchSize;
    public static boolean mStoreResultPersistent;
    public static String mUserSetting;
    public static String mTestDBName;
    public static String mResultsDBName;
    public static String mResultsDBServer;
    public static String mResultsDBUser;
    public static String mResultsDBPassword;

    public static long getTimeout() {
        return 3600000L;
    }

    public static void prepare() throws TestCaseException {
        mTraceLevel = LcBenchmarkWrapper.getParameterInt((String)"TraceLevel", (int)1);
        mBenchSize = LcBenchmarkWrapper.getParameterString((String)"SizeOption", (String)"-small");
        mMakeKey = LcBenchmarkWrapper.getParameterString((String)"MakeKey", (String)mTestDriverOptions.getProperty("MakeKey"));
        mStoreResultPersistent = LcBenchmarkWrapper.getParameterBoolean((String)"StoreResultPersistent", (boolean)false);
        mUserSetting = LcBenchmarkWrapper.getParameterString((String)"UserSetting", (String)"-multi");
        String storeMode = "NO";
        if (mStoreResultPersistent) {
            storeMode = "YES";
            mResultsDBName = LcBenchmarkWrapper.getParameterString((String)"ResultsDBName", (String)"NONE");
            mResultsDBServer = LcBenchmarkWrapper.getParameterString((String)"ResultsDBServer", (String)"NONE");
            mResultsDBUser = LcBenchmarkWrapper.getParameterString((String)"ResultsDBUser", (String)"NONE");
            mResultsDBPassword = LcBenchmarkWrapper.getParameterString((String)"ResultsDBPassword", (String)"NONE");
        }
        String infoString = "\n       *************************************************\n       Starting LcBenchmarkWrapper - Version: 1.0\n       *************************************************\n\n       Benchmarks settings:       \n       -------------------       \n       Test DB Name  :                " + mTestDBName + "\n" + "       Benchmark size:                " + mBenchSize + "\n" + "       Benchmark user setting:        " + mUserSetting + "\n" + "       Store results persistent:      " + storeMode + "\n";
        if (mStoreResultPersistent) {
            infoString = infoString + "\n       Results DB Name:               " + mResultsDBName + "\n" + "       Results DB Server:             " + mResultsDBServer + "\n" + "       Results DB User:               " + mResultsDBUser + "\n" + "       Results DB Password:           " + mResultsDBPassword + "\n";
        }
        LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), infoString);
    }

    public void run() {
        try {
            String sFileSep = System.getProperty("file.separator");
            String cmd = "";
            StringBuffer dropbuf = new StringBuffer();
            Execute dbdrop = new Execute("dbmcli -d BENCH -u dbm,dbm db_drop", null, dropbuf);
            dbdrop.exec();
            LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), "\nTried DB Drop of standard test db BENCH in case it was still there! \nOutput:\n" + dropbuf.toString());
            String executableName = "";
            executableName = System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN") ? "lcbenchmark.exe" : "lcbenchmark";
            cmd = mStoreResultPersistent ? TestDriver.getJTestRoot() + sFileSep + "tests" + sFileSep + executableName + " -v " + mBenchSize + " -i " + this.getDBRoot() + " " + mUserSetting + " -dp " + mResultsDBName + " -np " + mResultsDBServer + " -up " + mResultsDBUser + "," + mResultsDBPassword + " -mk " + mMakeKey : TestDriver.getJTestRoot() + sFileSep + "tests" + sFileSep + executableName + " -v " + mBenchSize + " -i " + this.getDBRoot() + " " + mUserSetting;
            LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), "\nStarting LCBENCHMARK with the following call:\n " + cmd + "\n");
            StringBuffer sb = new StringBuffer();
            Execute exc = new Execute(cmd, null, sb);
            exc.exec();
            int exitValue = exc.getExitValue();
            if (exitValue == 0) {
                LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), "\nExitValue is " + exitValue + "\nTest output:\n\n" + sb.toString());
            } else {
                LcBenchmarkWrapper.addGlobalMessage((String)LcBenchmarkWrapper.getTestClassId(), (char)'E', (String)("\nExitValue is " + exitValue + "\nTest output:\n\n" + sb.toString()));
            }
        }
        catch (Exception e) {
            LcBenchmarkWrapper.addGlobalMessage((String)LcBenchmarkWrapper.getTestClassId(), (char)'E', (String)("Method run() - Exception: " + e.getClass() + e.getMessage()));
            System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
        }
    }

    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
        System.out.println("End of " + LcBenchmarkWrapper.getTestClassId());
    }

    public static String getTestClassId() {
        return "LcBenchmarkWrapper";
    }

    public static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            LcBenchmarkWrapper.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            LcBenchmarkWrapper.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    static {
        mResultsDBName = "";
        mResultsDBServer = "";
        mResultsDBUser = "";
        mResultsDBPassword = "";
    }
}

