/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.SQLException;

public class DebugOutput {
    private boolean m_verbose = false;
    private boolean m_verboseCapture = false;
    private boolean m_verboseCaptureMsg = false;
    private boolean m_verboseConsumption = false;
    private boolean m_verboseConsumptionMsg = false;
    private boolean m_verboseException = false;
    private boolean m_verboseTraceback = false;
    private boolean m_verboseWait = false;
    private boolean m_silent = false;
    private PrintWriter m_logFile = null;
    private static DebugOutput s_instance = new DebugOutput();

    private DebugOutput() {
    }

    public static synchronized void createLogFile(String logFilename) {
        try {
            DebugOutput.s_instance.m_logFile = new PrintWriter(new FileWriter(logFilename));
        }
        catch (Exception ex) {
            if (!DebugOutput.s_instance.m_silent) {
                System.out.println("*** createLogFile: " + ex.toString());
            }
            DebugOutput.s_instance.m_logFile = null;
            DebugOutput.flush();
        }
    }

    public static void setSilent(boolean silent) {
        DebugOutput.s_instance.m_silent = silent;
    }

    private static synchronized void flush() {
        if (!DebugOutput.s_instance.m_silent) {
            System.out.flush();
        }
        if (DebugOutput.s_instance.m_logFile != null) {
            try {
                DebugOutput.s_instance.m_logFile.flush();
            }
            catch (Exception ex) {
                DebugOutput.s_instance.m_logFile = null;
            }
        }
    }

    private static String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }

    public static boolean isVerbose() {
        return DebugOutput.s_instance.m_verbose;
    }

    public static boolean isVerboseCapture() {
        return DebugOutput.s_instance.m_verboseCapture;
    }

    public static boolean isVerboseCaptureMsg() {
        return DebugOutput.s_instance.m_verboseCaptureMsg;
    }

    public static boolean isVerboseConsumption() {
        return DebugOutput.s_instance.m_verboseConsumption;
    }

    public static boolean isVerboseConsumptionMsg() {
        return DebugOutput.s_instance.m_verboseConsumptionMsg;
    }

    public static boolean isVerboseWait() {
        return DebugOutput.s_instance.m_verboseWait;
    }

    public static synchronized void printErrorMsg(String msg) {
        if (DebugOutput.s_instance.m_logFile != null) {
            DebugOutput.writeIntoLogFile(msg);
        }
        if (!DebugOutput.s_instance.m_silent) {
            System.out.println(msg);
        }
        DebugOutput.flush();
    }

    public static synchronized void printException(Exception ex) {
        if (!DebugOutput.s_instance.m_verboseException) {
            return;
        }
        if (ex instanceof SQLException) {
            SQLException e = (SQLException)ex;
            String msg = e.getMessage();
            if (e.getMessage() == null) {
                msg = e.toString();
            }
            String msgOutput = "SQLException " + e.getErrorCode() + ": " + msg;
            if (e.getSQLState() == null) {
                DebugOutput.printErrorMsg(msgOutput);
            } else {
                DebugOutput.printErrorMsg(msgOutput + ": " + e.getSQLState());
            }
        } else if (!DebugOutput.s_instance.m_verboseTraceback) {
            DebugOutput.printErrorMsg(ex.toString());
        }
        if (DebugOutput.s_instance.m_verboseTraceback) {
            DebugOutput.println(DebugOutput.getStackTraceAsString(ex));
        }
        DebugOutput.flush();
    }

    public static synchronized void println() {
        if (!DebugOutput.s_instance.m_silent) {
            DebugOutput.println("");
        }
        DebugOutput.flush();
    }

    public static synchronized void println(String line) {
        if (DebugOutput.s_instance.m_logFile != null) {
            DebugOutput.writeIntoLogFile(line);
        }
        if (!DebugOutput.s_instance.m_silent) {
            System.out.println(line);
        }
        DebugOutput.flush();
    }

    public static void setVerbose() {
        DebugOutput.s_instance.m_verbose = true;
    }

    public static void setVerboseCapture() {
        DebugOutput.s_instance.m_verbose = true;
        DebugOutput.s_instance.m_verboseCapture = true;
    }

    public static void setVerboseCaptureMsg() {
        DebugOutput.s_instance.m_verbose = true;
        DebugOutput.s_instance.m_verboseCapture = true;
        DebugOutput.s_instance.m_verboseCaptureMsg = true;
    }

    public static void setVerboseConsumption() {
        DebugOutput.s_instance.m_verbose = true;
        DebugOutput.s_instance.m_verboseConsumption = true;
    }

    public static void setVerboseConsumptionMsg() {
        DebugOutput.s_instance.m_verbose = true;
        DebugOutput.s_instance.m_verboseConsumption = true;
        DebugOutput.s_instance.m_verboseConsumptionMsg = true;
    }

    public static void setVerboseException() {
        DebugOutput.s_instance.m_verboseException = true;
    }

    public static void setVerboseTraceback() {
        DebugOutput.s_instance.m_verboseException = true;
        DebugOutput.s_instance.m_verboseTraceback = true;
    }

    public static void setVerboseWait() {
        DebugOutput.s_instance.m_verboseWait = true;
    }

    private static synchronized void writeIntoLogFile(String line) {
        try {
            DebugOutput.s_instance.m_logFile.println(line);
            DebugOutput.flush();
        }
        catch (Exception ex) {
            if (!DebugOutput.s_instance.m_silent) {
                System.out.println("*** printlnIntoLogFile: " + ex.toString());
                System.out.flush();
            }
            DebugOutput.s_instance.m_logFile = null;
        }
    }
}

