/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.triggerMinDB;

import com.sap.sdb.minDB.triggerInterface.Trigger;
import com.sap.sdb.minDB.triggerInterface.TriggerConnection;
import com.sap.sdb.minDB.triggerInterface.TriggerImageSet;
import com.sap.sdb.minDB.triggerInterface.TriggerParamSet;
import com.sap.sdb.syncMan.triggerMinDB.ClientTrigger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ClientDeleteTrigger
extends ClientTrigger
implements Trigger {
    private static final String STMT_INSERT_SHADOW_TAB = "insertShadowTab";
    private static final String STMT_DELETE_VERSION_TAB = "deleteVersionTab";
    private static final String STMT_SELECT_VERSION_TAB = "selectVersionTab";

    public void executeTrigger(TriggerConnection connection, HashMap prepStmtMap, TriggerParamSet param, TriggerImageSet image) throws SQLException {
        try {
            String keyCondition;
            String syncUser = param.getString("SYNCMAN_USER");
            String syncSchema = param.getString("SYNCMAN_SCHEMA");
            if (connection.getUsername().equals(syncUser)) {
                return;
            }
            int keyCount = param.getInt("KEY_COUNT");
            String transID = Long.toString(connection.getTransactionID());
            String sequenceNo = super.getNextSequenceNo(connection, param, syncSchema);
            String updaterID = param.getString("UPDATER_ID");
            PreparedStatement insertShadowStmt = (PreparedStatement)prepStmtMap.get(STMT_INSERT_SHADOW_TAB);
            PreparedStatement deleteVersionStmt = (PreparedStatement)prepStmtMap.get(STMT_DELETE_VERSION_TAB);
            PreparedStatement selectVersionStmt = (PreparedStatement)prepStmtMap.get(STMT_SELECT_VERSION_TAB);
            String string = keyCondition = selectVersionStmt == null || deleteVersionStmt == null ? super.buildKeyCondition(param, keyCount) : null;
            if (insertShadowStmt == null) {
                insertShadowStmt = this.prepareShadowTableInsert(connection, param, syncSchema, keyCount);
                prepStmtMap.put(STMT_INSERT_SHADOW_TAB, insertShadowStmt);
            }
            if (deleteVersionStmt == null) {
                deleteVersionStmt = this.prepareVersionTableDelete(connection, param, syncSchema, keyCondition);
                prepStmtMap.put(STMT_DELETE_VERSION_TAB, deleteVersionStmt);
            }
            if (selectVersionStmt == null) {
                selectVersionStmt = this.prepareVersionTableSelect(connection, param, syncSchema, keyCondition);
                prepStmtMap.put(STMT_SELECT_VERSION_TAB, selectVersionStmt);
            }
            for (int i = 1; i <= keyCount; ++i) {
                int colIndex = image.findColumn(param.getString("KEY" + i));
                String currKeyValue = image.getOldString(colIndex);
                insertShadowStmt.setString(i, currKeyValue);
                deleteVersionStmt.setString(i, currKeyValue);
                selectVersionStmt.setString(i, currKeyValue);
            }
            ResultSet result = selectVersionStmt.executeQuery();
            result.next();
            String rowCreator = result.getString(1);
            String rowVersion = result.getString(2);
            result.close();
            insertShadowStmt.setString(keyCount + 1, transID);
            insertShadowStmt.setString(keyCount + 2, sequenceNo);
            insertShadowStmt.setString(keyCount + 3, rowCreator);
            insertShadowStmt.setString(keyCount + 4, rowVersion);
            insertShadowStmt.setString(keyCount + 5, updaterID);
            insertShadowStmt.executeUpdate();
            deleteVersionStmt.executeUpdate();
            this.insertIntoTransList(connection, prepStmtMap, image, syncSchema, transID, sequenceNo);
        }
        catch (SQLException ex) {
            if (connection.isVerboseTrigger()) {
                connection.printStackTrace((Exception)ex);
            }
            throw ex;
        }
    }

    private PreparedStatement prepareShadowTableInsert(TriggerConnection connection, TriggerParamSet param, String syncSchema, int keyCount) throws SQLException {
        String keyNames = "";
        String keyParameters = "";
        for (int i = 1; i <= keyCount; ++i) {
            keyNames = keyNames + "\"_" + param.getString("KEY" + i) + "\", ";
            keyParameters = keyParameters + "?, ";
        }
        String sql = "INSERT INTO " + syncSchema + "." + param.getString("SHADOW_TABLE") + "(" + keyNames + "REP_TRANSID, REP_COUNTER, REP_TYPE, " + "ROW_CREATOR, ROW_VERSION, UPDATER_ID, " + "COL_GROUP_VERSION) VALUES (" + keyParameters + " ?, ?, 2," + " ?, ?, ?," + " '-1')";
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableDelete(TriggerConnection connection, TriggerParamSet param, String syncSchema, String keyCondition) throws SQLException {
        String sql = "DELETE FROM " + syncSchema + "." + param.getString("VERSION_TABLE") + " WHERE " + keyCondition;
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableSelect(TriggerConnection connection, TriggerParamSet param, String syncSchema, String keyCondition) throws SQLException {
        String sql = "SELECT ROW_CREATOR, ROW_VERSION FROM " + syncSchema + "." + param.getString("VERSION_TABLE") + " WHERE " + keyCondition;
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }
}

