/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.tool;

import com.sap.sdb.msgServer.client.AdminConnection;
import com.sap.sdb.msgServer.client.TopicBrowserImpl;
import com.sap.sdb.msgServer.client.TopicSessionImpl;
import com.sap.sdb.syncMan.SyncService;
import com.sap.sdb.syncMan.gui.jface_dialog.MSConnectDialog;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.tool.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.swt.widgets.Shell;

public class ConMessageServer {
    public static final String MS_SERVICE = "SERVICE com.sap.sdb.msgServer.service.JmsService ON PORT ";
    private static final String MS_VECTOR = "Vector:";
    private static final String JNDI_HOST = "jndi.host";
    private static final String JMS_HOST = "jms.host";
    private static final String JNDI_PORT = "jndi.port";
    private static final String JMS_PORT = "jms.port";
    private int m_AdminPort = -1;
    private String m_JndiHost = null;
    private int m_JndiPort = -1;
    private String m_MsgHost = null;
    private int m_MsgPort = -1;
    private String m_PassWord = null;
    private boolean m_useSSL = false;
    private AdminConnection m_adminConnect = null;
    private Shell m_parentShell = null;
    private ClassLoader m_classLoader = ClassLoader.getSystemClassLoader();

    public ConMessageServer(Shell parentShell) {
        this();
        this.m_parentShell = parentShell;
    }

    public ConMessageServer() {
    }

    public void disconnect() throws IOException {
        if (this.m_adminConnect != null) {
            this.m_adminConnect.close();
            this.m_adminConnect = null;
        }
        this.m_MsgPort = -1;
        this.m_JndiPort = -1;
        this.m_AdminPort = -1;
        this.m_JndiHost = null;
        this.m_MsgHost = null;
        this.m_PassWord = null;
        this.m_useSSL = false;
    }

    public void connect() throws IOException {
        MSConnectDialog dlg;
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (this.m_JndiHost == null) {
            this.m_JndiHost = (String)prop.get(JNDI_HOST);
        }
        if (this.m_MsgHost == null) {
            this.m_MsgHost = (String)prop.get(JMS_HOST);
        }
        if (this.m_JndiPort < 1) {
            this.m_JndiPort = Integer.valueOf((String)prop.get(JNDI_PORT));
        }
        if (this.m_MsgPort < 1) {
            this.m_MsgPort = Integer.valueOf((String)prop.get(JMS_PORT));
        }
        if (this.m_adminConnect != null) {
            this.disconnect();
        }
        if ((this.m_MsgHost == null || this.m_MsgHost.length() < 1 || this.m_PassWord == null || this.m_PassWord.length() < 1 || this.m_AdminPort < 0) && (dlg = new MSConnectDialog(this.m_parentShell, this.m_MsgHost, this.m_AdminPort, this.m_PassWord)) != null) {
            dlg.setBlockOnOpen(true);
            int returnCode = dlg.open();
            if (returnCode == 0) {
                this.m_MsgHost = dlg.getHost();
                this.m_AdminPort = dlg.getPort();
                this.m_PassWord = dlg.getPassword();
                this.m_useSSL = dlg.useSSL();
            } else {
                return;
            }
        }
        this.connect(this.m_MsgHost, this.m_MsgPort, this.m_JndiHost, this.m_JndiPort, this.m_AdminPort, this.m_PassWord, this.m_useSSL);
    }

    public void connect(String msgHost, int msgPort, String jndiHost, int jndiPort, int admin_port, String password, boolean useSSL) throws IOException {
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (jndiHost == null) {
            jndiHost = (String)prop.get(JNDI_HOST);
        }
        if (msgHost == null) {
            msgHost = (String)prop.get(JMS_HOST);
        }
        if (jndiPort < 1) {
            jndiPort = Integer.valueOf((String)prop.get(JNDI_PORT));
        }
        if (msgPort < 1) {
            msgPort = Integer.valueOf((String)prop.get(JMS_PORT));
        }
        this.m_MsgHost = msgHost;
        this.m_MsgPort = msgPort;
        this.m_JndiHost = jndiHost;
        this.m_JndiPort = jndiPort;
        this.m_PassWord = ConMessageServer.buildQualifier(password);
        this.m_useSSL = useSSL;
        this.m_AdminPort = admin_port;
        this.m_adminConnect = new AdminConnection();
        this.m_adminConnect.connectToAdminService(this.m_useSSL, this.m_MsgHost, this.m_AdminPort);
        String tmp = this.send("version", false);
        if (!tmp.trim().equalsIgnoreCase(SyncService.getVersion())) {
            this.disconnect();
            throw new IOException("Wrong Message Server:" + tmp + " - Expected version:" + SyncService.getVersion());
        }
        this.send("password " + this.m_PassWord, true);
        this.send("status", true);
    }

    public void createDurableTopicSubscriber(String topicName, String subscriptionName, String password, long clientUnitId) throws Exception {
        InitialContext jndi = null;
        String checkSubs = Resources.getString("AdminAgent.Subscription") + subscriptionName + "," + Resources.getString("AdminAgent.State") + Resources.getString("ConsumerEntity.active");
        Vector subs = ConMessageServer.loadSubscriptions(this, topicName);
        for (int i = 0; i < subs.size(); ++i) {
            if (subs.get(i).toString().indexOf(checkSubs) <= 0) continue;
            return;
        }
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (this.m_JndiHost != null) {
            prop.put(JNDI_HOST, this.m_JndiHost);
        }
        if (this.m_MsgHost != null) {
            prop.put(JMS_HOST, this.m_MsgHost);
        }
        if (this.m_JndiPort > 0) {
            prop.put(JNDI_PORT, Integer.toString(this.m_JndiPort));
        }
        if (this.m_MsgPort > 0) {
            prop.put(JMS_PORT, Integer.toString(this.m_MsgPort));
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            jndi = new InitialContext(prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        String selector = SyncManMessage.createMessageSelectorString(clientUnitId);
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        TopicConnection connection = conFactory.createTopicConnection("", password);
        TopicSession session = connection.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        TopicSubscriber subscriber = session.createDurableSubscriber(aTopic, subscriptionName, selector, false);
        subscriber.close();
        connection.close();
    }

    public void dropDurableTopicSubscriber(String topicName, String subscriptionName, String password) throws JMSException, NamingException, IOException {
        InitialContext jndi = null;
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (this.m_JndiHost != null) {
            prop.put(JNDI_HOST, this.m_JndiHost);
        }
        if (this.m_MsgHost != null) {
            prop.put(JMS_HOST, this.m_MsgHost);
        }
        if (this.m_JndiPort > 0) {
            prop.put(JNDI_PORT, Integer.toString(this.m_JndiPort));
        }
        if (this.m_MsgPort > 0) {
            prop.put(JMS_PORT, Integer.toString(this.m_MsgPort));
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            jndi = new InitialContext(prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        TopicConnection connection = conFactory.createTopicConnection("", password);
        TopicSession session = connection.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        session.createDurableSubscriber(aTopic, subscriptionName);
        session.unsubscribe(subscriptionName);
        connection.close();
    }

    public String getMsgHost() {
        return this.m_MsgHost;
    }

    public int getAdminPort() {
        return this.m_AdminPort;
    }

    public int getMsgPort() {
        return this.m_MsgPort;
    }

    public String getJndiHost() {
        return this.m_JndiHost;
    }

    public int getJndiPort() {
        return this.m_JndiPort;
    }

    public boolean getUseSSL() {
        return this.m_useSSL && this.m_adminConnect != null;
    }

    public String getPassWord() {
        return this.m_PassWord;
    }

    public boolean isConnected() {
        return this.m_adminConnect != null;
    }

    private boolean parseMessageServerRespond(String respond) {
        if (respond.length() < 1) {
            return true;
        }
        int servicePort1 = respond.indexOf(MS_SERVICE);
        if (servicePort1 > -1) {
            int servicePort2 = respond.indexOf("\n", servicePort1 + MS_SERVICE.length());
            if (servicePort2 <= -1) {
                return false;
            }
        } else {
            if (respond.startsWith("OK")) {
                return true;
            }
            return respond.indexOf("com.sap.sdb.msgServer.agents.DestinationAlreadyExistsException") > 0;
        }
        return true;
    }

    public Vector parseVectorResponse(String respond) {
        Vector<String> ret = new Vector<String>();
        if (!respond.startsWith(MS_VECTOR)) {
            return ret;
        }
        respond = respond.substring(MS_VECTOR.length(), respond.length() - 1);
        String item = "";
        int index = respond.indexOf("\r\n", 0);
        int lastIndex = 0;
        while (index > 0) {
            if (lastIndex != 0) {
                lastIndex += 2;
            }
            item = respond.substring(lastIndex, index);
            ret.add(item);
            lastIndex = index;
            index = respond.indexOf("\r\n", lastIndex + 1);
        }
        return ret;
    }

    public String send(String command, boolean parseRespond) throws IOException {
        if (this.m_adminConnect == null) {
            throw new IOException("Message Server: No valid server!");
        }
        this.m_adminConnect.sendMessage(command);
        String ret = this.m_adminConnect.receivedMessage();
        if (ret == null) {
            ret = "";
        }
        if (parseRespond && !this.parseMessageServerRespond(ret)) {
            throw new IOException("Message Server:" + ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getTopicMessages(String destName, String destPass, int count) throws JMSException, NamingException, IOException {
        InitialContext jndi = null;
        Vector<Message> messages = new Vector<Message>();
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (this.m_JndiHost != null) {
            prop.put(JNDI_HOST, this.m_JndiHost);
        }
        if (this.m_MsgHost != null) {
            prop.put(JMS_HOST, this.m_MsgHost);
        }
        if (this.m_JndiPort > 0) {
            prop.put(JNDI_PORT, Integer.toString(this.m_JndiPort));
        }
        if (this.m_MsgPort > 0) {
            prop.put(JMS_PORT, Integer.toString(this.m_MsgPort));
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        jndi = new InitialContext(prop);
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        TopicConnection connection = conFactory.createTopicConnection("", destPass);
        TopicSession session = connection.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + destName);
        try {
            try {
                connection.start();
                TopicBrowserImpl browser = ((TopicSessionImpl)session).createBrowser(aTopic);
                Enumeration e = browser.getEnumeration();
                for (int i = 0; i < count && e.hasMoreElements(); ++i) {
                    Message message = (Message)e.nextElement();
                    messages.add(message);
                }
                Object var17_18 = null;
            }
            catch (JMSException ex) {
                throw new JMSException(ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            try {
                connection.close();
                throw throwable;
            }
            catch (JMSException ex) {
                throw new JMSException(ex.toString());
            }
        }
        try {}
        catch (JMSException ex) {
            throw new JMSException(ex.toString());
        }
        connection.close();
        return messages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getQueueMessages(String destName, String destPass, int count) throws JMSException, NamingException, IOException {
        InitialContext jndi = null;
        Vector<Message> messages = new Vector<Message>();
        Properties prop = new Properties();
        InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
        prop.load(is);
        if (this.m_JndiHost != null) {
            prop.put(JNDI_HOST, this.m_JndiHost);
        }
        if (this.m_MsgHost != null) {
            prop.put(JMS_HOST, this.m_MsgHost);
        }
        if (this.m_JndiPort > 0) {
            prop.put(JNDI_PORT, Integer.toString(this.m_JndiPort));
        }
        if (this.m_MsgPort > 0) {
            prop.put(JMS_PORT, Integer.toString(this.m_MsgPort));
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        jndi = new InitialContext(prop);
        QueueConnectionFactory conFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
        QueueConnection connection = conFactory.createQueueConnection("", destPass);
        QueueSession session = connection.createQueueSession(false, 1);
        Queue aQueue = (Queue)jndi.lookup("jms.queue." + destName);
        try {
            try {
                connection.start();
                QueueBrowser browser = session.createBrowser(aQueue);
                Enumeration e = browser.getEnumeration();
                for (int i = 0; i < count && e.hasMoreElements(); ++i) {
                    Message message = (Message)e.nextElement();
                    messages.add(message);
                }
                Object var17_18 = null;
            }
            catch (JMSException ex) {
                throw new JMSException(ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            try {
                connection.close();
                throw throwable;
            }
            catch (JMSException ex) {
                throw new JMSException(ex.toString());
            }
        }
        try {}
        catch (JMSException ex) {
            throw new JMSException(ex.toString());
        }
        connection.close();
        return messages;
    }

    public static Vector loadAllDestinations(ConMessageServer msCon) throws Exception {
        if (!msCon.isConnected()) {
            throw new Exception("Message Server is not connected.");
        }
        Vector dest = new Vector();
        String respond = msCon.send(Resources.getString("Message.Server.cmd_ls_topics") + "SYNC_" + "%", false);
        dest = msCon.parseVectorResponse(respond);
        respond = msCon.send(Resources.getString("Message.Server.cmd_ls_queues") + "SYNC_" + "%", false);
        Vector temp = msCon.parseVectorResponse(respond);
        dest.addAll(temp);
        return dest;
    }

    public static Vector loadSubscriptions(ConMessageServer msCon, String topicName) throws Exception {
        if (!msCon.isConnected()) {
            throw new Exception("Message Server is not connected.");
        }
        String respond = msCon.send(Resources.getString("MessageServer.cmd_ls_subscription_topic") + topicName, false);
        return msCon.parseVectorResponse(respond);
    }

    private static String buildQualifier(String name) {
        String newName = name.charAt(0) == '\"' ? name.substring(1, name.length() - 1) : name.toUpperCase();
        return newName;
    }

    public void setConnectParam(String msgHost, int msgPort, String jndiHost, int jndiPort, int admin_port, String password, boolean use_ssl) {
        this.m_MsgHost = msgHost;
        this.m_MsgPort = msgPort;
        this.m_JndiHost = jndiHost;
        this.m_JndiPort = jndiPort;
        this.m_AdminPort = admin_port;
        this.m_PassWord = password;
        this.m_useSSL = use_ssl;
    }

    public String toString() {
        return this.getMsgHost() + ":" + this.getAdminPort() + (this.m_useSSL ? " with SSL" : "");
    }
}

