/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.tool;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.programmargs.Crypt;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.gui.jface_dialog.UserAuthorizationDialog;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.CreateSyncManTables;
import com.sap.sdb.syncMan.util.GenUID;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConDataBase {
    private static final char SQL_QUOTATION_MARKS = '\"';
    private static final char SQL_NAME_SEPARATOR = '.';
    private static final int MAXDB = 1;
    private static final int MINDB = 2;
    private static final int EMBEDDED_MINDB = 3;
    private static final int MYSQL = 4;
    private int m_databaseType;
    private String m_database;
    private String m_passWord;
    private String m_user;
    private String m_schema;
    private String m_host;
    private String m_SecurityProvider;
    private boolean m_useSSL;
    private int m_majorVersion;
    private String m_url;
    private Shell m_parentShell;
    private Connection m_connection = null;
    private String m_JDBCDriver;
    private String m_connectString;
    private boolean m_createDesignSchema;
    private boolean m_createRunTimeSchema;
    UserAuthorizationDialog dlg = null;
    private Crypt m_crypt = null;

    public ConDataBase(Shell parentShell, String securityProvider, String schema, boolean createDesignSchema, boolean createRunTimeSchema) {
        this(securityProvider, schema, createDesignSchema, createRunTimeSchema);
        this.m_parentShell = parentShell;
    }

    public ConDataBase(String securityProvider, String schema, boolean createDesignSchema, boolean createRunTimeSchema) {
        this.m_createDesignSchema = createDesignSchema;
        this.m_createRunTimeSchema = createRunTimeSchema;
        this.m_schema = schema;
        this.m_parentShell = null;
        this.m_JDBCDriver = "com.sap.dbtech.jdbc.DriverSapDB";
        this.m_SecurityProvider = securityProvider;
    }

    public String getJDBCDriver() {
        return this.m_JDBCDriver;
    }

    public void setJDBCDriver(String jdbcDriver) {
        this.m_JDBCDriver = jdbcDriver;
    }

    public void connect(String host, String database, String user, String password, boolean use_ssl) throws Exception {
        this.connect(host, database, user, password, use_ssl, null);
    }

    public void connect(String host, String database, String user, String password, boolean use_ssl, String additionalURL) throws Exception {
        user = ConDataBase.buildQualifier(user);
        password = ConDataBase.buildQualifier(password);
        this.setConnectParam(host, database, user, password, use_ssl, true, additionalURL);
        this.connect();
        if (SQLBuilder.hasLogWindow()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SQLBuilder.writeProt(Resources.getString("ConnectAction.Database.Connected") + ConDataBase.this.getUrl(), false);
                }
            });
        } else {
            SQLBuilder.writeProt(Resources.getString("ConnectAction.Database.Connected") + this.getUrl(), false);
        }
    }

    public boolean setConnectParam(String host, String database, String user, String password, boolean useSSL, boolean promptForMissing) throws SQLException {
        return this.setConnectParam(host, database, user, password, useSSL, promptForMissing, null);
    }

    public boolean setConnectParam(String host, String database, String user, String password, boolean useSSL, boolean promptForMissing, String additionalURL) throws SQLException {
        this.m_useSSL = useSSL;
        if (this.m_JDBCDriver.equals("com.sap.dbtech.jdbc.DriverSapDB")) {
            this.m_databaseType = 1;
        } else if (this.m_JDBCDriver.startsWith("com.sap.sdb.minDB")) {
            this.m_databaseType = this.m_JDBCDriver.indexOf("Embedded") > -1 ? 3 : 2;
        } else if (this.m_JDBCDriver.equals("com.mysql.jdbc.Driver")) {
            this.m_databaseType = 4;
        } else {
            throw new SQLException(Resources.getString("ConDataBase.Unknown_JDBC_Driver"));
        }
        if (host == null || host.length() < 1) {
            host = Resources.getString("DefaultHost");
        }
        if (promptForMissing) {
            if (host.length() < 1 && this.m_databaseType != 2 && database.length() < 1 && user.length() < 1 && password.length() < 1) {
                this.dlg = new UserAuthorizationDialog(this.m_parentShell);
            } else if (host.length() < 1 || this.m_databaseType != 2 && database.length() < 1 || user.length() < 1 || password.length() < 1) {
                this.dlg = new UserAuthorizationDialog(this.m_parentShell, host, database, user, password, useSSL);
            }
            if (this.dlg != null) {
                this.dlg.setBlockOnOpen(true);
                int returnCode = this.dlg.open();
                if (returnCode == 0) {
                    host = this.dlg.getHost();
                    database = this.dlg.getDatabase();
                    user = this.dlg.getUser();
                    password = this.dlg.getPassword();
                    useSSL = this.dlg.getUseSSL();
                } else {
                    return false;
                }
            }
        }
        this.dlg = null;
        this.m_host = host;
        this.m_database = database;
        this.m_user = user;
        this.m_passWord = password;
        this.m_useSSL = useSSL;
        if (this.m_databaseType == 1) {
            this.m_connectString = this.buildMaxDBConnectString(this.m_host, this.m_database, additionalURL);
        } else if (this.m_databaseType == 2) {
            this.m_connectString = this.buildMinDBConnectString(this.m_host, additionalURL);
        } else if (this.m_databaseType == 3) {
            this.m_connectString = this.buildEmbeddedMinDBConnectString(this.m_host, additionalURL);
        } else if (this.m_databaseType == 4) {
            this.m_connectString = this.buildMySQLConnectString(this.m_host, this.m_database, additionalURL);
        }
        return true;
    }

    private String buildMaxDBConnectString(String host, String database, String additionalURL) {
        if (additionalURL != null && additionalURL.indexOf(host) >= 0 && additionalURL.indexOf(database) >= 0) {
            return additionalURL;
        }
        String connectString = "jdbc:sapdb://";
        if (host != null) {
            connectString = connectString + host;
        }
        connectString = connectString + "/" + database + "?timeout=0";
        if (this.m_useSSL) {
            connectString = connectString + "&transport=secure";
        }
        return connectString;
    }

    private String buildMinDBConnectString(String host, String additionalURL) {
        if (additionalURL != null && additionalURL.indexOf(host) >= 0) {
            return additionalURL;
        }
        String connectString = "jdbc:MinDB://";
        if (host != null) {
            connectString = connectString + host;
        }
        return connectString;
    }

    private String buildEmbeddedMinDBConnectString(String host, String additionalURL) {
        if (additionalURL != null && additionalURL.indexOf(host) >= 0) {
            return additionalURL;
        }
        String connectString = "jdbc:embeddedMinDB://";
        if (host != null) {
            connectString = connectString + host;
        }
        return connectString;
    }

    private String buildMySQLConnectString(String host, String database, String additionalURL) {
        if (additionalURL != null && additionalURL.indexOf(host) >= 0 && additionalURL.indexOf(database) >= 0) {
            return additionalURL;
        }
        String connectString = "jdbc:mysql://";
        if (host != null) {
            connectString = connectString + host;
        }
        connectString = connectString + "/" + database;
        if (this.m_useSSL) {
            connectString = connectString + "&useSSL=true";
        }
        return connectString;
    }

    public void connect() throws Exception {
        Connection connection = null;
        try {
            Class.forName(this.m_JDBCDriver);
            connection = this.m_JDBCDriver.equals("com.sap.dbtech.jdbc.DriverSapDB") ? DriverManager.getConnection(this.m_connectString, "\"" + this.m_user + "\"", "\"" + this.m_passWord + "\"") : DriverManager.getConnection(this.m_connectString, this.m_user, this.m_passWord);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            this.m_majorVersion = connection.getMetaData().getDatabaseMajorVersion();
            this.m_url = connection.getMetaData().getURL();
            if (this.m_JDBCDriver.equals("com.sap.dbtech.jdbc.DriverSapDB")) {
                ConnectionPool.createInstance(this.m_connectString, this.m_JDBCDriver, this.m_user, this.m_passWord);
                try {
                    ConnectionPool.setReplicationSession(connection);
                }
                catch (Exception ex) {
                    SQLBuilder.writeProtAsync(ex);
                    ConnectionPool.destroyInstance();
                    this.disconnect();
                    return;
                }
                ConnectionPool.destroyInstance();
            }
            try {
                String tmp = this.getPassWord();
                if (tmp.charAt(0) == '\"') {
                    tmp = tmp.substring(1, tmp.length() - 1);
                }
                this.m_crypt = new Crypt(tmp, this.m_SecurityProvider);
            }
            catch (Exception ex) {
                SQLBuilder.writeProtAsync(ex);
                return;
            }
            if (this.m_createDesignSchema || this.m_createRunTimeSchema) {
                new CreateSyncManTables(connection, this.m_JDBCDriver, this.m_schema, true, this.m_createDesignSchema, this.m_createRunTimeSchema);
                if (this.m_createDesignSchema) {
                    this.checkTablesVersion(connection);
                }
            }
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        if (!GenUID.getInit()) {
            if (this.isMaxDB()) {
                GenUID.init(DesignSQLLayer.getTimeStamp((Connection)connection));
            } else if (this.isMinDB()) {
                GenUID.init(System.currentTimeMillis());
            } else {
                throw new SQLException(Resources.getString("ConDataBase.Invalid_JDBC_Driver"));
            }
        }
        this.m_connection = connection;
    }

    public String getDataBase() {
        return this.m_database;
    }

    public void disconnect() throws SQLException {
        if (this.m_connection != null) {
            this.m_host = null;
            this.m_database = null;
            this.m_user = null;
            this.m_passWord = null;
            this.m_useSSL = false;
            this.m_crypt = null;
            this.m_connection.rollback();
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public boolean isConnected() {
        return this.m_connection != null;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public String getPassWord() {
        return this.m_passWord;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getUrl() {
        return this.m_url;
    }

    public boolean getUseSSL() {
        return this.m_useSSL;
    }

    public String getConnectString() {
        return this.m_connectString;
    }

    public int getDatabaseMajorVersion() {
        return this.m_majorVersion;
    }

    public String buildTableQualifier(String tableName) {
        if (this.m_databaseType == 1 || this.m_databaseType == 2) {
            return '\"' + this.m_schema + '\"' + '.' + '\"' + tableName + '\"';
        }
        if (this.m_databaseType == 4) {
            return "`" + tableName + "`";
        }
        return null;
    }

    public synchronized boolean isMaxDB() {
        return this.m_databaseType == 1;
    }

    public synchronized boolean isMinDB() {
        return this.m_databaseType == 2;
    }

    public synchronized boolean isMySQL() {
        return this.m_databaseType == 4;
    }

    public String getSyncSchema() {
        return this.m_schema;
    }

    private static String buildQualifier(String name) {
        String newName = name.charAt(0) == '\"' ? name.substring(1, name.length() - 1) : name.toUpperCase();
        return newName;
    }

    public Crypt getCryptObject() {
        return this.m_crypt;
    }

    public String toString() {
        return this.getHost() + ":" + this.getDataBase() + (this.m_useSSL ? " with SSL" : "");
    }

    private void checkTablesVersion(Connection dbCon) throws Exception {
        Statement stmt = dbCon.createStatement();
        ResultSet result = stmt.executeQuery("SELECT TABLE_NAME,VERSION from \"" + this.m_schema + "\"." + "RD_TABLE_VERSIONS");
        while (result.next()) {
            String tabName = result.getString(1);
            String version = result.getString(2);
            if (version.equalsIgnoreCase(Server.getVersion())) continue;
            result.close();
            throw new Exception("Wrong version of syncman gui table: " + tabName);
        }
        result.close();
    }
}

