/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.message;

import com.sap.sdb.syncMan.message.RowReceiveMessage;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.TopicSession;

public class SyncManMessage {
    private long m_unitId;
    private int m_actionType;
    private String m_sqlTransID;
    private boolean m_isLastInTrans;
    private long m_tableId;
    private long m_rowCreatorID;
    private long m_rowVersion;
    private long m_updaterID;
    private long m_colGroupVersion;
    private SyncManMessage m_nextReceivedMsg = null;
    public static final String SINGLE_RECEIVER_PROPERTY = "singleReceiver";
    public static final String IGNORE_CLIENT_ID_PROPERTY = "ignoreClientID";
    private static final int VERSION_MULTI_MESSAGE = -607518719;
    private static final int VERSION_SINGLE_MESSAGE = -606470143;
    private static final int VERSION_END_INCREMENT = 65536;
    public static final byte BEFORE_IMAGE = 0;
    public static final byte AFTER_IMAGE = 1;
    static final String LINE_SEP = "\r\n";

    SyncManMessage() {
    }

    void appendHeaderToJMSMessage(BytesMessage jmsBytesMsg) throws JMSException {
        if (this.m_unitId == Long.MIN_VALUE || this.m_updaterID == Long.MIN_VALUE) {
            throw new JMSException("SyncManMessage not fully initialized");
        }
        jmsBytesMsg.writeInt(-606470143);
        jmsBytesMsg.writeLong(this.m_unitId);
        jmsBytesMsg.writeInt(this.m_actionType);
        jmsBytesMsg.writeLong(this.m_updaterID);
        jmsBytesMsg.writeBoolean(this.m_sqlTransID != null);
        if (this.m_sqlTransID != null) {
            jmsBytesMsg.writeUTF(this.m_sqlTransID);
        }
        if (this.m_actionType != 7) {
            jmsBytesMsg.writeBoolean(this.m_isLastInTrans);
            jmsBytesMsg.writeLong(this.m_tableId);
            jmsBytesMsg.writeLong(this.m_rowCreatorID);
            jmsBytesMsg.writeLong(this.m_rowVersion);
            jmsBytesMsg.writeLong(this.m_updaterID);
            jmsBytesMsg.writeLong(this.m_colGroupVersion);
        }
    }

    public static RowReceiveMessage createFromJMSMessage(Message jmsMsg) throws JMSException {
        RowReceiveMessage firstMsg = null;
        RowReceiveMessage prevMsg = null;
        BytesMessage jmsBytesMsg = (BytesMessage)jmsMsg;
        int msgCount = 1;
        int msgVersion = jmsBytesMsg.readInt();
        if (msgVersion == -607518719) {
            msgCount = jmsBytesMsg.readInt();
            msgVersion = jmsBytesMsg.readInt();
        }
        for (int i = 1; i <= msgCount; ++i) {
            if (msgVersion != -606470143) {
                throw new JMSException("unknown SyncMan message version: " + msgVersion);
            }
            RowReceiveMessage currMsg = new RowReceiveMessage();
            currMsg.m_unitId = jmsBytesMsg.readLong();
            currMsg.m_actionType = jmsBytesMsg.readInt();
            currMsg.m_updaterID = jmsBytesMsg.readLong();
            String string = currMsg.m_sqlTransID = jmsBytesMsg.readBoolean() ? jmsBytesMsg.readUTF() : null;
            if (currMsg.m_actionType == 7) {
                currMsg.m_isLastInTrans = true;
                currMsg.m_tableId = -1L;
                currMsg.m_rowCreatorID = -1L;
                currMsg.m_rowVersion = -1L;
                currMsg.m_updaterID = -1L;
                currMsg.m_colGroupVersion = -1L;
            } else {
                currMsg.m_isLastInTrans = jmsBytesMsg.readBoolean();
                currMsg.m_tableId = jmsBytesMsg.readLong();
                currMsg.m_rowCreatorID = jmsBytesMsg.readLong();
                currMsg.m_rowVersion = jmsBytesMsg.readLong();
                currMsg.m_updaterID = jmsBytesMsg.readLong();
                currMsg.m_colGroupVersion = jmsBytesMsg.readLong();
                currMsg.deserialize(jmsBytesMsg);
            }
            int endMsgVersion = jmsBytesMsg.readInt();
            if (endMsgVersion != -606404607) {
                throw new JMSException("unknown SyncMan message end version: " + endMsgVersion);
            }
            if (firstMsg == null) {
                firstMsg = currMsg;
            } else {
                prevMsg.m_nextReceivedMsg = currMsg;
            }
            if (msgCount > 1) {
                msgVersion = jmsBytesMsg.readInt();
            }
            prevMsg = currMsg;
        }
        if (msgCount > 1 && msgVersion != -607453183) {
            throw new JMSException("unknown multi SyncManMessage end version: " + msgVersion);
        }
        return firstMsg;
    }

    public void createEndOfTransJMSMsg(Message jmsMsg) throws JMSException {
        SyncManMessage endOfTransMsg = new SyncManMessage();
        endOfTransMsg.m_actionType = 7;
        endOfTransMsg.m_sqlTransID = this.m_sqlTransID;
        endOfTransMsg.m_unitId = this.m_unitId;
        endOfTransMsg.m_updaterID = this.m_updaterID;
        BytesMessage jmsBytesMsg = (BytesMessage)jmsMsg;
        endOfTransMsg.initJMSMessage(jmsBytesMsg, 1);
        jmsBytesMsg.writeInt(this.getMessageEndVersion());
    }

    public static String createMessageSelectorString(long clientUnitId) {
        String iamReceiver = "singleReceiver=" + Long.toString(clientUnitId);
        String receiverEmpty = "singleReceiver IS NULL";
        String selector = iamReceiver + " OR " + receiverEmpty;
        return selector;
    }

    public void finishMultiJMSMessage(Message jmsMsg) throws JMSException {
        ((BytesMessage)jmsMsg).writeInt(-607453183);
    }

    public int getActionType() {
        return this.m_actionType;
    }

    public long getColGroupVersion() {
        return this.m_colGroupVersion;
    }

    public boolean getIsLastInTransaction() {
        return this.m_isLastInTrans;
    }

    int getMessageEndVersion() {
        return -606404607;
    }

    public static int getMessageVersion() {
        return 1;
    }

    public RowReceiveMessage getNextReceivedMsg() {
        return (RowReceiveMessage)this.m_nextReceivedMsg;
    }

    public static Message getQueueMessage(QueueSession queueSession) throws JMSException {
        return queueSession.createBytesMessage();
    }

    public long getRowCreatorID() {
        return this.m_rowCreatorID;
    }

    public long getRowVersion() {
        return this.m_rowVersion;
    }

    public long getTableId() {
        return this.m_tableId;
    }

    public static Message getTopicMessage(TopicSession topicSession) throws JMSException {
        return topicSession.createBytesMessage();
    }

    public String getTransactId() {
        return this.m_sqlTransID;
    }

    public long getUnitId() {
        return this.m_unitId;
    }

    public long getUpdaterId() {
        return this.m_updaterID;
    }

    void initJMSMessage(BytesMessage jmsBytesMsg, int messagesPerJMSMsg) throws JMSException {
        jmsBytesMsg.clearProperties();
        jmsBytesMsg.clearBody();
        if (messagesPerJMSMsg > 1) {
            jmsBytesMsg.writeInt(-607518719);
            jmsBytesMsg.writeInt(messagesPerJMSMsg);
        }
        this.appendHeaderToJMSMessage(jmsBytesMsg);
    }

    public void initSendMessage(long unitId, int actionType, String sqlTransID, long tableId) {
        this.m_unitId = unitId;
        this.m_actionType = actionType;
        this.m_sqlTransID = sqlTransID;
        this.m_tableId = tableId;
    }

    void resetSendMessage() {
        this.m_actionType = -1;
        this.m_sqlTransID = null;
        this.m_isLastInTrans = false;
        this.m_tableId = -1L;
        this.m_unitId = -1L;
        this.m_rowCreatorID = -1L;
        this.m_rowVersion = -1L;
        this.m_updaterID = -1L;
        this.m_colGroupVersion = -1L;
    }

    public void setIsLastInTransaction() {
        this.m_isLastInTrans = true;
    }

    public void setVersionEntries(long rowCreaterID, long rowVersion, long updaterID, long colGroupVersion) {
        this.m_rowCreatorID = rowCreaterID;
        this.m_rowVersion = rowVersion;
        this.m_updaterID = updaterID;
        this.m_colGroupVersion = colGroupVersion;
    }

    public String toString() {
        return "unit=" + this.m_unitId + ", type=" + SyncManMessage.actionTypeToString(this.m_actionType) + ", trans=" + this.m_sqlTransID + ", isLast=" + this.m_isLastInTrans + ", tab=" + this.m_tableId + LINE_SEP + "   creator=" + this.m_rowCreatorID + ", rowVers=" + this.m_rowVersion + ", updater=" + this.m_updaterID + ", colVers=" + this.m_colGroupVersion;
    }

    public static String actionTypeToString(int actionType) {
        switch (actionType) {
            case -1: {
                return actionType + " (undef)";
            }
            case -2: {
                return actionType + " (undef)";
            }
            case 0: {
                return actionType + " (insert)";
            }
            case 1: {
                return actionType + " (update)";
            }
            case 2: {
                return actionType + " (delete)";
            }
            case 3: {
                return actionType + " (before image)";
            }
            case 4: {
                return actionType + " (refresh with ack)";
            }
            case 5: {
                return actionType + " (refresh without ack)";
            }
            case 6: {
                return actionType + " (refresh done)";
            }
            case 7: {
                return actionType + " (end fo trans)";
            }
        }
        return Integer.toString(actionType);
    }
}

