/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.definition;

import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationTable;
import com.sap.sdb.syncMan.util.SQLNames;
import com.sap.sdb.syncMan.util.TableName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ReplicationUnit
implements SQLNames {
    private ReplicationSchema m_schema;
    private boolean m_master;
    private int m_unitType;
    private long m_unitID;
    private String m_unitName;
    private String m_inDestName;
    private String m_inDestPass;
    private Hashtable m_tablesByName;
    private Hashtable m_tablesById;

    public ReplicationUnit(ReplicationSchema schema, long unitID, String unitName, int unitType, boolean isMaster, String inDestId, String inDestPass) throws Exception {
        this.m_schema = schema;
        this.m_master = isMaster;
        this.m_unitType = unitType;
        this.m_unitID = unitID;
        this.m_unitName = unitName;
        this.m_inDestName = inDestId;
        this.m_inDestPass = inDestPass;
        this.m_tablesByName = new Hashtable();
        this.m_tablesById = new Hashtable();
    }

    public ReplicationSchema getSchema() {
        return this.m_schema;
    }

    public long getUnitID() {
        return this.m_unitID;
    }

    public String getUnitName() {
        return this.m_unitName;
    }

    public int getUnitType() {
        return this.m_unitType;
    }

    public String getInboundDestName() {
        return this.m_inDestName;
    }

    public String getInboundDestPass() {
        return this.m_inDestPass;
    }

    public ReplicationTable getTableByName(TableName tabName) {
        return (ReplicationTable)this.m_tablesByName.get(tabName);
    }

    public ReplicationTable getTableById(long tabId) {
        return (ReplicationTable)this.m_tablesById.get(new Long(tabId));
    }

    public int getTableCount() {
        return this.m_tablesById.size();
    }

    public Enumeration getTableEnum() {
        return this.m_tablesById.elements();
    }

    public boolean isOutbound() {
        return this.m_unitType == 0 || this.m_unitType == 2;
    }

    public boolean isInbound() {
        return this.m_unitType == 1 || this.m_unitType == 2;
    }

    public boolean isMaster() {
        return this.m_master;
    }

    public Properties getJndiProperties() {
        return this.m_schema.getJndiProps();
    }

    public void addTable(ReplicationTable table, String tableName, long tableID) {
        this.m_tablesByName.put(tableName, table);
        this.m_tablesById.put(new Long(tableID), table);
    }

    public void init() {
        Enumeration en = this.m_tablesByName.elements();
        while (en.hasMoreElements()) {
            ReplicationTable table = (ReplicationTable)en.nextElement();
            table.init();
        }
    }
}

