/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.consumption.ConsumptionIgnoreListSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import java.sql.Connection;
import java.util.Hashtable;

public class ConsumptionIgnoreList {
    private ReplicationUnit m_unit;
    private Hashtable m_lastUpdaterHash;
    private ConsumptionIgnoreListSQLHandler m_sqlhandler;

    public ConsumptionIgnoreList(Connection konnek, ReplicationUnit unit) throws Exception {
        this.m_unit = unit;
        this.m_lastUpdaterHash = new Hashtable();
        this.m_sqlhandler = ConsumptionIgnoreListSQLHandler.createHandler(this.m_unit);
        this.m_sqlhandler.initializeList(konnek, this);
    }

    public synchronized void beginCritical(Connection konnek, RowReceiveMessage msg) throws Exception {
        SetCrRetval setCrRetval = this.internal_setCritical(msg.getUpdaterId(), msg.getRowCreatorID(), msg.getRowVersion(), true, 1);
        this.m_sqlhandler.beginCritical(konnek, msg, setCrRetval.increment, setCrRetval.refcount);
    }

    public synchronized boolean isInCritical(RowReceiveMessage msg) throws Exception {
        Long rowVersionObj;
        Long rowCreatorObj;
        Hashtable rowVersionHash;
        boolean retval = false;
        Long updaterObj = new Long(msg.getUpdaterId());
        Hashtable rowCreatorHash = (Hashtable)this.m_lastUpdaterHash.get(updaterObj);
        if (rowCreatorHash != null && (rowVersionHash = (Hashtable)rowCreatorHash.get(rowCreatorObj = new Long(msg.getRowCreatorID()))) != null && rowVersionHash.containsKey(rowVersionObj = new Long(msg.getRowVersion()))) {
            retval = true;
        }
        return retval;
    }

    public synchronized void endCritical(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean decrement = false;
        Long updaterObj = new Long(msg.getUpdaterId());
        Long rowCreatorObj = new Long(msg.getRowCreatorID());
        Long rowVersionObj = new Long(msg.getRowVersion());
        Hashtable rowCreatorHash = (Hashtable)this.m_lastUpdaterHash.get(updaterObj);
        Hashtable rowVersionHash = (Hashtable)rowCreatorHash.get(rowCreatorObj);
        Integer refCount = (Integer)rowVersionHash.get(rowVersionObj);
        int refCountPrimitive = refCount;
        if (refCountPrimitive > 1) {
            refCount = new Integer(refCountPrimitive - 1);
            rowVersionHash.put(rowVersionObj, refCount);
            decrement = true;
        } else {
            rowVersionHash.remove(rowVersionObj);
            if (rowVersionHash.isEmpty()) {
                rowCreatorHash.remove(rowCreatorObj);
                if (rowCreatorHash.isEmpty()) {
                    this.m_lastUpdaterHash.remove(rowCreatorHash);
                }
            }
        }
        this.m_sqlhandler.endCritical(konnek, msg, decrement, refCountPrimitive - 1);
    }

    public synchronized void setCritical(long lastUpdaterId, long rowCreatorId, long rowVersion, int refCount) throws Exception {
        this.internal_setCritical(lastUpdaterId, rowCreatorId, rowVersion, false, refCount);
    }

    private SetCrRetval internal_setCritical(long lastUpdaterId, long rowCreatorId, long rowVersion, boolean incrementRefCount, int refCount) throws Exception {
        Hashtable<Long, Integer> rowVersionHash;
        SetCrRetval retval = new SetCrRetval();
        retval.increment = false;
        retval.refcount = 1;
        Long lastUpdaterObj = new Long(lastUpdaterId);
        Long rowCreatorObj = new Long(rowCreatorId);
        Long rowVersionObj = new Long(rowVersion);
        Hashtable<Long, Hashtable<Long, Integer>> rowCreatorHash = (Hashtable<Long, Hashtable<Long, Integer>>)this.m_lastUpdaterHash.get(lastUpdaterObj);
        if (rowCreatorHash == null) {
            rowCreatorHash = new Hashtable<Long, Hashtable<Long, Integer>>();
            this.m_lastUpdaterHash.put(lastUpdaterObj, rowCreatorHash);
        }
        if ((rowVersionHash = (Hashtable<Long, Integer>)rowCreatorHash.get(rowCreatorObj)) == null) {
            rowVersionHash = new Hashtable<Long, Integer>();
            rowCreatorHash.put(rowCreatorObj, rowVersionHash);
        }
        if (incrementRefCount) {
            Integer refCountObj = (Integer)rowVersionHash.get(rowVersionObj);
            if (refCountObj == null) {
                refCountObj = new Integer(0);
            } else {
                retval.increment = true;
            }
            retval.refcount = refCountObj + refCount;
            refCountObj = new Integer(retval.refcount);
            rowVersionHash.put(rowVersionObj, refCountObj);
        } else {
            rowVersionHash.put(rowVersionObj, new Integer(refCount));
        }
        return retval;
    }

    private static class SetCrRetval {
        public boolean increment;
        public int refcount;

        private SetCrRetval() {
        }
    }
}

