/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureTransEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

class CaptureTransTable {
    private TreeMap m_chronologicalTransList;
    private HashMap m_transIDMaxSequenceIndex;
    private CapturePrepStmtCache m_prepStmtCache;

    CaptureTransTable(CapturePrepStmtCache prepStmtCache) {
        this.m_prepStmtCache = prepStmtCache;
        this.m_chronologicalTransList = new TreeMap();
        this.m_transIDMaxSequenceIndex = new HashMap();
    }

    synchronized void clear() {
        this.m_chronologicalTransList.clear();
        this.m_transIDMaxSequenceIndex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTrans(Connection con, CaptureTransEntry trans) throws SQLException {
        PreparedStatement prepStmt = this.m_prepStmtCache.getPrepStmt(con, 0);
        prepStmt.setBytes(1, trans.getTransIDBytes());
        prepStmt.executeUpdate();
        CaptureTransTable captureTransTable = this;
        synchronized (captureTransTable) {
            Long maxSequence = (Long)this.m_transIDMaxSequenceIndex.remove(trans.getTransID());
            if (maxSequence != null) {
                this.m_chronologicalTransList.remove(maxSequence);
            }
        }
    }

    synchronized CaptureTransEntry getFirstChronologicalTrans() {
        if (this.m_chronologicalTransList.isEmpty()) {
            return null;
        }
        return (CaptureTransEntry)this.m_chronologicalTransList.get(this.m_chronologicalTransList.firstKey());
    }

    synchronized boolean hasMoreTransactions() {
        return !this.m_chronologicalTransList.isEmpty();
    }

    void readCommittedTransactions(Connection con) throws SQLException {
        long maxSelectedSequence = this.selectMaxSequence(con);
        LinkedList transIDs = this.selectTransIDs(con, maxSelectedSequence);
        this.selectTablesNamesCreateList(con, transIDs);
    }

    private long selectMaxSequence(Connection con) throws SQLException {
        long maxSelectedSequence = -1L;
        PreparedStatement prepStmt = this.m_prepStmtCache.getPrepStmt(con, 6);
        ResultSet result = prepStmt.executeQuery();
        if (result.next()) {
            maxSelectedSequence = result.getLong(1);
        }
        result.close();
        con.commit();
        return maxSelectedSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectTablesNamesCreateList(Connection con, LinkedList selectedTransList) throws SQLException {
        if (selectedTransList == null) {
            return;
        }
        Iterator iter = selectedTransList.iterator();
        if (!iter.hasNext()) {
            return;
        }
        PreparedStatement prepStmt = this.m_prepStmtCache.getPrepStmt(con, 8);
        while (iter.hasNext()) {
            byte[] currTransIDBytes = (byte[])iter.next();
            CaptureTransEntry currTrans = new CaptureTransEntry(currTransIDBytes);
            prepStmt.setBytes(1, currTransIDBytes);
            ResultSet result = prepStmt.executeQuery();
            while (result.next()) {
                currTrans.addTable(result.getString("TABLE_SCHEMA"), result.getString("TABLE_NAME"), result.getLong("REP_SEQ"));
            }
            result.close();
            con.commit();
            CaptureTransTable captureTransTable = this;
            synchronized (captureTransTable) {
                Long maxSequence = new Long(currTrans.getMaxSequence());
                this.m_chronologicalTransList.put(maxSequence, currTrans);
                this.m_transIDMaxSequenceIndex.put(currTrans.getTransID(), maxSequence);
            }
        }
    }

    private LinkedList selectTransIDs(Connection con, long maxSequence) throws SQLException {
        if (maxSequence < 0L) {
            return null;
        }
        LinkedList<byte[]> transIDs = new LinkedList<byte[]>();
        PreparedStatement prepStmt = this.m_prepStmtCache.getPrepStmt(con, 9);
        prepStmt.setLong(1, maxSequence);
        prepStmt.setLong(2, maxSequence);
        ResultSet result = prepStmt.executeQuery();
        while (result.next()) {
            transIDs.addLast(result.getBytes(1));
            con.commit();
        }
        result.close();
        con.commit();
        return transIDs;
    }
}

