/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.capture.CaptureShadowTable;
import com.sap.sdb.syncMan.capture.CaptureTransEntry;
import com.sap.sdb.syncMan.capture.CaptureTransTable;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import javax.jms.JMSException;

class CaptureTransHandler
extends CaptureHandler {
    private boolean m_anyTransFound = true;
    private boolean m_accumulatedUpdates;
    private long m_timeLastCapture;
    private long m_timeoutMsec;
    private CaptureTransEntry m_currTrans;
    private CaptureTransTable m_transList;
    private static final String HANDLER_NAME = "CaptureTransHandler";
    private static final int SLEEP_TIME = 10;

    CaptureTransHandler(boolean accumulatedUpdates, int maxTableHandlers, long captureTimeoutMsec) {
        super(HANDLER_NAME, maxTableHandlers, null);
        this.m_accumulatedUpdates = accumulatedUpdates;
        this.m_timeLastCapture = System.currentTimeMillis();
        this.m_timeoutMsec = captureTimeoutMsec;
        this.m_currTrans = null;
        this.m_transList = new CaptureTransTable(super.getPrepStmtCache());
    }

    boolean accumulatedUpdWanted() {
        return this.m_accumulatedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws Exception {
        if (!this.existsUnitSenderMap()) {
            throw new JMSException("CaptureHandler: unit sender entries not established");
        }
        this.reset();
        this.m_currTrans = null;
        Connection con = ConnectionPool.getConnection();
        try {
            while (!super.isStopWanted()) {
                long currTime;
                if (!this.m_anyTransFound && this.m_timeoutMsec > 0L && (currTime = System.currentTimeMillis()) - this.m_timeLastCapture > this.m_timeoutMsec) {
                    DebugOutput.println("capture timeout");
                    CaptureManager.signalCaptureHandlerFinished();
                    super.setFinished();
                    return;
                }
                this.m_anyTransFound = false;
                super.setCustomMsg("select transactions");
                this.m_transList.readCommittedTransactions(con);
                con.commit();
                if (!this.m_transList.hasMoreTransactions()) {
                    super.setCustomMsg(super.getMsgSentCount() + " messages sent");
                    super.performSleep(10);
                    return;
                }
                this.handleTransactions(con);
                this.m_anyTransFound = true;
                this.m_timeLastCapture = System.currentTimeMillis();
            }
            super.checkTableHandleException();
        }
        catch (InterruptedException ex) {
            super.checkTableHandleException();
        }
        finally {
            ConnectionPool.freeConnection(con);
            super.resetCustomMsg();
        }
    }

    private void finshTransaction(Connection con) throws JMSException, SQLException {
        super.setCustomMsg("finish transID " + this.m_currTrans.getTransID());
        if (DebugOutput.isVerboseCapture()) {
            super.printOwnAction();
        }
        this.m_transList.deleteTrans(con, this.m_currTrans);
        super.finishJMSTransaction();
        con.commit();
        this.m_currTrans = null;
    }

    String getCurrentTransID() {
        return this.m_currTrans.getTransID();
    }

    byte[] getCurrentTransIDBytes() {
        return this.m_currTrans.getTransIDBytes();
    }

    private void handleTransactions(Connection con) throws Exception {
        while (this.m_transList.hasMoreTransactions()) {
            try {
                this.m_currTrans = this.m_transList.getFirstChronologicalTrans();
                super.setCustomMsg("capture transID " + this.getCurrentTransID());
                if (DebugOutput.isVerboseCapture()) {
                    super.printOwnAction();
                }
                if (this.m_accumulatedUpdates) {
                    this.sendAccumulatedUpdates(con);
                } else {
                    this.sendChangesOfTransation(con);
                }
                this.finshTransaction(con);
            }
            catch (Exception ex) {
                CaptureManager.rollbackJMSSession();
                con.rollback();
                throw ex;
            }
            finally {
                super.resetCustomMsg();
            }
        }
    }

    private void sendAccumulatedUpdates(Connection con) throws Exception {
        Iterator tabIter = this.m_currTrans.getTableIterator();
        while (tabIter.hasNext()) {
            TableName currTab = (TableName)tabIter.next();
            CaptureShadowTable currShadowTab = (CaptureShadowTable)this.getCaptureTable(con, currTab);
            currShadowTab.captureEntries(con, super.getPrepStmtCache());
            currShadowTab.deleteTransEntries(con, this.getCurrentTransIDBytes());
        }
    }

    private void sendChangesOfTransation(Connection con) throws Exception {
        TableName tabname = this.m_currTrans.getTheOnlyOneTable();
        if (tabname != null) {
            CaptureShadowTable shadowTab = (CaptureShadowTable)this.getCaptureTable(con, tabname);
            shadowTab.captureEntries(con, super.getPrepStmtCache());
            shadowTab.deleteTransEntries(con, this.getCurrentTransIDBytes());
            return;
        }
        super.setNumberOfCaptureTables(this.m_currTrans.getTableCount());
        super.triggerAndWaitForTableHandlers(con, this.m_currTrans.getTableIterator());
    }
}

