/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.SyncManThreadManager;
import com.sap.sdb.syncMan.capture.CaptureCopyHandler;
import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureTransHandler;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CaptureManager {
    private boolean m_isShutdown = false;
    private boolean m_initialCopy = true;
    private boolean m_sendTransient = false;
    private boolean m_isMaster = false;
    private boolean m_isVerboseMsg = false;
    private boolean m_isFinished = false;
    private long m_msgSentCount = 0L;
    private long m_createdVersCnt = 0L;
    private Object m_captureWait = null;
    private InitialContext m_jndi = null;
    private CaptureHandler m_captureHandler = null;
    private QueueConnection m_queueConnect = null;
    private TopicConnection m_topicConnect = null;
    private QueueSession m_queueSession = null;
    private TopicSession m_topicSession = null;
    private static CaptureManager s_captureManager = null;
    private static final int WAIT_TIMEOUT = 10000;

    private static void checkInstance() throws IllegalStateException {
        if (s_captureManager == null) {
            throw new IllegalStateException("CaptureManager singleton not created");
        }
    }

    static void commitJMSSession() throws JMSException {
        CaptureManager manager = CaptureManager.getInstance();
        if (manager.m_initialCopy) {
            return;
        }
        if (manager.m_topicSession != null) {
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: COMMIT TOPIC");
            }
            manager.m_topicSession.commit();
        }
        if (manager.m_queueSession != null) {
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: COMMIT QUEUE");
            }
            manager.m_queueSession.commit();
        }
    }

    private static synchronized void createInstance(Properties jndiProperties, boolean initialCopy, boolean sendTransient) throws Exception {
        if (s_captureManager != null) {
            throw new Exception("capture manager already working");
        }
        try {
            s_captureManager = new CaptureManager(jndiProperties, initialCopy, sendTransient);
        }
        catch (Exception ex) {
            s_captureManager = null;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyInstance() {
        CaptureManager manager = null;
        Class clazz = CaptureManager.class;
        synchronized (clazz) {
            manager = s_captureManager;
            if (manager == null || manager.m_isShutdown) {
                return;
            }
            manager.m_isShutdown = true;
        }
        try {
            manager.releaseOutstandingJMSConnection();
        }
        catch (JMSException ex) {
            DebugOutput.printException((Exception)((Object)ex));
        }
        clazz = CaptureManager.class;
        synchronized (clazz) {
            s_captureManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long doInitialClientCopy(Properties jndiProperties, String jdbcDriver, String databaseURL, String captureUser, String password, long singleReceiverID, String masterUnitName, boolean sendTransient, int maxTableHandlers) throws Exception {
        DebugOutput.setVerboseTraceback();
        long msgSent = 0L;
        CaptureManager.createInstance(jndiProperties, true, sendTransient);
        try {
            SyncManThreadManager.createInstance();
            ConnectionPool.createInstance(databaseURL, jdbcDriver, captureUser, password);
            try {
                try {
                    String[] masterUnits = new String[]{masterUnitName};
                    s_captureManager.triggerInitialCopy(singleReceiverID, masterUnits, maxTableHandlers);
                    msgSent = CaptureManager.waitForTablesCaptured();
                }
                catch (Exception ex) {
                    DebugOutput.printException(ex);
                    throw ex;
                }
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                SyncManThreadManager.stopAllThreads();
                Exception fatalError = SyncManThreadManager.getFatalError();
                if (fatalError == null) throw throwable;
                DebugOutput.printException(fatalError);
                throw fatalError;
            }
            SyncManThreadManager.stopAllThreads();
            Exception fatalError = SyncManThreadManager.getFatalError();
            if (fatalError != null) {
                DebugOutput.printException(fatalError);
                throw fatalError;
            }
            long l = msgSent;
            return l;
        }
        finally {
            CaptureManager.destroyInstance();
            SyncManThreadManager.destroyInstance();
            ConnectionPool.destroyInstance();
        }
    }

    private static synchronized CaptureManager getInstance() {
        CaptureManager.checkInstance();
        return s_captureManager;
    }

    static Message getJMSQueueMessage() throws JMSException {
        CaptureManager manager = CaptureManager.getInstance();
        return manager.m_queueSession == null ? null : SyncManMessage.getQueueMessage(manager.m_queueSession);
    }

    static QueueSender getJMSQueueSender(String destination) throws JMSException {
        try {
            CaptureManager manager = CaptureManager.getInstance();
            if (manager.m_queueSession == null) {
                return null;
            }
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CREATE QUEUE SENDER: jms.queue." + destination);
            }
            Queue myQueue = (Queue)manager.m_jndi.lookup("jms.queue." + destination);
            QueueSender sender = manager.m_queueSession.createSender(myQueue);
            if (manager.m_sendTransient) {
                sender.setDeliveryMode(1);
            }
            return sender;
        }
        catch (Exception ex) {
            throw new JMSException(ex.toString());
        }
    }

    static Message getJMSTopicMessage() throws JMSException {
        CaptureManager manager = CaptureManager.getInstance();
        return manager.m_topicSession == null ? null : SyncManMessage.getTopicMessage(manager.m_topicSession);
    }

    static TopicPublisher getJMSTopicPublisher(String destination) throws JMSException {
        try {
            CaptureManager manager = CaptureManager.getInstance();
            if (manager.m_topicSession == null) {
                return null;
            }
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CREATE TOPIC PUBLISHER: jms.queue." + destination);
            }
            Topic myTopic = (Topic)manager.m_jndi.lookup("jms.topic." + destination);
            TopicPublisher publisher = manager.m_topicSession.createPublisher(myTopic);
            if (manager.m_sendTransient) {
                publisher.setDeliveryMode(1);
            }
            return publisher;
        }
        catch (Exception ex) {
            throw new JMSException(ex.toString());
        }
    }

    /*
     * Exception decompiling
     */
    public static long initRowVersions(String jdbcDriver, String databaseURL, String captureUser, String password, String masterUnitName, int maxTableHandlers) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isMaster() {
        return s_captureManager == null ? false : CaptureManager.s_captureManager.m_isMaster;
    }

    static void rollbackJMSSession() throws JMSException {
        CaptureManager manager = CaptureManager.getInstance();
        if (manager.m_initialCopy) {
            return;
        }
        if (manager.m_topicSession != null) {
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: ROLLBACK TOPIC");
            }
            manager.m_topicSession.rollback();
        }
        if (manager.m_queueSession != null) {
            if (manager.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: ROLLBACK QUEUE");
            }
            manager.m_queueSession.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void signalCaptureHandlerFinished() {
        CaptureManager manager = CaptureManager.getInstance();
        Object object = manager.m_captureWait;
        synchronized (object) {
            manager.m_isFinished = true;
            manager.m_captureWait.notify();
        }
    }

    public static void startCaptureTransacted(Properties jndiProperties, boolean accumulatedUpdates, long captureTimeoutMsec, boolean sendTransient, int maxTableHandlers) throws Exception {
        if (accumulatedUpdates) {
            throw new Exception("option 'accumulated_updates' not yet implemented");
        }
        CaptureManager.createInstance(jndiProperties, false, sendTransient);
        s_captureManager.establishJMSConnection(null);
        CaptureManager.s_captureManager.m_captureHandler = new CaptureTransHandler(accumulatedUpdates, maxTableHandlers, captureTimeoutMsec);
        CaptureManager.s_captureManager.m_captureHandler.start();
    }

    public static void startInitialClientCopy(Properties jndiProperties, String singleReceiverName, String[] masterUnits, boolean sendTransient, int maxTableHandlers) throws Exception {
        long singleReceiverID = -1L;
        if (!singleReceiverName.equalsIgnoreCase("allunits")) {
            try {
                singleReceiverID = Long.parseLong(singleReceiverName);
            }
            catch (NumberFormatException ex) {
                throw new Exception("invalid initial client: '" + singleReceiverName + "'");
            }
        }
        CaptureManager.createInstance(jndiProperties, true, sendTransient);
        s_captureManager.triggerInitialCopy(singleReceiverID, masterUnits, maxTableHandlers);
    }

    public static long waitForTablesCaptured() throws InterruptedException {
        CaptureManager manager = CaptureManager.getInstance();
        manager.waitUntilCaptured();
        long msgSent = manager.m_msgSentCount;
        CaptureManager.destroyInstance();
        return msgSent;
    }

    private CaptureManager() {
        this.m_initialCopy = true;
        this.m_sendTransient = true;
        this.m_captureWait = new Object();
        this.m_jndi = null;
    }

    private CaptureManager(Properties jndiProperties, boolean initialCopy, boolean sendTransient) throws NamingException {
        this.m_initialCopy = initialCopy;
        this.m_sendTransient = sendTransient;
        this.m_captureWait = new Object();
        this.m_jndi = new InitialContext(jndiProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishJMSConnection(String[] unitnames) throws Exception {
        String password;
        this.m_isVerboseMsg = DebugOutput.isVerboseCaptureMsg();
        Connection con = ConnectionPool.getConnection();
        try {
            CapturePrepStmtCache stmtCache = new CapturePrepStmtCache(ConnectionPool.getSchema(), unitnames);
            password = this.selectMasterClientPassword(con, stmtCache, true);
            boolean bl = this.m_isMaster = password != null;
            if (!this.m_isMaster) {
                password = this.selectMasterClientPassword(con, stmtCache, false);
                if (password == null) {
                    throw new Exception("capture handling: password not found");
                }
                if (this.m_initialCopy) {
                    throw new Exception("initial copy not supported for clients");
                }
            }
        }
        finally {
            ConnectionPool.freeConnection(con);
        }
        boolean isTransacted = !this.m_initialCopy;
        password = SQLBuilder.makeMsgSvrPassword(password, "com.sap.sdb.syncMan.util.0CAFFE");
        if (this.m_isMaster) {
            if (this.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CREATE TOPIC SESSION (transacted=" + isTransacted + ")");
            }
            TopicConnectionFactory topicFactory = (TopicConnectionFactory)this.m_jndi.lookup("jms.TopicConnectionFactory");
            this.m_topicConnect = topicFactory.createTopicConnection("", password);
            this.m_topicSession = this.m_topicConnect.createTopicSession(isTransacted, 1);
        } else {
            if (this.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CREATE QUEUE SESSION (transacted=" + isTransacted + ")");
            }
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.m_jndi.lookup("jms.QueueConnectionFactory");
            this.m_queueConnect = queueFactory.createQueueConnection("", password);
            this.m_queueSession = this.m_queueConnect.createQueueSession(isTransacted, 1);
        }
    }

    private void releaseOutstandingJMSConnection() throws JMSException {
        if (this.m_captureHandler != null) {
            this.m_captureHandler.removeAllUnitSenders();
        }
        if (this.m_queueConnect != null) {
            if (this.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CLOSE QUEUE SESSION");
            }
            this.m_queueConnect.close();
        }
        if (this.m_topicConnect != null) {
            if (this.m_isVerboseMsg) {
                DebugOutput.println("CaptureManager: CLOSE TOPIC SESSION");
            }
            this.m_topicConnect.close();
        }
    }

    private String selectMasterClientPassword(Connection con, CapturePrepStmtCache stmtCache, boolean masterWanted) throws Exception {
        String password = null;
        PreparedStatement stmt = stmtCache.getPrepStmt(con, 7);
        stmt.setBoolean(1, masterWanted);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            password = result.getString(1);
        }
        result.close();
        return password;
    }

    private void triggerInitialCopy(long singleReceiverID, String[] masterUnits, int maxTableHandlers) throws Exception {
        this.establishJMSConnection(masterUnits);
        this.m_captureHandler = new CaptureCopyHandler(singleReceiverID, masterUnits, maxTableHandlers);
        this.m_captureHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilCaptured() throws InterruptedException {
        Object object = this.m_captureWait;
        synchronized (object) {
            while (!this.m_isFinished) {
                this.m_captureWait.wait(10000L);
                if (!SyncManThreadManager.isErrorOccurred()) continue;
            }
        }
        if (this.m_captureHandler != null) {
            this.m_msgSentCount = this.m_captureHandler.getMsgSentCount();
            this.m_createdVersCnt = this.m_captureHandler.getCreatedVersionCount();
        }
    }
}

