/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.util.SQLNames;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

class CaptureColConstraint
implements SQLNames {
    private boolean m_compareFirstValue;
    private Long m_clientUnitID;
    private int m_constraintType;
    private String m_constraintValue;
    private String m_constraintValue2 = null;

    CaptureColConstraint(ResultSet constraintResult) throws SQLException {
        this.m_clientUnitID = new Long(constraintResult.getLong("CLIENT_ID"));
        this.m_constraintType = constraintResult.getInt("CONSTRAINT_TYPE");
        this.m_constraintValue = constraintResult.getString("CONSTRAINT_VALUE1");
        this.m_constraintValue2 = this.m_constraintType == 7 ? constraintResult.getString("CONSTRAINT_VALUE2") : null;
        this.m_compareFirstValue = this.m_constraintType != 8 && this.m_constraintType != 9 && this.m_constraintType != 10;
    }

    Long checkUnqualifiedClient(Connection con, String value, boolean isNull) {
        if (isNull || value == null) {
            return this.m_clientUnitID;
        }
        if (this.m_compareFirstValue) {
            int compareResult = value.compareTo(this.m_constraintValue);
            switch (this.m_constraintType) {
                case 1: {
                    return compareResult == 0 ? null : this.m_clientUnitID;
                }
                case 2: {
                    return compareResult != 0 ? null : this.m_clientUnitID;
                }
                case 3: {
                    return compareResult > 0 ? null : this.m_clientUnitID;
                }
                case 4: {
                    return compareResult >= 0 ? null : this.m_clientUnitID;
                }
                case 5: {
                    return compareResult < 0 ? null : this.m_clientUnitID;
                }
                case 6: {
                    return compareResult <= 0 ? null : this.m_clientUnitID;
                }
                case 7: {
                    if (compareResult < 0) {
                        return this.m_clientUnitID;
                    }
                    compareResult = value.compareTo(this.m_constraintValue2);
                    return compareResult <= 0 ? null : this.m_clientUnitID;
                }
            }
            return this.m_clientUnitID;
        }
        if (this.m_constraintType == 10) {
            return this.matchesLike(con, value) ? null : this.m_clientUnitID;
        }
        if (this.m_constraintType == 8 || this.m_constraintType == 9) {
            return this.matchesIn(con, value) ? null : this.m_clientUnitID;
        }
        return this.m_clientUnitID;
    }

    private boolean matchesIn(Connection con, String value) {
        String valueDelimiter = this.m_constraintValue.indexOf("'") >= 0 ? "'" : "";
        String inToken = this.m_constraintType == 8 ? " IN (" : " NOT IN (";
        String sql = "SELECT dummy FROM dual WHERE " + valueDelimiter + value + valueDelimiter + inToken + this.m_constraintValue + ")";
        try {
            ResultSet dummyResult = con.createStatement().executeQuery(sql);
            boolean matches = dummyResult.next();
            dummyResult.close();
            return matches;
        }
        catch (SQLException ex) {
            return false;
        }
    }

    private boolean matchesLike(Connection con, String value) {
        String sql = "SELECT dummy FROM dual WHERE '" + value + "' LIKE '" + this.m_constraintValue + "'";
        try {
            ResultSet dummyResult = con.createStatement().executeQuery(sql);
            boolean matches = dummyResult.next();
            dummyResult.close();
            return matches;
        }
        catch (SQLException ex) {
            return false;
        }
    }
}

