/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan;

import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import com.sap.sdb.syncMan.tool.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SyncServiceAdmin {
    private static final String PASSWORD = "-password";
    private static final String ACCESS_KEY = "-access_key";
    private static final String SECURITY_PROVIDER = "-security_provider";
    static Reader from_server = null;
    static PrintWriter to_server = null;
    static SSLSocket ssl = null;
    static Socket s = null;

    public static void main(String[] args) {
        try {
            String hostname = null;
            String password = null;
            String access_key = null;
            String security_provider = null;
            int portnumber = 0;
            String command = null;
            boolean useSSL = false;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-A") || args[i].equals(ACCESS_KEY)) {
                    access_key = args[i + 1];
                    i += 2;
                    AccParams param = new AccParams(access_key, security_provider);
                    param.loadParameters();
                    if (password != null && password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    hostname = param.getMsgServer();
                    password = param.getDBPassword();
                    portnumber = Integer.parseInt(param.getSyncAdminPort());
                    break;
                }
                if (args[i].equals(SECURITY_PROVIDER)) {
                    security_provider = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-host")) {
                    hostname = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-port")) {
                    portnumber = Integer.parseInt(args[i + 1]);
                    i += 2;
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals(PASSWORD)) {
                    if (password != null && password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        String tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (password == null || password.length() < 1) {
                        ++i;
                        password = PasswordPrompt.getPassword("SyncService Admin Password:\n");
                    } else {
                        i += 2;
                    }
                    password = SyncServiceAdmin.buildLogonQualifier(password);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-encryption")) {
                    if (args[i + 1] != null && args[i + 1].equalsIgnoreCase("ssl")) {
                        useSSL = true;
                    }
                    i += 2;
                    continue;
                }
                if (command != null) {
                    throw new Exception("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                }
                command = args[i];
                ++i;
            }
            if (hostname == null || hostname.length() < 1 || password == null || password.length() < 1 || portnumber < 1) {
                throw new Exception(Resources.getString("Insufficient_Connect_Parameter") + " SyncService Admin");
            }
            if (useSSL) {
                SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
                ssl = (SSLSocket)sslFact.createSocket(hostname, portnumber);
                from_server = new InputStreamReader(ssl.getInputStream());
                to_server = new PrintWriter(new OutputStreamWriter(ssl.getOutputStream()));
            } else {
                s = new Socket(hostname, portnumber);
                from_server = new InputStreamReader(s.getInputStream());
                to_server = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
            }
            BufferedReader from_user = new BufferedReader(new InputStreamReader(System.in));
            final PrintWriter to_user = new PrintWriter(new OutputStreamWriter(System.out));
            if (useSSL) {
                to_user.println("Connected to " + ssl.getInetAddress() + ":" + ssl.getPort() + " with SSL Connection");
            } else {
                to_user.println("Connected to " + s.getInetAddress() + ":" + s.getPort());
            }
            to_user.flush();
            Thread t = new Thread("Thread-SyncServiceAdmin"){

                public void run() {
                    char[] buffer = new char[1024];
                    try {
                        int chars_read;
                        while ((chars_read = from_server.read(buffer)) != -1) {
                            to_user.write(buffer, 0, chars_read);
                            to_user.write(">");
                            to_user.flush();
                        }
                    }
                    catch (IOException e) {
                        to_user.println(e);
                    }
                    to_user.println("Connection closed by the server.");
                    to_user.flush();
                    System.exit(0);
                }
            };
            t.setPriority(Thread.currentThread().getPriority() + 1);
            t.start();
            if (password != null) {
                to_server.println("password " + password);
                to_server.flush();
            }
            if (command != null) {
                to_server.println(command);
                to_server.flush();
                to_server.println("quit");
                to_server.flush();
            } else {
                String line;
                while ((line = from_user.readLine()) != null) {
                    to_server.println(line);
                    to_server.flush();
                }
                t.interrupt();
                s.close();
                to_user.println("Connection closed by client.");
                to_user.flush();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: java AdminClient -host <sync service hostname> -port <sync service admin portnumber [-password <password> \"<command>\"]> -encryption");
            System.err.println("Usage: java AdminClient -A <acces key> -host <sync service hostname> -port <sync service admin portnumber");
            System.err.println("The password will be converted to uppercase,");
            System.err.println("if not surrounded with double quote signs.");
            System.exit(1);
        }
    }

    private static String buildLogonQualifier(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        if (name.charAt(0) == '\"') {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }
}

