/*!**********************************************************************

  module: hwd15text.h

  -----------------------------------------------------------------------

  responsible:  Holger Bischoff
				Markus Oezgen

  special area: Text/Template Repository

  description:  Repository for text pieces

  see also:     

  -----------------------------------------------------------------------

  copyright:          Copyright (c) 2000-2005 SAP AG



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




************************************************************************/

#ifndef HWD15TEXT_H
#define HWD15TEXT_H

/*=======================================================================
 *  INCLUDES
 *=====================================================================*/

#include "gsp00.h"
#include "hwd01wadef.h"

/*=======================================================================
 *  PROTOTYPES
 *=====================================================================*/

tsp00_Bool wd15GetString ( sapdbwa_Int4	  groupId,
						   sapdbwa_Int4	  textId,
						   const char	**text     );

/*=======================================================================
 *  TYPES
 *=====================================================================*/

typedef struct {

	sapdbwa_Int4  groupId;
	sapdbwa_Int4  textId;
	const char	 *text;

} twd15_Text;

#endif

/****************************************************************************
 ***
 *** HTML Admin Templates
 ***
 ****************************************************************************/

#define ADMIN_HTML_TITLE									15
#define ADMIN_HTML_ERROR									16
#define ADMIN_HTML_VALUE_UPDATE_CONFIRMATION				17
#define ADMIN_JS_BEGIN									19
#define ADMIN_JS_END										20
#define ADMIN_HTML_FRAMESET								21
#define ADMIN_HTML_BEGIN									22
#define ADMIN_HTML_END									23
#define ADMIN_HTML_HEADER_BEGIN							24
#define ADMIN_HTML_HEADER_END							25
#define ADMIN_JS_TREE_SETTINGS							26
#define ADMIN_JS_TREE_CREATE_ROOT_FOLDERS				27
#define ADMIN_JS_TREE_ADD_SESSIONPOOL					30
#define ADMIN_JS_TREE_ADD_SERVICE						31
#define ADMIN_JS_TREE_ADD_COMSERVICE						32
#define ADMIN_JS_TREE_ADD_CLOSE							33
#define ADMIN_HTML_NAVIGATION							34
#define ADMIN_HTML_SHOW_SESSIONPOOL						35
#define ADMIN_HTML_SHOW_SERVICE							36
#define ADMIN_HTML_SHOW_COMSERVICE						37
#define ADMIN_HTML_SHOW_END								38
#define ADMIN_HTML_GLOBAL_SETTINGS_FORM_BEGIN			39
#define ADMIN_HTML_GLOBAL_SETTINGS_FORM_END				44
#define ADMIN_HTML_MAIN_HEADER							45
#define ADMIN_HTML_INIT_DETAILS_BEGIN					46
#define ADMIN_HTML_SERVICE_FORM_BEGIN					47
#define ADMIN_HTML_SERVICE_FORM_END_BEGIN				64
#define ADMIN_HTML_SERVICE_FORM_CONTINUE_1				65
#define ADMIN_JS_TREE_ADD_GLOBAL_SETTINGS				66
#define ADMIN_HTML_BODY_BEGIN							67
#define ADMIN_HTML_BODY_END								68
#define ADMIN_HTML_RESOURCE_SETTINGS_FORM_BEGIN			69
#define ADMIN_HTML_RESOURCE_SETTINGS_FORM_END			74
#define ADMIN_JS_NEW_SESSIONPOOL							75
#define ADMIN_JS_NEW_SERVICE								76
#define ADMIN_JS_NEW_COM_SERVICE							77
#define ADMIN_HTML_NEW_PARAMETER_FORM_BEGIN				78
#define ADMIN_HTML_NEW_PARAMETER_FORM_CONTINUE_1			79
#define ADMIN_HTML_NEW_PARAMETER_FORM_END				82
#define ADMIN_HTML_INVALID_PARAMETER_NAME				83
#define ADMIN_HTML_HORIZONTAL_RULE						89
#define ADMIN_HTML_NEW_SERVICE_FORM_BEGIN				91
#define ADMIN_HTML_NEW_SERVICE_FORM_END							101
#define ADMIN_HTML_SERVICE_CREATE_CONFIRMATION					102
#define ADMIN_JS_REFRESH_NAVIGATION								103
#define ADMIN_JS_CLEAR_TREE										104
#define ADMIN_HTML_DELETE_SERVICE_GET_CONFIRMATION_BEGIN			105
#define ADMIN_HTML_DELETE_SERVICE_GET_CONFIRMATION_CONTINUE_1	106
#define ADMIN_HTML_DELETE_SERVICE_GET_CONFIRMATION_END			107
#define ADMIN_HTML_DELETE_SERVICE_CONFIRMATION					108
#define ADMIN_HTML_DELETE_PARAMETERS_FORM_BEGIN					109
#define ADMIN_HTML_DELETE_PARAMETERS_FORM_CONTINUE_1				110
#define ADMIN_HTML_DELETE_PARAMETERS_FORM_END					114
#define ADMIN_HTML_DELETE_PARAMETERS_CONFIRMATION				115
#define ADMIN_HTML_DELETE_PARAMETERS_NOTHING						116
#define ADMIN_HTML_SERVICE_BEGIN									121
#define ADMIN_HTML_COMSERVICE_BEGIN								123
#define ADMIN_HTML_COMSERVICE_CONTINUE_1							124
#define ADMIN_HTML_COMSERVICE_FORM_BEGIN							125
#define ADMIN_HTML_COMSERVICE_FORM_CONTINUE_1					126
#define ADMIN_HTML_COMSERVICE_CLASS_ID_BEGIN						127
#define ADMIN_HTML_COMSERVICE_CLASS_ID_END						128
#define ADMIN_HTML_COMSERVICE_LOGFILE_BEGIN						129
#define ADMIN_HTML_COMSERVICE_LOGFILE_END						130
#define ADMIN_HTML_COMSERVICE_SERVICE_NAME_BEGIN					131
#define ADMIN_HTML_COMSERVICE_SERVICE_NAME_END					132
#define ADMIN_HTML_COMSERVICE_FORM_END							133
#define ADMIN_HTML_SHOW_SESSION_POOL_BEGIN						134
#define ADMIN_HTML_SHOW_SESSION_POOL_CONTINUE_1					135
#define ADMIN_HTML_SHOW_SESSION_POOL_FORM_BEGIN					136
#define ADMIN_HTML_SHOW_SESSION_POOL_FORM_CONTINUE_1				137
#define ADMIN_HTML_SHOW_SESSION_POOL_FORM_END					158
#define ADMIN_HTML_OPTION										159
#define ADMIN_HTML_OPTION_SELECTED								160
#define ADMIN_HTML_OPTION_CLOSE									161
#define ADMIN_HTML_NEW_SESSION_POOL_FORM_BEGIN					162
#define ADMIN_HTML_NEW_SESSION_POOL_FORM_END						172
#define ADMIN_HTML_SESSION_POOL_CREATE_CONFIRMATION				173
#define ADMIN_HTML_SERVICE_ALREADY_EXISTS_BEGIN					176
#define ADMIN_HTML_SERVICE_ALREADY_EXISTS_END					177
#define ADMIN_HTML_SESSION_POOL_ALREADY_EXISTS_BEGIN				178
#define ADMIN_HTML_SESSION_POOL_ALREADY_EXISTS_END				179
#define ADMIN_HTML_DELETE_SESSION_POOL_GET_CONFIRMATION_BEGIN		180
#define ADMIN_HTML_DELETE_SESSION_POOL_GET_CONFIRMATION_CONTINUE_1	181
#define ADMIN_HTML_DELETE_SESSION_POOL_GET_CONFIRMATION_END			182
#define ADMIN_HTML_DELETE_SESSION_POOL_CONFIRMATION					183
#define ADMIN_HTML_NEW_COMPARAMETER_FORM_BEGIN						184
#define ADMIN_HTML_NEW_COMPARAMETER_TITLE_END						185
#define ADMIN_HTML_NEW_COMPARAMETER_SERVICE_END						186
#define ADMIN_HTML_NEW_COMPARAMETER_NAME								187
#define ADMIN_HTML_NEW_COMPARAMETER_DEFAULT_VALUE					188
#define ADMIN_HTML_NEW_COMPARAMETER_FORM_END						189
#define ADMIN_HTML_DELETE_COMPARAMETERS_FORM_BEGIN					190
#define ADMIN_HTML_DELETE_COMPARAMETERS_FORM_CONTINUE_1				191
#define ADMIN_HTML_DELETE_COMPARAMETERS_PARAMETER_BEGIN				192
#define ADMIN_HTML_DELETE_COMPARAMETERS_PARAMETER_CONTINUE_1		193
#define ADMIN_HTML_DELETE_COMPARAMETERS_PARAMETER_END				194
#define ADMIN_HTML_DELETE_COMPARAMETERS_FORM_END					195
#define ADMIN_HTML_DELETE_COMSERVICE_GET_CONFIRMATION_BEGIN			196
#define ADMIN_HTML_DELETE_COMSERVICE_GET_CONFIRMATION_CONTINUE_1	197
#define ADMIN_HTML_DELETE_COMSERVICE_GET_CONFIRMATION_END			198
#define ADMIN_HTML_DELETE_COMSERVICE_CONFIRMATION					199
#define ADMIN_HTML_DELETE_COMPARAMETERS_CONFIRMATION				200
#define ADMIN_HTML_DELETE_COMPARAMETERS_NOTHING						201
#define ADMIN_HTML_NEW_COMSERVICE_FORM_BEGIN						202
#define ADMIN_HTML_NEW_COMSERVICE_NAME								203
#define ADMIN_HTML_NEW_COMSERVICE_CLASS_ID							204
#define ADMIN_HTML_NEW_COMSERVICE_LOGFILE							205
#define ADMIN_HTML_NEW_COMSERVICE_SERVICE_NAME						206
#define ADMIN_HTML_NEW_COMSERVICE_FORM_END							207
#define ADMIN_HTML_COMSERVICE_ALREADY_EXISTS_BEGIN					208
#define ADMIN_HTML_COMSERVICE_ALREADY_EXISTS_END					209
#define ADMIN_HTML_COMSERVICE_CREATE_CONFIRMATION					210
#define ADMIN_HTML_RESERVED_SERVICE_NAME_BEGIN						211
#define ADMIN_HTML_RESERVED_SERVICE_NAME_END						212
#define ADMIN_HTML_RESERVED_COMSERVICE_NAME_BEGIN					213
#define ADMIN_HTML_RESERVED_COMSERVICE_NAME_END						214
#define ADMIN_JS_TREE_CREATE_ROOT_COM_FOLDERS						215
#define ADMIN_HTML_CLEAR_LOG_FILE									218
#define ADMIN_HTML_CLEAR_LOG_FILE_HTTP_REQUESTS						2181
#define ADMIN_HTML_CLEAR_LOG_FILE_HTTP_ERRORS						2182
#define ADMIN_HTML_LOG_FILE_CLEAR_CONFIRMATION						219
#define ADMIN_HTML_EMPTY_LOG_FILE									220
#define ADMIN_HTML_EMPTY_LOG_FILE_HTTP_REQUESTS						2201
#define ADMIN_HTML_EMPTY_LOG_FILE_HTTP_ERRORS						2202
#define ADMIN_HTML_START_SERVICE_CONFIRMATION_BEGIN					221
#define ADMIN_HTML_START_SERVICE_OK									222
#define ADMIN_HTML_START_SERVICE_NOT_OK								223
#define ADMIN_HTML_STOP_SERVICE_CONFIRMATION_BEGIN					224
#define ADMIN_HTML_STOP_SERVICE_CONFIRMATION_OK						225
#define ADMIN_HTML_STOP_SERVICE_CONFIRMATION_NOT_OK					226
#define ADMIN_HTML_SERVICE_ALREADY_LOADED_BEGIN						227
#define ADMIN_HTML_SERVICE_ALREADY_LOADED_END						228
#define ADMIN_HTML_SERVICE_FORM_END_START_SERVICE					229
#define ADMIN_HTML_SERVICE_FORM_END_STOP_SERVICE					230
#define ADMIN_HTML_SERVICE_FORM_END_END								231
#define ADMIN_HTML_STOP_SERVICE_CONFIRMATION_NAME					232
#define ADMIN_HTML_STOP_SERVICE_CONFIRMATION_END					233
#define ADMIN_HTML_STOP_SERVICE_LIST_OF_SERVICES_TITLE              234
#define ADMIN_HTML_SERVICE_MISSING_SSL_URL							240
#define ADMIN_HTML_SERVICE_FORM_END_RELOAD_SERVICE					244
#define ADMIN_HTML_SERVICE_NOT_FOUND								245
#define ADMIN_HTML_RESTART_WEBSERVER								255
#define ADMIN_HTML_SERVICE_ON_LOAD_BEGIN							256
#define ADMIN_HTML_SERVICE_ON_LOAD_END								257
#define ADMIN_HTML_INIT_DETAILS_END									258
#define ADMIN_HTML_GLOBAL_SETTINGS_FORM_CONTINUE_1					259
#define ADMIN_HTML_RESOURCE_SETTINGS_FORM_CONTINUE_1				260
#define ADMIN_HTML_NEW_SESSION_POOL_FORM_CONTINUE_1					261
#define	ADMIN_HTML_NEW_SERVICE_FORM_CONTINUE_1						264
#define ADMIN_HTML_SESSION_POOL_COULD_NOT_LOAD						265
#define ADMIN_HTML_SERVICE_FORM_END_GOTO_SERVICE					266
#define ADMIN_HTML_SERVICE_ON_LOAD_CONTINUE_1						267
#define ADMIN_HTML_RELOAD_SESSION_POOL_FAILED						268
#define ADMIN_HTML_GENERAL_SETTINGS_FORM_BEGIN						269
#define ADMIN_HTML_GENERAL_SETTINGS_FORM_CONTINUE_1					270
#define ADMIN_HTML_GENERAL_SETTINGS_FORM_END						271
#define ADMIN_HTML_CONTROL_TABLE_START_WIDTH_100					272
#define ADMIN_HTML_CONTROL_TABLE_START								273
#define ADMIN_HTML_SERVICE_BEGIN_CONTINUE_1							274
#define ADMIN_HTML_NEW_PARAMETER_FORM_CONTINUE_2					275
#define ADMIN_HTML_DELETE_SERVICE_GET_CONFIRMATION_CONTINUE_2		276
#define ADMIN_HTML_DELETE_SERVICE_GET_CONFIRMATION_CONTINUE_3		277

