/*!
  @file           hsp100.h
  @author         RaymondR
  @special area   Version
  @brief          Version information functions


\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/

#ifndef HSP100_H
#define HSP100_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "gsp100.h"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

/*!
  @brief Return version string
  The mayor/minor/correction level is returned in format %d.%d.%02d
  @param componentName [in] name of component
  @param pBuildNumberFunc [in] the build number function
  @param versionString [out] the returned version string
 */
externC void  sp100_GetVersionString  ( tsp100_CompName const         componentName,      /* INPUT */
                                        tsp100_BuildNumberFunc        pBuildNumberFunc,   /* INPUT */
                                        tsp00_Versionc  VAR_ARRAY_REF versionString );    /* OUTPUT */

externC void sp100_GetSenderIDVersion ( tsp00_C5c VAR_ARRAY_REF       SenderID );         /* OUTPUT */

externC void  sp100_GetVersionID      ( tsp100_VersionIDType          IDType,		      /* INPUT	 */
                                        tsp100_BuildNumberFuncEx      pBuildNumberFuncEx, /* INPUT  */
                                        tsp100_VersionID             *pVersionID );       /* OUTPUT */

externC tsp100_VersionResult
              sp100_Compare2VersionIDs( tsp100_VersionIDType          IDType,             /* INPUT */ 
                                        tsp100_VersionID             *pCmpVersionID1,     /* INPUT */
                                        tsp100_VersionID             *pCmpVersionID2 );   /* INPUT */

externC tsp100_VersionResult        /* - tsp100_VersionID0 compare only! */
              sp100_CompareVersionIDs ( tsp100_VersionID             *pCmpVersionID );    /* INPUT */

/* 
 *  following functions are generated by vmake !!!!
 */
externC char* s100buildnumber         ( void );
externC char* s100buildnumberEx       ( unsigned char                *pBuildNumberPrefix,
                                        unsigned long                *pBuildNumber );

/*!
  @brief Return version string for internal use as ping reply string
  The mayor/minor/correction level is returned in format %d.%d.%d
  @param componentName [in] name of component
  @param pBuildNumberFunc [in] the build number function
  @param versionString [out] the returned version string
 */
externC void  sp100_GetPingReplyVersionString  ( tsp100_CompName const        componentName,      /* INPUT */
                                                 tsp100_BuildNumberFunc       pBuildNumberFunc,   /* INPUT */
                                                 tsp00_Versionc VAR_ARRAY_REF versionString );    /* OUTPUT */

/*!
  @brief Add leading zero to correction level if missing
  The mayor/minor/correction level is expected either as %d.%d.%d or %d.%d.%02d but returned in format %d.%d.%02d
  @param versionString [inout] the version string
 */
externC void sp100_ConvertToVersionString ( tsp00_Versionc VAR_ARRAY_REF versionString );

/*!
  @brief Remove leading zero to correction level if missing
  The mayor/minor/correction level is expected either as %d.%d.%d or %d.%d.%02d but returned in format %d.%d.%d
  @param versionString [inout] the version string
 */
externC void sp100_ConvertToPingReplyVersionString ( tsp00_Versionc VAR_ARRAY_REF versionString );

/*! This activate string version conversion code... */
#define HAS_CONVERT_TO_PING_REPLY_VERSION_STRING

#endif  /* HSP100_H */
