/****************************************************************************

  module      : vbd200.cpp

  -------------------------------------------------------------------------

  author      : Henrik
  responsible : Henrik

  special area: DataCacheIO
  description : 


  last changed: 2004-03-00  14:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 1999-2005 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

                      // Content of include files
#include "gsp00.h"
#include "ggg00.h"
#include "hgg01.h"
#include "hgg04.h"
#include "hbd20_1.h"
#include "hbd20_5.h"
#include "gbd200.h"
#include "gbd02.h"
#include "hsp30.h"
#include "heo55k.h"
#include "hgg08.h" // g08data1
#include "DataAccess/Data_PrimPageAccess.hpp"
#include "SAPDBCommon/Algorithms/SAPDBAlgo_QuickSort.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/


/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/



/*===========================================================================*
 *  GLOBAL VARIABLES                                                         *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL VARIABLES                                                          *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL FUNCTIONS (PROTOTYPES)                                             *
 *===========================================================================*/


/*===========================================================================*
 *  GLOBAL FUNCTIONS (CODE)                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  LOCAL FUNCTIONS (CODE)                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  DEFINITION OF METHODS DECLARED IN gbd200.h (CODE)                        * 
 *===========================================================================*/

// singleton
bd200_IOSorter* bd200_IOSorter::m_Instance = NULL;

bd200_IOSorter::bd200_IOSorter(SAPDBMem_IRawAllocator &allocator):
   m_CblockIdx(allocator)
   {};

bd200_IOSorter& bd200_IOSorter::GetInstance(){
    if ( NULL == m_Instance ) {
        bd200_IOSorter::CreateInstance();
    }

    return *m_Instance;
}


void bd200_IOSorter::CreateInstance() {
    if ( NULL == m_Instance ) {
        m_Instance = new( RTEMem_Allocator::Instance() ) bd200_IOSorter(RTEMem_Allocator::Instance());
        if (NULL == m_Instance ){
            RTE_Crash(SAPDBErr_Exception(__FILE__, __LINE__, SAPDBERR_ASSERT_STATE_FAILED, "bd200_IOSorter::CreateInstance() alloc failed"));
        }
        m_Instance->Initialize();
    }
}

void bd200_IOSorter::Initialize() {
    m_Cblocks = NULL;
    m_CblockOffset = 0;
    m_NumberCblocks = 0;
}

void bd200_IOSorter::CollectDataPages(const tsp00_TaskId taskId)
{
    SAPDB_Int region;
    tgg00_BasisError    base_err;
    tsp00_Int4 elements;
    SAPDB_Bool1             svpCompleted;

    bd200_PageComparator myComparator;

    // get dataCacheSize
    tsp00_Int4 cacheSize;
    bd20GetCacheSize(cacheSize);

    m_NumberCblocks = 0;

    vbegexcl (taskId, g08ClusterIO);
    m_CblockOffset = 0;

    SAPDBERR_ASSERT_STATE(NULL == m_Cblocks);
    // allocate 
    m_Cblocks = (tbd02_pDataCBlock *) RTEMem_Allocator::Instance().Allocate(cacheSize * sizeof( tbd02_pDataCBlockListPtr ));
    if (NULL == m_Cblocks){
        // FIXME, error handling
    }

    for (region = 0; region < g01region_cnt (rgnData_egg00); region++)
    {
        bd20GetPagesForClusteredIO(taskId, region, base_err, elements, (tbd02_pDataCBlockListPtr)&(m_Cblocks[m_NumberCblocks]), svpCompleted);
        m_NumberCblocks += elements;
    }
    m_CblockIdx.Clear();
    m_CblockIdx.Reserve(m_NumberCblocks);
    for (SAPDB_UInt blockIdx = 0 ; blockIdx < m_NumberCblocks; blockIdx++)
    {
        m_CblockIdx.InsertEnd(blockIdx);
    }

    SAPDBAlgo_QuickSort<tbd02_pDataCBlock>(m_Cblocks, (SAPDB_UInt4)m_NumberCblocks, myComparator);
    vendexcl (taskId, g08ClusterIO);
};

void bd200_IOSorter::GetPagesForIO(const tsp00_TaskId taskId, 
                                   IOMan_DataPages   &pages,
                                   SAPDB_Int          numPages,
                                   SAPDB_Bool         inSavepoint,
                                   SAPDB_Bool        &complete)
{
    Data_BasePage Page;
    complete = SAPDB_FALSE;

    Container_Vector<SAPDB_UInt>::Iterator cblockIter;

    vbegexcl (taskId, g08ClusterIO);
    cblockIter = m_CblockIdx.Begin();

    while ((cblockIter != m_CblockIdx.End()) && !m_CblockIdx.IsEmpty() && (!pages.IsFull()) && (numPages > 0))
    {
        tsp00_PageNo PageNo = m_Cblocks[ *cblockIter ]->dcb_occupant();
        if (NIL_PAGE_NO_GG00 != PageNo) 
        {
            SAPDB_Int RegOffset = PageNo % g01region_cnt (rgnData_egg00);
            vbegexcl (taskId, g08data1 + RegOffset);

            if (!inSavepoint || (cstSvpRelevant_ebd02 == m_Cblocks[ *cblockIter ]->dcb_ChangedState_bd02()) ){  // still valid 
                if ((0 == m_Cblocks[ *cblockIter ]->dcb_copy_no() ) &&
                    (iosNone_ebd02 == m_Cblocks[ *cblockIter ]->dcb_io_state() ) &&
                    NIL_PAGE_NO_GG00 != m_Cblocks[ *cblockIter ]->dcb_occupant() )
                {
                    Page.Assign( m_Cblocks[ *cblockIter ]->dcb_pFrame_bd02 ,
                             !gg04IsStaticPage( m_Cblocks[ *cblockIter ]->dcb_pFrame_bd02->nd_pt2() ),
                             m_Cblocks[ *cblockIter ]->dcb_pFrame_bd02 ->nd_pmode().includes( pmTemp_egg00 ),
                             m_Cblocks[ *cblockIter ]);
                    numPages--;

                    m_Cblocks[ *cblockIter ]->dcb_io_state().becomes(iosServerIO_ebd02);

                    m_CblockIdx.Delete(cblockIter);
                    pages.Append(Page);
                }
                else // skip, try again later
                {
                    cblockIter++;
                }
            }
            else // not svpRelevant
            {
                m_CblockIdx.Delete(cblockIter);
            }
            vendexcl (taskId, g08data1 + RegOffset);
        }
        else
        {
            m_CblockIdx.Delete(cblockIter);
        }
    }
    if (m_CblockIdx.IsEmpty())
    {
        complete = SAPDB_TRUE;
    }
    vendexcl (taskId, g08ClusterIO);
}

void bd200_IOSorter::ResetIOState(const tsp00_TaskId taskId, 
                                   IOMan_DataPages   &pages)
{
    typedef IOMan_PagesIterator<Data_BasePage> bd200_Iterator;
    tbd2_data_cb_flush_list cbptrList;

// loop ueber alles
    bd200_Iterator iter( pages );
    for( iter.Begin( ); !iter.End(); ++iter )
    {
// get segment
        SAPDB_Int RegOffset  = (*iter).PageNo() % g01region_cnt (rgnData_egg00);
        cbptrList[0]         = STATIC_CAST(tbd02_pDataCBlock ,(*iter).GetHint());

        bd20ResetIOState (taskId, RegOffset, 1, cbptrList);
    }
}

void bd200_IOSorter::EndSave(const tsp00_TaskId taskId){
    vbegexcl (taskId, g08ClusterIO);
    if (m_Cblocks != NULL)
    {
        RTEMem_Allocator::Instance().Deallocate(m_Cblocks);
        m_Cblocks = NULL;
    }
    vendexcl (taskId, g08ClusterIO);
}
    
bool bd200_PageComparator::IsEqual( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B ) {
    return l_equal == PageCompare(A,B);
}

bool bd200_PageComparator::IsPredecessor( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B ) {
    return l_less == PageCompare(A,B);
}

tsp00_LcompResult_Enum bd200_PageComparator::PageCompare( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B ) {
    tsp00_LcompResult_Enum PageCmp;

    if (A == B)
    {
        return l_equal;
    }

    Data_PrimPageAccess APage(A->dcb_pFrame_bd02 );
    Data_PrimPageAccess BPage(B->dcb_pFrame_bd02 );
    Data_PageNo ARoot = APage.RootPageNo(); 
    Data_PageNo BRoot = BPage.RootPageNo(); 

    if (ARoot == BRoot) // same file
    {
        // test auf sortierbares File
        tgg00_PageType2_Enum APageType2 = APage.ReadPageType2();
        tsp00_Int2 ALevel = APage.GetLevel();
        tsp00_Int2 BLevel = BPage.GetLevel();

        SAPDBERR_ASSERT_STATE(APageType2 == BPage.ReadPageType2());

        if (( (APageType2 == pt2Tab_egg00) ||
             (APageType2 == pt2Inv_egg00) ||
             (APageType2 == pt2InvSubtree_egg00) )  &&
             (ALevel == LEAF_LEVEL_BD00) && (ALevel == BLevel))
        {
            if ((A->dcb_io_state() == iosNone_ebd02) && // readable
                (B->dcb_io_state() == iosNone_ebd02))
            {
                if ((0 == APage.GetRecordCount()) && (0 == BPage.GetRecordCount()))
                {
                    PageCmp = l_equal;
                }
                else
                {
                    if (0 == APage.GetRecordCount())
                    {
                        PageCmp = l_less;
                    }
                    else
                    {
                        if (0 == BPage.GetRecordCount())
                        {
                            PageCmp = l_greater;
                        }
                        else
                        {
                            tgg00_Rec * ARec = APage.GetFirstRecord();
                            tgg00_Rec * BRec = BPage.GetFirstRecord();

                            tsp00_LcompResult RecCmpRes;
                            s30cmp(ARec->recBody_gg00(), 0 + POS_OFF_DIFF_BD00, ARec->recKeyLen_gg00(),
                                   BRec->recBody_gg00(), 0 + POS_OFF_DIFF_BD00, BRec->recKeyLen_gg00(), RecCmpRes);

                            SAPDBERR_ASSERT_STATE(RecCmpRes != l_equal);

                            PageCmp = RecCmpRes;
                        }
                    }
                }
            }
            else  // page is 'busy', sort busy pages to the upper end
            {
                if ((A->dcb_io_state() != iosNone_ebd02) && 
                    (B->dcb_io_state() != iosNone_ebd02))
                {
                    PageCmp = l_equal;
                }
                else
                {
                    if ((A->dcb_io_state() != iosNone_ebd02))
                    {
                        PageCmp = l_greater;
                    }
                    else
                    {
                        PageCmp = l_less;
                    }
                }
            }
        }
        else // same file, but unsortable -> equal
        {
            PageCmp = l_equal;
        }
    }
    else  // different files
    {
        if ( ARoot < BRoot )
        {
            PageCmp = l_less;
        }
        else
        {
            PageCmp = l_greater;
        }
    }

    return PageCmp;
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
