/*!******************************************************************************

  @file         hbd03.h

  ------------------------------------------------------------------------------

  @author       <unknown>

  @brief        <unknown topic>

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD03_H
#define HBD03_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x09\xe5\x0b\xdf\x95\x9c\x7c\x94\x72\x3c\xfa\x85\xf1\xf3\x16\x56'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b03add_inv (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_Lkey            &  lk,
    tgg00_Lkey            &  rk);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03AggrFuncOnIndex (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  InvFileId,
    tgg00_FileId          &  AuxFileId,
    tgg00_TwoKeys         &  StartKeyPair,
    tgg00_TwoKeys         &  StopKeyPair,
    tgg00_AggrDescrRec    &  AggrFieldDescr,
    tgg00_SelectFieldsParam  &  SelParam,
    tgg00_StackDesc       &  StackDesc,
    tsp00_Buf &              AuxBuffer,
    tsp00_Buf &              ResultBuffer,
    pasbool                  bOneListOnly,
    pasbool                  bWarnOfNullValues);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03BuildIndex (
    tgg00_TransContext    &  trans,
    tgg00_IndexMode_Param     indexmode,
    tgg00_FileId          &  file_id,
    tgg00_FileId          &  inv_id,
    tgg00_StackDesc       &  stack_desc,
    tsp00_Int2               indexNo,
    tgg00_IndexCounter    &  index_counter);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03CreateIndexFile (
    tgg00_TransContext    &  trans,
    tgg00_FileId          &  invFileId,
    tgg00_FileId          &  tableFileId,
    const tsp00_Int2         indexNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

class FileDir_FileNo;
class Msg_List;

externPascal void bd03CreateOmsKeyPartitionFile (
    tgg00_TransContext    &  trans,
    Msg_List&                msgList,
    tgg00_FileId          &  omsKeyFileId,
    const FileDir_FileNo&     omsKeyFileNo,
    const FileDir_FileNo&     omsParentFileNo,
    const tsp00_Int2         partitionNo,
    pasbool                  addToFileDir);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03calculate_page_count (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_Lkey            &  startkey,
    tgg00_Lkey            &  stopkey,
    pasbool                  count_records,
    tsp00_Int4            &  page_count,
    tsp00_Int4            &  min_page_cnt,
    tsp00_Int4            &  record_cnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03DiagnoseIndex (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_FileId          &  inv_id,
    tgg00_FileId          &  temp_tree_id,
    tgg00_Rec             &  b,
    tsp00_Int4            &  prim_duplicates,
    tsp00_Int4            &  prim_missing);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03del_inv (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_Lkey            &  lk,
    tgg00_Lkey            &  rk,
    tbd00_DelInvReason_Param     callReason);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03get_inv (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  act_tree_id,
    tgg00_Lkey            &  lk,
    tgg00_Lkey            &  rk,
    tgg00_Lkey            &  stop_rk,
    tgg00_Lkey            &  CurrentPrimKey,
    tgg00_BdInvSet        &  bd_inv_info,
    pasbool                  count_only,
    unsigned char            wanted_lock,
    tgg00_KeylistBuf      &  b,
    tsp00_Int4            &  primkeycnt,
    tsp00_Int4            &  ll);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03KeyVtrace (
    tgg00_TransContext    &  t,
    tsp00_KeyPtr             pKey1,
    tsp00_Int4               KeyLen1,
    tsp00_KeyPtr             pKey2,
    tsp00_Int4               KeyLen2,
    tgg00_VtraceType_Param     TraceObject);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03InvStatistics (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  FiledId,
    pasbool                  bWithSelectivity,
    tgg00_SampleInfo      &  StatInfo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03SimpleInvStatistics (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_Int4            &  Leafnodes,
    tsp00_Int4            &  SecKeyCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03next_invkey (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    pasbool                  inclusive,
    tgg00_Lkey            &  lk);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03ReleaseInvTree (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FiledId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03StatisticsUpdate (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FiledId,
    tsp00_Int4            &  NumLeaves,
    tsp00_Int4            &  AvgPrimKeyCountPerPage,
    pasbool                  bOnlyCountLeaves);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03SetToNotAccessible (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FiledId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03ParticipantCreateIndex (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  PrimFileId,
    tgg00_FileId          &  InvFileId,
    tgg00_StackDesc       &  StackDesc,
    tsp00_KeyPtr             StartPrimKey,
    tsp00_KeyPtr             StopPrimKey,
    tsp00_Int4               StartPrimKeyLen,
    tsp00_Int4               StopPrimKeyLen,
    tsp00_Int4               NumLeavesToScan,
    tsp00_Int4               AvgRecordsPerLeaf,
    tsp00_PageNo             PrimQueuePno,
    tsp00_PageNo             SecQueuePno,
    pasbool                  bUseMemorySort,
    tgg00_IndexMode_Param     IndexMode,
    tgg00_IndexCounter    &  IndexCounter,
    tsp00_Int4            &  TempLeafPageCount,
    tsp00_PageNo          &  FirstLeafPno,
    pasbool               &  bEntriesExist);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03select_invrec (
    tgg00_TransContext    &  t,
    tgg00_TwoFileIds      &  file_ids,
    tgg00_TwoKeys         &  keypair,
    tgg00_TwoKeys         &  stop_keypair,
    tgg00_Lkey            &  start_key,
    tgg00_BdInvSet        &  invrange_set,
    tsp00_Int4               recbuf_size,
    tsp00_MoveObjPtr         recbuf_ptr,
    tgg00_SelectFieldsParam  &  sel,
    tgg00_StackDesc       &  stack_desc,
    tgg00_LockReqMode     &  granted_lock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03test_unique_inv (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_Lkey            &  sec_key,
    tgg00_Lkey            &  prim_key);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03VerifyInvTree (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FiledId,
    pasbool                  IsCold,
    pasbool                  bWithExtendedCheck,
    tsp00_Int4            &  NumPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b03MergeInvLists (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_FileId          &  f_id_dest,
    tgg00_TwoKeys         &  start_keys,
    tgg00_TwoKeys         &  stop_keys,
    pasbool                  prim_stop,
    pasbool                  count_only,
    tsp00_Int4            &  count);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03OmsAddInv (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_KeyPtr             pSecKey,
    tsp00_Int4               SecKeyLen,
    tsp00_KeyPtr             pNewPrimKey,
    tsp00_Int4               NewPrimKeyLen,
    tsp00_Int4               FoundPrimKeySize,
    tsp00_KeyPtr             pFoundPrimKey,
    tsp00_Int4            &  FoundPrimKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03OmsDelInv (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_KeyPtr             pSecKey,
    tsp00_Int4               SecKeyLen,
    tsp00_KeyPtr             pNewPrimKey,
    tsp00_Int4               NewPrimKeyLen,
    tsp00_Int4               FoundPrimKeySize,
    tsp00_KeyPtr             pFoundPrimKey,
    tsp00_Int4               FoundPrimKeyToCompareSize,
    tsp00_Int4            &  FoundPrimKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03OmsGetInv (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_KeyPtr             pSecKey,
    tsp00_Int4               SecKeyLen,
    tsp00_Int4               PrimKeySize,
    tsp00_KeyPtr             pPrimKey,
    tsp00_Int4            &  PrimKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03ExtractIndex (
    tgg00_TransContext    &  trans,
    tsp00_PageNo             root,
    tsp00_VFilename       &  hostFileName);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03GetInvPageCount (
    tgg00_TransContext    &  t,
    const tgg00_Surrogate  &  indexSurr,
    tsp00_Int4            &  leafPageCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03GetInvPageAndRecordCount (
    tgg00_TransContext    &  t,
    const tgg00_Surrogate  &  indexSurr,
    tsp00_Int4            &  leafPageCount,
    tsp00_Int4            &  secKeyCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03SetIndexLeafCaching (
    integer                  value);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd03CountClusteredPages (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_Int4            &  TotalPageCount,
    tsp00_Int4            &  TotalClusteredBlocks,
    tsp00_Int4            &  TotalClusteredPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

