/*!***************************************************************************

  module      : gbd200.h

  -------------------------------------------------------------------------

  author      : Henrik

  special area: DataCacheIO
  description : 


  last changed: 2004-09-01  14:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 1999-2005 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/



#ifndef GBD200_H
#define GBD200_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

                // Content of include files
#include "RunTime/MemoryManagement/RTEMem_Allocator.hpp"
#include "SAPDBCommon/Algorithms/SAPDBAlgo_Comparator.hpp"
#include "IOManager/IOMan_DataPages.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  FORWARD DECLARATION                                                      *
 *===========================================================================*/


/*===========================================================================*
 *  GLOBAL FUNCTIONS (CODE)                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

class bd200_IOSorter {

public:

    static bd200_IOSorter& GetInstance();


    void CollectDataPages(const tsp00_TaskId taskId);

    void GetPagesForIO(const tsp00_TaskId taskId, 
                                   IOMan_DataPages   &pages,
                                   SAPDB_Int          numPages,
                                   SAPDB_Bool         inSavePoint,
                                   SAPDB_Bool        &complete);

    void ResetIOState(const tsp00_TaskId taskId, 
                                   IOMan_DataPages   &pages);

    void EndSave( const tsp00_TaskId taskId);

private:

    static void CreateInstance();

    bd200_IOSorter(SAPDBMem_IRawAllocator &allocator);

    void Initialize();


    static bd200_IOSorter * m_Instance;

    tbd02_pDataCBlock * m_Cblocks;
    SAPDB_UInt           m_CblockOffset;
    Container_Vector<SAPDB_UInt> m_CblockIdx;
    SAPDB_UInt           m_NumberCblocks;

};

class bd200_PageComparator: public SAPDBAlgo_IComparator<tbd02_pDataCBlock> {
public:
    bool IsEqual( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B );

    bool IsPredecessor( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B );

    tsp00_LcompResult_Enum PageCompare( tbd02_pDataCBlock const& A, tbd02_pDataCBlock const& B );
};

/*===========================================================================*
 *  DEFINITION OF METHODS                                                    *
 *===========================================================================*/

#endif  /* GBD200_H */

